/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.client.internal;

import com.gemstone.gemfire.InternalGemFireError;
import com.gemstone.gemfire.cache.client.ServerConnectivityException;
import com.gemstone.gemfire.cache.client.ServerOperationException;
import com.gemstone.gemfire.cache.client.internal.Connection;
import com.gemstone.gemfire.cache.client.internal.ConnectionImpl;
import com.gemstone.gemfire.cache.client.internal.ConnectionStats;
import com.gemstone.gemfire.cache.client.internal.Op;
import com.gemstone.gemfire.cache.client.internal.UserAttributes;
import com.gemstone.gemfire.internal.HeapDataOutputStream;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.cache.PutAllPartialResultException;
import com.gemstone.gemfire.internal.cache.TXManagerImpl;
import com.gemstone.gemfire.internal.cache.tier.MessageType;
import com.gemstone.gemfire.internal.cache.tier.sockets.ChunkedMessage;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.Part;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import org.apache.logging.log4j.Logger;

public abstract class AbstractOp
implements Op {
    private static final Logger logger = LogService.getLogger();
    private final Message msg;
    protected boolean failed;
    protected boolean timedOut;

    protected AbstractOp(int msgType, int msgParts) {
        this.msg = new Message(msgParts, Version.CURRENT);
        this.getMessage().setMessageType(msgType);
    }

    protected Message getMessage() {
        return this.msg;
    }

    protected void initMessagePart() {
    }

    private void setMsgTransactionId() {
        if (this.participateInTransaction() && this.getMessage().getTransactionId() == -1) {
            this.getMessage().setTransactionId(TXManagerImpl.getCurrentTXUniqueId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void attemptSend(Connection cnx) throws Exception {
        this.setMsgTransactionId();
        if (logger.isTraceEnabled(LogMarker.DISTRIBUTION_BRIDGE_SERVER) && logger.isDebugEnabled()) {
            logger.debug("Sending op={} using {}", this.getShortClassName(), cnx);
        }
        this.getMessage().setComms(cnx.getSocket(), cnx.getInputStream(), cnx.getOutputStream(), cnx.getCommBuffer(), cnx.getStats());
        try {
            this.sendMessage(cnx);
        }
        finally {
            this.getMessage().unsetComms();
        }
    }

    public String getShortClassName() {
        String cname = this.getClass().getName();
        return cname.substring(this.getClass().getPackage().getName().length() + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendMessage(Connection cnx) throws Exception {
        if (cnx.getServer().getRequiresCredentials()) {
            this.getMessage().setEarlyAck((byte)2);
            HeapDataOutputStream hdos = new HeapDataOutputStream(Version.CURRENT);
            long userId = -1L;
            if (UserAttributes.userAttributes.get() == null) {
                userId = cnx.getServer().getUserId();
            } else {
                Long id = UserAttributes.userAttributes.get().getServerToId().get(cnx.getServer());
                if (id == null) {
                    throw new ServerConnectivityException("Connection error while authenticating user");
                }
                userId = id;
            }
            try {
                hdos.writeLong(cnx.getConnectionID());
                hdos.writeLong(userId);
                this.getMessage().setSecurePart(((ConnectionImpl)cnx).getHandShake().encryptBytes(hdos.toByteArray()));
            }
            finally {
                hdos.close();
            }
        }
        this.getMessage().send(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object attemptReadResponse(Connection cnx) throws Exception {
        Message msg = this.createResponseMessage();
        if (msg != null) {
            msg.setComms(cnx.getSocket(), cnx.getInputStream(), cnx.getOutputStream(), cnx.getCommBuffer(), cnx.getStats());
            if (msg instanceof ChunkedMessage) {
                try {
                    Object object = this.processResponse(msg, cnx);
                    return object;
                }
                finally {
                    msg.unsetComms();
                    this.processSecureBytes(cnx, msg);
                }
            }
            try {
                msg.recv();
            }
            finally {
                msg.unsetComms();
                this.processSecureBytes(cnx, msg);
            }
            return this.processResponse(msg, cnx);
        }
        return null;
    }

    protected void processSecureBytes(Connection cnx, Message message) throws Exception {
        if (cnx.getServer().getRequiresCredentials()) {
            if (!message.isSecureMode()) {
                if (logger.isDebugEnabled()) {
                    logger.trace(LogMarker.BRIDGE_SERVER, "Response message from {} for {} has no secure part.", cnx, this);
                }
                return;
            }
            byte[] partBytes = message.getSecureBytes();
            if (partBytes == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Response message for {} has no bytes in secure part.", this);
                }
                return;
            }
            byte[] bytes = ((ConnectionImpl)cnx).getHandShake().decryptBytes(partBytes);
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(bytes));
            cnx.setConnectionID(dis.readLong());
        }
    }

    protected Message createResponseMessage() {
        return new Message(1, Version.CURRENT);
    }

    protected Object processResponse(Message m, Connection con) throws Exception {
        return this.processResponse(m);
    }

    protected abstract Object processResponse(Message var1) throws Exception;

    protected abstract boolean isErrorResponse(int var1);

    protected void processAck(Message msg, String opName) throws Exception {
        int msgType = msg.getMessageType();
        if (msgType == 6) {
            return;
        }
        Part part = msg.getPart(0);
        if (msgType == 2) {
            String s = ": While performing a remote " + opName;
            Throwable t = (Throwable)part.getObject();
            if (t instanceof PutAllPartialResultException) {
                throw (PutAllPartialResultException)t;
            }
            throw new ServerOperationException(s, t);
        }
        if (this.isErrorResponse(msgType)) {
            throw new ServerOperationException(part.getString());
        }
        throw new InternalGemFireError("Unexpected message type " + MessageType.getString(msgType));
    }

    protected final Object processObjResponse(Message msg, String opName) throws Exception {
        Part part = msg.getPart(0);
        int msgType = msg.getMessageType();
        if (msgType == 1) {
            return part.getObject();
        }
        if (msgType == 2) {
            String s = "While performing a remote " + opName;
            throw new ServerOperationException(s, (Throwable)part.getObject());
        }
        if (this.isErrorResponse(msgType)) {
            throw new ServerOperationException(part.getString());
        }
        throw new InternalGemFireError("Unexpected message type " + MessageType.getString(msgType));
    }

    protected final void processChunkedResponse(ChunkedMessage msg, String opName, ChunkHandler callback) throws Exception {
        msg.readHeader();
        int msgType = msg.getMessageType();
        if (msgType == 1) {
            do {
                msg.receiveChunk();
                callback.handle(msg);
            } while (!msg.isLastChunk());
        } else {
            if (msgType == 2) {
                msg.receiveChunk();
                Part part = msg.getPart(0);
                String s = "While performing a remote " + opName;
                throw new ServerOperationException(s, (Throwable)part.getObject());
            }
            if (this.isErrorResponse(msgType)) {
                msg.receiveChunk();
                Part part = msg.getPart(0);
                throw new ServerOperationException(part.getString());
            }
            throw new InternalGemFireError("Unexpected message type " + MessageType.getString(msgType));
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public Object attempt(Connection cnx) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected final boolean hasFailed() {
        return this.failed;
    }

    protected final boolean hasTimedOut() {
        return this.timedOut;
    }

    protected abstract long startAttempt(ConnectionStats var1);

    protected abstract void endSendAttempt(ConnectionStats var1, long var2);

    protected abstract void endAttempt(ConnectionStats var1, long var2);

    protected boolean needsUserId() {
        return true;
    }

    protected boolean participateInTransaction() {
        return true;
    }

    @Override
    public boolean useThreadLocalConnection() {
        return true;
    }

    public static interface ChunkHandler {
        public void handle(ChunkedMessage var1) throws Exception;
    }
}

