/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.asyncqueue.internal;

import com.gemstone.gemfire.cache.asyncqueue.AsyncEventListener;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventQueue;
import com.gemstone.gemfire.cache.asyncqueue.internal.AsyncEventQueueStats;
import com.gemstone.gemfire.cache.util.Gateway;
import com.gemstone.gemfire.cache.wan.GatewayEventFilter;
import com.gemstone.gemfire.cache.wan.GatewayEventSubstitutionFilter;
import com.gemstone.gemfire.cache.wan.GatewaySender;
import com.gemstone.gemfire.internal.cache.RegionQueue;
import com.gemstone.gemfire.internal.cache.wan.AbstractGatewaySender;
import com.gemstone.gemfire.internal.cache.wan.AbstractGatewaySenderEventProcessor;
import com.gemstone.gemfire.internal.cache.wan.serial.ConcurrentSerialGatewaySenderEventProcessor;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class AsyncEventQueueImpl
implements AsyncEventQueue {
    private GatewaySender sender = null;
    private AsyncEventListener asyncEventListener = null;
    public static final String ASYNC_EVENT_QUEUE_PREFIX = "AsyncEventQueue_";

    public AsyncEventQueueImpl(GatewaySender sender, AsyncEventListener eventListener) {
        this.sender = sender;
        this.asyncEventListener = eventListener;
    }

    @Override
    public String getId() {
        return AsyncEventQueueImpl.getAsyncEventQueueIdFromSenderId(this.sender.getId());
    }

    @Override
    public AsyncEventListener getAsyncEventListener() {
        return this.asyncEventListener;
    }

    @Override
    public List<GatewayEventFilter> getGatewayEventFilters() {
        return this.sender.getGatewayEventFilters();
    }

    @Override
    public GatewayEventSubstitutionFilter getGatewayEventSubstitutionFilter() {
        return this.sender.getGatewayEventSubstitutionFilter();
    }

    @Override
    public int getBatchSize() {
        return this.sender.getBatchSize();
    }

    @Override
    public String getDiskStoreName() {
        return this.sender.getDiskStoreName();
    }

    @Override
    public int getBatchTimeInterval() {
        return this.sender.getBatchTimeInterval();
    }

    @Override
    public boolean isBatchConflationEnabled() {
        return this.sender.isBatchConflationEnabled();
    }

    @Override
    public int getMaximumQueueMemory() {
        return this.sender.getMaximumQueueMemory();
    }

    @Override
    public boolean isPersistent() {
        return this.sender.isPersistenceEnabled();
    }

    @Override
    public boolean isDiskSynchronous() {
        return this.sender.isDiskSynchronous();
    }

    @Override
    public int getDispatcherThreads() {
        return this.sender.getDispatcherThreads();
    }

    @Override
    public Gateway.OrderPolicy getOrderPolicy() {
        return this.sender.getOrderPolicy();
    }

    @Override
    public boolean isPrimary() {
        return ((AbstractGatewaySender)this.sender).isPrimary();
    }

    @Override
    public int size() {
        AbstractGatewaySenderEventProcessor eventProcessor = ((AbstractGatewaySender)this.sender).getEventProcessor();
        int size2 = 0;
        if (eventProcessor instanceof ConcurrentSerialGatewaySenderEventProcessor) {
            Set<RegionQueue> queues = ((ConcurrentSerialGatewaySenderEventProcessor)eventProcessor).getQueues();
            Iterator<RegionQueue> itr = queues.iterator();
            while (itr.hasNext()) {
                size2 += itr.next().size();
            }
        } else {
            size2 = eventProcessor.getQueue().size();
        }
        return size2;
    }

    public GatewaySender getSender() {
        return this.sender;
    }

    public AsyncEventQueueStats getStatistics() {
        AbstractGatewaySender abstractSender = (AbstractGatewaySender)this.sender;
        return (AsyncEventQueueStats)abstractSender.getStatistics();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AsyncEventQueue)) {
            return false;
        }
        AsyncEventQueueImpl asyncEventQueue = (AsyncEventQueueImpl)obj;
        return asyncEventQueue.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public static String getSenderIdFromAsyncEventQueueId(String asyncQueueId) {
        StringBuilder builder = new StringBuilder();
        builder.append(ASYNC_EVENT_QUEUE_PREFIX);
        builder.append(asyncQueueId);
        return builder.toString();
    }

    public static String getAsyncEventQueueIdFromSenderId(String senderId) {
        if (!senderId.startsWith(ASYNC_EVENT_QUEUE_PREFIX)) {
            return senderId;
        }
        return senderId.substring(ASYNC_EVENT_QUEUE_PREFIX.length());
    }

    public static boolean isAsyncEventQueue(String senderId) {
        return senderId.startsWith(ASYNC_EVENT_QUEUE_PREFIX);
    }

    @Override
    public boolean isParallel() {
        return this.sender.isParallel();
    }

    public boolean isBucketSorted() {
        return false;
    }
}

