/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.asyncqueue.internal;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventListener;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventQueue;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventQueueFactory;
import com.gemstone.gemfire.cache.asyncqueue.internal.AsyncEventQueueImpl;
import com.gemstone.gemfire.cache.util.Gateway;
import com.gemstone.gemfire.cache.wan.GatewayEventFilter;
import com.gemstone.gemfire.cache.wan.GatewayEventSubstitutionFilter;
import com.gemstone.gemfire.cache.wan.GatewaySender;
import com.gemstone.gemfire.cache.wan.GatewaySenderFactory;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderAttributes;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderFactoryImpl;
import com.gemstone.gemfire.internal.cache.xmlcache.AsyncEventQueueCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.CacheCreation;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class AsyncEventQueueFactoryImpl
implements AsyncEventQueueFactory {
    private static final Logger logger = LogService.getLogger();
    private GatewaySenderAttributes attrs = new GatewaySenderAttributes();
    private Cache cache;
    public static final int DEFAULT_BATCH_TIME_INTERVAL = 5;

    public AsyncEventQueueFactoryImpl(Cache cache) {
        this.cache = cache;
        this.attrs = new GatewaySenderAttributes();
        this.attrs.batchTimeInterval = 5;
    }

    @Override
    public AsyncEventQueueFactory setBatchSize(int size2) {
        this.attrs.batchSize = size2;
        return this;
    }

    @Override
    public AsyncEventQueueFactory setPersistent(boolean isPersistent) {
        this.attrs.isPersistenceEnabled = isPersistent;
        return this;
    }

    @Override
    public AsyncEventQueueFactory setDiskStoreName(String name) {
        this.attrs.diskStoreName = name;
        return this;
    }

    @Override
    public AsyncEventQueueFactory setMaximumQueueMemory(int memory) {
        this.attrs.maximumQueueMemory = memory;
        return this;
    }

    @Override
    public AsyncEventQueueFactory setDiskSynchronous(boolean isSynchronous) {
        this.attrs.isDiskSynchronous = isSynchronous;
        return this;
    }

    @Override
    public AsyncEventQueueFactory setBatchTimeInterval(int batchTimeInterval) {
        this.attrs.batchTimeInterval = batchTimeInterval;
        return this;
    }

    @Override
    public AsyncEventQueueFactory setBatchConflationEnabled(boolean isConflation) {
        this.attrs.isBatchConflationEnabled = isConflation;
        return this;
    }

    @Override
    public AsyncEventQueueFactory setDispatcherThreads(int numThreads) {
        this.attrs.dispatcherThreads = numThreads;
        return this;
    }

    @Override
    public AsyncEventQueueFactory setOrderPolicy(Gateway.OrderPolicy policy) {
        this.attrs.policy = policy;
        return this;
    }

    @Override
    public AsyncEventQueueFactory addGatewayEventFilter(GatewayEventFilter filter) {
        this.attrs.addGatewayEventFilter(filter);
        return this;
    }

    @Override
    public AsyncEventQueueFactory removeGatewayEventFilter(GatewayEventFilter filter) {
        this.attrs.eventFilters.remove(filter);
        return this;
    }

    @Override
    public AsyncEventQueueFactory setGatewayEventSubstitutionListener(GatewayEventSubstitutionFilter filter) {
        this.attrs.eventSubstitutionFilter = filter;
        return this;
    }

    public AsyncEventQueueFactory removeGatewayEventAlternateValueProvider(GatewayEventSubstitutionFilter provider) {
        return this;
    }

    @Override
    public AsyncEventQueue create(String asyncQueueId, AsyncEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(LocalizedStrings.AsyncEventQueue_ASYNC_EVENT_LISTENER_CANNOT_BE_NULL.toLocalizedString());
        }
        AsyncEventQueue asyncEventQueue = null;
        if (this.cache instanceof GemFireCacheImpl) {
            if (logger.isDebugEnabled()) {
                logger.debug("Creating GatewaySender that underlies the AsyncEventQueue");
            }
            GatewaySenderFactory senderFactory = this.cache.createGatewaySenderFactory();
            senderFactory.setMaximumQueueMemory(this.attrs.getMaximumQueueMemory());
            senderFactory.setBatchSize(this.attrs.getBatchSize());
            senderFactory.setBatchTimeInterval(this.attrs.getBatchTimeInterval());
            if (this.attrs.isPersistenceEnabled()) {
                senderFactory.setPersistenceEnabled(true);
            }
            senderFactory.setDiskStoreName(this.attrs.getDiskStoreName());
            senderFactory.setDiskSynchronous(this.attrs.isDiskSynchronous());
            senderFactory.setBatchConflationEnabled(this.attrs.isBatchConflationEnabled());
            senderFactory.setParallel(this.attrs.isParallel());
            senderFactory.setDispatcherThreads(this.attrs.getDispatcherThreads());
            if (this.attrs.getOrderPolicy() != null) {
                senderFactory.setOrderPolicy(this.attrs.getOrderPolicy());
            }
            for (GatewayEventFilter filter : this.attrs.eventFilters) {
                senderFactory.addGatewayEventFilter(filter);
            }
            senderFactory.setGatewayEventSubstitutionFilter(this.attrs.getGatewayEventSubstitutionFilter());
            GatewaySenderFactoryImpl factoryImpl = (GatewaySenderFactoryImpl)senderFactory;
            factoryImpl.setForInternalUse(true);
            factoryImpl.addAsyncEventListener(listener);
            factoryImpl.setBucketSorted(this.attrs.isBucketSorted());
            GatewaySender sender = factoryImpl.create(AsyncEventQueueImpl.getSenderIdFromAsyncEventQueueId(asyncQueueId));
            asyncEventQueue = new AsyncEventQueueImpl(sender, listener);
            ((GemFireCacheImpl)this.cache).addAsyncEventQueue(asyncEventQueue);
        } else if (this.cache instanceof CacheCreation) {
            asyncEventQueue = new AsyncEventQueueCreation(asyncQueueId, this.attrs, listener);
            ((CacheCreation)this.cache).addAsyncEventQueue(asyncEventQueue);
        }
        return asyncEventQueue;
    }

    public void configureAsyncEventQueue(AsyncEventQueue asyncQueueCreation) {
        this.attrs.batchSize = asyncQueueCreation.getBatchSize();
        this.attrs.batchTimeInterval = asyncQueueCreation.getBatchTimeInterval();
        this.attrs.isBatchConflationEnabled = asyncQueueCreation.isBatchConflationEnabled();
        this.attrs.isPersistenceEnabled = asyncQueueCreation.isPersistent();
        this.attrs.diskStoreName = asyncQueueCreation.getDiskStoreName();
        this.attrs.isDiskSynchronous = asyncQueueCreation.isDiskSynchronous();
        this.attrs.maximumQueueMemory = asyncQueueCreation.getMaximumQueueMemory();
        this.attrs.isParallel = asyncQueueCreation.isParallel();
        this.attrs.isBucketSorted = ((AsyncEventQueueCreation)asyncQueueCreation).isBucketSorted();
        this.attrs.dispatcherThreads = asyncQueueCreation.getDispatcherThreads();
        this.attrs.policy = asyncQueueCreation.getOrderPolicy();
        this.attrs.eventFilters = asyncQueueCreation.getGatewayEventFilters();
        this.attrs.eventSubstitutionFilter = asyncQueueCreation.getGatewayEventSubstitutionFilter();
    }

    @Override
    public AsyncEventQueueFactory setParallel(boolean isParallel) {
        this.attrs.isParallel = isParallel;
        return this;
    }

    public AsyncEventQueueFactory setBucketSorted(boolean isbucketSorted) {
        this.attrs.isBucketSorted = isbucketSorted;
        return this;
    }
}

