/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache;

import com.gemstone.gemfire.cache.RegionRoleException;
import com.gemstone.gemfire.distributed.Role;
import com.gemstone.gemfire.distributed.internal.membership.InternalRole;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class RegionDistributionException
extends RegionRoleException {
    private static final long serialVersionUID = -5950359426786805646L;
    private transient Set failedRoles = Collections.EMPTY_SET;

    public RegionDistributionException(String s, String regionFullPath, Set failedRoles) {
        super(s, regionFullPath);
        this.failedRoles = failedRoles;
        if (this.failedRoles == null) {
            this.failedRoles = Collections.EMPTY_SET;
        }
    }

    public RegionDistributionException(String s, String regionFullPath, Set failedRoles, Throwable ex) {
        super(s, regionFullPath, ex);
        this.failedRoles = failedRoles;
        if (this.failedRoles == null) {
            this.failedRoles = Collections.EMPTY_SET;
        }
    }

    public Set getFailedRoles() {
        return this.failedRoles;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        HashSet<String> roleNames = new HashSet<String>(this.failedRoles.size());
        Iterator iter = this.failedRoles.iterator();
        while (iter.hasNext()) {
            String name = ((Role)iter.next()).getName();
            roleNames.add(name);
        }
        out.writeObject(roleNames);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        Set roleNames = (Set)in.readObject();
        HashSet<InternalRole> roles = new HashSet<InternalRole>(roleNames.size());
        for (String name : roleNames) {
            roles.add(InternalRole.getRole(name));
        }
        this.failedRoles = roles;
    }
}

