/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache;

import com.gemstone.gemfire.InternalGemFireError;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.DiskWriteAttributesFactory;
import com.gemstone.gemfire.cache.DynamicRegionListener;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.RegionExistsException;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.internal.ServerRegionProxy;
import com.gemstone.gemfire.cache.util.BridgeWriter;
import com.gemstone.gemfire.cache.wan.GatewaySender;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.DynamicRegionAttributes;
import com.gemstone.gemfire.internal.cache.DynamicRegionFactoryImpl;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EnumListenerEvent;
import com.gemstone.gemfire.internal.cache.EvictionAttributesImpl;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.InitialImageOperation;
import com.gemstone.gemfire.internal.cache.InternalRegionArguments;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEventImpl;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.security.GemFireSecurityException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;

public abstract class DynamicRegionFactory {
    public static final String dynamicRegionListName = "__DynamicRegions";
    private Region dynamicRegionList = null;
    private static final long regionCreateSleepMillis = Long.getLong("DynamicRegionFactory.msDelay", 250L);
    private static DynamicRegionFactory singleInstance = new DynamicRegionFactoryImpl();
    GemFireCacheImpl c = null;
    Config config = null;
    private static volatile List regionListeners = Collections.EMPTY_LIST;
    private static final Object regionListenerLock = new Object();

    public void open() {
        this.open(new Config());
    }

    public void open(Config conf) {
        this.config = new Config(conf);
    }

    protected void _close() {
        this.config = null;
        this.c = null;
    }

    public boolean isOpen() {
        return this.getConfig() != null;
    }

    public boolean isActive() {
        return this.isOpen() && this.c != null;
    }

    public boolean isClosed() {
        return !this.isOpen();
    }

    public Config getConfig() {
        if (this.config == null) {
            return null;
        }
        return new Config(this.config);
    }

    public static boolean regionIsDynamicRegionList(String regionPath) {
        return regionPath != null && regionPath.equals("/__DynamicRegions");
    }

    protected void _internalInit(GemFireCacheImpl theCache) throws CacheException {
        if (this.isClosed()) {
            return;
        }
        try {
            boolean isClient;
            this.c = theCache;
            this.dynamicRegionList = theCache.getRegion(dynamicRegionListName);
            boolean bl = isClient = this.config.getBridgeWriter() != null || this.config.getPoolName() != null;
            if (this.dynamicRegionList == null) {
                InternalGemFireError assErr;
                InternalRegionArguments ira = new InternalRegionArguments().setDestroyLockFlag(true).setSnapshotInputStream(null).setImageTarget(null);
                AttributesFactory af = new AttributesFactory();
                if (this.config.getPersistBackup()) {
                    af.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
                    af.setDiskWriteAttributes(new DiskWriteAttributesFactory().create());
                    if (this.config.getDiskDir() != null) {
                        af.setDiskDirs(new File[]{this.config.getDiskDir()});
                    }
                }
                if (isClient) {
                    af.setScope(Scope.LOCAL);
                    af.setDataPolicy(DataPolicy.NORMAL);
                    af.setStatisticsEnabled(true);
                    String cpName = this.config.getPoolName();
                    if (cpName != null) {
                        Pool cp = PoolManager.find(cpName);
                        if (cp == null) {
                            throw new IllegalStateException("Invalid pool name specified. This pool is not registered with the cache: " + cpName);
                        }
                        if (!cp.getSubscriptionEnabled()) {
                            throw new IllegalStateException("The client pool of a DynamicRegionFactory must be configured with queue-enabled set to true.");
                        }
                        af.setPoolName(cpName);
                    } else {
                        BridgeWriter bw = this.config.getBridgeWriter();
                        if (!bw.hasEstablishCallbackConnection()) {
                            throw new IllegalStateException(LocalizedStrings.DynamicRegionFactory_THE_CLIENT_POOL_OF_A_DYNAMICREGIONFACTORY_MUST_BE_CONFIGURED_WITH_ESTABLISHCALLBACKCONNECTION_SET_TO_TRUE.toLocalizedString());
                        }
                        af.setCacheWriter(bw);
                    }
                    ira.setInternalMetaRegion(new LocalMetaRegion(af.create(), ira));
                } else {
                    af.setScope(Scope.DISTRIBUTED_ACK);
                    if (!this.config.getPersistBackup()) {
                        af.setDataPolicy(DataPolicy.REPLICATE);
                    }
                    af.setEnableGateway(true);
                    for (GatewaySender gs : this.c.getGatewaySenders()) {
                        if (gs.isParallel()) continue;
                        af.addGatewaySenderId(gs.getId());
                    }
                    ira.setInternalMetaRegion(new DistributedMetaRegion(af.create()));
                }
                try {
                    this.dynamicRegionList = theCache.createVMRegion(dynamicRegionListName, af.create(), ira);
                }
                catch (IOException e) {
                    assErr = new InternalGemFireError(LocalizedStrings.DynamicRegionFactory_UNEXPECTED_EXCEPTION.toLocalizedString());
                    assErr.initCause(e);
                    throw assErr;
                }
                catch (ClassNotFoundException e) {
                    assErr = new InternalGemFireError(LocalizedStrings.DynamicRegionFactory_UNEXPECTED_EXCEPTION.toLocalizedString());
                    assErr.initCause(e);
                    throw assErr;
                }
                if (isClient) {
                    this.dynamicRegionList.registerInterest("ALL_KEYS");
                }
                if (theCache.getLoggerI18n().fineEnabled()) {
                    theCache.getLoggerI18n().fine("Created dynamic region: " + this.dynamicRegionList);
                }
            } else if (theCache.getLoggerI18n().fineEnabled()) {
                theCache.getLoggerI18n().fine("Retrieved dynamic region: " + this.dynamicRegionList);
            }
            this.createDefinedDynamicRegions();
        }
        catch (CacheException e) {
            theCache.getLoggerI18n().warning(LocalizedStrings.DynamicRegionFactory_ERROR_INITIALIZING_DYNAMICREGIONFACTORY, e);
            throw e;
        }
    }

    private void createDefinedDynamicRegions() throws CacheException {
        Set<Region.Entry<?, ?>> s = this.dynamicRegionList.entrySet(false);
        Iterator<Region.Entry<Object, Object>> i = s.iterator();
        TreeMap<String, DynamicRegionAttributes> sorted = new TreeMap<String, DynamicRegionAttributes>();
        while (i.hasNext()) {
            Region.Entry<?, ?> e = i.next();
            DynamicRegionAttributes dda = (DynamicRegionAttributes)e.getValue();
            sorted.put(dda.rootRegionName + "/" + dda.name, dda);
        }
        for (DynamicRegionAttributes dda : sorted.values()) {
            this.doBeforeRegionCreated(dda.rootRegionName, dda.name, null);
            Region region = this.createDynamicRegionImpl(dda.rootRegionName, dda.name, false);
            this.doAfterRegionCreated(region, false, false, null);
        }
    }

    public static DynamicRegionFactory get() {
        return singleInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDynamicRegionListener(DynamicRegionListener listener) {
        Object object = regionListenerLock;
        synchronized (object) {
            List oldListeners = regionListeners;
            if (!oldListeners.contains(listener)) {
                ArrayList<DynamicRegionListener> newListeners = new ArrayList<DynamicRegionListener>(oldListeners);
                newListeners.add(listener);
                regionListeners = newListeners;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterDynamicRegionListener(DynamicRegionListener listener) {
        Object object = regionListenerLock;
        synchronized (object) {
            ArrayList newListeners;
            List oldListeners = regionListeners;
            if (oldListeners.contains(listener) && (newListeners = new ArrayList(oldListeners)).remove(listener)) {
                regionListeners = newListeners;
            }
        }
    }

    private void doBeforeRegionCreated(String parentRegion, String regionName, DistributedMember mbr) {
        for (DynamicRegionListener listener : regionListeners) {
            try {
                listener.beforeRegionCreate(parentRegion, regionName);
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
                this.c.getLoggerI18n().warning(LocalizedStrings.DynamicRegionFactory_DYNAMICREGIONLISTENER__0__THREW_EXCEPTION_ON_BEFOREREGIONCREATED, listener, t);
            }
        }
    }

    private void doAfterRegionCreated(Region region, boolean distributed, boolean isOriginRemote, DistributedMember mbr) {
        RegionEventImpl event = new RegionEventImpl(region, Operation.REGION_CREATE, null, isOriginRemote, this.getMember(mbr));
        for (DynamicRegionListener listener : regionListeners) {
            try {
                listener.afterRegionCreate(event);
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
                this.c.getLoggerI18n().warning(LocalizedStrings.DynamicRegionFactory_DYNAMICREGIONLISTENER__0__THREW_EXCEPTION_ON_AFTERREGIONCREATED, listener, t);
            }
        }
    }

    private void doBeforeRegionDestroyed(Region region, boolean distributed, boolean isOriginRemote, boolean expiration, DistributedMember mbr) {
        Operation op = !distributed && !isOriginRemote ? (expiration ? Operation.REGION_EXPIRE_LOCAL_DESTROY : Operation.REGION_LOCAL_DESTROY) : (expiration ? Operation.REGION_EXPIRE_DESTROY : Operation.REGION_DESTROY);
        RegionEventImpl event = new RegionEventImpl(region, op, null, isOriginRemote, this.getMember(mbr));
        for (DynamicRegionListener listener : regionListeners) {
            try {
                listener.beforeRegionDestroy(event);
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
                this.c.getLoggerI18n().warning(LocalizedStrings.DynamicRegionFactory_DYNAMICREGIONLISTENER__0__THREW_EXCEPTION_ON_BEFOREREGIONDESTROYED, listener, t);
            }
        }
    }

    private void doAfterRegionDestroyed(Region region, boolean distributed, boolean isOriginRemote, boolean expiration, DistributedMember mbr) {
        Operation op = !distributed && !isOriginRemote ? (expiration ? Operation.REGION_EXPIRE_LOCAL_DESTROY : Operation.REGION_LOCAL_DESTROY) : (expiration ? Operation.REGION_EXPIRE_DESTROY : Operation.REGION_DESTROY);
        RegionEventImpl event = new RegionEventImpl(region, op, null, isOriginRemote, this.getMember(mbr));
        for (DynamicRegionListener listener : regionListeners) {
            try {
                listener.afterRegionDestroy(event);
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
                this.c.getLoggerI18n().warning(LocalizedStrings.DynamicRegionFactory_DYNAMICREGIONLISTENER__0__THREW_EXCEPTION_ON_AFTERREGIONDESTROYED, listener, t);
            }
        }
    }

    private DistributedMember getMember(DistributedMember mbr) {
        if (mbr == null) {
            return InternalDistributedSystem.getAnyInstance().getDistributedMember();
        }
        return null;
    }

    public Region createDynamicRegion(String parentRegionName, String regionName) throws CacheException {
        if (this.isClosed()) {
            throw new IllegalStateException("Dynamic region factory is closed");
        }
        this.doBeforeRegionCreated(parentRegionName, regionName, null);
        Region region = this.createDynamicRegionImpl(parentRegionName, regionName, true);
        this.doAfterRegionCreated(region, false, false, null);
        return region;
    }

    public void destroyDynamicRegion(String fullRegionName) throws CacheException {
        if (!this.dynamicRegionList.containsKey(fullRegionName)) {
            throw new RegionDestroyedException(LocalizedStrings.DynamicRegionFactory_DYNAMIC_REGION_0_HAS_NOT_BEEN_CREATED.toLocalizedString(fullRegionName), fullRegionName);
        }
        if (this.isClosed()) {
            throw new IllegalStateException("Dynamic region factory is closed");
        }
        Region region = this.c.getRegion(fullRegionName);
        if (region != null) {
            DistributedMember mbr = this.getMember(null);
            this.doBeforeRegionDestroyed(region, false, false, false, mbr);
            region.localDestroyRegion();
            this.destroyDynamicRegionImpl(fullRegionName);
            this.doAfterRegionDestroyed(region, false, false, false, mbr);
        } else {
            this.destroyDynamicRegionImpl(fullRegionName);
        }
    }

    private Region createDynamicRegionImpl(String parentRegionName, String newRegionName, boolean addEntry) throws CacheException {
        ServerRegionProxy proxy;
        Region parentRegion = this.c.getRegion(parentRegionName);
        Region newRegion = null;
        if (parentRegion == null) {
            String errMsg = LocalizedStrings.DynamicRegionFactory_ERROR__COULD_NOT_FIND_A_REGION_NAMED___0_.toLocalizedString(parentRegionName);
            RegionDestroyedException e = new RegionDestroyedException(errMsg, parentRegionName);
            this.c.getLoggerI18n().warning(LocalizedStrings.DynamicRegionFactory_ERROR__COULD_NOT_FIND_A_REGION_NAMED___0_, parentRegionName, (Throwable)e);
            throw e;
        }
        RegionAttributes rra = parentRegion.getAttributes();
        RegionAttributes newRegionAttributes = null;
        AttributesFactory af = new AttributesFactory(rra);
        EvictionAttributes ev = rra.getEvictionAttributes();
        if (ev != null && ev.getAlgorithm().isLRU()) {
            EvictionAttributesImpl rev = new EvictionAttributesImpl((EvictionAttributesImpl)ev);
            af.setEvictionAttributes(rev);
        }
        if (newRegionName.endsWith("_PRTEST_")) {
            af.setPartitionAttributes(new PartitionAttributesFactory().create());
        }
        newRegionAttributes = af.create();
        try {
            newRegion = parentRegion.createSubregion(newRegionName, newRegionAttributes);
            this.c.getLoggerI18n().fine("Created dynamic region " + newRegion);
        }
        catch (RegionExistsException ex) {
            this.c.getLoggerI18n().fine("DynamicRegion " + newRegionName + " in parent " + parentRegionName + " already existed");
            newRegion = ex.getRegion();
        }
        if (addEntry) {
            DynamicRegionAttributes dra = new DynamicRegionAttributes();
            dra.name = newRegionName;
            dra.rootRegionName = parentRegion.getFullPath();
            if (this.c.getLoggerI18n().fineEnabled()) {
                this.c.getLoggerI18n().fine("Putting entry into dynamic region list at key: " + newRegion.getFullPath());
            }
            this.dynamicRegionList.put(newRegion.getFullPath(), dra);
        }
        if (this.config.getRegisterInterest() && (proxy = ((LocalRegion)newRegion).getServerProxy()) != null && proxy.getPool().getSubscriptionEnabled()) {
            try {
                newRegion.registerInterest("ALL_KEYS");
            }
            catch (GemFireSecurityException ex) {
                this.c.getSecurityLoggerI18n().warning(LocalizedStrings.DynamicRegionFactory_EXCEPTION_WHEN_REGISTERING_INTEREST_FOR_ALL_KEYS_IN_DYNAMIC_REGION_0_1, new Object[]{newRegion.getFullPath(), ex});
            }
        }
        if (regionCreateSleepMillis > 0L) {
            try {
                Thread.sleep(regionCreateSleepMillis);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (this.c.getLoggerI18n().fineEnabled()) {
            this.c.getLoggerI18n().fine("Created Dynamic Region " + newRegion.getFullPath());
        }
        return newRegion;
    }

    private void destroyDynamicRegionImpl(String fullRegionName) throws CacheException {
        try {
            if (this.c.getLoggerI18n().fineEnabled()) {
                this.c.getLoggerI18n().fine("Destroying entry from dynamic region list at key: " + fullRegionName);
            }
            this.dynamicRegionList.destroy(fullRegionName);
        }
        catch (CacheException e) {
            this.c.getLoggerI18n().warning(LocalizedStrings.DynamicRegionFactory_ERROR_DESTROYING_DYNAMIC_REGION__0, fullRegionName, (Throwable)e);
            throw e;
        }
        if (this.c.getLoggerI18n().fineEnabled()) {
            this.c.getLoggerI18n().fine("Destroyed Dynamic Region " + fullRegionName);
        }
    }

    protected void buildDynamicRegion(EntryEvent event) {
        if (!this.isOpen()) {
            return;
        }
        if (!event.isOriginRemote() && !event.isBridgeEvent()) {
            return;
        }
        DynamicRegionAttributes dra = (DynamicRegionAttributes)event.getNewValue();
        String parentRegionName = dra.rootRegionName;
        String newRegionName = dra.name;
        try {
            this.doBeforeRegionCreated(parentRegionName, newRegionName, event.getDistributedMember());
            Region region = this.createDynamicRegionImpl(parentRegionName, newRegionName, false);
            this.doAfterRegionCreated(region, true, true, event.getDistributedMember());
        }
        catch (Exception e) {
            this.c.getLoggerI18n().warning(LocalizedStrings.DynamicRegionFactory_ERROR_ATTEMPTING_TO_LOCALLY_CREATE_DYNAMIC_REGION__0, newRegionName, (Throwable)e);
        }
    }

    protected void razeDynamicRegion(EntryEvent event) {
        if (!this.isOpen()) {
            return;
        }
        String fullRegionName = (String)event.getKey();
        Region drRegion = this.c.getRegion(fullRegionName);
        if (drRegion != null) {
            try {
                this.doBeforeRegionDestroyed(drRegion, true, event.getOperation().isDistributed(), event.getOperation().isExpiration(), event.getDistributedMember());
                drRegion.localDestroyRegion();
                this.doAfterRegionDestroyed(drRegion, true, event.getOperation().isDistributed(), event.getOperation().isExpiration(), event.getDistributedMember());
            }
            catch (Exception e) {
                this.c.getLoggerI18n().warning(LocalizedStrings.DynamicRegionFactory_ERROR_ATTEMPTING_TO_LOCALLY_DESTROY_DYNAMIC_REGION__0, fullRegionName, (Throwable)e);
            }
        }
    }

    private class DistributedMetaRegion
    extends DistributedRegion {
        protected DistributedMetaRegion(RegionAttributes attrs) {
            super(DynamicRegionFactory.dynamicRegionListName, attrs, null, DynamicRegionFactory.this.c, new InternalRegionArguments());
        }

        @Override
        protected boolean isSecret() {
            return true;
        }

        @Override
        protected boolean isCopyOnRead() {
            return false;
        }

        @Override
        public final boolean shouldNotifyBridgeClients() {
            return this.getCache().getBridgeServers().size() > 0;
        }

        @Override
        public void invokeDestroyCallbacks(EnumListenerEvent eventType, EntryEventImpl event, boolean callDispatchEventsCallback, boolean notifyGateways) {
            Assert.assertTrue(eventType.equals(EnumListenerEvent.AFTER_DESTROY));
            event.setEventType(eventType);
            this.notifyBridgeClients(event);
            if (notifyGateways) {
                this.notifyGatewayHubs(eventType, event);
            }
            DynamicRegionFactory.this.razeDynamicRegion(event);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected long basicPutPart2(EntryEventImpl event, RegionEntry entry, boolean isInitialized, long lastModified, boolean clearConflict) {
            boolean isCreate = event.getOperation().isCreate();
            boolean set = false;
            if (isCreate && !event.callbacksInvoked()) {
                event.callbacksInvoked(true);
                set = true;
            }
            long result = super.basicPutPart2(event, entry, isInitialized, lastModified, clearConflict);
            if (set) {
                event.callbacksInvoked(false);
            }
            if (isCreate) {
                try {
                    InitialImageOperation.setInhibitStateFlush(true);
                    DynamicRegionFactory.this.buildDynamicRegion(event);
                }
                finally {
                    InitialImageOperation.setInhibitStateFlush(false);
                }
            }
            return result;
        }

        @Override
        public void basicPutPart3(EntryEventImpl event, RegionEntry entry, boolean isInitialized, long lastModified, boolean invokeCallbacks, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue) {
            super.basicPutPart3(event, entry, isInitialized, lastModified, invokeCallbacks, ifNew, ifOld, expectedOldValue, requireOldValue);
            if (invokeCallbacks &= !entry.isTombstone()) {
                boolean doCallback = false;
                if (isInitialized && event.isGenerateCallbacks()) {
                    doCallback = true;
                }
                if (doCallback) {
                    this.notifyGatewayHubs(event.getOperation().isUpdate() ? EnumListenerEvent.AFTER_UPDATE : EnumListenerEvent.AFTER_CREATE, event);
                    if (!event.isBulkOpInProgress()) {
                        try {
                            entry.dispatchListenerEvents(event);
                        }
                        catch (InterruptedException ie) {
                            Thread.currentThread().interrupt();
                            this.stopper.checkCancelInProgress(null);
                        }
                    }
                }
            }
        }
    }

    private class LocalMetaRegion
    extends LocalRegion {
        protected LocalMetaRegion(RegionAttributes attrs, InternalRegionArguments ira) {
            super(DynamicRegionFactory.dynamicRegionListName, attrs, null, DynamicRegionFactory.this.c, ira);
            Assert.assertTrue(attrs.getScope().isLocal());
        }

        @Override
        protected boolean isSecret() {
            return true;
        }

        @Override
        protected boolean isCopyOnRead() {
            return false;
        }

        @Override
        protected boolean shouldNotifyBridgeClients() {
            return this.getCache().getBridgeServers().size() > 0;
        }

        @Override
        public void invokeDestroyCallbacks(EnumListenerEvent eventType, EntryEventImpl event, boolean callDispatchEventsCallback, boolean notifyGateways) {
            Assert.assertTrue(eventType.equals(EnumListenerEvent.AFTER_DESTROY));
            event.setEventType(eventType);
            this.notifyBridgeClients(event);
            if (notifyGateways) {
                this.notifyGatewayHubs(eventType, event);
            }
            DynamicRegionFactory.this.razeDynamicRegion(event);
        }

        @Override
        protected long basicPutPart2(EntryEventImpl event, RegionEntry entry, boolean isInitialized, long lastModified, boolean clearConflict) {
            boolean isCreate = event.getOperation().isCreate();
            boolean set = false;
            if (isCreate && !event.callbacksInvoked()) {
                event.callbacksInvoked(true);
                set = true;
            }
            long result = super.basicPutPart2(event, entry, isInitialized, lastModified, clearConflict);
            if (set) {
                event.callbacksInvoked(false);
            }
            if (isCreate) {
                DynamicRegionFactory.this.buildDynamicRegion(event);
            }
            return result;
        }

        @Override
        public void basicPutPart3(EntryEventImpl event, RegionEntry entry, boolean isInitialized, long lastModified, boolean invokeCallbacks, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue) {
            super.basicPutPart3(event, entry, isInitialized, lastModified, invokeCallbacks, ifNew, ifOld, expectedOldValue, requireOldValue);
            if (invokeCallbacks &= !entry.isTombstone()) {
                boolean doCallback = false;
                if (isInitialized && event.isGenerateCallbacks()) {
                    doCallback = true;
                }
                if (doCallback) {
                    this.notifyGatewayHubs(event.getOperation().isUpdate() ? EnumListenerEvent.AFTER_UPDATE : EnumListenerEvent.AFTER_CREATE, event);
                    if (!event.isBulkOpInProgress()) {
                        try {
                            entry.dispatchListenerEvents(event);
                        }
                        catch (InterruptedException ie) {
                            Thread.currentThread().interrupt();
                            this.stopper.checkCancelInProgress(null);
                        }
                    }
                }
            }
        }
    }

    public static class Config {
        private static final boolean DISABLE_REGISTER_INTEREST = Boolean.getBoolean("DynamicRegionFactory.disableRegisterInterest");
        private static final boolean DISABLE_PERSIST_BACKUP = Boolean.getBoolean("DynamicRegionFactory.disablePersistence");
        public final boolean persistBackup;
        public final File diskDir;
        public final boolean registerInterest;
        public final BridgeWriter bridgeWriter;
        public final String poolName;

        public Config() {
            this(null, null, !DISABLE_PERSIST_BACKUP);
        }

        @Deprecated
        public Config(File diskDir, BridgeWriter bridgeWriter) {
            this(diskDir, bridgeWriter, !DISABLE_PERSIST_BACKUP);
        }

        @Deprecated
        public Config(File diskDir, BridgeWriter bridgeWriter, boolean persistBackup) {
            this(diskDir, bridgeWriter, persistBackup, !DISABLE_REGISTER_INTEREST);
        }

        @Deprecated
        public Config(File diskDir, BridgeWriter bridgeWriter, boolean persistBackup, boolean registerInterest) {
            this.registerInterest = registerInterest;
            this.persistBackup = persistBackup;
            this.diskDir = diskDir;
            this.bridgeWriter = bridgeWriter;
            this.poolName = null;
        }

        public Config(File diskDir, String poolName, boolean persistBackup, boolean registerInterest) {
            this.registerInterest = registerInterest;
            this.persistBackup = persistBackup;
            this.diskDir = diskDir;
            this.poolName = poolName;
            this.bridgeWriter = null;
        }

        public boolean getPersistBackup() {
            return this.persistBackup;
        }

        public boolean getRegisterInterest() {
            return this.registerInterest;
        }

        public File getDiskDir() {
            return this.diskDir;
        }

        public BridgeWriter getBridgeWriter() {
            return this.bridgeWriter;
        }

        public String getPoolName() {
            return this.poolName;
        }

        Config(Config conf) {
            this.diskDir = conf.diskDir;
            this.persistBackup = conf.persistBackup;
            this.bridgeWriter = conf.bridgeWriter;
            this.registerInterest = conf.registerInterest;
            this.poolName = conf.poolName;
        }
    }
}

