/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.CacheExistsException;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.GatewayException;
import com.gemstone.gemfire.cache.RegionExistsException;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.GemFireVersion;
import com.gemstone.gemfire.internal.cache.CacheConfig;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.pdx.PdxSerializer;
import java.util.Properties;

public class CacheFactory {
    private final Properties dsProps;
    private final CacheConfig cacheConfig = new CacheConfig();

    public CacheFactory() {
        this(null);
    }

    public CacheFactory(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        this.dsProps = props;
    }

    public CacheFactory set(String name, String value2) {
        this.dsProps.setProperty(name, value2);
        return this;
    }

    @Deprecated
    public static synchronized Cache create(DistributedSystem system) throws CacheExistsException, TimeoutException, CacheWriterException, GatewayException, RegionExistsException {
        return CacheFactory.create(system, false, new CacheConfig());
    }

    private static synchronized Cache create(DistributedSystem system, boolean existingOk, CacheConfig cacheConfig) throws CacheExistsException, TimeoutException, CacheWriterException, GatewayException, RegionExistsException {
        GemFireCacheImpl instance = GemFireCacheImpl.getInstance();
        if (instance != null && !instance.isClosed()) {
            if (existingOk) {
                cacheConfig.validateCacheConfig(instance);
                return instance;
            }
            throw new CacheExistsException(instance, LocalizedStrings.CacheFactory_0_AN_OPEN_CACHE_ALREADY_EXISTS.toLocalizedString(instance), instance.creationStack);
        }
        return GemFireCacheImpl.create(system, cacheConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cache create() throws TimeoutException, CacheWriterException, GatewayException, RegionExistsException {
        Class<CacheFactory> clazz = CacheFactory.class;
        synchronized (CacheFactory.class) {
            DistributedSystem ds = null;
            if (this.dsProps.isEmpty()) {
                ds = InternalDistributedSystem.getConnectedInstance();
            }
            if (ds == null) {
                ds = DistributedSystem.connect(this.dsProps);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return CacheFactory.create(ds, true, this.cacheConfig);
        }
    }

    public static Cache getInstance(DistributedSystem system) {
        return CacheFactory.basicGetInstance(system, false);
    }

    public static Cache getInstanceCloseOk(DistributedSystem system) {
        return CacheFactory.basicGetInstance(system, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Cache basicGetInstance(DistributedSystem system, boolean closeOk) {
        int initReq = LocalRegion.threadInitLevelRequirement();
        if (initReq == 2 || initReq == 1) {
            return CacheFactory.basicGetInstancePart2(system, closeOk);
        }
        Class<CacheFactory> clazz = CacheFactory.class;
        synchronized (CacheFactory.class) {
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return CacheFactory.basicGetInstancePart2(system, closeOk);
        }
    }

    private static Cache basicGetInstancePart2(DistributedSystem system, boolean closeOk) {
        GemFireCacheImpl instance = GemFireCacheImpl.getInstance();
        if (instance == null) {
            throw new CacheClosedException(LocalizedStrings.CacheFactory_A_CACHE_HAS_NOT_YET_BEEN_CREATED.toLocalizedString());
        }
        if (instance.isClosed() && !closeOk) {
            throw instance.getCacheClosedException(LocalizedStrings.CacheFactory_THE_CACHE_HAS_BEEN_CLOSED.toLocalizedString(), null);
        }
        if (!instance.getDistributedSystem().equals(system)) {
            throw new CacheClosedException(LocalizedStrings.CacheFactory_A_CACHE_HAS_NOT_YET_BEEN_CREATED_FOR_THE_GIVEN_DISTRIBUTED_SYSTEM.toLocalizedString());
        }
        return instance;
    }

    public static synchronized Cache getAnyInstance() {
        GemFireCacheImpl instance = GemFireCacheImpl.getInstance();
        if (instance == null) {
            throw new CacheClosedException(LocalizedStrings.CacheFactory_A_CACHE_HAS_NOT_YET_BEEN_CREATED.toLocalizedString());
        }
        instance.getCancelCriterion().checkCancelInProgress(null);
        return instance;
    }

    public static String getVersion() {
        return GemFireVersion.getGemFireVersion();
    }

    public CacheFactory setPdxReadSerialized(boolean readSerialized) {
        this.cacheConfig.setPdxReadSerialized(readSerialized);
        return this;
    }

    public CacheFactory setPdxSerializer(PdxSerializer serializer) {
        this.cacheConfig.setPdxSerializer(serializer);
        return this;
    }

    public CacheFactory setPdxDiskStore(String diskStoreName) {
        this.cacheConfig.setPdxDiskStore(diskStoreName);
        return this;
    }

    public CacheFactory setPdxPersistent(boolean isPersistent) {
        this.cacheConfig.setPdxPersistent(isPersistent);
        return this;
    }

    public CacheFactory setPdxIgnoreUnreadFields(boolean ignore) {
        this.cacheConfig.setPdxIgnoreUnreadFields(ignore);
        return this;
    }
}

