/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin.jmx.internal;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.admin.AdminException;
import com.gemstone.gemfire.admin.SystemMemberCacheServer;
import com.gemstone.gemfire.admin.SystemMemberRegion;
import com.gemstone.gemfire.admin.internal.SystemMemberBridgeServerImpl;
import com.gemstone.gemfire.admin.internal.SystemMemberCacheImpl;
import com.gemstone.gemfire.admin.jmx.internal.DynamicManagedBean;
import com.gemstone.gemfire.admin.jmx.internal.MBeanUtil;
import com.gemstone.gemfire.admin.jmx.internal.ManagedResource;
import com.gemstone.gemfire.admin.jmx.internal.ManagedResourceType;
import com.gemstone.gemfire.admin.jmx.internal.StatisticAttributeInfo;
import com.gemstone.gemfire.admin.jmx.internal.SystemMemberBridgeServerJmxImpl;
import com.gemstone.gemfire.admin.jmx.internal.SystemMemberRegionJmxImpl;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.admin.AdminBridgeServer;
import com.gemstone.gemfire.internal.admin.GemFireVM;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBean;
import org.apache.commons.modeler.ManagedBean;
import org.apache.logging.log4j.Level;

public class SystemMemberCacheJmxImpl
extends SystemMemberCacheImpl
implements ManagedResource {
    private ObjectName objectName;
    private Map<String, SystemMemberRegionJmxImpl> managedRegionResourcesMap = new HashMap<String, SystemMemberRegionJmxImpl>();
    private Map<Number, SystemMemberBridgeServerJmxImpl> managedCacheServerResourcesMap = new HashMap<Number, SystemMemberBridgeServerJmxImpl>();
    private String mbeanName;
    private ModelMBean modelMBean;

    public SystemMemberCacheJmxImpl(GemFireVM vm) throws AdminException {
        super(vm);
        this.initializeMBean();
    }

    private void initializeMBean() throws AdminException {
        this.mbeanName = new StringBuffer("GemFire.Cache:").append("name=").append(MBeanUtil.makeCompliantMBeanNameProperty(this.getName())).append(",id=").append(this.getId()).append(",owner=").append(MBeanUtil.makeCompliantMBeanNameProperty(this.vm.getId().toString())).append(",type=Cache").toString();
        this.objectName = MBeanUtil.createMBean(this, this.addDynamicAttributes(MBeanUtil.lookupManagedBean(this)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected SystemMemberRegion createSystemMemberRegion(Region r) throws AdminException {
        SystemMemberRegionJmxImpl managedSystemMemberRegion = null;
        boolean needsRefresh = false;
        Map<String, SystemMemberRegionJmxImpl> map = this.managedRegionResourcesMap;
        synchronized (map) {
            SystemMemberRegionJmxImpl managedResource = this.managedRegionResourcesMap.get(r.getFullPath());
            if (managedResource != null) {
                managedSystemMemberRegion = managedResource;
            } else {
                managedSystemMemberRegion = new SystemMemberRegionJmxImpl(this, r);
                this.managedRegionResourcesMap.put(r.getFullPath(), managedSystemMemberRegion);
                needsRefresh = true;
            }
        }
        if (needsRefresh) {
            managedSystemMemberRegion.refresh();
        }
        return managedSystemMemberRegion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected SystemMemberBridgeServerImpl createSystemMemberBridgeServer(AdminBridgeServer bridge) throws AdminException {
        SystemMemberBridgeServerJmxImpl managedSystemMemberBridgeServer = null;
        Map<Number, SystemMemberBridgeServerJmxImpl> map = this.managedCacheServerResourcesMap;
        synchronized (map) {
            SystemMemberBridgeServerJmxImpl managedCacheServerResource = this.managedCacheServerResourcesMap.get(bridge.getId());
            if (managedCacheServerResource != null) {
                managedSystemMemberBridgeServer = managedCacheServerResource;
            } else {
                managedSystemMemberBridgeServer = new SystemMemberBridgeServerJmxImpl(this, bridge);
                this.managedCacheServerResourcesMap.put(bridge.getId(), managedSystemMemberBridgeServer);
            }
        }
        return managedSystemMemberBridgeServer;
    }

    ManagedBean addDynamicAttributes(ManagedBean managed) throws AdminException {
        if (managed == null) {
            throw new IllegalArgumentException(LocalizedStrings.SystemMemberCacheJmxImpl_MANAGEDBEAN_IS_NULL.toLocalizedString());
        }
        this.refresh();
        DynamicManagedBean newManagedBean = new DynamicManagedBean(managed);
        for (int i = 0; i < this.statistics.length; ++i) {
            StatisticAttributeInfo attrInfo = new StatisticAttributeInfo();
            attrInfo.setName(this.statistics[i].getName());
            attrInfo.setDisplayName(this.statistics[i].getName());
            attrInfo.setDescription(this.statistics[i].getDescription());
            attrInfo.setType("java.lang.Number");
            attrInfo.setIs(false);
            attrInfo.setReadable(true);
            attrInfo.setWriteable(false);
            attrInfo.setStat(this.statistics[i]);
            newManagedBean.addAttribute(attrInfo);
        }
        return newManagedBean;
    }

    public ObjectName manageRegion(String path) throws AdminException, MalformedObjectNameException {
        try {
            SystemMemberRegionJmxImpl region = null;
            try {
                region = (SystemMemberRegionJmxImpl)this.getRegion(path);
            }
            catch (AdminException e) {
                MBeanUtil.logStackTrace(Level.WARN, e);
                throw e;
            }
            if (region == null) {
                throw new AdminException(LocalizedStrings.SystemMemberCacheJmxImpl_THIS_CACHE_DOES_NOT_CONTAIN_REGION_0.toLocalizedString(path));
            }
            return ObjectName.getInstance(region.getMBeanName());
        }
        catch (RuntimeException e) {
            MBeanUtil.logStackTrace(Level.WARN, e);
            throw e;
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Error e) {
            SystemFailure.checkFailure();
            MBeanUtil.logStackTrace(Level.ERROR, e);
            throw e;
        }
    }

    public ObjectName manageCacheServer() throws AdminException, MalformedObjectNameException {
        try {
            SystemMemberBridgeServerJmxImpl bridge = (SystemMemberBridgeServerJmxImpl)this.addCacheServer();
            return ObjectName.getInstance(bridge.getMBeanName());
        }
        catch (AdminException e) {
            MBeanUtil.logStackTrace(Level.WARN, e);
            throw e;
        }
        catch (RuntimeException e) {
            MBeanUtil.logStackTrace(Level.WARN, e);
            throw e;
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Error e) {
            SystemFailure.checkFailure();
            MBeanUtil.logStackTrace(Level.ERROR, e);
            throw e;
        }
    }

    @Deprecated
    public ObjectName manageBridgeServer() throws AdminException, MalformedObjectNameException {
        return this.manageCacheServer();
    }

    public ObjectName[] manageCacheServers() throws AdminException, MalformedObjectNameException {
        try {
            SystemMemberCacheServer[] bridges = this.getCacheServers();
            ObjectName[] names = new ObjectName[bridges.length];
            for (int i = 0; i < bridges.length; ++i) {
                SystemMemberBridgeServerJmxImpl bridge = (SystemMemberBridgeServerJmxImpl)bridges[i];
                names[i] = ObjectName.getInstance(bridge.getMBeanName());
            }
            return names;
        }
        catch (AdminException e) {
            MBeanUtil.logStackTrace(Level.WARN, e);
            throw e;
        }
        catch (RuntimeException e) {
            MBeanUtil.logStackTrace(Level.WARN, e);
            throw e;
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Error e) {
            SystemFailure.checkFailure();
            MBeanUtil.logStackTrace(Level.ERROR, e);
            throw e;
        }
    }

    @Deprecated
    public ObjectName[] manageBridgeServers() throws AdminException, MalformedObjectNameException {
        return this.manageCacheServers();
    }

    @Override
    public String getMBeanName() {
        return this.mbeanName;
    }

    @Override
    public ModelMBean getModelMBean() {
        return this.modelMBean;
    }

    @Override
    public void setModelMBean(ModelMBean modelMBean) {
        this.modelMBean = modelMBean;
    }

    @Override
    public ObjectName getObjectName() {
        return this.objectName;
    }

    @Override
    public ManagedResourceType getManagedResourceType() {
        return ManagedResourceType.SYSTEM_MEMBER_CACHE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanupResource() {
        Collection<ManagedResource> values;
        Map<Object, ManagedResource> map = this.managedRegionResourcesMap;
        synchronized (map) {
            values = this.managedRegionResourcesMap.values();
            for (SystemMemberRegionJmxImpl systemMemberRegionJmxImpl : values) {
                MBeanUtil.unregisterMBean(systemMemberRegionJmxImpl);
            }
            this.managedRegionResourcesMap.clear();
        }
        map = this.managedCacheServerResourcesMap;
        synchronized (map) {
            values = this.managedCacheServerResourcesMap.values();
            for (SystemMemberBridgeServerJmxImpl systemMemberBridgeServerJmxImpl : values) {
                MBeanUtil.unregisterMBean(systemMemberBridgeServerJmxImpl);
            }
            this.managedCacheServerResourcesMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ManagedResource cleanupRegionResources(String regionPath) {
        SystemMemberRegionJmxImpl cleaned = null;
        Map<String, SystemMemberRegionJmxImpl> map = this.managedRegionResourcesMap;
        synchronized (map) {
            Set<Map.Entry<String, SystemMemberRegionJmxImpl>> entries = this.managedRegionResourcesMap.entrySet();
            Iterator<Map.Entry<String, SystemMemberRegionJmxImpl>> it = entries.iterator();
            while (it.hasNext()) {
                Map.Entry<String, SystemMemberRegionJmxImpl> entry = it.next();
                SystemMemberRegionJmxImpl managedResource = entry.getValue();
                ObjectName objName = managedResource.getObjectName();
                String pathProp = objName.getKeyProperty("path");
                if (pathProp == null || !pathProp.equals(regionPath)) continue;
                cleaned = managedResource;
                it.remove();
                break;
            }
        }
        return cleaned;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SystemMemberCacheJmxImpl)) {
            return false;
        }
        SystemMemberCacheJmxImpl other = (SystemMemberCacheJmxImpl)obj;
        return this.getMBeanName().equals(other.getMBeanName());
    }

    public int hashCode() {
        return this.getMBeanName().hashCode();
    }
}

