/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin.jmx.internal;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.admin.AdminException;
import com.gemstone.gemfire.admin.OperationCancelledException;
import com.gemstone.gemfire.admin.Statistic;
import com.gemstone.gemfire.admin.internal.StatisticResourceImpl;
import com.gemstone.gemfire.admin.jmx.internal.AdminDistributedSystemJmxImpl;
import com.gemstone.gemfire.admin.jmx.internal.DynamicManagedBean;
import com.gemstone.gemfire.admin.jmx.internal.MBeanUtil;
import com.gemstone.gemfire.admin.jmx.internal.ManagedResource;
import com.gemstone.gemfire.admin.jmx.internal.ManagedResourceType;
import com.gemstone.gemfire.admin.jmx.internal.RefreshNotificationType;
import com.gemstone.gemfire.admin.jmx.internal.StatisticAttributeInfo;
import com.gemstone.gemfire.admin.jmx.internal.SystemMemberJmx;
import com.gemstone.gemfire.internal.admin.StatResource;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBean;
import javax.naming.OperationNotSupportedException;
import org.apache.commons.modeler.ManagedBean;
import org.apache.logging.log4j.Logger;

public class StatisticResourceJmxImpl
extends StatisticResourceImpl
implements NotificationListener,
ManagedResource {
    private static final Logger logger = LogService.getLogger();
    private int refreshInterval = 0;
    private ObjectName objectName;
    private boolean timerInited = false;
    private String mbeanName;
    private ModelMBean modelMBean;

    public StatisticResourceJmxImpl(StatResource statResource, SystemMemberJmx member) throws AdminException {
        super(statResource, member);
        this.initializeMBean();
    }

    private void initializeMBean() throws AdminException {
        this.mbeanName = new StringBuffer("GemFire.Statistic:").append("source=").append(MBeanUtil.makeCompliantMBeanNameProperty(this.member.getId())).append(",type=").append(MBeanUtil.makeCompliantMBeanNameProperty(this.getType())).append(",name=").append(MBeanUtil.makeCompliantMBeanNameProperty(this.getName())).append(",uid=").append(this.getUniqueId()).toString();
        this.objectName = MBeanUtil.createMBean(this, this.addDynamicAttributes(MBeanUtil.lookupManagedBean(this)));
        AdminDistributedSystemJmxImpl sysJmx = (AdminDistributedSystemJmxImpl)this.member.getDistributedSystem();
        if (sysJmx.getRefreshInterval() > 0) {
            this.refreshInterval = sysJmx.getRefreshInterval();
        }
    }

    public int getRefreshInterval() {
        return this.refreshInterval;
    }

    private void _setRefreshInterval(int refreshInterval) {
        boolean isRegistered = MBeanUtil.isRefreshNotificationRegistered(this, RefreshNotificationType.STATISTIC_RESOURCE_STATISTICS);
        if (isRegistered && this.getRefreshInterval() == refreshInterval) {
            return;
        }
        try {
            MBeanUtil.registerRefreshNotification(this, this.getMBeanName(), RefreshNotificationType.STATISTIC_RESOURCE_STATISTICS, refreshInterval);
            this.refreshInterval = refreshInterval;
            this.timerInited = true;
        }
        catch (RuntimeException e) {
            logger.warn(e.getMessage(), (Throwable)e);
            this.refreshInterval = 0;
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Error e) {
            SystemFailure.checkFailure();
            logger.error(e.getMessage(), (Throwable)e);
            this.refreshInterval = 0;
        }
    }

    @Deprecated
    public void setRefreshInterval(int refreshInterval) throws OperationNotSupportedException {
        throw new OperationNotSupportedException(LocalizedStrings.MANAGED_RESOURCE_REFRESH_INTERVAL_CANT_BE_SET_DIRECTLY.toLocalizedString());
    }

    @Override
    public void handleNotification(Notification notification, Object hb) {
        AdminDistributedSystemJmxImpl adminDSJmx = (AdminDistributedSystemJmxImpl)this.member.getDistributedSystem();
        String typeStatResourceStats = RefreshNotificationType.STATISTIC_RESOURCE_STATISTICS.getType();
        if (typeStatResourceStats.equals(notification.getType()) && this.getMBeanName().equals(notification.getUserData()) && !adminDSJmx.isRmiClientCountZero()) {
            try {
                this.refresh();
            }
            catch (AdminException e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
            catch (OperationCancelledException e) {
                logger.warn(e.getMessage(), (Throwable)e);
                this._setRefreshInterval(0);
            }
            catch (CancelException e) {
            }
            catch (RuntimeException e) {
                logger.debug(e.getMessage(), (Throwable)e);
                this._setRefreshInterval(0);
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Error e) {
                SystemFailure.checkFailure();
                logger.error(e.getMessage(), (Throwable)e);
                this.refreshInterval = 0;
            }
        }
    }

    ManagedBean addDynamicAttributes(ManagedBean managed) throws AdminException {
        if (managed == null) {
            throw new IllegalArgumentException(LocalizedStrings.StatisticResourceJmxImpl_MANAGEDBEAN_IS_NULL.toLocalizedString());
        }
        this.refresh();
        DynamicManagedBean newManagedBean = new DynamicManagedBean(managed);
        for (int i = 0; i < this.statistics.length; ++i) {
            StatisticAttributeInfo attrInfo = new StatisticAttributeInfo();
            attrInfo.setName(this.statistics[i].getName());
            attrInfo.setDisplayName(this.statistics[i].getName());
            attrInfo.setDescription(this.statistics[i].getDescription());
            attrInfo.setType("java.lang.Number");
            attrInfo.setIs(false);
            attrInfo.setReadable(true);
            attrInfo.setWriteable(false);
            attrInfo.setStat(this.statistics[i]);
            newManagedBean.addAttribute(attrInfo);
        }
        return newManagedBean;
    }

    @Override
    public Statistic[] getStatistics() {
        if (!this.timerInited && this.refreshInterval > 0) {
            this._setRefreshInterval(this.refreshInterval);
        }
        if (this.statistics == null) {
            try {
                this.refresh();
            }
            catch (AdminException e) {
                this.statistics = new Statistic[0];
            }
        }
        return this.statistics;
    }

    @Override
    public String getMBeanName() {
        return this.mbeanName;
    }

    @Override
    public ModelMBean getModelMBean() {
        return this.modelMBean;
    }

    @Override
    public void setModelMBean(ModelMBean modelMBean) {
        this.modelMBean = modelMBean;
    }

    @Override
    public ObjectName getObjectName() {
        return this.objectName;
    }

    @Override
    public ManagedResourceType getManagedResourceType() {
        return ManagedResourceType.STATISTIC_RESOURCE;
    }

    @Override
    public void cleanupResource() {
        this.modelMBean = null;
        this.member = null;
        this.statistics = null;
        this.statResource = null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StatisticResourceJmxImpl)) {
            return false;
        }
        StatisticResourceJmxImpl other = (StatisticResourceJmxImpl)obj;
        return this.getMBeanName().equals(other.getMBeanName());
    }

    public int hashCode() {
        return this.getMBeanName().hashCode();
    }
}

