/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin.jmx.internal;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.admin.RuntimeAdminException;
import com.gemstone.gemfire.admin.jmx.internal.DynamicManagedBean;
import com.gemstone.gemfire.admin.jmx.internal.ManagedResource;
import com.gemstone.gemfire.admin.jmx.internal.RefreshNotificationType;
import com.gemstone.gemfire.internal.ClassPathLoader;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.JMRuntimeException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MBeanServerNotification;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.timer.Timer;
import javax.management.timer.TimerMBean;
import org.apache.commons.modeler.ManagedBean;
import org.apache.commons.modeler.Registry;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public class MBeanUtil {
    private static final Logger logger = LogService.getLogger();
    private static final String DEFAULT_DOMAIN = "GemFire";
    private static String REFRESH_TIMER_NAME = "GemFire:type=RefreshTimer";
    private static boolean isStarted;
    private static Registry registry;
    private static MBeanServer mbeanServer;
    private static ObjectName refreshTimerObjectName;
    private static TimerMBean refreshTimer;
    private static Map<NotificationListener, Map<RefreshNotificationType, Integer>> refreshClients;
    private static final Map<ObjectName, ManagedResource> managedResources;

    static MBeanServer start() {
        if (!isStarted) {
            mbeanServer = MBeanUtil.createMBeanServer();
            registry = MBeanUtil.createRegistry();
            MBeanUtil.registerServerNotificationListener();
            MBeanUtil.createRefreshTimer();
            isStarted = true;
        }
        return mbeanServer;
    }

    static void stop() {
        if (isStarted) {
            MBeanUtil.stopRefreshTimer();
            registry.stop();
            registry = null;
            MBeanUtil.releaseMBeanServer();
            isStarted = false;
        }
    }

    static synchronized MBeanServer createMBeanServer() {
        if (mbeanServer == null) {
            mbeanServer = MBeanServerFactory.createMBeanServer(DEFAULT_DOMAIN);
        }
        return mbeanServer;
    }

    static synchronized Registry createRegistry() {
        if (registry == null) {
            try {
                registry = Registry.getRegistry(null, null);
                if (mbeanServer == null) {
                    throw new IllegalStateException(LocalizedStrings.MBeanUtil_MBEAN_SERVER_NOT_INITIALIZED_YET.toLocalizedString());
                }
                registry.setMBeanServer(mbeanServer);
                String mbeansResource = MBeanUtil.getOSPath("/com/gemstone/gemfire/admin/jmx/mbeans-descriptors.xml");
                URL url = ClassPathLoader.getLatest().getResource(MBeanUtil.class, mbeansResource);
                MBeanUtil.raiseOnFailure(url != null, LocalizedStrings.MBeanUtil_FAILED_TO_FIND_0.toLocalizedString(mbeansResource));
                registry.loadMetadata((Object)url);
                String[] test = registry.findManagedBeans();
                MBeanUtil.raiseOnFailure(test != null && test.length > 0, LocalizedStrings.MBeanUtil_FAILED_TO_LOAD_0.toLocalizedString(mbeansResource));
            }
            catch (Exception e) {
                MBeanUtil.logStackTrace(Level.WARN, e);
                throw new RuntimeAdminException(LocalizedStrings.MBeanUtil_FAILED_TO_GET_MBEAN_REGISTRY.toLocalizedString(), e);
            }
        }
        return registry;
    }

    static ObjectName createMBean(ManagedResource resource) {
        return MBeanUtil.createMBean(resource, MBeanUtil.lookupManagedBean(resource));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ObjectName createMBean(ManagedResource resource, ManagedBean managed) {
        try {
            ObjectName objName;
            DynamicManagedBean mb = new DynamicManagedBean(managed);
            resource.setModelMBean(mb.createMBean(resource));
            try {
                objName = ObjectName.getInstance(resource.getMBeanName());
            }
            catch (MalformedObjectNameException e) {
                throw new MalformedObjectNameException(LocalizedStrings.MBeanUtil_0_IN_1.toLocalizedString(e.getMessage(), resource.getMBeanName()));
            }
            Class<MBeanUtil> clazz = MBeanUtil.class;
            synchronized (MBeanUtil.class) {
                if (mbeanServer != null && !mbeanServer.isRegistered(objName)) {
                    mbeanServer.registerMBean(resource.getModelMBean(), objName);
                    Map<ObjectName, ManagedResource> map = managedResources;
                    synchronized (map) {
                        managedResources.put(objName, resource);
                    }
                }
                // ** MonitorExit[var4_6] (shouldn't be in output)
                return objName;
            }
        }
        catch (Exception e) {
            throw new RuntimeAdminException(LocalizedStrings.MBeanUtil_FAILED_TO_CREATE_MBEAN_FOR_0.toLocalizedString(resource.getMBeanName()), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ObjectName ensureMBeanIsRegistered(ManagedResource resource) {
        try {
            ObjectName objName = ObjectName.getInstance(resource.getMBeanName());
            Class<MBeanUtil> clazz = MBeanUtil.class;
            synchronized (MBeanUtil.class) {
                if (mbeanServer != null && !mbeanServer.isRegistered(objName)) {
                    // ** MonitorExit[var2_3] (shouldn't be in output)
                    return MBeanUtil.createMBean(resource);
                }
                // ** MonitorExit[var2_3] (shouldn't be in output)
                MBeanUtil.raiseOnFailure(mbeanServer.isRegistered(objName), LocalizedStrings.MBeanUtil_COULDNT_FIND_MBEAN_REGISTERED_WITH_OBJECTNAME_0.toLocalizedString(objName.toString()));
                return objName;
            }
        }
        catch (Exception e) {
            throw new RuntimeAdminException(e);
        }
    }

    static ManagedBean lookupManagedBean(ManagedResource resource) {
        ManagedBean managed = null;
        if (registry == null) {
            throw new IllegalArgumentException(LocalizedStrings.MBeanUtil_MANAGEDBEAN_IS_NULL.toLocalizedString());
        }
        managed = registry.findManagedBean(resource.getManagedResourceType().getClassTypeName());
        if (managed == null) {
            throw new IllegalArgumentException(LocalizedStrings.MBeanUtil_MANAGEDBEAN_IS_NULL.toLocalizedString());
        }
        managed.setClassName("com.gemstone.gemfire.admin.jmx.internal.MX4JModelMBean");
        return managed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void registerRefreshNotification(NotificationListener client, Object userData, RefreshNotificationType type, int refreshInterval) {
        if (client == null) {
            throw new IllegalArgumentException(LocalizedStrings.MBeanUtil_NOTIFICATIONLISTENER_IS_REQUIRED.toLocalizedString());
        }
        if (type == null) {
            throw new IllegalArgumentException(LocalizedStrings.MBeanUtil_REFRESHNOTIFICATIONTYPE_IS_REQUIRED.toLocalizedString());
        }
        if (refreshTimerObjectName == null || refreshTimer == null) {
            throw new IllegalStateException(LocalizedStrings.MBeanUtil_REFRESHTIMER_HAS_NOT_BEEN_PROPERLY_INITIALIZED.toLocalizedString());
        }
        try {
            Integer timerNotificationId;
            Map<RefreshNotificationType, Integer> notifications = null;
            Map<NotificationListener, Map<RefreshNotificationType, Integer>> map = refreshClients;
            synchronized (map) {
                notifications = refreshClients.get(client);
            }
            if (notifications == null) {
                if (refreshInterval <= 0) {
                    return;
                }
                notifications = new HashMap<RefreshNotificationType, Integer>();
                map = refreshClients;
                synchronized (map) {
                    refreshClients.put(client, notifications);
                }
                MBeanUtil.validateRefreshTimer();
                try {
                    mbeanServer.addNotificationListener(refreshTimerObjectName, client, null, new Object());
                }
                catch (InstanceNotFoundException e) {
                    MBeanUtil.logStackTrace(Level.WARN, e, LocalizedStrings.MBeanUtil_COULD_NOT_FIND_REGISTERED_REFRESHTIMER_INSTANCE.toLocalizedString());
                }
            }
            if ((timerNotificationId = notifications.get(type)) != null) {
                try {
                    refreshTimer.removeNotification(timerNotificationId);
                }
                catch (InstanceNotFoundException e) {
                }
                finally {
                    notifications.put(type, null);
                }
            }
            if (refreshInterval > 0) {
                timerNotificationId = refreshTimer.addNotification(type.getType(), type.getMessage(), userData, new Date(System.currentTimeMillis() + (long)(refreshInterval * 1000)), refreshInterval * 1000);
                notifications.put(type, timerNotificationId);
            }
        }
        catch (RuntimeException e) {
            MBeanUtil.logStackTrace(Level.WARN, e);
            throw e;
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Error e) {
            SystemFailure.checkFailure();
            MBeanUtil.logStackTrace(Level.ERROR, e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isRefreshNotificationRegistered(NotificationListener client, RefreshNotificationType type) {
        Integer timerNotificationId;
        boolean isRegistered = false;
        Map<RefreshNotificationType, Integer> notifications = null;
        Map<NotificationListener, Map<RefreshNotificationType, Integer>> map = refreshClients;
        synchronized (map) {
            notifications = refreshClients.get(client);
        }
        if (notifications != null && (timerNotificationId = notifications.get(type)) != null) {
            isRegistered = true;
        }
        return isRegistered;
    }

    static void validateRefreshTimer() {
        if (refreshTimerObjectName == null || refreshTimer == null) {
            MBeanUtil.createRefreshTimer();
        }
        MBeanUtil.raiseOnFailure(refreshTimer != null, "Failed to validate Refresh Timer");
        if (mbeanServer != null && !mbeanServer.isRegistered(refreshTimerObjectName)) {
            try {
                mbeanServer.registerMBean(refreshTimer, refreshTimerObjectName);
            }
            catch (JMException e) {
                MBeanUtil.logStackTrace(Level.WARN, e);
            }
            catch (JMRuntimeException e) {
                MBeanUtil.logStackTrace(Level.WARN, e);
            }
        }
    }

    static void createRefreshTimer() {
        try {
            refreshTimer = new Timer();
            mbeanServer.registerMBean(refreshTimer, refreshTimerObjectName);
            refreshTimer.start();
        }
        catch (JMException e) {
            MBeanUtil.logStackTrace(Level.WARN, e, LocalizedStrings.MBeanUtil_FAILED_TO_CREATE_REFRESH_TIMER.toLocalizedString());
        }
        catch (JMRuntimeException e) {
            MBeanUtil.logStackTrace(Level.WARN, e, LocalizedStrings.MBeanUtil_FAILED_TO_CREATE_REFRESH_TIMER.toLocalizedString());
        }
        catch (Exception e) {
            MBeanUtil.logStackTrace(Level.WARN, e, LocalizedStrings.MBeanUtil_FAILED_TO_CREATE_REFRESH_TIMER.toLocalizedString());
        }
    }

    static void stopRefreshTimer() {
        try {
            if (refreshTimer != null && mbeanServer != null) {
                mbeanServer.unregisterMBean(refreshTimerObjectName);
                refreshTimer.stop();
            }
        }
        catch (JMException e) {
            MBeanUtil.logStackTrace(Level.WARN, e);
        }
        catch (JMRuntimeException e) {
            MBeanUtil.logStackTrace(Level.WARN, e);
        }
        catch (Exception e) {
            MBeanUtil.logStackTrace(Level.DEBUG, e, "Failed to stop refresh timer for MBeanUtil");
        }
    }

    public static String makeCompliantMBeanNameProperty(String value2) {
        value2 = value2.replace(':', '-');
        value2 = value2.replace(',', '-');
        value2 = value2.replace('=', '-');
        value2 = value2.replace('*', '-');
        if ((value2 = value2.replace('?', '-')).length() < 1) {
            value2 = "nothing";
        }
        return value2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void releaseMBeanServer() {
        try {
            for (ObjectName name : mbeanServer.queryNames(null, null)) {
                if (!name.getDomain().startsWith(DEFAULT_DOMAIN)) continue;
                MBeanUtil.unregisterMBean(name);
            }
            MBeanServerFactory.releaseMBeanServer(mbeanServer);
            mbeanServer = null;
        }
        catch (JMRuntimeException e) {
            MBeanUtil.logStackTrace(Level.WARN, e);
        }
        Map<Object, Object> map = managedResources;
        synchronized (map) {
            managedResources.clear();
        }
        map = refreshClients;
        synchronized (map) {
            refreshClients.clear();
        }
        map = managedResources;
        synchronized (map) {
            managedResources.clear();
        }
        map = refreshClients;
        synchronized (map) {
            refreshClients.clear();
        }
    }

    static boolean isRegistered(ObjectName objectName) {
        return mbeanServer != null && mbeanServer.isRegistered(objectName);
    }

    static void unregisterMBean(ObjectName objectName) {
        try {
            if (mbeanServer != null && mbeanServer.isRegistered(objectName)) {
                mbeanServer.unregisterMBean(objectName);
            }
        }
        catch (MBeanRegistrationException e) {
            MBeanUtil.logStackTrace(Level.WARN, null, LocalizedStrings.MBeanUtil_FAILED_WHILE_UNREGISTERING_MBEAN_WITH_OBJECTNAME_0.toLocalizedString(objectName));
        }
        catch (InstanceNotFoundException e) {
            MBeanUtil.logStackTrace(Level.WARN, null, LocalizedStrings.MBeanUtil_WHILE_UNREGISTERING_COULDNT_FIND_MBEAN_WITH_OBJECTNAME_0.toLocalizedString(objectName));
        }
        catch (JMRuntimeException e) {
            MBeanUtil.logStackTrace(Level.WARN, null, LocalizedStrings.MBeanUtil_COULD_NOT_UNREGISTER_MBEAN_WITH_OBJECTNAME_0.toLocalizedString(objectName));
        }
    }

    static void unregisterMBean(ManagedResource resource) {
        if (resource != null) {
            MBeanUtil.unregisterMBean(resource.getObjectName());
            MBeanUtil.cleanupResource(resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cleanupResource(ManagedResource resource) {
        Map<ObjectName, ManagedResource> map = managedResources;
        synchronized (map) {
            managedResources.remove(resource.getObjectName());
        }
        resource.cleanupResource();
        Map<RefreshNotificationType, Integer> notifications = null;
        Map<NotificationListener, Map<RefreshNotificationType, Integer>> map2 = refreshClients;
        synchronized (map2) {
            notifications = refreshClients.remove(resource);
        }
        if (notifications != null) {
            Set<Map.Entry<RefreshNotificationType, Integer>> entries = notifications.entrySet();
            for (Map.Entry<RefreshNotificationType, Integer> e : entries) {
                Integer timerNotificationId = e.getValue();
                if (null == timerNotificationId) continue;
                try {
                    refreshTimer.removeNotification(timerNotificationId);
                }
                catch (InstanceNotFoundException xptn) {
                    MBeanUtil.logStackTrace(Level.DEBUG, xptn);
                }
            }
            try {
                if (mbeanServer != null && mbeanServer.isRegistered(refreshTimerObjectName)) {
                    mbeanServer.removeNotificationListener(refreshTimerObjectName, (NotificationListener)((Object)resource));
                }
            }
            catch (ListenerNotFoundException xptn) {
                MBeanUtil.logStackTrace(Level.WARN, null, xptn.getMessage());
            }
            catch (InstanceNotFoundException xptn) {
                MBeanUtil.logStackTrace(Level.WARN, null, LocalizedStrings.MBeanUtil_WHILE_UNREGISTERING_COULDNT_FIND_MBEAN_WITH_OBJECTNAME_0.toLocalizedString(refreshTimerObjectName));
            }
        }
    }

    static String getOSPath(String path) {
        if (MBeanUtil.pathIsWindows(path)) {
            return path.replace('/', '\\');
        }
        return path.replace('\\', '/');
    }

    static boolean pathIsWindows(String path) {
        if (path != null && path.length() > 1) {
            return Character.isLetter(path.charAt(0)) && path.charAt(1) == ':' || path.startsWith("//") || path.startsWith("\\\\");
        }
        return false;
    }

    static void registerServerNotificationListener() {
        if (mbeanServer == null) {
            return;
        }
        try {
            ObjectName delegate = ObjectName.getInstance("JMImplementation:type=MBeanServerDelegate");
            mbeanServer.addNotificationListener(delegate, new NotificationListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void handleNotification(Notification notification, Object handback) {
                    MBeanServerNotification serverNotification = (MBeanServerNotification)notification;
                    if ("JMX.mbean.unregistered".equals(serverNotification.getType())) {
                        ObjectName objectName = serverNotification.getMBeanName();
                        Map map = managedResources;
                        synchronized (map) {
                            Object entry = managedResources.get(objectName);
                            if (entry == null) {
                                return;
                            }
                            if (!(entry instanceof ManagedResource)) {
                                throw new ClassCastException(LocalizedStrings.MBeanUtil_0_IS_NOT_A_MANAGEDRESOURCE.toLocalizedString(entry.getClass().getName()));
                            }
                            ManagedResource resource = (ManagedResource)entry;
                            MBeanUtil.cleanupResource(resource);
                        }
                    }
                }
            }, null, null);
        }
        catch (JMException e) {
            MBeanUtil.logStackTrace(Level.WARN, e, LocalizedStrings.MBeanUtil_FAILED_TO_REGISTER_SERVERNOTIFICATIONLISTENER.toLocalizedString());
        }
        catch (JMRuntimeException e) {
            MBeanUtil.logStackTrace(Level.WARN, e, LocalizedStrings.MBeanUtil_FAILED_TO_REGISTER_SERVERNOTIFICATIONLISTENER.toLocalizedString());
        }
    }

    public static void logStackTrace(Level level, Throwable throwable) {
        MBeanUtil.logStackTrace(level, throwable, null);
    }

    public static void logStackTrace(Level level, Throwable throwable, String message) {
        logger.log(level, message, throwable);
    }

    private static void raiseOnFailure(boolean condition, String message) {
        if (!condition) {
            throw new RuntimeAdminException(message);
        }
    }

    static {
        refreshClients = new HashMap<NotificationListener, Map<RefreshNotificationType, Integer>>();
        managedResources = new HashMap<ObjectName, ManagedResource>();
        try {
            refreshTimerObjectName = ObjectName.getInstance(REFRESH_TIMER_NAME);
        }
        catch (Exception e) {
            MBeanUtil.logStackTrace(Level.ERROR, e);
        }
    }
}

