/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin.internal;

import com.gemstone.gemfire.admin.AdminException;
import com.gemstone.gemfire.admin.Statistic;
import com.gemstone.gemfire.admin.StatisticResource;
import com.gemstone.gemfire.admin.SystemMember;
import com.gemstone.gemfire.admin.internal.StatisticImpl;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.admin.Stat;
import com.gemstone.gemfire.internal.admin.StatResource;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.util.ArrayList;

public class StatisticResourceImpl
implements StatisticResource {
    protected StatResource statResource;
    protected String name;
    protected String description;
    protected String type;
    protected SystemMember member;
    protected Statistic[] statistics;

    public StatisticResourceImpl(StatResource statResource, SystemMember member) throws AdminException {
        this.statResource = statResource;
        this.member = member;
        this.name = this.statResource.getName();
        this.description = this.statResource.getDescription();
        this.type = this.statResource.getType();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getOwner() {
        return this.member.toString();
    }

    @Override
    public Statistic[] getStatistics() {
        if (this.statistics == null) {
            try {
                this.refresh();
            }
            catch (AdminException e) {
                this.statistics = new Statistic[0];
            }
        }
        return this.statistics;
    }

    @Override
    public long getUniqueId() {
        return this.statResource.getResourceUniqueID();
    }

    @Override
    public void refresh() throws AdminException {
        Stat[] stats = null;
        if (this.statResource != null) {
            stats = this.statResource.getStats();
        }
        if (stats == null || stats.length < 1) {
            throw new AdminException(LocalizedStrings.StatisticResourceImpl_FAILED_TO_REFRESH_STATISTICS_0_FOR_1.toLocalizedString(this.getType() + "-" + this.getName(), this.getOwner()));
        }
        if (this.statistics == null || this.statistics.length < 1) {
            ArrayList<Statistic> statList = new ArrayList<Statistic>();
            for (int i = 0; i < stats.length; ++i) {
                statList.add(this.createStatistic(stats[i]));
            }
            this.statistics = statList.toArray(new Statistic[0]);
        } else {
            for (int i = 0; i < stats.length; ++i) {
                this.updateStatistic(stats[i]);
            }
        }
    }

    private void updateStatistic(Stat stat) {
        for (int i = 0; i < this.statistics.length; ++i) {
            if (!this.statistics[i].getName().equals(stat.getName())) continue;
            ((StatisticImpl)this.statistics[i]).setStat(stat);
            return;
        }
        Assert.assertTrue(false, "Unknown stat: " + stat.getName());
    }

    protected Statistic createStatistic(Stat stat) {
        return new StatisticImpl(stat);
    }

    public String toString() {
        return this.getName();
    }
}

