/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin.internal;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.admin.internal.PrepareBackupResponse;
import com.gemstone.gemfire.cache.persistence.PersistentID;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.internal.admin.remote.AdminFailureResponse;
import com.gemstone.gemfire.internal.admin.remote.AdminMultipleReplyProcessor;
import com.gemstone.gemfire.internal.admin.remote.AdminResponse;
import com.gemstone.gemfire.internal.admin.remote.CliLegacyMessage;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.persistence.BackupManager;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public class PrepareBackupRequest
extends CliLegacyMessage {
    private static final Logger logger = LogService.getLogger();

    public static Map<DistributedMember, Set<PersistentID>> send(DM dm, Set recipients) {
        PrepareBackupRequest request = new PrepareBackupRequest();
        request.setRecipients(recipients);
        PrepareBackupReplyProcessor replyProcessor = new PrepareBackupReplyProcessor(dm, (Collection)recipients);
        request.msgId = replyProcessor.getProcessorId();
        dm.putOutgoing(request);
        try {
            replyProcessor.waitForReplies();
        }
        catch (ReplyException e) {
            if (!(e.getCause() instanceof CancelException)) {
                throw e;
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        AdminResponse response = request.createResponse((DistributionManager)dm);
        response.setSender(dm.getDistributionManagerId());
        replyProcessor.process(response);
        return replyProcessor.results;
    }

    @Override
    protected AdminResponse createResponse(DistributionManager dm) {
        HashSet<PersistentID> persistentIds;
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        if (cache == null) {
            persistentIds = new HashSet();
        } else {
            try {
                BackupManager manager = cache.startBackup(this.getSender());
                persistentIds = manager.prepareBackup();
            }
            catch (IOException e) {
                logger.error(LocalizedMessage.create(LocalizedStrings.CliLegacyMessage_ERROR, this.getClass()), (Throwable)e);
                return AdminFailureResponse.create(dm, this.getSender(), e);
            }
        }
        return new PrepareBackupResponse(this.getSender(), persistentIds);
    }

    @Override
    public int getDSFID() {
        return 2116;
    }

    private static class PrepareBackupReplyProcessor
    extends AdminMultipleReplyProcessor {
        Map<DistributedMember, Set<PersistentID>> results = Collections.synchronizedMap(new HashMap());

        public PrepareBackupReplyProcessor(DM dm, Collection initMembers) {
            super(dm, initMembers);
        }

        @Override
        protected boolean stopBecauseOfExceptions() {
            return false;
        }

        @Override
        protected void process(DistributionMessage msg, boolean warn) {
            HashSet<PersistentID> persistentIds;
            if (msg instanceof PrepareBackupResponse && (persistentIds = ((PrepareBackupResponse)msg).getPersistentIds()) != null && !persistentIds.isEmpty()) {
                this.results.put(msg.getSender(), persistentIds);
            }
            super.process(msg, warn);
        }
    }
}

