/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin.internal;

import com.gemstone.gemfire.admin.AdminDistributedSystem;
import com.gemstone.gemfire.admin.AdminException;
import com.gemstone.gemfire.admin.ConfigurationParameter;
import com.gemstone.gemfire.admin.ManagedEntityConfig;
import com.gemstone.gemfire.admin.internal.AdminDistributedSystemImpl;
import com.gemstone.gemfire.admin.internal.InternalManagedEntity;
import com.gemstone.gemfire.admin.internal.ManagedEntityController;
import com.gemstone.gemfire.admin.internal.SystemMemberImpl;
import com.gemstone.gemfire.internal.admin.GemFireVM;

public abstract class ManagedSystemMemberImpl
extends SystemMemberImpl
implements InternalManagedEntity {
    protected ManagedEntityController controller;
    private int state = 10;
    private final Object stateChange = new Object();

    protected ManagedSystemMemberImpl(AdminDistributedSystemImpl system, GemFireVM vm) throws AdminException {
        super((AdminDistributedSystem)system, vm);
        this.controller = system.getEntityController();
    }

    protected ManagedSystemMemberImpl(AdminDistributedSystemImpl system, ManagedEntityConfig config) throws AdminException {
        super(system);
        this.internalId = null;
        this.id = this.getNewId();
        this.host = config.getHost();
        this.name = this.id;
        this.controller = system.getEntityController();
    }

    public String getWorkingDirectory() {
        return this.getEntityConfig().getWorkingDirectory();
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.getEntityConfig().setWorkingDirectory(workingDirectory);
    }

    public String getProductDirectory() {
        return this.getEntityConfig().getProductDirectory();
    }

    public void setProductDirectory(String productDirectory) {
        this.getEntityConfig().setProductDirectory(productDirectory);
    }

    @Override
    public String getHost() {
        return this.getEntityConfig().getHost();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setState(int state) {
        if (this.stateChange == null) {
            int oldState = this.state;
            this.state = state;
            return oldState;
        }
        Object object = this.stateChange;
        synchronized (object) {
            int oldState = this.state;
            this.state = state;
            this.stateChange.notifyAll();
            return oldState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean needToStop() {
        Object object = this.stateChange;
        synchronized (object) {
            if (this.state == 11 || this.state == 12) {
                return false;
            }
            this.setState(12);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean needToStart() {
        Object object = this.stateChange;
        synchronized (object) {
            if (this.state == 14 || this.state == 13) {
                return false;
            }
            this.setState(13);
            return true;
        }
    }

    @Override
    void setGemFireVM(GemFireVM vm) throws AdminException {
        super.setGemFireVM(vm);
        if (vm != null) {
            this.setState(14);
        } else {
            this.setState(11);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitToStart(long timeout) throws InterruptedException {
        Object object;
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < timeout) {
            object = this.stateChange;
            synchronized (object) {
                if (this.state == 14) {
                    break;
                }
                this.stateChange.wait(System.currentTimeMillis() - start);
            }
        }
        object = this.stateChange;
        synchronized (object) {
            return this.state == 14;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitToStop(long timeout) throws InterruptedException {
        Object object;
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < timeout) {
            object = this.stateChange;
            synchronized (object) {
                if (this.state == 11) {
                    break;
                }
                this.stateChange.wait(System.currentTimeMillis() - start);
            }
        }
        object = this.stateChange;
        synchronized (object) {
            return this.state == 11;
        }
    }

    protected void appendConfiguration(StringBuffer sb) {
        ConfigurationParameter[] params = this.getConfiguration();
        for (int i = 0; i < params.length; ++i) {
            ConfigurationParameter param = params[i];
            if (!param.isModifiable()) continue;
            String name = param.getName();
            String value2 = param.getValueAsString();
            if (value2 == null || value2.equals("")) continue;
            if (name.equals("locators")) {
                String locator = value2;
                int firstBracket = locator.indexOf(91);
                int lastBracket = locator.indexOf(93);
                if (firstBracket > -1 && lastBracket > -1) {
                    String host = locator.substring(0, firstBracket);
                    String port = locator.substring(firstBracket + 1, lastBracket);
                    locator = host + ":" + port;
                }
                sb.append(" ");
                sb.append(name);
                sb.append("=");
                sb.append(locator);
                continue;
            }
            sb.append(" ");
            sb.append(name);
            sb.append("=");
            sb.append(value2);
        }
    }
}

