/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin.internal;

import com.gemstone.gemfire.InternalGemFireException;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.admin.AdminException;
import com.gemstone.gemfire.admin.GemFireHealth;
import com.gemstone.gemfire.admin.GemFireHealthConfig;
import com.gemstone.gemfire.admin.GemFireMemberStatus;
import com.gemstone.gemfire.admin.RegionSubRegionSnapshot;
import com.gemstone.gemfire.admin.internal.AbstractHealthEvaluator;
import com.gemstone.gemfire.admin.internal.DistributedSystemHealthEvaluator;
import com.gemstone.gemfire.admin.internal.GemFireHealthImpl;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.Config;
import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.gemfire.internal.admin.AdminBridgeServer;
import com.gemstone.gemfire.internal.admin.CacheInfo;
import com.gemstone.gemfire.internal.admin.DLockInfo;
import com.gemstone.gemfire.internal.admin.GemFireVM;
import com.gemstone.gemfire.internal.admin.GfManagerAgent;
import com.gemstone.gemfire.internal.admin.HealthListener;
import com.gemstone.gemfire.internal.admin.Stat;
import com.gemstone.gemfire.internal.admin.StatAlertDefinition;
import com.gemstone.gemfire.internal.admin.StatListener;
import com.gemstone.gemfire.internal.admin.StatResource;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.LoggingThreadGroup;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import java.io.File;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.logging.log4j.Logger;

class DistributedSystemHealthMonitor
implements Runnable,
GemFireVM {
    private static final Logger logger = LogService.getLogger();
    private DistributedSystemHealthEvaluator eval;
    private GemFireHealthImpl healthImpl;
    private int interval;
    private Thread thread;
    private volatile boolean stopRequested = false;
    private GemFireHealth.Health prevHealth = GemFireHealth.GOOD_HEALTH;
    private List okayDiagnoses;
    private List poorDiagnoses;

    DistributedSystemHealthMonitor(DistributedSystemHealthEvaluator eval, GemFireHealthImpl healthImpl, int interval) {
        this.eval = eval;
        this.healthImpl = healthImpl;
        this.interval = interval;
        this.okayDiagnoses = new ArrayList();
        this.poorDiagnoses = new ArrayList();
        LoggingThreadGroup group = LoggingThreadGroup.createThreadGroup(LocalizedStrings.DistributedSystemHealthMonitor_HEALTH_MONITORS.toLocalizedString(), logger);
        String name = LocalizedStrings.DistributedSystemHealthMonitor_HEALTH_MONITOR_FOR_0.toLocalizedString(eval.getDescription());
        this.thread = new Thread(group, this, name);
        this.thread.setDaemon(true);
    }

    @Override
    public void run() {
        if (logger.isDebugEnabled()) {
            logger.debug("Monitoring health of {} every {} seconds", this.eval.getDescription(), this.interval);
        }
        while (!this.stopRequested) {
            SystemFailure.checkFailure();
            try {
                Thread.sleep(this.interval * 1000);
                ArrayList status = new ArrayList();
                this.eval.evaluate(status);
                GemFireHealth.Health overallHealth = GemFireHealth.GOOD_HEALTH;
                this.okayDiagnoses.clear();
                this.poorDiagnoses.clear();
                for (AbstractHealthEvaluator.HealthStatus health : status) {
                    GemFireHealth.Health healthCode;
                    if (overallHealth == GemFireHealth.GOOD_HEALTH) {
                        if (health.getHealthCode() != GemFireHealth.GOOD_HEALTH) {
                            overallHealth = health.getHealthCode();
                        }
                    } else if (overallHealth == GemFireHealth.OKAY_HEALTH && health.getHealthCode() == GemFireHealth.POOR_HEALTH) {
                        overallHealth = GemFireHealth.POOR_HEALTH;
                    }
                    if ((healthCode = health.getHealthCode()) == GemFireHealth.OKAY_HEALTH) {
                        this.okayDiagnoses.add(health.getDiagnosis());
                        continue;
                    }
                    if (healthCode != GemFireHealth.POOR_HEALTH) continue;
                    this.poorDiagnoses.add(health.getDiagnosis());
                    break;
                }
                if (overallHealth == this.prevHealth) continue;
                this.healthImpl.healthChanged(this, overallHealth);
                this.prevHealth = overallHealth;
            }
            catch (InterruptedException ex) {
                // empty catch block
                break;
            }
        }
        this.eval.close();
        if (logger.isDebugEnabled()) {
            logger.debug("Stopped checking for distributed system health");
        }
    }

    void start() {
        this.thread.start();
    }

    void stop() {
        if (this.thread.isAlive()) {
            this.stopRequested = true;
            this.thread.interrupt();
            this.healthImpl.nodeLeft(null, this);
            try {
                this.thread.join();
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                logger.warn(LocalizedMessage.create(LocalizedStrings.DistributedSystemHealthMonitor_INTERRUPTED_WHILE_STOPPING_HEALTH_MONITOR_THREAD), (Throwable)ex);
            }
        }
    }

    @Override
    public InetAddress getHost() {
        try {
            return SocketCreator.getLocalHost();
        }
        catch (Exception ex) {
            throw new InternalGemFireException(LocalizedStrings.DistributedSystemHealthMonitor_COULD_NOT_GET_LOCALHOST.toLocalizedString());
        }
    }

    @Override
    public String getName() {
        throw new UnsupportedOperationException("Not a real GemFireVM");
    }

    @Override
    public File getWorkingDirectory() {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    @Override
    public File getGemFireDir() {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    @Override
    public Date getBirthDate() {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    @Override
    public Properties getLicenseInfo() {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    @Override
    public GemFireMemberStatus getSnapshot() {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    @Override
    public RegionSubRegionSnapshot getRegionSnapshot() {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    @Override
    public StatResource[] getStats(String statisticsTypeName) {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    @Override
    public StatResource[] getAllStats() {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    @Override
    public DLockInfo[] getDistributedLockInfo() {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    @Override
    public void addStatListener(StatListener observer, StatResource observedResource, Stat observedStat) {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    @Override
    public void removeStatListener(StatListener observer) {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    @Override
    public void addHealthListener(HealthListener observer, GemFireHealthConfig cfg) {
    }

    @Override
    public void removeHealthListener() {
    }

    @Override
    public void resetHealthStatus() {
        this.prevHealth = GemFireHealth.GOOD_HEALTH;
    }

    @Override
    public String[] getHealthDiagnosis(GemFireHealth.Health healthCode) {
        if (healthCode == GemFireHealth.GOOD_HEALTH) {
            return new String[0];
        }
        if (healthCode == GemFireHealth.OKAY_HEALTH) {
            String[] array = new String[this.okayDiagnoses.size()];
            this.okayDiagnoses.toArray(array);
            return array;
        }
        Assert.assertTrue(healthCode == GemFireHealth.POOR_HEALTH);
        String[] array = new String[this.poorDiagnoses.size()];
        this.poorDiagnoses.toArray(array);
        return array;
    }

    @Override
    public Config getConfig() {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    @Override
    public void setConfig(Config cfg) {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    @Override
    public GfManagerAgent getManagerAgent() {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    @Override
    public String[] getSystemLogs() {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    @Override
    public void setInspectionClasspath(String classpath) {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    @Override
    public String getInspectionClasspath() {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    @Override
    public Region[] getRootRegions() {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    @Override
    public Region getRegion(CacheInfo c, String path) {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    @Override
    public Region createVMRootRegion(CacheInfo c, String name, RegionAttributes attrs) {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    @Override
    public Region createSubregion(CacheInfo c, String parentPath, String name, RegionAttributes attrs) {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    @Override
    public void setCacheInspectionMode(int mode) {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    @Override
    public int getCacheInspectionMode() {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    @Override
    public void takeRegionSnapshot(String regionName, int snapshotId) {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    @Override
    public InternalDistributedMember getId() {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    @Override
    public CacheInfo getCacheInfo() {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    @Override
    public String getVersionInfo() {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    @Override
    public CacheInfo setCacheLockTimeout(CacheInfo c, int v) {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    @Override
    public CacheInfo setCacheLockLease(CacheInfo c, int v) {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    @Override
    public CacheInfo setCacheSearchTimeout(CacheInfo c, int v) {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    @Override
    public AdminBridgeServer addBridgeServer(CacheInfo cache) throws AdminException {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    @Override
    public AdminBridgeServer getBridgeInfo(CacheInfo cache, int id) throws AdminException {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    @Override
    public AdminBridgeServer startBridgeServer(CacheInfo cache, AdminBridgeServer bridge) throws AdminException {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    @Override
    public AdminBridgeServer stopBridgeServer(CacheInfo cache, AdminBridgeServer bridge) throws AdminException {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    @Override
    public void setAlertsManager(StatAlertDefinition[] alertDefs, long refreshInterval, boolean setRemotely) {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    @Override
    public void setRefreshInterval(long refreshInterval) {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }

    @Override
    public void updateAlertDefinitions(StatAlertDefinition[] alertDefs, int actionCode) {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedSystemHealthMonitor_NOT_A_REAL_GEMFIREVM.toLocalizedString());
    }
}

