/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin;

import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.io.ObjectStreamException;
import java.io.Serializable;

public class AlertLevel
implements Serializable {
    private static final long serialVersionUID = -4752438966587392126L;
    public static final AlertLevel WARNING = new AlertLevel(900, "WARNING");
    public static final AlertLevel ERROR = new AlertLevel(950, "ERROR");
    public static final AlertLevel SEVERE = new AlertLevel(1000, "SEVERE");
    public static final AlertLevel OFF = new AlertLevel(Integer.MAX_VALUE, "OFF");
    private final transient int severity;
    private final transient String name;
    public final int ordinal = nextOrdinal++;
    private static int nextOrdinal = 0;
    private static final AlertLevel[] VALUES = new AlertLevel[]{WARNING, ERROR, SEVERE, OFF};

    private Object readResolve() throws ObjectStreamException {
        return VALUES[this.ordinal];
    }

    private AlertLevel(int severity, String name) {
        this.severity = severity;
        this.name = name;
    }

    public static AlertLevel fromOrdinal(int ordinal) {
        return VALUES[ordinal];
    }

    public static AlertLevel forSeverity(int severity) {
        switch (severity) {
            case 900: {
                return WARNING;
            }
            case 950: {
                return ERROR;
            }
            case 1000: {
                return SEVERE;
            }
            case 0x7FFFFFFF: {
                return OFF;
            }
        }
        throw new IllegalArgumentException(LocalizedStrings.AlertLevel_UNKNOWN_ALERT_SEVERITY_0.toLocalizedString(severity));
    }

    public static AlertLevel forName(String name) {
        for (int i = 0; i < VALUES.length; ++i) {
            AlertLevel level = VALUES[i];
            if (!level.getName().equalsIgnoreCase(name)) continue;
            return level;
        }
        throw new IllegalArgumentException(LocalizedStrings.AlertLevel_THERE_IS_NO_ALERT_LEVEL_0.toLocalizedString(name));
    }

    public int getSeverity() {
        return this.severity;
    }

    public String getName() {
        return this.name;
    }

    public static AlertLevel[] values() {
        return VALUES;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof AlertLevel)) {
            return false;
        }
        AlertLevel that = (AlertLevel)other;
        if (this.severity != that.severity) {
            return false;
        }
        return this.name == that.name || this.name != null && this.name.equals(that.name);
    }

    public int hashCode() {
        int result = 17;
        int mult = 37;
        result = 37 * result + this.severity;
        result = 37 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }
}

