/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.InternalGemFireError;
import com.gemstone.gemfire.internal.SystemFailureTestHook;
import com.gemstone.gemfire.internal.admin.remote.RemoteGfManagerAgent;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

@SuppressFBWarnings(value={"DM_GC"}, justification="This class performs System.gc as last ditch effort during out-of-memory condition.")
public final class SystemFailure {
    static final String JVM_CORRUPTION = LocalizedStrings.SystemFailure_JVM_CORRUPTION_HAS_BEEN_DETECTED.toLocalizedString();
    static final String CALLING_SYSTEM_EXIT = LocalizedStrings.SystemFailure_SINCE_THIS_IS_A_DEDICATED_CACHE_SERVER_AND_THE_JVM_HAS_BEEN_CORRUPTED_THIS_PROCESS_WILL_NOW_TERMINATE_PERMISSION_TO_CALL_SYSTEM_EXIT_INT_WAS_GIVEN_IN_THE_FOLLOWING_CONTEXT.toLocalizedString();
    public static final String DISTRIBUTION_HALTED_MESSAGE = LocalizedStrings.SystemFailure_DISTRIBUTION_HALTED_DUE_TO_JVM_CORRUPTION.toLocalizedString();
    public static final String DISTRIBUTED_SYSTEM_DISCONNECTED_MESSAGE = LocalizedStrings.SystemFailure_DISTRIBUTED_SYSTEM_DISCONNECTED_DUE_TO_JVM_CORRUPTION.toLocalizedString();
    protected static volatile Error failure = null;
    private static volatile Runnable failureAction = new Runnable(){

        @Override
        public void run() {
            System.err.println(JVM_CORRUPTION);
            failure.printStackTrace();
        }
    };
    private static volatile boolean exitOK = false;
    private static volatile Throwable exitExcuse;
    private static final Object failureSync;
    private static volatile boolean gemfireCloseCompleted;
    private static volatile boolean failureActionCompleted;
    private static final ThreadGroup tg;
    public static final int WATCHDOG_WAIT;
    private static Thread watchDog;
    private static boolean isCacheClosing;
    private static Thread proctor;
    private static final Object memorySync;
    static long minimumMemoryThreshold;
    public static final long MEMORY_POLL_INTERVAL;
    public static final long MEMORY_MAX_WAIT;
    public static final boolean MONITOR_MEMORY;
    private static final long NEVER_STARVED = Long.MAX_VALUE;
    private static long firstStarveTime;
    private static long lastTotalMemory;
    private static final boolean DEBUG = false;
    public static final boolean TRACE_CLOSE = false;
    protected static final String WATCHDOG_NAME = "SystemFailure Watchdog";
    protected static final String PROCTOR_NAME = "SystemFailure Proctor";
    private static volatile boolean emergencyClassesLoaded;
    private static volatile boolean stopping;

    public static boolean setExitOK(boolean newVal) {
        boolean result = exitOK;
        exitOK = newVal;
        exitExcuse = exitOK ? new Throwable("SystemFailure exitOK set") : null;
        return result;
    }

    public static boolean isJVMFailureError(Error err) {
        return err instanceof OutOfMemoryError || err instanceof UnknownError;
    }

    private SystemFailure() {
    }

    public static void signalCacheCreate() {
        isCacheClosing = false;
    }

    public static void signalCacheClose() {
        isCacheClosing = true;
        if (proctor != null) {
            proctor.interrupt();
        }
        if (watchDog != null) {
            watchDog.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startWatchDog() {
        if (failureActionCompleted) {
            return;
        }
        Object object = failureSync;
        synchronized (object) {
            if (watchDog != null && watchDog.isAlive()) {
                return;
            }
            watchDog = new Thread(tg, new Runnable(){

                @Override
                public void run() {
                    SystemFailure.runWatchDog();
                }
            }, "SystemFailure WatchDog");
            watchDog.setDaemon(true);
            watchDog.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void stopWatchDog() {
        Object object = failureSync;
        synchronized (object) {
            stopping = true;
            if (watchDog != null && watchDog.isAlive()) {
                failureSync.notifyAll();
                try {
                    watchDog.join(100L);
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
                if (watchDog.isAlive()) {
                    watchDog.interrupt();
                    try {
                        watchDog.join(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            watchDog = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void runWatchDog() {
        boolean warned = false;
        SystemFailure.logFine(WATCHDOG_NAME, "Starting");
        try {
            SystemFailure.basicLoadEmergencyClasses();
        }
        catch (ExceptionInInitializerError e) {
            String msg;
            boolean noSurprise = false;
            Throwable cause = e.getCause();
            if (cause != null && cause instanceof IllegalStateException && (msg = cause.getMessage()).indexOf("Shutdown in progress") >= 0) {
                noSurprise = true;
            }
            if (!noSurprise) {
                SystemFailure.logWarning(WATCHDOG_NAME, "Unable to load GemFire classes: ", e);
            }
            return;
        }
        catch (CancelException e) {
        }
        catch (Throwable t) {
            SystemFailure.logWarning(WATCHDOG_NAME, "Unable to initialize watchdog", t);
            return;
        }
        while (true) {
            if (stopping) {
                return;
            }
            try {
                if (isCacheClosing) break;
                Object t = failureSync;
                synchronized (t) {
                    if (stopping) {
                        return;
                    }
                    SystemFailure.logFine(WATCHDOG_NAME, "Waiting for disaster");
                    try {
                        failureSync.wait(WATCHDOG_WAIT * 1000);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    if (stopping) {
                        return;
                    }
                }
                if (failureActionCompleted) {
                    SystemFailure.logInfo(WATCHDOG_NAME, "all actions completed; exiting");
                }
                if (failure == null) {
                    SystemFailure.logFine(WATCHDOG_NAME, "no failure detected");
                    continue;
                }
                if (!warned) {
                    warned = SystemFailure.logWarning(WATCHDOG_NAME, "failure detected", failure);
                }
                if (!gemfireCloseCompleted) {
                    SystemFailure.logInfo(WATCHDOG_NAME, "closing GemFire");
                    try {
                        SystemFailure.emergencyClose();
                    }
                    catch (Throwable t2) {
                        SystemFailure.logWarning(WATCHDOG_NAME, "trouble closing GemFire", t2);
                        continue;
                    }
                    gemfireCloseCompleted = true;
                }
                if (!failureActionCompleted) {
                    Runnable r = failureAction;
                    if (r != null) {
                        SystemFailure.logInfo(WATCHDOG_NAME, "running user's runnable");
                        try {
                            r.run();
                        }
                        catch (Throwable t3) {
                            SystemFailure.logWarning(WATCHDOG_NAME, "trouble running user's runnable", t3);
                            continue;
                        }
                    }
                    failureActionCompleted = true;
                }
                stopping = true;
                SystemFailure.stopProctor();
                if (exitOK) {
                    SystemFailure.logWarning(WATCHDOG_NAME, CALLING_SYSTEM_EXIT, exitExcuse);
                    System.exit(1);
                }
                SystemFailure.logInfo(WATCHDOG_NAME, "exiting");
                return;
            }
            catch (Throwable t) {
                SystemFailure.logWarning(WATCHDOG_NAME, "thread encountered a problem: " + t, t);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startProctor() {
        if (failure != null) {
            SystemFailure.notifyWatchDog();
            return;
        }
        Object object = failureSync;
        synchronized (object) {
            if (proctor != null && proctor.isAlive()) {
                return;
            }
            proctor = new Thread(tg, new Runnable(){

                @Override
                public void run() {
                    SystemFailure.runProctor();
                }
            }, PROCTOR_NAME);
            proctor.setDaemon(true);
            proctor.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void stopProctor() {
        Object object = failureSync;
        synchronized (object) {
            stopping = true;
            if (proctor != null && proctor.isAlive()) {
                proctor.interrupt();
                try {
                    proctor.join(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            proctor = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void runProctor() {
        long maxMemory = Runtime.getRuntime().maxMemory();
        OutOfMemoryError oome = new OutOfMemoryError(LocalizedStrings.SystemFailure_0_MEMORY_HAS_REMAINED_CHRONICALLY_BELOW_1_BYTES_OUT_OF_A_MAXIMUM_OF_2_FOR_3_SEC.toLocalizedString(PROCTOR_NAME, minimumMemoryThreshold, maxMemory, WATCHDOG_WAIT));
        SystemFailure.logFine(PROCTOR_NAME, "Starting, threshold = " + minimumMemoryThreshold + "; max = " + maxMemory);
        while (!isCacheClosing) {
            if (stopping) {
                return;
            }
            try {
                long lastStarveTime;
                long curThreshold;
                try {
                    Thread.sleep(MEMORY_POLL_INTERVAL * 1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (stopping) {
                    return;
                }
                if (failureActionCompleted) {
                    return;
                }
                if (failure != null) {
                    SystemFailure.notifyWatchDog();
                    SystemFailure.logFine(PROCTOR_NAME, "Failure has been reported, exiting");
                    return;
                }
                if (!MONITOR_MEMORY) continue;
                long totalMemory = Runtime.getRuntime().totalMemory();
                if (totalMemory < maxMemory) {
                    firstStarveTime = Long.MAX_VALUE;
                    continue;
                }
                if (lastTotalMemory < totalMemory) {
                    lastTotalMemory = totalMemory;
                    firstStarveTime = Long.MAX_VALUE;
                    continue;
                }
                lastTotalMemory = totalMemory;
                long freeMemory = Runtime.getRuntime().freeMemory();
                if (freeMemory == 0L) {
                    new Object();
                    freeMemory = Runtime.getRuntime().freeMemory();
                }
                Object object = memorySync;
                synchronized (object) {
                    curThreshold = minimumMemoryThreshold;
                    lastStarveTime = firstStarveTime;
                }
                if (freeMemory >= curThreshold || curThreshold == 0L) {
                    if (lastStarveTime != Long.MAX_VALUE) {
                        SystemFailure.logFine(PROCTOR_NAME, "...low memory has self-corrected.");
                    }
                    object = memorySync;
                    synchronized (object) {
                        firstStarveTime = Long.MAX_VALUE;
                        continue;
                    }
                }
                long now = System.currentTimeMillis();
                if (lastStarveTime == Long.MAX_VALUE) {
                    SystemFailure.logWarning(PROCTOR_NAME, "Noting that current memory available is less than the currently designated threshold", null);
                    Object object2 = memorySync;
                    synchronized (object2) {
                        firstStarveTime = now;
                    }
                    System.gc();
                    continue;
                }
                if (now - lastStarveTime < MEMORY_MAX_WAIT * 1000L) {
                    SystemFailure.logWarning(PROCTOR_NAME, "Noting that current memory available is still below currently designated threshold", null);
                    continue;
                }
                SystemFailure.logWarning(PROCTOR_NAME, "Memory is chronically low; setting failure!", null);
                SystemFailure.setFailure(oome);
                SystemFailure.notifyWatchDog();
                return;
            }
            catch (Throwable t) {
                SystemFailure.logWarning(PROCTOR_NAME, "thread encountered a problem", t);
            }
        }
    }

    public static void loadEmergencyClasses() {
        SystemFailure.startThreads();
    }

    private static void basicLoadEmergencyClasses() {
        if (emergencyClassesLoaded) {
            return;
        }
        emergencyClassesLoaded = true;
        SystemFailureTestHook.loadEmergencyClasses();
        GemFireCacheImpl.loadEmergencyClasses();
        RemoteGfManagerAgent.loadEmergencyClasses();
    }

    public static void emergencyClose() {
        GemFireCacheImpl.emergencyClose();
        RemoteGfManagerAgent.emergencyClose();
        System.gc();
    }

    private static void throwFailure() throws InternalGemFireError, Error {
        if (failure != null) {
            throw failure;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyWatchDog() {
        SystemFailure.startWatchDog();
        Object object = failureSync;
        synchronized (object) {
            failureSync.notifyAll();
        }
    }

    public static void checkFailure() throws InternalGemFireError, Error {
        if (failure == null) {
            return;
        }
        SystemFailure.notifyWatchDog();
        SystemFailure.throwFailure();
    }

    public static void initiateFailure(Error f) throws InternalGemFireError, Error {
        SystemFailure.setFailure(f);
        SystemFailure.throwFailure();
    }

    public static void setFailure(Error failure) {
        if (failure == null) {
            throw new IllegalArgumentException(LocalizedStrings.SystemFailure_YOU_ARE_NOT_PERMITTED_TO_UNSET_A_SYSTEM_FAILURE.toLocalizedString());
        }
        if (SystemFailureTestHook.errorIsExpected(failure)) {
            return;
        }
        SystemFailure.failure = failure;
        SystemFailure.notifyWatchDog();
    }

    public static Error getFailure() {
        return failure;
    }

    public static Runnable setFailureAction(Runnable action) {
        Runnable old = failureAction;
        failureAction = action;
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long setFailureMemoryThreshold(long newVal) {
        long result;
        Object object = memorySync;
        synchronized (object) {
            result = minimumMemoryThreshold;
            minimumMemoryThreshold = newVal;
            firstStarveTime = Long.MAX_VALUE;
        }
        SystemFailure.startProctor();
        return result;
    }

    private static boolean logStdErr(String kind, String name, String s, Throwable t) {
        try {
            System.err.print(name);
            System.err.print(": [");
            System.err.print(kind);
            System.err.print("] ");
            System.err.println(s);
            if (t != null) {
                t.printStackTrace();
            }
            return true;
        }
        catch (Throwable t2) {
            return false;
        }
    }

    protected static boolean logWarning(String name, String s, Throwable t) {
        return SystemFailure.logStdErr("warning", name, s, t);
    }

    protected static void logInfo(String name, String s) {
        SystemFailure.logStdErr("info", name, s, null);
    }

    protected static void logFine(String name, String s) {
    }

    public static void startThreads() {
        stopping = false;
        SystemFailure.startWatchDog();
        SystemFailure.startProctor();
    }

    public static void stopThreads() {
        stopping = true;
        SystemFailure.stopProctor();
        SystemFailure.stopWatchDog();
    }

    static {
        failureSync = new Object();
        gemfireCloseCompleted = false;
        failureActionCompleted = false;
        tg = new ThreadGroup("SystemFailure Watchdog Threads"){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                System.err.println("Internal error in SystemFailure watchdog:" + e);
                e.printStackTrace();
            }
        };
        WATCHDOG_WAIT = Integer.getInteger("gemfire.WATCHDOG_WAIT", 15);
        isCacheClosing = false;
        memorySync = new Object();
        minimumMemoryThreshold = Long.getLong("gemfire.SystemFailure.chronic_memory_threshold", 0x100000L);
        MEMORY_POLL_INTERVAL = Long.getLong("gemfire.SystemFailure.MEMORY_POLL_INTERVAL", 1L);
        MEMORY_MAX_WAIT = Long.getLong("gemfire.SystemFailure.MEMORY_MAX_WAIT", 15L);
        MONITOR_MEMORY = Boolean.getBoolean("gemfire.SystemFailure.MONITOR_MEMORY");
        firstStarveTime = Long.MAX_VALUE;
        lastTotalMemory = 0L;
        emergencyClassesLoaded = false;
    }
}

