/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.internal.InternalInstantiator;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientProxyMembershipID;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;

public abstract class Instantiator {
    private Class<? extends DataSerializable> clazz;
    private int id;
    private EventID eventId;
    private ClientProxyMembershipID context;

    public static synchronized void register(Instantiator instantiator) {
        InternalInstantiator.register(instantiator, true);
    }

    public static synchronized void register(Instantiator instantiator, boolean distribute) {
        InternalInstantiator.register(instantiator, distribute);
    }

    public Instantiator(Class<? extends DataSerializable> c, int classId) {
        if (c == null) {
            throw new NullPointerException(LocalizedStrings.Instantiator_CANNOT_REGISTER_A_NULL_CLASS.toLocalizedString());
        }
        if (!DataSerializable.class.isAssignableFrom(c)) {
            throw new IllegalArgumentException(LocalizedStrings.Instantiator_CLASS_0_DOES_NOT_IMPLEMENT_DATASERIALIZABLE.toLocalizedString(c.getName()));
        }
        if (classId == 0) {
            throw new IllegalArgumentException(LocalizedStrings.Instantiator_CLASS_ID_0_MUST_NOT_BE_0.toLocalizedString(classId));
        }
        this.clazz = c;
        this.id = classId;
    }

    public abstract DataSerializable newInstance();

    public final Class<? extends DataSerializable> getInstantiatedClass() {
        return this.clazz;
    }

    public final int getId() {
        return this.id;
    }

    public final void setEventId(Object eventId) {
        this.eventId = (EventID)eventId;
    }

    public final Object getEventId() {
        return this.eventId;
    }

    public final void setContext(Object context) {
        this.context = (ClientProxyMembershipID)context;
    }

    public final Object getContext() {
        return this.context;
    }
}

