/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.trace.instrument;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.accumulo.trace.instrument.Span;
import org.apache.accumulo.trace.instrument.impl.NullSpan;
import org.apache.accumulo.trace.instrument.impl.RootMilliSpan;
import org.apache.accumulo.trace.instrument.receivers.SpanReceiver;
import org.apache.accumulo.trace.thrift.TInfo;

public class Tracer {
    private static final Random random = new SecureRandom();
    private final List<SpanReceiver> receivers = new ArrayList<SpanReceiver>();
    private static final ThreadLocal<Span> currentTrace = new ThreadLocal();
    public static final NullSpan NULL_SPAN = new NullSpan();
    private static final TInfo dontTrace = new TInfo(0L, 0L);
    private static Tracer instance = null;

    public static synchronized void setInstance(Tracer tracer) {
        instance = tracer;
    }

    public static synchronized Tracer getInstance() {
        if (instance == null) {
            instance = new Tracer();
        }
        return instance;
    }

    public static TInfo traceInfo() {
        Span span2 = currentTrace.get();
        if (span2 != null) {
            return new TInfo(span2.traceId(), span2.spanId());
        }
        return dontTrace;
    }

    public Span start(String description) {
        Span parent = currentTrace.get();
        if (parent == null) {
            return NULL_SPAN;
        }
        return this.push(parent.child(description));
    }

    public Span on(String description) {
        Span parent = currentTrace.get();
        Span root = parent == null ? new RootMilliSpan(description, random.nextLong(), random.nextLong(), 0L) : parent.child(description);
        return this.push(root);
    }

    public Span startThread(Span parent, String activity) {
        return this.push(parent.child(activity));
    }

    public void endThread(Span span2) {
        if (span2 != null) {
            span2.stop();
            currentTrace.set(null);
        }
    }

    public boolean isTracing() {
        return currentTrace.get() != null;
    }

    public Span currentTrace() {
        return currentTrace.get();
    }

    public void stopTracing() {
        this.endThread(this.currentTrace());
    }

    protected void deliver(Span span2) {
        for (SpanReceiver receiver : this.receivers) {
            receiver.span(span2.traceId(), span2.spanId(), span2.parentId(), span2.getStartTimeMillis(), span2.getStopTimeMillis(), span2.description(), span2.getData());
        }
    }

    public synchronized void addReceiver(SpanReceiver receiver) {
        this.receivers.add(receiver);
    }

    public synchronized void removeReceiver(SpanReceiver receiver) {
        this.receivers.remove(receiver);
    }

    public Span push(Span span2) {
        if (span2 != null) {
            currentTrace.set(span2);
            span2.start();
        }
        return span2;
    }

    public void pop(Span span2) {
        if (span2 != null) {
            this.deliver(span2);
            currentTrace.set(span2.parent());
        } else {
            currentTrace.set(null);
        }
    }

    public Span continueTrace(String description, long traceId, long parentId) {
        return this.push(new RootMilliSpan(description, traceId, random.nextLong(), parentId));
    }

    public void flush() {
        for (SpanReceiver receiver : this.receivers) {
            receiver.flush();
        }
    }
}

