/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.objectweb.asm.util;

import java.util.Map;
import org.jruby.org.objectweb.asm.AnnotationVisitor;
import org.jruby.org.objectweb.asm.Attribute;
import org.jruby.org.objectweb.asm.Type;
import org.jruby.org.objectweb.asm.util.ASMifiable;
import org.jruby.org.objectweb.asm.util.ASMifierAnnotationVisitor;
import org.jruby.org.objectweb.asm.util.AbstractVisitor;

public class ASMifierAbstractVisitor
extends AbstractVisitor {
    protected String name;
    Map labelNames;

    protected ASMifierAbstractVisitor(String string2) {
        this.name = string2;
    }

    public AnnotationVisitor visitAnnotation(String string2, boolean bl) {
        this.buf.setLength(0);
        this.buf.append("{\n").append("av0 = ").append(this.name).append(".visitAnnotation(");
        this.appendConstant(string2);
        this.buf.append(", ").append(bl).append(");\n");
        this.text.add(this.buf.toString());
        ASMifierAnnotationVisitor aSMifierAnnotationVisitor = new ASMifierAnnotationVisitor(0);
        this.text.add(aSMifierAnnotationVisitor.getText());
        this.text.add("}\n");
        return aSMifierAnnotationVisitor;
    }

    public void visitAttribute(Attribute attribute) {
        this.buf.setLength(0);
        this.buf.append("// ATTRIBUTE ").append(attribute.type).append('\n');
        if (attribute instanceof ASMifiable) {
            this.buf.append("{\n");
            ((ASMifiable)((Object)attribute)).asmify(this.buf, "attr", this.labelNames);
            this.buf.append(this.name).append(".visitAttribute(attr);\n");
            this.buf.append("}\n");
        }
        this.text.add(this.buf.toString());
    }

    public void visitEnd() {
        this.buf.setLength(0);
        this.buf.append(this.name).append(".visitEnd();\n");
        this.text.add(this.buf.toString());
    }

    void appendConstant(Object object) {
        ASMifierAbstractVisitor.appendConstant(this.buf, object);
    }

    static void appendConstant(StringBuffer stringBuffer, Object object) {
        if (object == null) {
            stringBuffer.append("null");
        } else if (object instanceof String) {
            ASMifierAbstractVisitor.appendString(stringBuffer, (String)object);
        } else if (object instanceof Type) {
            stringBuffer.append("Type.getType(\"");
            stringBuffer.append(((Type)object).getDescriptor());
            stringBuffer.append("\")");
        } else if (object instanceof Byte) {
            stringBuffer.append("new Byte((byte)").append(object).append(')');
        } else if (object instanceof Boolean) {
            stringBuffer.append((Boolean)object != false ? "Boolean.TRUE" : "Boolean.FALSE");
        } else if (object instanceof Short) {
            stringBuffer.append("new Short((short)").append(object).append(')');
        } else if (object instanceof Character) {
            char c = ((Character)object).charValue();
            stringBuffer.append("new Character((char)").append((int)c).append(')');
        } else if (object instanceof Integer) {
            stringBuffer.append("new Integer(").append(object).append(')');
        } else if (object instanceof Float) {
            stringBuffer.append("new Float(\"").append(object).append("\")");
        } else if (object instanceof Long) {
            stringBuffer.append("new Long(").append(object).append("L)");
        } else if (object instanceof Double) {
            stringBuffer.append("new Double(\"").append(object).append("\")");
        } else if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            stringBuffer.append("new byte[] {");
            for (int j = 0; j < byArray.length; ++j) {
                stringBuffer.append(j == 0 ? "" : ",").append(byArray[j]);
            }
            stringBuffer.append('}');
        } else if (object instanceof boolean[]) {
            boolean[] blArray = (boolean[])object;
            stringBuffer.append("new boolean[] {");
            for (int j = 0; j < blArray.length; ++j) {
                stringBuffer.append(j == 0 ? "" : ",").append(blArray[j]);
            }
            stringBuffer.append('}');
        } else if (object instanceof short[]) {
            short[] sArray = (short[])object;
            stringBuffer.append("new short[] {");
            for (int j = 0; j < sArray.length; ++j) {
                stringBuffer.append(j == 0 ? "" : ",").append("(short)").append(sArray[j]);
            }
            stringBuffer.append('}');
        } else if (object instanceof char[]) {
            char[] cArray = (char[])object;
            stringBuffer.append("new char[] {");
            for (int j = 0; j < cArray.length; ++j) {
                stringBuffer.append(j == 0 ? "" : ",").append("(char)").append((int)cArray[j]);
            }
            stringBuffer.append('}');
        } else if (object instanceof int[]) {
            int[] nArray = (int[])object;
            stringBuffer.append("new int[] {");
            for (int j = 0; j < nArray.length; ++j) {
                stringBuffer.append(j == 0 ? "" : ",").append(nArray[j]);
            }
            stringBuffer.append('}');
        } else if (object instanceof long[]) {
            long[] lArray = (long[])object;
            stringBuffer.append("new long[] {");
            for (int j = 0; j < lArray.length; ++j) {
                stringBuffer.append(j == 0 ? "" : ",").append(lArray[j]).append('L');
            }
            stringBuffer.append('}');
        } else if (object instanceof float[]) {
            float[] fArray = (float[])object;
            stringBuffer.append("new float[] {");
            for (int j = 0; j < fArray.length; ++j) {
                stringBuffer.append(j == 0 ? "" : ",").append(fArray[j]).append('f');
            }
            stringBuffer.append('}');
        } else if (object instanceof double[]) {
            double[] dArray = (double[])object;
            stringBuffer.append("new double[] {");
            for (int j = 0; j < dArray.length; ++j) {
                stringBuffer.append(j == 0 ? "" : ",").append(dArray[j]).append('d');
            }
            stringBuffer.append('}');
        }
    }
}

