/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.java.proxies;

import java.util.Map;
import java.util.Set;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.java.proxies.ConcreteJavaProxy;
import org.jruby.java.proxies.JavaProxy;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class MapJavaProxy
extends ConcreteJavaProxy {
    private RubyHashMap wrappedMap;

    public MapJavaProxy(Ruby runtime2, RubyClass klazz) {
        super(runtime2, klazz);
    }

    public static RubyClass createMapJavaProxy(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        RubyClass mapJavaProxy = runtime2.defineClass("MapJavaProxy", runtime2.getJavaSupport().getConcreteProxyClass(), new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime2, RubyClass klazz) {
                return new MapJavaProxy(runtime2, klazz);
            }
        });
        ConcreteJavaProxy.initialize(mapJavaProxy);
        return mapJavaProxy;
    }

    private RubyHashMap getOrCreateRubyHashMap() {
        if (this.wrappedMap == null) {
            this.wrappedMap = new RubyHashMap(this.getRuntime(), this);
        }
        try {
            this.wrappedMap.setSize(((Map)this.getObject()).size());
        }
        catch (RaiseException e) {
            this.wrappedMap.setSize(0);
        }
        return this.wrappedMap;
    }

    @JRubyMethod(name={"default"})
    public IRubyObject default_value_get(ThreadContext context) {
        return this.getOrCreateRubyHashMap().default_value_get(context);
    }

    @JRubyMethod(name={"default"})
    public IRubyObject default_value_get(ThreadContext context, IRubyObject arg2) {
        return this.getOrCreateRubyHashMap().default_value_get(context, arg2);
    }

    @JRubyMethod(name={"default="}, required=1)
    public IRubyObject default_value_set(IRubyObject defaultValue) {
        return this.getOrCreateRubyHashMap().default_value_set(defaultValue);
    }

    @JRubyMethod(name={"default_proc"})
    public IRubyObject default_proc() {
        return this.getOrCreateRubyHashMap().default_proc();
    }

    @JRubyMethod(name={"default_proc="}, compat=CompatVersion.RUBY1_9)
    public IRubyObject set_default_proc(IRubyObject proc2) {
        return this.getOrCreateRubyHashMap().set_default_proc(proc2);
    }

    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect(ThreadContext context) {
        return this.getOrCreateRubyHashMap().inspect(context);
    }

    @JRubyMethod(name={"size", "length"})
    public RubyFixnum rb_size() {
        return this.getOrCreateRubyHashMap().rb_size();
    }

    @JRubyMethod(name={"empty?"})
    public RubyBoolean empty_p() {
        return this.getOrCreateRubyHashMap().empty_p();
    }

    @JRubyMethod(name={"to_a"})
    public RubyArray to_a() {
        return this.getOrCreateRubyHashMap().to_a();
    }

    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s(ThreadContext context) {
        return this.getOrCreateRubyHashMap().to_s(context);
    }

    @JRubyMethod(name={"to_s"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject to_s19(ThreadContext context) {
        return this.getOrCreateRubyHashMap().to_s19(context);
    }

    @JRubyMethod(name={"rehash"})
    public RubyHash rehash() {
        return this.getOrCreateRubyHashMap().rehash();
    }

    @JRubyMethod(name={"to_hash"})
    public RubyHash to_hash() {
        return this.getOrCreateRubyHashMap().to_hash();
    }

    @JRubyMethod(name={"[]=", "store"}, required=2, compat=CompatVersion.RUBY1_8)
    public IRubyObject op_aset(ThreadContext context, IRubyObject key2, IRubyObject value2) {
        return this.getOrCreateRubyHashMap().op_aset(context, key2, value2);
    }

    @JRubyMethod(name={"[]=", "store"}, required=2, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_aset19(ThreadContext context, IRubyObject key2, IRubyObject value2) {
        return this.getOrCreateRubyHashMap().op_aset19(context, key2, value2);
    }

    @JRubyMethod(name={"=="})
    public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
        return this.getOrCreateRubyHashMap().op_equal(context, other);
    }

    @JRubyMethod(name={"eql?"})
    public IRubyObject op_eql19(ThreadContext context, IRubyObject other) {
        return this.getOrCreateRubyHashMap().op_eql19(context, other);
    }

    @JRubyMethod(name={"[]"}, required=1)
    public IRubyObject op_aref(ThreadContext context, IRubyObject key2) {
        return this.getOrCreateRubyHashMap().op_aref(context, key2);
    }

    @JRubyMethod(name={"hash"}, compat=CompatVersion.RUBY1_8)
    public RubyFixnum hash() {
        return this.getOrCreateRubyHashMap().hash();
    }

    @JRubyMethod(name={"hash"}, compat=CompatVersion.RUBY1_9)
    public RubyFixnum hash19() {
        return this.getOrCreateRubyHashMap().hash19();
    }

    @JRubyMethod(name={"fetch"}, required=1, optional=1)
    public IRubyObject fetch(ThreadContext context, IRubyObject[] args2, Block block) {
        return this.getOrCreateRubyHashMap().fetch(context, args2, block);
    }

    @JRubyMethod(name={"has_key?", "key?", "include?", "member?"}, required=1)
    public RubyBoolean has_key_p(IRubyObject key2) {
        return this.getOrCreateRubyHashMap().has_key_p(key2);
    }

    @JRubyMethod(name={"has_value?", "value?"}, required=1)
    public RubyBoolean has_value_p(ThreadContext context, IRubyObject expected) {
        return this.getOrCreateRubyHashMap().has_value_p(context, expected);
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_8)
    public IRubyObject each(ThreadContext context, Block block) {
        return this.getOrCreateRubyHashMap().each(context, block);
    }

    @JRubyMethod(name={"each"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject each19(ThreadContext context, Block block) {
        return this.getOrCreateRubyHashMap().each19(context, block);
    }

    @JRubyMethod(name={"each_pair"})
    public IRubyObject each_pair(ThreadContext context, Block block) {
        return this.getOrCreateRubyHashMap().each_pair(context, block);
    }

    @JRubyMethod(name={"each_value"})
    public IRubyObject each_value(ThreadContext context, Block block) {
        return this.getOrCreateRubyHashMap().each_value(context, block);
    }

    @JRubyMethod(name={"each_key"})
    public IRubyObject each_key(ThreadContext context, Block block) {
        return this.getOrCreateRubyHashMap().each_key(context, block);
    }

    @JRubyMethod(name={"select!"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject select_bang(ThreadContext context, Block block) {
        return this.getOrCreateRubyHashMap().select_bang(context, block);
    }

    @JRubyMethod(name={"keep_if"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject keep_if(ThreadContext context, Block block) {
        return this.getOrCreateRubyHashMap().keep_if(context, block);
    }

    @JRubyMethod(name={"sort"})
    public IRubyObject sort(ThreadContext context, Block block) {
        return this.getOrCreateRubyHashMap().sort(context, block);
    }

    @JRubyMethod(name={"index"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject index(ThreadContext context, IRubyObject expected) {
        return this.getOrCreateRubyHashMap().index(context, expected);
    }

    @JRubyMethod(name={"index"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject index19(ThreadContext context, IRubyObject expected) {
        return this.getOrCreateRubyHashMap().index19(context, expected);
    }

    @JRubyMethod(name={"key"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject key(ThreadContext context, IRubyObject expected) {
        return this.getOrCreateRubyHashMap().key(context, expected);
    }

    @JRubyMethod(name={"indexes", "indices"}, rest=true)
    public RubyArray indices(ThreadContext context, IRubyObject[] indices2) {
        return this.getOrCreateRubyHashMap().indices(context, indices2);
    }

    @JRubyMethod(name={"keys"})
    public RubyArray keys() {
        return this.getOrCreateRubyHashMap().keys();
    }

    @JRubyMethod(name={"values"})
    public RubyArray rb_values() {
        return this.getOrCreateRubyHashMap().rb_values();
    }

    @JRubyMethod(name={"shift"})
    public IRubyObject shift(ThreadContext context) {
        return this.getOrCreateRubyHashMap().shift(context);
    }

    @JRubyMethod(name={"delete"})
    public IRubyObject delete(ThreadContext context, IRubyObject key2, Block block) {
        return this.getOrCreateRubyHashMap().delete(context, key2, block);
    }

    @JRubyMethod(name={"select"})
    public IRubyObject select(ThreadContext context, Block block) {
        return this.getOrCreateRubyHashMap().select(context, block);
    }

    @JRubyMethod(name={"select"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject select19(ThreadContext context, Block block) {
        return this.getOrCreateRubyHashMap().select19(context, block);
    }

    @JRubyMethod(name={"delete_if"})
    public IRubyObject delete_if(ThreadContext context, Block block) {
        return this.getOrCreateRubyHashMap().delete_if(context, block);
    }

    @JRubyMethod(name={"reject"})
    public IRubyObject reject(ThreadContext context, Block block) {
        return this.getOrCreateRubyHashMap().reject(context, block);
    }

    @JRubyMethod(name={"reject!"})
    public IRubyObject reject_bang(ThreadContext context, Block block) {
        return this.getOrCreateRubyHashMap().reject_bang(context, block);
    }

    @JRubyMethod(name={"clear"})
    public RubyHash rb_clear() {
        return this.getOrCreateRubyHashMap().rb_clear();
    }

    @JRubyMethod(name={"invert"})
    public RubyHash invert(ThreadContext context) {
        return this.getOrCreateRubyHashMap().invert(context);
    }

    @JRubyMethod(name={"merge!", "update"}, required=1, compat=CompatVersion.RUBY1_8)
    public RubyHash merge_bang(ThreadContext context, IRubyObject other, Block block) {
        return this.getOrCreateRubyHashMap().merge_bang(context, other, block);
    }

    @JRubyMethod(name={"merge!", "update"}, required=1, compat=CompatVersion.RUBY1_9)
    public RubyHash merge_bang19(ThreadContext context, IRubyObject other, Block block) {
        return this.getOrCreateRubyHashMap().merge_bang19(context, other, block);
    }

    @JRubyMethod(name={"merge"})
    public RubyHash merge(ThreadContext context, IRubyObject other, Block block) {
        return this.getOrCreateRubyHashMap().merge(context, other, block);
    }

    @JRubyMethod(name={"initialize_copy"}, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public RubyHash initialize_copy(ThreadContext context, IRubyObject other) {
        return this.getOrCreateRubyHashMap().initialize_copy(context, other);
    }

    @JRubyMethod(name={"initialize_copy"}, required=1, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public RubyHash initialize_copy19(ThreadContext context, IRubyObject other) {
        return this.getOrCreateRubyHashMap().initialize_copy19(context, other);
    }

    @JRubyMethod(name={"replace"}, required=1, compat=CompatVersion.RUBY1_8)
    public RubyHash replace(ThreadContext context, IRubyObject other) {
        return this.getOrCreateRubyHashMap().replace(context, other);
    }

    @JRubyMethod(name={"replace"}, required=1, compat=CompatVersion.RUBY1_9)
    public RubyHash replace19(ThreadContext context, IRubyObject other) {
        return this.getOrCreateRubyHashMap().replace19(context, other);
    }

    @JRubyMethod(name={"values_at"}, rest=true)
    public RubyArray values_at(ThreadContext context, IRubyObject[] args2) {
        return this.getOrCreateRubyHashMap().values_at(context, args2);
    }

    @JRubyMethod(name={"assoc"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject assoc(ThreadContext context, IRubyObject obj) {
        return this.getOrCreateRubyHashMap().assoc(context, obj);
    }

    @JRubyMethod(name={"rassoc"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject rassoc(ThreadContext context, IRubyObject obj) {
        return this.getOrCreateRubyHashMap().rassoc(context, obj);
    }

    @JRubyMethod(name={"flatten"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject flatten(ThreadContext context) {
        return this.getOrCreateRubyHashMap().flatten(context);
    }

    @JRubyMethod(name={"flatten"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject flatten(ThreadContext context, IRubyObject level2) {
        return this.getOrCreateRubyHashMap().flatten(context, level2);
    }

    @JRubyMethod(name={"compare_by_identity"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject getCompareByIdentity(ThreadContext context) {
        return this.getOrCreateRubyHashMap().getCompareByIdentity(context);
    }

    @JRubyMethod(name={"compare_by_identity?"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject getCompareByIdentity_p(ThreadContext context) {
        return this.getOrCreateRubyHashMap().getCompareByIdentity_p(context);
    }

    public IRubyObject dup() {
        try {
            MapJavaProxy proxy2 = new MapJavaProxy(this.getRuntime(), this.metaClass);
            Map newMap = (Map)this.getObject().getClass().newInstance();
            newMap.putAll((Map)this.getObject());
            proxy2.setObject(newMap);
            return proxy2;
        }
        catch (InstantiationException ex) {
            throw this.getRuntime().newNotImplementedError("can't dup Map of type " + this.getObject().getClass().getName());
        }
        catch (IllegalAccessException ex) {
            throw this.getRuntime().newNotImplementedError("can't dup Map of type " + this.getObject().getClass().getName());
        }
    }

    public IRubyObject rbClone() {
        try {
            MapJavaProxy proxy2 = new MapJavaProxy(this.getRuntime(), this.metaClass);
            Map newMap = (Map)this.getObject().getClass().newInstance();
            newMap.putAll((Map)this.getObject());
            proxy2.setObject(newMap);
            return proxy2;
        }
        catch (InstantiationException ex) {
            throw this.getRuntime().newNotImplementedError("can't clone Map of type " + this.getObject().getClass().getName());
        }
        catch (IllegalAccessException ex) {
            throw this.getRuntime().newNotImplementedError("can't clone Map of type " + this.getObject().getClass().getName());
        }
    }

    private static class RubyHashMap
    extends RubyHash {
        private IRubyObject receiver;

        public RubyHashMap(Ruby runtime2, IRubyObject receiver2) {
            super(runtime2);
            this.receiver = receiver2;
        }

        private void setSize(int size2) {
            this.size = size2;
        }

        private Map getMap() {
            return (Map)((JavaProxy)this.receiver).getObject();
        }

        public void internalPut(IRubyObject key2, IRubyObject value2, boolean checkForExisting) {
            Map map = this.getMap();
            map.put(key2.toJava(Object.class), value2.toJava(Object.class));
            this.size = map.size();
        }

        public IRubyObject internalGet(IRubyObject key2) {
            Object result2 = this.getMap().get(key2.toJava(Object.class));
            if (result2 == null) {
                return null;
            }
            return JavaUtil.convertJavaToUsableRubyObject(this.getRuntime(), result2);
        }

        public RubyHash.RubyHashEntry internalGetEntry(IRubyObject key2) {
            Object convertedKey;
            Map map = this.getMap();
            Object value2 = map.get(convertedKey = key2.toJava(Object.class));
            if (value2 != null) {
                RubyHash.RubyHashEntry rubyEntry = new RubyHash.RubyHashEntry(key2.hashCode(), key2, JavaUtil.convertJavaToUsableRubyObject(this.getRuntime(), value2), null, null);
                return rubyEntry;
            }
            return NO_ENTRY;
        }

        public RubyHash.RubyHashEntry internalDelete(IRubyObject key2) {
            Object convertedKey;
            Map map = this.getMap();
            Object value2 = map.get(convertedKey = key2.toJava(Object.class));
            if (value2 != null) {
                RubyHash.RubyHashEntry rubyEntry = new RubyHash.RubyHashEntry(key2.hashCode(), key2, JavaUtil.convertJavaToUsableRubyObject(this.getRuntime(), value2), null, null);
                map.remove(convertedKey);
                this.size = map.size();
                return rubyEntry;
            }
            return NO_ENTRY;
        }

        public RubyHash.RubyHashEntry internalDeleteEntry(RubyHash.RubyHashEntry entry) {
            Object convertedKey;
            Map map = this.getMap();
            if (map.containsKey(convertedKey = ((IRubyObject)entry.getKey()).toJava(Object.class))) {
                map.remove(convertedKey);
                this.size = map.size();
                return entry;
            }
            return NO_ENTRY;
        }

        public void visitAll(RubyHash.Visitor visitor) {
            Map.Entry[] entries2;
            for (Map.Entry entry : entries2 = this.getMap().entrySet().toArray(new Map.Entry[0])) {
                IRubyObject key2 = JavaUtil.convertJavaToUsableRubyObject(this.getRuntime(), entry.getKey());
                IRubyObject value2 = JavaUtil.convertJavaToUsableRubyObject(this.getRuntime(), entry.getValue());
                visitor.visit(key2, value2);
            }
        }

        public void op_asetForString(Ruby runtime2, RubyString key2, IRubyObject value2) {
            this.getMap().put(key2.toJava(String.class), value2.toJava(Object.class));
            this.size = this.getMap().size();
        }

        public RubyHash rehash() {
            throw this.getRuntime().newNotImplementedError("rehash method is not implemented in a Java Map backed object");
        }

        public RubyHash rb_clear() {
            this.getMap().clear();
            this.size = 0;
            return this;
        }

        public IRubyObject shift(ThreadContext context) {
            throw this.getRuntime().newNotImplementedError("shift method is not implemented in a Java Map backed object");
        }

        public RubyHash to_hash() {
            RubyHash hash2 = new RubyHash(this.getRuntime());
            Set entries2 = ((Map)((JavaProxy)this.receiver).getObject()).entrySet();
            for (Map.Entry entry : entries2) {
                IRubyObject key2 = JavaUtil.convertJavaToUsableRubyObject(this.getRuntime(), entry.getKey());
                IRubyObject value2 = JavaUtil.convertJavaToUsableRubyObject(this.getRuntime(), entry.getValue());
                if (this.getRuntime().getInstanceConfig().getCompatVersion() == CompatVersion.RUBY1_8) {
                    hash2.op_aset(this.getRuntime().getCurrentContext(), key2, value2);
                    continue;
                }
                hash2.op_aset19(this.getRuntime().getCurrentContext(), key2, value2);
            }
            return hash2;
        }
    }
}

