/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.policies;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.Query;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.google.common.collect.AbstractIterator;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class TokenAwarePolicy
implements LoadBalancingPolicy {
    private final LoadBalancingPolicy childPolicy;
    private Metadata clusterMetadata;

    public TokenAwarePolicy(LoadBalancingPolicy childPolicy) {
        this.childPolicy = childPolicy;
    }

    @Override
    public void init(Cluster cluster, Collection<Host> hosts) {
        this.clusterMetadata = cluster.getMetadata();
        this.childPolicy.init(cluster, hosts);
    }

    @Override
    public HostDistance distance(Host host) {
        return this.childPolicy.distance(host);
    }

    @Override
    public Iterator<Host> newQueryPlan(final Query query) {
        ByteBuffer partitionKey = query.getRoutingKey();
        if (partitionKey == null) {
            return this.childPolicy.newQueryPlan(query);
        }
        final Set<Host> replicas = this.clusterMetadata.getReplicas(partitionKey);
        if (replicas.isEmpty()) {
            return this.childPolicy.newQueryPlan(query);
        }
        return new AbstractIterator<Host>(){
            private final Iterator<Host> iter;
            private Iterator<Host> childIterator;
            {
                this.iter = replicas.iterator();
            }

            protected Host computeNext() {
                Host host;
                while (this.iter.hasNext()) {
                    host = this.iter.next();
                    if (!host.isUp() || TokenAwarePolicy.this.childPolicy.distance(host) != HostDistance.LOCAL) continue;
                    return host;
                }
                if (this.childIterator == null) {
                    this.childIterator = TokenAwarePolicy.this.childPolicy.newQueryPlan(query);
                }
                while (this.childIterator.hasNext()) {
                    host = this.childIterator.next();
                    if (replicas.contains(host) && TokenAwarePolicy.this.childPolicy.distance(host) == HostDistance.LOCAL) continue;
                    return host;
                }
                return (Host)this.endOfData();
            }
        };
    }

    @Override
    public void onUp(Host host) {
        this.childPolicy.onUp(host);
    }

    @Override
    public void onDown(Host host) {
        this.childPolicy.onDown(host);
    }

    @Override
    public void onAdd(Host host) {
        this.childPolicy.onAdd(host);
    }

    @Override
    public void onRemove(Host host) {
        this.childPolicy.onRemove(host);
    }
}

