/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.nio.ByteBuffer;
import java.util.Set;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.ReadResponse;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.service.IResponseResolver;
import org.apache.cassandra.service.StorageService;
import org.cliffc.high_scale_lib.NonBlockingHashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRowResolver
implements IResponseResolver<ReadResponse, Row> {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractRowResolver.class);
    protected final String table;
    protected final Set<MessageIn<ReadResponse>> replies = new NonBlockingHashSet();
    protected final DecoratedKey key;

    public AbstractRowResolver(ByteBuffer key, String table) {
        this.key = StorageService.getPartitioner().decorateKey(key);
        this.table = table;
    }

    @Override
    public void preprocess(MessageIn<ReadResponse> message) {
        this.replies.add(message);
    }

    @Override
    public Iterable<MessageIn<ReadResponse>> getMessages() {
        return this.replies;
    }
}

