/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.filter;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.IColumnContainer;
import org.apache.cassandra.db.Memtable;
import org.apache.cassandra.db.OnDiskAtom;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.SuperColumn;
import org.apache.cassandra.db.columniterator.ISSTableColumnIterator;
import org.apache.cassandra.db.columniterator.IdentityQueryFilter;
import org.apache.cassandra.db.columniterator.OnDiskAtomIterator;
import org.apache.cassandra.db.filter.IDiskAtomFilter;
import org.apache.cassandra.db.filter.NamesQueryFilter;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.db.filter.SliceQueryFilter;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.utils.CloseableIterator;
import org.apache.cassandra.utils.IMergeIterator;
import org.apache.cassandra.utils.MergeIterator;

public class QueryFilter {
    public final DecoratedKey key;
    public final QueryPath path;
    public final IDiskAtomFilter filter;
    private final IDiskAtomFilter superFilter;

    public QueryFilter(DecoratedKey key, QueryPath path, IDiskAtomFilter filter) {
        this.key = key;
        this.path = path;
        this.filter = filter;
        this.superFilter = path.superColumnName == null ? null : new NamesQueryFilter(path.superColumnName);
    }

    public OnDiskAtomIterator getMemtableColumnIterator(Memtable memtable) {
        ColumnFamily cf = memtable.getColumnFamily(this.key);
        if (cf == null) {
            return null;
        }
        return this.getMemtableColumnIterator(cf, this.key);
    }

    public OnDiskAtomIterator getMemtableColumnIterator(ColumnFamily cf, DecoratedKey key) {
        assert (cf != null);
        if (this.path.superColumnName == null) {
            return this.filter.getMemtableColumnIterator(cf, key);
        }
        return this.superFilter.getMemtableColumnIterator(cf, key);
    }

    public ISSTableColumnIterator getSSTableColumnIterator(SSTableReader sstable) {
        if (this.path.superColumnName == null) {
            return this.filter.getSSTableColumnIterator(sstable, this.key);
        }
        return this.superFilter.getSSTableColumnIterator(sstable, this.key);
    }

    public ISSTableColumnIterator getSSTableColumnIterator(SSTableReader sstable, FileDataInput file, DecoratedKey key, RowIndexEntry indexEntry) {
        if (this.path.superColumnName == null) {
            return this.filter.getSSTableColumnIterator(sstable, file, key, indexEntry);
        }
        return this.superFilter.getSSTableColumnIterator(sstable, file, key, indexEntry);
    }

    public void collateOnDiskAtom(ColumnFamily returnCF, List<? extends CloseableIterator<OnDiskAtom>> toCollate, int gcBefore) {
        ArrayList<CloseableIterator<IColumn>> filteredIterators = new ArrayList<CloseableIterator<IColumn>>(toCollate.size());
        for (CloseableIterator<OnDiskAtom> closeableIterator : toCollate) {
            filteredIterators.add(QueryFilter.gatherTombstones(returnCF, closeableIterator));
        }
        this.collateColumns(returnCF, filteredIterators, gcBefore);
    }

    public void collateColumns(final ColumnFamily returnCF, List<? extends CloseableIterator<IColumn>> toCollate, final int gcBefore) {
        IDiskAtomFilter topLevelFilter = this.superFilter == null ? this.filter : this.superFilter;
        Comparator<IColumn> fcomp = topLevelFilter.getColumnComparator(returnCF.getComparator());
        MergeIterator.Reducer<IColumn, IColumn> reducer = new MergeIterator.Reducer<IColumn, IColumn>(){
            ColumnFamily curCF;
            {
                this.curCF = returnCF.cloneMeShallow();
            }

            @Override
            public void reduce(IColumn current) {
                if (this.curCF.isSuper() && this.curCF.isEmpty()) {
                    assert (current instanceof SuperColumn);
                    this.curCF.addColumn(((SuperColumn)current).cloneMe());
                } else {
                    this.curCF.addColumn(current);
                }
            }

            @Override
            protected IColumn getReduced() {
                IColumn c = this.curCF.iterator().next();
                if (QueryFilter.this.superFilter != null) {
                    DeletionInfo delInfo = ((SuperColumn)c).deletionInfo();
                    ((SuperColumn)c).delete(returnCF.deletionInfo());
                    c = QueryFilter.this.filter.filterSuperColumn((SuperColumn)c, gcBefore);
                    ((SuperColumn)c).setDeletionInfo(delInfo);
                }
                this.curCF.clear();
                return c;
            }
        };
        IMergeIterator<IColumn, IColumn> reduced = MergeIterator.get(toCollate, fcomp, reducer);
        topLevelFilter.collectReducedColumns(returnCF, reduced, gcBefore);
    }

    public static CloseableIterator<IColumn> gatherTombstones(final ColumnFamily returnCF, final CloseableIterator<OnDiskAtom> iter) {
        return new CloseableIterator<IColumn>(){
            private IColumn next;

            @Override
            public boolean hasNext() {
                if (this.next != null) {
                    return true;
                }
                this.getNext();
                return this.next != null;
            }

            @Override
            public IColumn next() {
                if (this.next == null) {
                    this.getNext();
                }
                assert (this.next != null);
                IColumn toReturn = this.next;
                this.next = null;
                return toReturn;
            }

            private void getNext() {
                while (iter.hasNext()) {
                    OnDiskAtom atom = (OnDiskAtom)iter.next();
                    if (atom instanceof IColumn) {
                        this.next = (IColumn)atom;
                        break;
                    }
                    returnCF.addAtom(atom);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void close() throws IOException {
                iter.close();
            }
        };
    }

    public String getColumnFamilyName() {
        return this.path.columnFamilyName;
    }

    public static boolean isRelevant(IColumn column, IColumnContainer container, int gcBefore) {
        long maxChange = column.mostRecentNonGCableChangeAt(gcBefore);
        return (column.getLocalDeletionTime() >= gcBefore || maxChange > column.getMarkedForDeleteAt()) && !container.deletionInfo().isDeleted(column.name(), maxChange);
    }

    public static QueryFilter getSliceFilter(DecoratedKey key, QueryPath path, ByteBuffer start, ByteBuffer finish, boolean reversed, int limit) {
        return new QueryFilter(key, path, new SliceQueryFilter(start, finish, reversed, limit));
    }

    public static QueryFilter getIdentityFilter(DecoratedKey key, QueryPath path) {
        return new QueryFilter(key, path, new IdentityQueryFilter());
    }

    public static QueryFilter getNamesFilter(DecoratedKey key, QueryPath path, SortedSet<ByteBuffer> columns) {
        return new QueryFilter(key, path, new NamesQueryFilter(columns));
    }

    public static QueryFilter getNamesFilter(DecoratedKey key, QueryPath path, ByteBuffer column) {
        return new QueryFilter(key, path, new NamesQueryFilter(column));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(key=" + this.key + ", path=" + this.path + (this.filter == null ? "" : ", filter=" + this.filter) + (this.superFilter == null ? "" : ", superFilter=" + this.superFilter) + ")";
    }
}

