/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.fate.util;

import java.net.UnknownHostException;
import java.security.Security;
import org.apache.log4j.Logger;

public class AddressUtil {
    private static final Logger log = Logger.getLogger(AddressUtil.class);

    public static int getAddressCacheNegativeTtl(UnknownHostException originalException) {
        int negativeTtl = 10;
        try {
            negativeTtl = Integer.parseInt(Security.getProperty("networkaddress.cache.negative.ttl"));
        }
        catch (NumberFormatException exception) {
            log.warn((Object)"Failed to get JVM negative DNS respones cache TTL due to format problem (e.g. this JVM might not have the property). Falling back to default based on Oracle JVM 1.6 (10s)", (Throwable)exception);
        }
        catch (SecurityException exception) {
            log.warn((Object)"Failed to get JVM negative DNS response cache TTL due to security manager. Falling back to default based on Oracle JVM 1.6 (10s)", (Throwable)exception);
        }
        if (-1 == negativeTtl) {
            log.error((Object)"JVM negative DNS repsonse cache TTL is set to 'forever' and host lookup failed. TTL can be changed with security property 'networkaddress.cache.negative.ttl', see java.net.InetAddress.", (Throwable)originalException);
            throw new IllegalArgumentException(originalException);
        }
        if (0 > negativeTtl) {
            log.warn((Object)"JVM specified negative DNS response cache TTL was negative (and not 'forever'). Falling back to default based on Oracle JVM 1.6 (10s)");
            negativeTtl = 10;
        }
        return negativeTtl;
    }
}

