/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util.shell.commands;

import java.io.IOException;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.util.Merge;
import org.apache.accumulo.core.util.shell.Shell;
import org.apache.accumulo.core.util.shell.commands.OptUtil;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.hadoop.io.Text;

public class MergeCommand
extends Shell.Command {
    private Option verboseOpt;
    private Option forceOpt;
    private Option sizeOpt;
    private Option allOpt;

    @Override
    public int execute(String fullCommand, CommandLine cl, final Shell shellState) throws Exception {
        boolean verbose = shellState.isVerbose();
        boolean force = false;
        boolean all = false;
        long size = -1L;
        String tableName = OptUtil.getTableOpt(cl, shellState);
        Text startRow = OptUtil.getStartRow(cl);
        Text endRow = OptUtil.getEndRow(cl);
        if (cl.hasOption(this.verboseOpt.getOpt())) {
            verbose = true;
        }
        if (cl.hasOption(this.forceOpt.getOpt())) {
            force = true;
        }
        if (cl.hasOption(this.allOpt.getOpt())) {
            all = true;
        }
        if (cl.hasOption(this.sizeOpt.getOpt())) {
            size = AccumuloConfiguration.getMemoryInBytes(cl.getOptionValue(this.sizeOpt.getOpt()));
        }
        if (startRow == null && endRow == null && size < 0L && !all) {
            shellState.getReader().flush();
            String line = shellState.getReader().readLine("Merge the entire table { " + tableName + " } into one tablet (yes|no)? ");
            if (line == null) {
                return 0;
            }
            if (!line.equalsIgnoreCase("y") && !line.equalsIgnoreCase("yes")) {
                return 0;
            }
        }
        if (size < 0L) {
            shellState.getConnector().tableOperations().merge(tableName, startRow, endRow);
        } else {
            final boolean finalVerbose = verbose;
            Merge merge = new Merge(){

                @Override
                protected void message(String fmt, Object ... args) {
                    if (finalVerbose) {
                        try {
                            shellState.getReader().println((CharSequence)String.format(fmt, args));
                        }
                        catch (IOException ex) {
                            throw new RuntimeException(ex);
                        }
                    }
                }
            };
            merge.mergomatic(shellState.getConnector(), tableName, startRow, endRow, size, force);
        }
        return 0;
    }

    @Override
    public String description() {
        return "merges tablets in a table";
    }

    @Override
    public int numArgs() {
        return 0;
    }

    @Override
    public Options getOptions() {
        Options o = new Options();
        this.verboseOpt = new Option("v", "verbose", false, "verbose output during merge");
        this.sizeOpt = new Option("s", "size", true, "merge tablets to the given size over the entire table");
        this.forceOpt = new Option("f", "force", false, "merge small tablets to large tablets, even if it goes over the given size");
        this.allOpt = new Option("", "all", false, "allow an entire table to be merged into one tablet without prompting the user for confirmation");
        Option startRowOpt = OptUtil.startRowOpt();
        startRowOpt.setDescription("begin row (NOT inclusive)");
        o.addOption(startRowOpt);
        o.addOption(OptUtil.endRowOpt());
        o.addOption(OptUtil.tableOpt("table to be merged"));
        o.addOption(this.verboseOpt);
        o.addOption(this.sizeOpt);
        o.addOption(this.forceOpt);
        o.addOption(this.allOpt);
        return o;
    }
}

