/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util;

import java.text.DecimalFormat;

public class NumUtil {
    private static final String[] QUANTITY_SUFFIX = new String[]{"", "K", "M", "B", "T", "e15", "e18", "e21"};
    private static final String[] SIZE_SUFFIX = new String[]{"", "K", "M", "G", "T", "P", "E", "Z"};
    private static DecimalFormat df = new DecimalFormat("#,###,##0");
    private static DecimalFormat df_mantissa = new DecimalFormat("#,###,##0.00");

    public static String bigNumberForSize(long big) {
        return NumUtil.bigNumber(big, SIZE_SUFFIX, 1024L);
    }

    public static String bigNumberForQuantity(long big) {
        return NumUtil.bigNumber(big, QUANTITY_SUFFIX, 1000L);
    }

    public static String bigNumberForQuantity(double big) {
        return NumUtil.bigNumber(big, QUANTITY_SUFFIX, 1000L);
    }

    private static String bigNumber(long big, String[] SUFFIXES, long base) {
        if (big < base) {
            return df.format(big) + SUFFIXES[0];
        }
        int exp = (int)(Math.log(big) / Math.log(base));
        double val = (double)big / Math.pow(base, exp);
        return df_mantissa.format(val) + SUFFIXES[exp];
    }

    private static String bigNumber(double big, String[] SUFFIXES, long base) {
        if (big < (double)base) {
            return df_mantissa.format(big) + SUFFIXES[0];
        }
        int exp = (int)(Math.log(big) / Math.log(base));
        double val = big / Math.pow(base, exp);
        return df_mantissa.format(val) + SUFFIXES[exp];
    }
}

