/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.master.thrift;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.client.impl.thrift.ThriftTableOperationException;
import org.apache.accumulo.core.data.thrift.TKeyExtent;
import org.apache.accumulo.core.master.thrift.FateService;
import org.apache.accumulo.core.master.thrift.MasterGoalState;
import org.apache.accumulo.core.master.thrift.MasterMonitorInfo;
import org.apache.accumulo.core.master.thrift.TabletLoadState;
import org.apache.accumulo.core.master.thrift.TabletSplit;
import org.apache.accumulo.core.security.thrift.TCredentials;
import org.apache.accumulo.trace.thrift.TInfo;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.ProcessFunction;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.TProcessor;
import org.apache.thrift.TServiceClientFactory;
import org.apache.thrift.async.AsyncMethodCallback;
import org.apache.thrift.async.TAsyncClient;
import org.apache.thrift.async.TAsyncClientFactory;
import org.apache.thrift.async.TAsyncClientManager;
import org.apache.thrift.async.TAsyncMethodCall;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TMemoryInputTransport;
import org.apache.thrift.transport.TNonblockingTransport;
import org.apache.thrift.transport.TTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterClientService {

    public static class reportTabletStatus_args
    implements TBase<reportTabletStatus_args, _Fields>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("reportTabletStatus_args");
        private static final TField TINFO_FIELD_DESC = new TField("tinfo", 12, 5);
        private static final TField CREDENTIALS_FIELD_DESC = new TField("credentials", 12, 1);
        private static final TField SERVER_NAME_FIELD_DESC = new TField("serverName", 11, 2);
        private static final TField STATUS_FIELD_DESC = new TField("status", 8, 3);
        private static final TField TABLET_FIELD_DESC = new TField("tablet", 12, 4);
        private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
        public TInfo tinfo;
        public TCredentials credentials;
        public String serverName;
        public TabletLoadState status;
        public TKeyExtent tablet;
        public static final Map<_Fields, FieldMetaData> metaDataMap;

        public reportTabletStatus_args() {
        }

        public reportTabletStatus_args(TInfo tinfo, TCredentials credentials, String serverName, TabletLoadState status, TKeyExtent tablet) {
            this();
            this.tinfo = tinfo;
            this.credentials = credentials;
            this.serverName = serverName;
            this.status = status;
            this.tablet = tablet;
        }

        public reportTabletStatus_args(reportTabletStatus_args other) {
            if (other.isSetTinfo()) {
                this.tinfo = new TInfo(other.tinfo);
            }
            if (other.isSetCredentials()) {
                this.credentials = new TCredentials(other.credentials);
            }
            if (other.isSetServerName()) {
                this.serverName = other.serverName;
            }
            if (other.isSetStatus()) {
                this.status = other.status;
            }
            if (other.isSetTablet()) {
                this.tablet = new TKeyExtent(other.tablet);
            }
        }

        public reportTabletStatus_args deepCopy() {
            return new reportTabletStatus_args(this);
        }

        public void clear() {
            this.tinfo = null;
            this.credentials = null;
            this.serverName = null;
            this.status = null;
            this.tablet = null;
        }

        public TInfo getTinfo() {
            return this.tinfo;
        }

        public reportTabletStatus_args setTinfo(TInfo tinfo) {
            this.tinfo = tinfo;
            return this;
        }

        public void unsetTinfo() {
            this.tinfo = null;
        }

        public boolean isSetTinfo() {
            return this.tinfo != null;
        }

        public void setTinfoIsSet(boolean value) {
            if (!value) {
                this.tinfo = null;
            }
        }

        public TCredentials getCredentials() {
            return this.credentials;
        }

        public reportTabletStatus_args setCredentials(TCredentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public void unsetCredentials() {
            this.credentials = null;
        }

        public boolean isSetCredentials() {
            return this.credentials != null;
        }

        public void setCredentialsIsSet(boolean value) {
            if (!value) {
                this.credentials = null;
            }
        }

        public String getServerName() {
            return this.serverName;
        }

        public reportTabletStatus_args setServerName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public void unsetServerName() {
            this.serverName = null;
        }

        public boolean isSetServerName() {
            return this.serverName != null;
        }

        public void setServerNameIsSet(boolean value) {
            if (!value) {
                this.serverName = null;
            }
        }

        public TabletLoadState getStatus() {
            return this.status;
        }

        public reportTabletStatus_args setStatus(TabletLoadState status) {
            this.status = status;
            return this;
        }

        public void unsetStatus() {
            this.status = null;
        }

        public boolean isSetStatus() {
            return this.status != null;
        }

        public void setStatusIsSet(boolean value) {
            if (!value) {
                this.status = null;
            }
        }

        public TKeyExtent getTablet() {
            return this.tablet;
        }

        public reportTabletStatus_args setTablet(TKeyExtent tablet) {
            this.tablet = tablet;
            return this;
        }

        public void unsetTablet() {
            this.tablet = null;
        }

        public boolean isSetTablet() {
            return this.tablet != null;
        }

        public void setTabletIsSet(boolean value) {
            if (!value) {
                this.tablet = null;
            }
        }

        public void setFieldValue(_Fields field, Object value) {
            switch (field) {
                case TINFO: {
                    if (value == null) {
                        this.unsetTinfo();
                        break;
                    }
                    this.setTinfo((TInfo)value);
                    break;
                }
                case CREDENTIALS: {
                    if (value == null) {
                        this.unsetCredentials();
                        break;
                    }
                    this.setCredentials((TCredentials)value);
                    break;
                }
                case SERVER_NAME: {
                    if (value == null) {
                        this.unsetServerName();
                        break;
                    }
                    this.setServerName((String)value);
                    break;
                }
                case STATUS: {
                    if (value == null) {
                        this.unsetStatus();
                        break;
                    }
                    this.setStatus((TabletLoadState)((Object)value));
                    break;
                }
                case TABLET: {
                    if (value == null) {
                        this.unsetTablet();
                        break;
                    }
                    this.setTablet((TKeyExtent)value);
                }
            }
        }

        public Object getFieldValue(_Fields field) {
            switch (field) {
                case TINFO: {
                    return this.getTinfo();
                }
                case CREDENTIALS: {
                    return this.getCredentials();
                }
                case SERVER_NAME: {
                    return this.getServerName();
                }
                case STATUS: {
                    return this.getStatus();
                }
                case TABLET: {
                    return this.getTablet();
                }
            }
            throw new IllegalStateException();
        }

        public boolean isSet(_Fields field) {
            if (field == null) {
                throw new IllegalArgumentException();
            }
            switch (field) {
                case TINFO: {
                    return this.isSetTinfo();
                }
                case CREDENTIALS: {
                    return this.isSetCredentials();
                }
                case SERVER_NAME: {
                    return this.isSetServerName();
                }
                case STATUS: {
                    return this.isSetStatus();
                }
                case TABLET: {
                    return this.isSetTablet();
                }
            }
            throw new IllegalStateException();
        }

        public boolean equals(Object that) {
            if (that == null) {
                return false;
            }
            if (that instanceof reportTabletStatus_args) {
                return this.equals((reportTabletStatus_args)that);
            }
            return false;
        }

        public boolean equals(reportTabletStatus_args that) {
            if (that == null) {
                return false;
            }
            boolean this_present_tinfo = this.isSetTinfo();
            boolean that_present_tinfo = that.isSetTinfo();
            if (this_present_tinfo || that_present_tinfo) {
                if (!this_present_tinfo || !that_present_tinfo) {
                    return false;
                }
                if (!this.tinfo.equals(that.tinfo)) {
                    return false;
                }
            }
            boolean this_present_credentials = this.isSetCredentials();
            boolean that_present_credentials = that.isSetCredentials();
            if (this_present_credentials || that_present_credentials) {
                if (!this_present_credentials || !that_present_credentials) {
                    return false;
                }
                if (!this.credentials.equals(that.credentials)) {
                    return false;
                }
            }
            boolean this_present_serverName = this.isSetServerName();
            boolean that_present_serverName = that.isSetServerName();
            if (this_present_serverName || that_present_serverName) {
                if (!this_present_serverName || !that_present_serverName) {
                    return false;
                }
                if (!this.serverName.equals(that.serverName)) {
                    return false;
                }
            }
            boolean this_present_status = this.isSetStatus();
            boolean that_present_status = that.isSetStatus();
            if (this_present_status || that_present_status) {
                if (!this_present_status || !that_present_status) {
                    return false;
                }
                if (!this.status.equals((Object)that.status)) {
                    return false;
                }
            }
            boolean this_present_tablet = this.isSetTablet();
            boolean that_present_tablet = that.isSetTablet();
            if (this_present_tablet || that_present_tablet) {
                if (!this_present_tablet || !that_present_tablet) {
                    return false;
                }
                if (!this.tablet.equals(that.tablet)) {
                    return false;
                }
            }
            return true;
        }

        public int hashCode() {
            return 0;
        }

        public int compareTo(reportTabletStatus_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            reportTabletStatus_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetTinfo()).compareTo(typedOther.isSetTinfo());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetTinfo() && (lastComparison = TBaseHelper.compareTo((Comparable)this.tinfo, (Comparable)typedOther.tinfo)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetCredentials()).compareTo(typedOther.isSetCredentials());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetCredentials() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.credentials), (Comparable)((Object)typedOther.credentials))) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetServerName()).compareTo(typedOther.isSetServerName());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetServerName() && (lastComparison = TBaseHelper.compareTo((String)this.serverName, (String)typedOther.serverName)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetStatus()).compareTo(typedOther.isSetStatus());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetStatus() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.status), (Comparable)((Object)typedOther.status))) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetTablet()).compareTo(typedOther.isSetTablet());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetTablet() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.tablet), (Comparable)((Object)typedOther.tablet))) != 0) {
                return lastComparison;
            }
            return 0;
        }

        public _Fields fieldForId(int fieldId) {
            return _Fields.findByThriftId(fieldId);
        }

        public void read(TProtocol iprot) throws TException {
            schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
        }

        public void write(TProtocol oprot) throws TException {
            schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("reportTabletStatus_args(");
            boolean first = true;
            sb.append("tinfo:");
            if (this.tinfo == null) {
                sb.append("null");
            } else {
                sb.append(this.tinfo);
            }
            first = false;
            if (!first) {
                sb.append(", ");
            }
            sb.append("credentials:");
            if (this.credentials == null) {
                sb.append("null");
            } else {
                sb.append(this.credentials);
            }
            first = false;
            if (!first) {
                sb.append(", ");
            }
            sb.append("serverName:");
            if (this.serverName == null) {
                sb.append("null");
            } else {
                sb.append(this.serverName);
            }
            first = false;
            if (!first) {
                sb.append(", ");
            }
            sb.append("status:");
            if (this.status == null) {
                sb.append("null");
            } else {
                sb.append((Object)this.status);
            }
            first = false;
            if (!first) {
                sb.append(", ");
            }
            sb.append("tablet:");
            if (this.tablet == null) {
                sb.append("null");
            } else {
                sb.append(this.tablet);
            }
            first = false;
            sb.append(")");
            return sb.toString();
        }

        public void validate() throws TException {
            if (this.tinfo != null) {
                this.tinfo.validate();
            }
            if (this.credentials != null) {
                this.credentials.validate();
            }
            if (this.tablet != null) {
                this.tablet.validate();
            }
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            try {
                this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
            }
            catch (TException te) {
                throw new IOException(te);
            }
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            try {
                this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
            }
            catch (TException te) {
                throw new IOException(te);
            }
        }

        static {
            schemes.put(StandardScheme.class, new reportTabletStatus_argsStandardSchemeFactory());
            schemes.put(TupleScheme.class, new reportTabletStatus_argsTupleSchemeFactory());
            EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
            tmpMap.put(_Fields.TINFO, new FieldMetaData("tinfo", 3, (FieldValueMetaData)new StructMetaData(12, TInfo.class)));
            tmpMap.put(_Fields.CREDENTIALS, new FieldMetaData("credentials", 3, (FieldValueMetaData)new StructMetaData(12, TCredentials.class)));
            tmpMap.put(_Fields.SERVER_NAME, new FieldMetaData("serverName", 3, new FieldValueMetaData(11)));
            tmpMap.put(_Fields.STATUS, new FieldMetaData("status", 3, (FieldValueMetaData)new EnumMetaData(16, TabletLoadState.class)));
            tmpMap.put(_Fields.TABLET, new FieldMetaData("tablet", 3, (FieldValueMetaData)new StructMetaData(12, TKeyExtent.class)));
            metaDataMap = Collections.unmodifiableMap(tmpMap);
            FieldMetaData.addStructMetaDataMap(reportTabletStatus_args.class, metaDataMap);
        }

        private static class reportTabletStatus_argsTupleScheme
        extends TupleScheme<reportTabletStatus_args> {
            private reportTabletStatus_argsTupleScheme() {
            }

            public void write(TProtocol prot, reportTabletStatus_args struct) throws TException {
                TTupleProtocol oprot = (TTupleProtocol)prot;
                BitSet optionals = new BitSet();
                if (struct.isSetTinfo()) {
                    optionals.set(0);
                }
                if (struct.isSetCredentials()) {
                    optionals.set(1);
                }
                if (struct.isSetServerName()) {
                    optionals.set(2);
                }
                if (struct.isSetStatus()) {
                    optionals.set(3);
                }
                if (struct.isSetTablet()) {
                    optionals.set(4);
                }
                oprot.writeBitSet(optionals, 5);
                if (struct.isSetTinfo()) {
                    struct.tinfo.write((TProtocol)oprot);
                }
                if (struct.isSetCredentials()) {
                    struct.credentials.write((TProtocol)oprot);
                }
                if (struct.isSetServerName()) {
                    oprot.writeString(struct.serverName);
                }
                if (struct.isSetStatus()) {
                    oprot.writeI32(struct.status.getValue());
                }
                if (struct.isSetTablet()) {
                    struct.tablet.write((TProtocol)oprot);
                }
            }

            public void read(TProtocol prot, reportTabletStatus_args struct) throws TException {
                TTupleProtocol iprot = (TTupleProtocol)prot;
                BitSet incoming = iprot.readBitSet(5);
                if (incoming.get(0)) {
                    struct.tinfo = new TInfo();
                    struct.tinfo.read((TProtocol)iprot);
                    struct.setTinfoIsSet(true);
                }
                if (incoming.get(1)) {
                    struct.credentials = new TCredentials();
                    struct.credentials.read((TProtocol)iprot);
                    struct.setCredentialsIsSet(true);
                }
                if (incoming.get(2)) {
                    struct.serverName = iprot.readString();
                    struct.setServerNameIsSet(true);
                }
                if (incoming.get(3)) {
                    struct.status = TabletLoadState.findByValue(iprot.readI32());
                    struct.setStatusIsSet(true);
                }
                if (incoming.get(4)) {
                    struct.tablet = new TKeyExtent();
                    struct.tablet.read((TProtocol)iprot);
                    struct.setTabletIsSet(true);
                }
            }
        }

        private static class reportTabletStatus_argsTupleSchemeFactory
        implements SchemeFactory {
            private reportTabletStatus_argsTupleSchemeFactory() {
            }

            public reportTabletStatus_argsTupleScheme getScheme() {
                return new reportTabletStatus_argsTupleScheme();
            }
        }

        private static class reportTabletStatus_argsStandardScheme
        extends StandardScheme<reportTabletStatus_args> {
            private reportTabletStatus_argsStandardScheme() {
            }

            public void read(TProtocol iprot, reportTabletStatus_args struct) throws TException {
                iprot.readStructBegin();
                while (true) {
                    TField schemeField = iprot.readFieldBegin();
                    if (schemeField.type == 0) break;
                    switch (schemeField.id) {
                        case 5: {
                            if (schemeField.type == 12) {
                                struct.tinfo = new TInfo();
                                struct.tinfo.read(iprot);
                                struct.setTinfoIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        case 1: {
                            if (schemeField.type == 12) {
                                struct.credentials = new TCredentials();
                                struct.credentials.read(iprot);
                                struct.setCredentialsIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        case 2: {
                            if (schemeField.type == 11) {
                                struct.serverName = iprot.readString();
                                struct.setServerNameIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        case 3: {
                            if (schemeField.type == 8) {
                                struct.status = TabletLoadState.findByValue(iprot.readI32());
                                struct.setStatusIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        case 4: {
                            if (schemeField.type == 12) {
                                struct.tablet = new TKeyExtent();
                                struct.tablet.read(iprot);
                                struct.setTabletIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        default: {
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        }
                    }
                    iprot.readFieldEnd();
                }
                iprot.readStructEnd();
                struct.validate();
            }

            public void write(TProtocol oprot, reportTabletStatus_args struct) throws TException {
                struct.validate();
                oprot.writeStructBegin(STRUCT_DESC);
                if (struct.credentials != null) {
                    oprot.writeFieldBegin(CREDENTIALS_FIELD_DESC);
                    struct.credentials.write(oprot);
                    oprot.writeFieldEnd();
                }
                if (struct.serverName != null) {
                    oprot.writeFieldBegin(SERVER_NAME_FIELD_DESC);
                    oprot.writeString(struct.serverName);
                    oprot.writeFieldEnd();
                }
                if (struct.status != null) {
                    oprot.writeFieldBegin(STATUS_FIELD_DESC);
                    oprot.writeI32(struct.status.getValue());
                    oprot.writeFieldEnd();
                }
                if (struct.tablet != null) {
                    oprot.writeFieldBegin(TABLET_FIELD_DESC);
                    struct.tablet.write(oprot);
                    oprot.writeFieldEnd();
                }
                if (struct.tinfo != null) {
                    oprot.writeFieldBegin(TINFO_FIELD_DESC);
                    struct.tinfo.write(oprot);
                    oprot.writeFieldEnd();
                }
                oprot.writeFieldStop();
                oprot.writeStructEnd();
            }
        }

        private static class reportTabletStatus_argsStandardSchemeFactory
        implements SchemeFactory {
            private reportTabletStatus_argsStandardSchemeFactory() {
            }

            public reportTabletStatus_argsStandardScheme getScheme() {
                return new reportTabletStatus_argsStandardScheme();
            }
        }

        public static enum _Fields implements TFieldIdEnum
        {
            TINFO(5, "tinfo"),
            CREDENTIALS(1, "credentials"),
            SERVER_NAME(2, "serverName"),
            STATUS(3, "status"),
            TABLET(4, "tablet");

            private static final Map<String, _Fields> byName;
            private final short _thriftId;
            private final String _fieldName;

            public static _Fields findByThriftId(int fieldId) {
                switch (fieldId) {
                    case 5: {
                        return TINFO;
                    }
                    case 1: {
                        return CREDENTIALS;
                    }
                    case 2: {
                        return SERVER_NAME;
                    }
                    case 3: {
                        return STATUS;
                    }
                    case 4: {
                        return TABLET;
                    }
                }
                return null;
            }

            public static _Fields findByThriftIdOrThrow(int fieldId) {
                _Fields fields = _Fields.findByThriftId(fieldId);
                if (fields == null) {
                    throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
                }
                return fields;
            }

            public static _Fields findByName(String name) {
                return byName.get(name);
            }

            private _Fields(short thriftId, String fieldName) {
                this._thriftId = thriftId;
                this._fieldName = fieldName;
            }

            public short getThriftFieldId() {
                return this._thriftId;
            }

            public String getFieldName() {
                return this._fieldName;
            }

            static {
                byName = new HashMap<String, _Fields>();
                for (_Fields field : EnumSet.allOf(_Fields.class)) {
                    byName.put(field.getFieldName(), field);
                }
            }
        }
    }

    public static class reportSplitExtent_args
    implements TBase<reportSplitExtent_args, _Fields>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("reportSplitExtent_args");
        private static final TField TINFO_FIELD_DESC = new TField("tinfo", 12, 4);
        private static final TField CREDENTIALS_FIELD_DESC = new TField("credentials", 12, 1);
        private static final TField SERVER_NAME_FIELD_DESC = new TField("serverName", 11, 2);
        private static final TField SPLIT_FIELD_DESC = new TField("split", 12, 3);
        private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
        public TInfo tinfo;
        public TCredentials credentials;
        public String serverName;
        public TabletSplit split;
        public static final Map<_Fields, FieldMetaData> metaDataMap;

        public reportSplitExtent_args() {
        }

        public reportSplitExtent_args(TInfo tinfo, TCredentials credentials, String serverName, TabletSplit split) {
            this();
            this.tinfo = tinfo;
            this.credentials = credentials;
            this.serverName = serverName;
            this.split = split;
        }

        public reportSplitExtent_args(reportSplitExtent_args other) {
            if (other.isSetTinfo()) {
                this.tinfo = new TInfo(other.tinfo);
            }
            if (other.isSetCredentials()) {
                this.credentials = new TCredentials(other.credentials);
            }
            if (other.isSetServerName()) {
                this.serverName = other.serverName;
            }
            if (other.isSetSplit()) {
                this.split = new TabletSplit(other.split);
            }
        }

        public reportSplitExtent_args deepCopy() {
            return new reportSplitExtent_args(this);
        }

        public void clear() {
            this.tinfo = null;
            this.credentials = null;
            this.serverName = null;
            this.split = null;
        }

        public TInfo getTinfo() {
            return this.tinfo;
        }

        public reportSplitExtent_args setTinfo(TInfo tinfo) {
            this.tinfo = tinfo;
            return this;
        }

        public void unsetTinfo() {
            this.tinfo = null;
        }

        public boolean isSetTinfo() {
            return this.tinfo != null;
        }

        public void setTinfoIsSet(boolean value) {
            if (!value) {
                this.tinfo = null;
            }
        }

        public TCredentials getCredentials() {
            return this.credentials;
        }

        public reportSplitExtent_args setCredentials(TCredentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public void unsetCredentials() {
            this.credentials = null;
        }

        public boolean isSetCredentials() {
            return this.credentials != null;
        }

        public void setCredentialsIsSet(boolean value) {
            if (!value) {
                this.credentials = null;
            }
        }

        public String getServerName() {
            return this.serverName;
        }

        public reportSplitExtent_args setServerName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public void unsetServerName() {
            this.serverName = null;
        }

        public boolean isSetServerName() {
            return this.serverName != null;
        }

        public void setServerNameIsSet(boolean value) {
            if (!value) {
                this.serverName = null;
            }
        }

        public TabletSplit getSplit() {
            return this.split;
        }

        public reportSplitExtent_args setSplit(TabletSplit split) {
            this.split = split;
            return this;
        }

        public void unsetSplit() {
            this.split = null;
        }

        public boolean isSetSplit() {
            return this.split != null;
        }

        public void setSplitIsSet(boolean value) {
            if (!value) {
                this.split = null;
            }
        }

        public void setFieldValue(_Fields field, Object value) {
            switch (field) {
                case TINFO: {
                    if (value == null) {
                        this.unsetTinfo();
                        break;
                    }
                    this.setTinfo((TInfo)value);
                    break;
                }
                case CREDENTIALS: {
                    if (value == null) {
                        this.unsetCredentials();
                        break;
                    }
                    this.setCredentials((TCredentials)value);
                    break;
                }
                case SERVER_NAME: {
                    if (value == null) {
                        this.unsetServerName();
                        break;
                    }
                    this.setServerName((String)value);
                    break;
                }
                case SPLIT: {
                    if (value == null) {
                        this.unsetSplit();
                        break;
                    }
                    this.setSplit((TabletSplit)value);
                }
            }
        }

        public Object getFieldValue(_Fields field) {
            switch (field) {
                case TINFO: {
                    return this.getTinfo();
                }
                case CREDENTIALS: {
                    return this.getCredentials();
                }
                case SERVER_NAME: {
                    return this.getServerName();
                }
                case SPLIT: {
                    return this.getSplit();
                }
            }
            throw new IllegalStateException();
        }

        public boolean isSet(_Fields field) {
            if (field == null) {
                throw new IllegalArgumentException();
            }
            switch (field) {
                case TINFO: {
                    return this.isSetTinfo();
                }
                case CREDENTIALS: {
                    return this.isSetCredentials();
                }
                case SERVER_NAME: {
                    return this.isSetServerName();
                }
                case SPLIT: {
                    return this.isSetSplit();
                }
            }
            throw new IllegalStateException();
        }

        public boolean equals(Object that) {
            if (that == null) {
                return false;
            }
            if (that instanceof reportSplitExtent_args) {
                return this.equals((reportSplitExtent_args)that);
            }
            return false;
        }

        public boolean equals(reportSplitExtent_args that) {
            if (that == null) {
                return false;
            }
            boolean this_present_tinfo = this.isSetTinfo();
            boolean that_present_tinfo = that.isSetTinfo();
            if (this_present_tinfo || that_present_tinfo) {
                if (!this_present_tinfo || !that_present_tinfo) {
                    return false;
                }
                if (!this.tinfo.equals(that.tinfo)) {
                    return false;
                }
            }
            boolean this_present_credentials = this.isSetCredentials();
            boolean that_present_credentials = that.isSetCredentials();
            if (this_present_credentials || that_present_credentials) {
                if (!this_present_credentials || !that_present_credentials) {
                    return false;
                }
                if (!this.credentials.equals(that.credentials)) {
                    return false;
                }
            }
            boolean this_present_serverName = this.isSetServerName();
            boolean that_present_serverName = that.isSetServerName();
            if (this_present_serverName || that_present_serverName) {
                if (!this_present_serverName || !that_present_serverName) {
                    return false;
                }
                if (!this.serverName.equals(that.serverName)) {
                    return false;
                }
            }
            boolean this_present_split = this.isSetSplit();
            boolean that_present_split = that.isSetSplit();
            if (this_present_split || that_present_split) {
                if (!this_present_split || !that_present_split) {
                    return false;
                }
                if (!this.split.equals(that.split)) {
                    return false;
                }
            }
            return true;
        }

        public int hashCode() {
            return 0;
        }

        public int compareTo(reportSplitExtent_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            reportSplitExtent_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetTinfo()).compareTo(typedOther.isSetTinfo());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetTinfo() && (lastComparison = TBaseHelper.compareTo((Comparable)this.tinfo, (Comparable)typedOther.tinfo)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetCredentials()).compareTo(typedOther.isSetCredentials());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetCredentials() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.credentials), (Comparable)((Object)typedOther.credentials))) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetServerName()).compareTo(typedOther.isSetServerName());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetServerName() && (lastComparison = TBaseHelper.compareTo((String)this.serverName, (String)typedOther.serverName)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSplit()).compareTo(typedOther.isSetSplit());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSplit() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.split), (Comparable)((Object)typedOther.split))) != 0) {
                return lastComparison;
            }
            return 0;
        }

        public _Fields fieldForId(int fieldId) {
            return _Fields.findByThriftId(fieldId);
        }

        public void read(TProtocol iprot) throws TException {
            schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
        }

        public void write(TProtocol oprot) throws TException {
            schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("reportSplitExtent_args(");
            boolean first = true;
            sb.append("tinfo:");
            if (this.tinfo == null) {
                sb.append("null");
            } else {
                sb.append(this.tinfo);
            }
            first = false;
            if (!first) {
                sb.append(", ");
            }
            sb.append("credentials:");
            if (this.credentials == null) {
                sb.append("null");
            } else {
                sb.append(this.credentials);
            }
            first = false;
            if (!first) {
                sb.append(", ");
            }
            sb.append("serverName:");
            if (this.serverName == null) {
                sb.append("null");
            } else {
                sb.append(this.serverName);
            }
            first = false;
            if (!first) {
                sb.append(", ");
            }
            sb.append("split:");
            if (this.split == null) {
                sb.append("null");
            } else {
                sb.append(this.split);
            }
            first = false;
            sb.append(")");
            return sb.toString();
        }

        public void validate() throws TException {
            if (this.tinfo != null) {
                this.tinfo.validate();
            }
            if (this.credentials != null) {
                this.credentials.validate();
            }
            if (this.split != null) {
                this.split.validate();
            }
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            try {
                this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
            }
            catch (TException te) {
                throw new IOException(te);
            }
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            try {
                this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
            }
            catch (TException te) {
                throw new IOException(te);
            }
        }

        static {
            schemes.put(StandardScheme.class, new reportSplitExtent_argsStandardSchemeFactory());
            schemes.put(TupleScheme.class, new reportSplitExtent_argsTupleSchemeFactory());
            EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
            tmpMap.put(_Fields.TINFO, new FieldMetaData("tinfo", 3, (FieldValueMetaData)new StructMetaData(12, TInfo.class)));
            tmpMap.put(_Fields.CREDENTIALS, new FieldMetaData("credentials", 3, (FieldValueMetaData)new StructMetaData(12, TCredentials.class)));
            tmpMap.put(_Fields.SERVER_NAME, new FieldMetaData("serverName", 3, new FieldValueMetaData(11)));
            tmpMap.put(_Fields.SPLIT, new FieldMetaData("split", 3, (FieldValueMetaData)new StructMetaData(12, TabletSplit.class)));
            metaDataMap = Collections.unmodifiableMap(tmpMap);
            FieldMetaData.addStructMetaDataMap(reportSplitExtent_args.class, metaDataMap);
        }

        private static class reportSplitExtent_argsTupleScheme
        extends TupleScheme<reportSplitExtent_args> {
            private reportSplitExtent_argsTupleScheme() {
            }

            public void write(TProtocol prot, reportSplitExtent_args struct) throws TException {
                TTupleProtocol oprot = (TTupleProtocol)prot;
                BitSet optionals = new BitSet();
                if (struct.isSetTinfo()) {
                    optionals.set(0);
                }
                if (struct.isSetCredentials()) {
                    optionals.set(1);
                }
                if (struct.isSetServerName()) {
                    optionals.set(2);
                }
                if (struct.isSetSplit()) {
                    optionals.set(3);
                }
                oprot.writeBitSet(optionals, 4);
                if (struct.isSetTinfo()) {
                    struct.tinfo.write((TProtocol)oprot);
                }
                if (struct.isSetCredentials()) {
                    struct.credentials.write((TProtocol)oprot);
                }
                if (struct.isSetServerName()) {
                    oprot.writeString(struct.serverName);
                }
                if (struct.isSetSplit()) {
                    struct.split.write((TProtocol)oprot);
                }
            }

            public void read(TProtocol prot, reportSplitExtent_args struct) throws TException {
                TTupleProtocol iprot = (TTupleProtocol)prot;
                BitSet incoming = iprot.readBitSet(4);
                if (incoming.get(0)) {
                    struct.tinfo = new TInfo();
                    struct.tinfo.read((TProtocol)iprot);
                    struct.setTinfoIsSet(true);
                }
                if (incoming.get(1)) {
                    struct.credentials = new TCredentials();
                    struct.credentials.read((TProtocol)iprot);
                    struct.setCredentialsIsSet(true);
                }
                if (incoming.get(2)) {
                    struct.serverName = iprot.readString();
                    struct.setServerNameIsSet(true);
                }
                if (incoming.get(3)) {
                    struct.split = new TabletSplit();
                    struct.split.read((TProtocol)iprot);
                    struct.setSplitIsSet(true);
                }
            }
        }

        private static class reportSplitExtent_argsTupleSchemeFactory
        implements SchemeFactory {
            private reportSplitExtent_argsTupleSchemeFactory() {
            }

            public reportSplitExtent_argsTupleScheme getScheme() {
                return new reportSplitExtent_argsTupleScheme();
            }
        }

        private static class reportSplitExtent_argsStandardScheme
        extends StandardScheme<reportSplitExtent_args> {
            private reportSplitExtent_argsStandardScheme() {
            }

            public void read(TProtocol iprot, reportSplitExtent_args struct) throws TException {
                iprot.readStructBegin();
                while (true) {
                    TField schemeField = iprot.readFieldBegin();
                    if (schemeField.type == 0) break;
                    switch (schemeField.id) {
                        case 4: {
                            if (schemeField.type == 12) {
                                struct.tinfo = new TInfo();
                                struct.tinfo.read(iprot);
                                struct.setTinfoIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        case 1: {
                            if (schemeField.type == 12) {
                                struct.credentials = new TCredentials();
                                struct.credentials.read(iprot);
                                struct.setCredentialsIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        case 2: {
                            if (schemeField.type == 11) {
                                struct.serverName = iprot.readString();
                                struct.setServerNameIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        case 3: {
                            if (schemeField.type == 12) {
                                struct.split = new TabletSplit();
                                struct.split.read(iprot);
                                struct.setSplitIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        default: {
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        }
                    }
                    iprot.readFieldEnd();
                }
                iprot.readStructEnd();
                struct.validate();
            }

            public void write(TProtocol oprot, reportSplitExtent_args struct) throws TException {
                struct.validate();
                oprot.writeStructBegin(STRUCT_DESC);
                if (struct.credentials != null) {
                    oprot.writeFieldBegin(CREDENTIALS_FIELD_DESC);
                    struct.credentials.write(oprot);
                    oprot.writeFieldEnd();
                }
                if (struct.serverName != null) {
                    oprot.writeFieldBegin(SERVER_NAME_FIELD_DESC);
                    oprot.writeString(struct.serverName);
                    oprot.writeFieldEnd();
                }
                if (struct.split != null) {
                    oprot.writeFieldBegin(SPLIT_FIELD_DESC);
                    struct.split.write(oprot);
                    oprot.writeFieldEnd();
                }
                if (struct.tinfo != null) {
                    oprot.writeFieldBegin(TINFO_FIELD_DESC);
                    struct.tinfo.write(oprot);
                    oprot.writeFieldEnd();
                }
                oprot.writeFieldStop();
                oprot.writeStructEnd();
            }
        }

        private static class reportSplitExtent_argsStandardSchemeFactory
        implements SchemeFactory {
            private reportSplitExtent_argsStandardSchemeFactory() {
            }

            public reportSplitExtent_argsStandardScheme getScheme() {
                return new reportSplitExtent_argsStandardScheme();
            }
        }

        public static enum _Fields implements TFieldIdEnum
        {
            TINFO(4, "tinfo"),
            CREDENTIALS(1, "credentials"),
            SERVER_NAME(2, "serverName"),
            SPLIT(3, "split");

            private static final Map<String, _Fields> byName;
            private final short _thriftId;
            private final String _fieldName;

            public static _Fields findByThriftId(int fieldId) {
                switch (fieldId) {
                    case 4: {
                        return TINFO;
                    }
                    case 1: {
                        return CREDENTIALS;
                    }
                    case 2: {
                        return SERVER_NAME;
                    }
                    case 3: {
                        return SPLIT;
                    }
                }
                return null;
            }

            public static _Fields findByThriftIdOrThrow(int fieldId) {
                _Fields fields = _Fields.findByThriftId(fieldId);
                if (fields == null) {
                    throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
                }
                return fields;
            }

            public static _Fields findByName(String name) {
                return byName.get(name);
            }

            private _Fields(short thriftId, String fieldName) {
                this._thriftId = thriftId;
                this._fieldName = fieldName;
            }

            public short getThriftFieldId() {
                return this._thriftId;
            }

            public String getFieldName() {
                return this._fieldName;
            }

            static {
                byName = new HashMap<String, _Fields>();
                for (_Fields field : EnumSet.allOf(_Fields.class)) {
                    byName.put(field.getFieldName(), field);
                }
            }
        }
    }

    public static class getMasterStats_result
    implements TBase<getMasterStats_result, _Fields>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("getMasterStats_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 12, 0);
        private static final TField SEC_FIELD_DESC = new TField("sec", 12, 1);
        private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
        public MasterMonitorInfo success;
        public ThriftSecurityException sec;
        public static final Map<_Fields, FieldMetaData> metaDataMap;

        public getMasterStats_result() {
        }

        public getMasterStats_result(MasterMonitorInfo success2, ThriftSecurityException sec) {
            this();
            this.success = success2;
            this.sec = sec;
        }

        public getMasterStats_result(getMasterStats_result other) {
            if (other.isSetSuccess()) {
                this.success = new MasterMonitorInfo(other.success);
            }
            if (other.isSetSec()) {
                this.sec = new ThriftSecurityException(other.sec);
            }
        }

        public getMasterStats_result deepCopy() {
            return new getMasterStats_result(this);
        }

        public void clear() {
            this.success = null;
            this.sec = null;
        }

        public MasterMonitorInfo getSuccess() {
            return this.success;
        }

        public getMasterStats_result setSuccess(MasterMonitorInfo success2) {
            this.success = success2;
            return this;
        }

        public void unsetSuccess() {
            this.success = null;
        }

        public boolean isSetSuccess() {
            return this.success != null;
        }

        public void setSuccessIsSet(boolean value) {
            if (!value) {
                this.success = null;
            }
        }

        public ThriftSecurityException getSec() {
            return this.sec;
        }

        public getMasterStats_result setSec(ThriftSecurityException sec) {
            this.sec = sec;
            return this;
        }

        public void unsetSec() {
            this.sec = null;
        }

        public boolean isSetSec() {
            return this.sec != null;
        }

        public void setSecIsSet(boolean value) {
            if (!value) {
                this.sec = null;
            }
        }

        public void setFieldValue(_Fields field, Object value) {
            switch (field) {
                case SUCCESS: {
                    if (value == null) {
                        this.unsetSuccess();
                        break;
                    }
                    this.setSuccess((MasterMonitorInfo)value);
                    break;
                }
                case SEC: {
                    if (value == null) {
                        this.unsetSec();
                        break;
                    }
                    this.setSec((ThriftSecurityException)value);
                }
            }
        }

        public Object getFieldValue(_Fields field) {
            switch (field) {
                case SUCCESS: {
                    return this.getSuccess();
                }
                case SEC: {
                    return this.getSec();
                }
            }
            throw new IllegalStateException();
        }

        public boolean isSet(_Fields field) {
            if (field == null) {
                throw new IllegalArgumentException();
            }
            switch (field) {
                case SUCCESS: {
                    return this.isSetSuccess();
                }
                case SEC: {
                    return this.isSetSec();
                }
            }
            throw new IllegalStateException();
        }

        public boolean equals(Object that) {
            if (that == null) {
                return false;
            }
            if (that instanceof getMasterStats_result) {
                return this.equals((getMasterStats_result)that);
            }
            return false;
        }

        public boolean equals(getMasterStats_result that) {
            if (that == null) {
                return false;
            }
            boolean this_present_success = this.isSetSuccess();
            boolean that_present_success = that.isSetSuccess();
            if (this_present_success || that_present_success) {
                if (!this_present_success || !that_present_success) {
                    return false;
                }
                if (!this.success.equals(that.success)) {
                    return false;
                }
            }
            boolean this_present_sec = this.isSetSec();
            boolean that_present_sec = that.isSetSec();
            if (this_present_sec || that_present_sec) {
                if (!this_present_sec || !that_present_sec) {
                    return false;
                }
                if (!this.sec.equals(that.sec)) {
                    return false;
                }
            }
            return true;
        }

        public int hashCode() {
            return 0;
        }

        public int compareTo(getMasterStats_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            getMasterStats_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.success), (Comparable)((Object)typedOther.success))) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSec()).compareTo(typedOther.isSetSec());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSec() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.sec), (Comparable)((Object)typedOther.sec))) != 0) {
                return lastComparison;
            }
            return 0;
        }

        public _Fields fieldForId(int fieldId) {
            return _Fields.findByThriftId(fieldId);
        }

        public void read(TProtocol iprot) throws TException {
            schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
        }

        public void write(TProtocol oprot) throws TException {
            schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("getMasterStats_result(");
            boolean first = true;
            sb.append("success:");
            if (this.success == null) {
                sb.append("null");
            } else {
                sb.append(this.success);
            }
            first = false;
            if (!first) {
                sb.append(", ");
            }
            sb.append("sec:");
            if (this.sec == null) {
                sb.append("null");
            } else {
                sb.append(this.sec);
            }
            first = false;
            sb.append(")");
            return sb.toString();
        }

        public void validate() throws TException {
            if (this.success != null) {
                this.success.validate();
            }
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            try {
                this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
            }
            catch (TException te) {
                throw new IOException(te);
            }
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            try {
                this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
            }
            catch (TException te) {
                throw new IOException(te);
            }
        }

        static {
            schemes.put(StandardScheme.class, new getMasterStats_resultStandardSchemeFactory());
            schemes.put(TupleScheme.class, new getMasterStats_resultTupleSchemeFactory());
            EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
            tmpMap.put(_Fields.SUCCESS, new FieldMetaData("success", 3, (FieldValueMetaData)new StructMetaData(12, MasterMonitorInfo.class)));
            tmpMap.put(_Fields.SEC, new FieldMetaData("sec", 3, new FieldValueMetaData(12)));
            metaDataMap = Collections.unmodifiableMap(tmpMap);
            FieldMetaData.addStructMetaDataMap(getMasterStats_result.class, metaDataMap);
        }

        private static class getMasterStats_resultTupleScheme
        extends TupleScheme<getMasterStats_result> {
            private getMasterStats_resultTupleScheme() {
            }

            public void write(TProtocol prot, getMasterStats_result struct) throws TException {
                TTupleProtocol oprot = (TTupleProtocol)prot;
                BitSet optionals = new BitSet();
                if (struct.isSetSuccess()) {
                    optionals.set(0);
                }
                if (struct.isSetSec()) {
                    optionals.set(1);
                }
                oprot.writeBitSet(optionals, 2);
                if (struct.isSetSuccess()) {
                    struct.success.write((TProtocol)oprot);
                }
                if (struct.isSetSec()) {
                    struct.sec.write((TProtocol)oprot);
                }
            }

            public void read(TProtocol prot, getMasterStats_result struct) throws TException {
                TTupleProtocol iprot = (TTupleProtocol)prot;
                BitSet incoming = iprot.readBitSet(2);
                if (incoming.get(0)) {
                    struct.success = new MasterMonitorInfo();
                    struct.success.read((TProtocol)iprot);
                    struct.setSuccessIsSet(true);
                }
                if (incoming.get(1)) {
                    struct.sec = new ThriftSecurityException();
                    struct.sec.read((TProtocol)iprot);
                    struct.setSecIsSet(true);
                }
            }
        }

        private static class getMasterStats_resultTupleSchemeFactory
        implements SchemeFactory {
            private getMasterStats_resultTupleSchemeFactory() {
            }

            public getMasterStats_resultTupleScheme getScheme() {
                return new getMasterStats_resultTupleScheme();
            }
        }

        private static class getMasterStats_resultStandardScheme
        extends StandardScheme<getMasterStats_result> {
            private getMasterStats_resultStandardScheme() {
            }

            public void read(TProtocol iprot, getMasterStats_result struct) throws TException {
                iprot.readStructBegin();
                while (true) {
                    TField schemeField = iprot.readFieldBegin();
                    if (schemeField.type == 0) break;
                    switch (schemeField.id) {
                        case 0: {
                            if (schemeField.type == 12) {
                                struct.success = new MasterMonitorInfo();
                                struct.success.read(iprot);
                                struct.setSuccessIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        case 1: {
                            if (schemeField.type == 12) {
                                struct.sec = new ThriftSecurityException();
                                struct.sec.read(iprot);
                                struct.setSecIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        default: {
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        }
                    }
                    iprot.readFieldEnd();
                }
                iprot.readStructEnd();
                struct.validate();
            }

            public void write(TProtocol oprot, getMasterStats_result struct) throws TException {
                struct.validate();
                oprot.writeStructBegin(STRUCT_DESC);
                if (struct.success != null) {
                    oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                    struct.success.write(oprot);
                    oprot.writeFieldEnd();
                }
                if (struct.sec != null) {
                    oprot.writeFieldBegin(SEC_FIELD_DESC);
                    struct.sec.write(oprot);
                    oprot.writeFieldEnd();
                }
                oprot.writeFieldStop();
                oprot.writeStructEnd();
            }
        }

        private static class getMasterStats_resultStandardSchemeFactory
        implements SchemeFactory {
            private getMasterStats_resultStandardSchemeFactory() {
            }

            public getMasterStats_resultStandardScheme getScheme() {
                return new getMasterStats_resultStandardScheme();
            }
        }

        public static enum _Fields implements TFieldIdEnum
        {
            SUCCESS(0, "success"),
            SEC(1, "sec");

            private static final Map<String, _Fields> byName;
            private final short _thriftId;
            private final String _fieldName;

            public static _Fields findByThriftId(int fieldId) {
                switch (fieldId) {
                    case 0: {
                        return SUCCESS;
                    }
                    case 1: {
                        return SEC;
                    }
                }
                return null;
            }

            public static _Fields findByThriftIdOrThrow(int fieldId) {
                _Fields fields = _Fields.findByThriftId(fieldId);
                if (fields == null) {
                    throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
                }
                return fields;
            }

            public static _Fields findByName(String name) {
                return byName.get(name);
            }

            private _Fields(short thriftId, String fieldName) {
                this._thriftId = thriftId;
                this._fieldName = fieldName;
            }

            public short getThriftFieldId() {
                return this._thriftId;
            }

            public String getFieldName() {
                return this._fieldName;
            }

            static {
                byName = new HashMap<String, _Fields>();
                for (_Fields field : EnumSet.allOf(_Fields.class)) {
                    byName.put(field.getFieldName(), field);
                }
            }
        }
    }

    public static class getMasterStats_args
    implements TBase<getMasterStats_args, _Fields>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("getMasterStats_args");
        private static final TField TINFO_FIELD_DESC = new TField("tinfo", 12, 2);
        private static final TField CREDENTIALS_FIELD_DESC = new TField("credentials", 12, 1);
        private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
        public TInfo tinfo;
        public TCredentials credentials;
        public static final Map<_Fields, FieldMetaData> metaDataMap;

        public getMasterStats_args() {
        }

        public getMasterStats_args(TInfo tinfo, TCredentials credentials) {
            this();
            this.tinfo = tinfo;
            this.credentials = credentials;
        }

        public getMasterStats_args(getMasterStats_args other) {
            if (other.isSetTinfo()) {
                this.tinfo = new TInfo(other.tinfo);
            }
            if (other.isSetCredentials()) {
                this.credentials = new TCredentials(other.credentials);
            }
        }

        public getMasterStats_args deepCopy() {
            return new getMasterStats_args(this);
        }

        public void clear() {
            this.tinfo = null;
            this.credentials = null;
        }

        public TInfo getTinfo() {
            return this.tinfo;
        }

        public getMasterStats_args setTinfo(TInfo tinfo) {
            this.tinfo = tinfo;
            return this;
        }

        public void unsetTinfo() {
            this.tinfo = null;
        }

        public boolean isSetTinfo() {
            return this.tinfo != null;
        }

        public void setTinfoIsSet(boolean value) {
            if (!value) {
                this.tinfo = null;
            }
        }

        public TCredentials getCredentials() {
            return this.credentials;
        }

        public getMasterStats_args setCredentials(TCredentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public void unsetCredentials() {
            this.credentials = null;
        }

        public boolean isSetCredentials() {
            return this.credentials != null;
        }

        public void setCredentialsIsSet(boolean value) {
            if (!value) {
                this.credentials = null;
            }
        }

        public void setFieldValue(_Fields field, Object value) {
            switch (field) {
                case TINFO: {
                    if (value == null) {
                        this.unsetTinfo();
                        break;
                    }
                    this.setTinfo((TInfo)value);
                    break;
                }
                case CREDENTIALS: {
                    if (value == null) {
                        this.unsetCredentials();
                        break;
                    }
                    this.setCredentials((TCredentials)value);
                }
            }
        }

        public Object getFieldValue(_Fields field) {
            switch (field) {
                case TINFO: {
                    return this.getTinfo();
                }
                case CREDENTIALS: {
                    return this.getCredentials();
                }
            }
            throw new IllegalStateException();
        }

        public boolean isSet(_Fields field) {
            if (field == null) {
                throw new IllegalArgumentException();
            }
            switch (field) {
                case TINFO: {
                    return this.isSetTinfo();
                }
                case CREDENTIALS: {
                    return this.isSetCredentials();
                }
            }
            throw new IllegalStateException();
        }

        public boolean equals(Object that) {
            if (that == null) {
                return false;
            }
            if (that instanceof getMasterStats_args) {
                return this.equals((getMasterStats_args)that);
            }
            return false;
        }

        public boolean equals(getMasterStats_args that) {
            if (that == null) {
                return false;
            }
            boolean this_present_tinfo = this.isSetTinfo();
            boolean that_present_tinfo = that.isSetTinfo();
            if (this_present_tinfo || that_present_tinfo) {
                if (!this_present_tinfo || !that_present_tinfo) {
                    return false;
                }
                if (!this.tinfo.equals(that.tinfo)) {
                    return false;
                }
            }
            boolean this_present_credentials = this.isSetCredentials();
            boolean that_present_credentials = that.isSetCredentials();
            if (this_present_credentials || that_present_credentials) {
                if (!this_present_credentials || !that_present_credentials) {
                    return false;
                }
                if (!this.credentials.equals(that.credentials)) {
                    return false;
                }
            }
            return true;
        }

        public int hashCode() {
            return 0;
        }

        public int compareTo(getMasterStats_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            getMasterStats_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetTinfo()).compareTo(typedOther.isSetTinfo());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetTinfo() && (lastComparison = TBaseHelper.compareTo((Comparable)this.tinfo, (Comparable)typedOther.tinfo)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetCredentials()).compareTo(typedOther.isSetCredentials());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetCredentials() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.credentials), (Comparable)((Object)typedOther.credentials))) != 0) {
                return lastComparison;
            }
            return 0;
        }

        public _Fields fieldForId(int fieldId) {
            return _Fields.findByThriftId(fieldId);
        }

        public void read(TProtocol iprot) throws TException {
            schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
        }

        public void write(TProtocol oprot) throws TException {
            schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("getMasterStats_args(");
            boolean first = true;
            sb.append("tinfo:");
            if (this.tinfo == null) {
                sb.append("null");
            } else {
                sb.append(this.tinfo);
            }
            first = false;
            if (!first) {
                sb.append(", ");
            }
            sb.append("credentials:");
            if (this.credentials == null) {
                sb.append("null");
            } else {
                sb.append(this.credentials);
            }
            first = false;
            sb.append(")");
            return sb.toString();
        }

        public void validate() throws TException {
            if (this.tinfo != null) {
                this.tinfo.validate();
            }
            if (this.credentials != null) {
                this.credentials.validate();
            }
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            try {
                this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
            }
            catch (TException te) {
                throw new IOException(te);
            }
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            try {
                this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
            }
            catch (TException te) {
                throw new IOException(te);
            }
        }

        static {
            schemes.put(StandardScheme.class, new getMasterStats_argsStandardSchemeFactory());
            schemes.put(TupleScheme.class, new getMasterStats_argsTupleSchemeFactory());
            EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
            tmpMap.put(_Fields.TINFO, new FieldMetaData("tinfo", 3, (FieldValueMetaData)new StructMetaData(12, TInfo.class)));
            tmpMap.put(_Fields.CREDENTIALS, new FieldMetaData("credentials", 3, (FieldValueMetaData)new StructMetaData(12, TCredentials.class)));
            metaDataMap = Collections.unmodifiableMap(tmpMap);
            FieldMetaData.addStructMetaDataMap(getMasterStats_args.class, metaDataMap);
        }

        private static class getMasterStats_argsTupleScheme
        extends TupleScheme<getMasterStats_args> {
            private getMasterStats_argsTupleScheme() {
            }

            public void write(TProtocol prot, getMasterStats_args struct) throws TException {
                TTupleProtocol oprot = (TTupleProtocol)prot;
                BitSet optionals = new BitSet();
                if (struct.isSetTinfo()) {
                    optionals.set(0);
                }
                if (struct.isSetCredentials()) {
                    optionals.set(1);
                }
                oprot.writeBitSet(optionals, 2);
                if (struct.isSetTinfo()) {
                    struct.tinfo.write((TProtocol)oprot);
                }
                if (struct.isSetCredentials()) {
                    struct.credentials.write((TProtocol)oprot);
                }
            }

            public void read(TProtocol prot, getMasterStats_args struct) throws TException {
                TTupleProtocol iprot = (TTupleProtocol)prot;
                BitSet incoming = iprot.readBitSet(2);
                if (incoming.get(0)) {
                    struct.tinfo = new TInfo();
                    struct.tinfo.read((TProtocol)iprot);
                    struct.setTinfoIsSet(true);
                }
                if (incoming.get(1)) {
                    struct.credentials = new TCredentials();
                    struct.credentials.read((TProtocol)iprot);
                    struct.setCredentialsIsSet(true);
                }
            }
        }

        private static class getMasterStats_argsTupleSchemeFactory
        implements SchemeFactory {
            private getMasterStats_argsTupleSchemeFactory() {
            }

            public getMasterStats_argsTupleScheme getScheme() {
                return new getMasterStats_argsTupleScheme();
            }
        }

        private static class getMasterStats_argsStandardScheme
        extends StandardScheme<getMasterStats_args> {
            private getMasterStats_argsStandardScheme() {
            }

            public void read(TProtocol iprot, getMasterStats_args struct) throws TException {
                iprot.readStructBegin();
                while (true) {
                    TField schemeField = iprot.readFieldBegin();
                    if (schemeField.type == 0) break;
                    switch (schemeField.id) {
                        case 2: {
                            if (schemeField.type == 12) {
                                struct.tinfo = new TInfo();
                                struct.tinfo.read(iprot);
                                struct.setTinfoIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        case 1: {
                            if (schemeField.type == 12) {
                                struct.credentials = new TCredentials();
                                struct.credentials.read(iprot);
                                struct.setCredentialsIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        default: {
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        }
                    }
                    iprot.readFieldEnd();
                }
                iprot.readStructEnd();
                struct.validate();
            }

            public void write(TProtocol oprot, getMasterStats_args struct) throws TException {
                struct.validate();
                oprot.writeStructBegin(STRUCT_DESC);
                if (struct.credentials != null) {
                    oprot.writeFieldBegin(CREDENTIALS_FIELD_DESC);
                    struct.credentials.write(oprot);
                    oprot.writeFieldEnd();
                }
                if (struct.tinfo != null) {
                    oprot.writeFieldBegin(TINFO_FIELD_DESC);
                    struct.tinfo.write(oprot);
                    oprot.writeFieldEnd();
                }
                oprot.writeFieldStop();
                oprot.writeStructEnd();
            }
        }

        private static class getMasterStats_argsStandardSchemeFactory
        implements SchemeFactory {
            private getMasterStats_argsStandardSchemeFactory() {
            }

            public getMasterStats_argsStandardScheme getScheme() {
                return new getMasterStats_argsStandardScheme();
            }
        }

        public static enum _Fields implements TFieldIdEnum
        {
            TINFO(2, "tinfo"),
            CREDENTIALS(1, "credentials");

            private static final Map<String, _Fields> byName;
            private final short _thriftId;
            private final String _fieldName;

            public static _Fields findByThriftId(int fieldId) {
                switch (fieldId) {
                    case 2: {
                        return TINFO;
                    }
                    case 1: {
                        return CREDENTIALS;
                    }
                }
                return null;
            }

            public static _Fields findByThriftIdOrThrow(int fieldId) {
                _Fields fields = _Fields.findByThriftId(fieldId);
                if (fields == null) {
                    throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
                }
                return fields;
            }

            public static _Fields findByName(String name) {
                return byName.get(name);
            }

            private _Fields(short thriftId, String fieldName) {
                this._thriftId = thriftId;
                this._fieldName = fieldName;
            }

            public short getThriftFieldId() {
                return this._thriftId;
            }

            public String getFieldName() {
                return this._fieldName;
            }

            static {
                byName = new HashMap<String, _Fields>();
                for (_Fields field : EnumSet.allOf(_Fields.class)) {
                    byName.put(field.getFieldName(), field);
                }
            }
        }
    }

    public static class removeSystemProperty_result
    implements TBase<removeSystemProperty_result, _Fields>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("removeSystemProperty_result");
        private static final TField SEC_FIELD_DESC = new TField("sec", 12, 1);
        private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
        public ThriftSecurityException sec;
        public static final Map<_Fields, FieldMetaData> metaDataMap;

        public removeSystemProperty_result() {
        }

        public removeSystemProperty_result(ThriftSecurityException sec) {
            this();
            this.sec = sec;
        }

        public removeSystemProperty_result(removeSystemProperty_result other) {
            if (other.isSetSec()) {
                this.sec = new ThriftSecurityException(other.sec);
            }
        }

        public removeSystemProperty_result deepCopy() {
            return new removeSystemProperty_result(this);
        }

        public void clear() {
            this.sec = null;
        }

        public ThriftSecurityException getSec() {
            return this.sec;
        }

        public removeSystemProperty_result setSec(ThriftSecurityException sec) {
            this.sec = sec;
            return this;
        }

        public void unsetSec() {
            this.sec = null;
        }

        public boolean isSetSec() {
            return this.sec != null;
        }

        public void setSecIsSet(boolean value) {
            if (!value) {
                this.sec = null;
            }
        }

        public void setFieldValue(_Fields field, Object value) {
            switch (field) {
                case SEC: {
                    if (value == null) {
                        this.unsetSec();
                        break;
                    }
                    this.setSec((ThriftSecurityException)value);
                }
            }
        }

        public Object getFieldValue(_Fields field) {
            switch (field) {
                case SEC: {
                    return this.getSec();
                }
            }
            throw new IllegalStateException();
        }

        public boolean isSet(_Fields field) {
            if (field == null) {
                throw new IllegalArgumentException();
            }
            switch (field) {
                case SEC: {
                    return this.isSetSec();
                }
            }
            throw new IllegalStateException();
        }

        public boolean equals(Object that) {
            if (that == null) {
                return false;
            }
            if (that instanceof removeSystemProperty_result) {
                return this.equals((removeSystemProperty_result)that);
            }
            return false;
        }

        public boolean equals(removeSystemProperty_result that) {
            if (that == null) {
                return false;
            }
            boolean this_present_sec = this.isSetSec();
            boolean that_present_sec = that.isSetSec();
            if (this_present_sec || that_present_sec) {
                if (!this_present_sec || !that_present_sec) {
                    return false;
                }
                if (!this.sec.equals(that.sec)) {
                    return false;
                }
            }
            return true;
        }

        public int hashCode() {
            return 0;
        }

        public int compareTo(removeSystemProperty_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            removeSystemProperty_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSec()).compareTo(typedOther.isSetSec());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSec() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.sec), (Comparable)((Object)typedOther.sec))) != 0) {
                return lastComparison;
            }
            return 0;
        }

        public _Fields fieldForId(int fieldId) {
            return _Fields.findByThriftId(fieldId);
        }

        public void read(TProtocol iprot) throws TException {
            schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
        }

        public void write(TProtocol oprot) throws TException {
            schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("removeSystemProperty_result(");
            boolean first = true;
            sb.append("sec:");
            if (this.sec == null) {
                sb.append("null");
            } else {
                sb.append(this.sec);
            }
            first = false;
            sb.append(")");
            return sb.toString();
        }

        public void validate() throws TException {
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            try {
                this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
            }
            catch (TException te) {
                throw new IOException(te);
            }
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            try {
                this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
            }
            catch (TException te) {
                throw new IOException(te);
            }
        }

        static {
            schemes.put(StandardScheme.class, new removeSystemProperty_resultStandardSchemeFactory());
            schemes.put(TupleScheme.class, new removeSystemProperty_resultTupleSchemeFactory());
            EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
            tmpMap.put(_Fields.SEC, new FieldMetaData("sec", 3, new FieldValueMetaData(12)));
            metaDataMap = Collections.unmodifiableMap(tmpMap);
            FieldMetaData.addStructMetaDataMap(removeSystemProperty_result.class, metaDataMap);
        }

        private static class removeSystemProperty_resultTupleScheme
        extends TupleScheme<removeSystemProperty_result> {
            private removeSystemProperty_resultTupleScheme() {
            }

            public void write(TProtocol prot, removeSystemProperty_result struct) throws TException {
                TTupleProtocol oprot = (TTupleProtocol)prot;
                BitSet optionals = new BitSet();
                if (struct.isSetSec()) {
                    optionals.set(0);
                }
                oprot.writeBitSet(optionals, 1);
                if (struct.isSetSec()) {
                    struct.sec.write((TProtocol)oprot);
                }
            }

            public void read(TProtocol prot, removeSystemProperty_result struct) throws TException {
                TTupleProtocol iprot = (TTupleProtocol)prot;
                BitSet incoming = iprot.readBitSet(1);
                if (incoming.get(0)) {
                    struct.sec = new ThriftSecurityException();
                    struct.sec.read((TProtocol)iprot);
                    struct.setSecIsSet(true);
                }
            }
        }

        private static class removeSystemProperty_resultTupleSchemeFactory
        implements SchemeFactory {
            private removeSystemProperty_resultTupleSchemeFactory() {
            }

            public removeSystemProperty_resultTupleScheme getScheme() {
                return new removeSystemProperty_resultTupleScheme();
            }
        }

        private static class removeSystemProperty_resultStandardScheme
        extends StandardScheme<removeSystemProperty_result> {
            private removeSystemProperty_resultStandardScheme() {
            }

            public void read(TProtocol iprot, removeSystemProperty_result struct) throws TException {
                iprot.readStructBegin();
                while (true) {
                    TField schemeField = iprot.readFieldBegin();
                    if (schemeField.type == 0) break;
                    switch (schemeField.id) {
                        case 1: {
                            if (schemeField.type == 12) {
                                struct.sec = new ThriftSecurityException();
                                struct.sec.read(iprot);
                                struct.setSecIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        default: {
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        }
                    }
                    iprot.readFieldEnd();
                }
                iprot.readStructEnd();
                struct.validate();
            }

            public void write(TProtocol oprot, removeSystemProperty_result struct) throws TException {
                struct.validate();
                oprot.writeStructBegin(STRUCT_DESC);
                if (struct.sec != null) {
                    oprot.writeFieldBegin(SEC_FIELD_DESC);
                    struct.sec.write(oprot);
                    oprot.writeFieldEnd();
                }
                oprot.writeFieldStop();
                oprot.writeStructEnd();
            }
        }

        private static class removeSystemProperty_resultStandardSchemeFactory
        implements SchemeFactory {
            private removeSystemProperty_resultStandardSchemeFactory() {
            }

            public removeSystemProperty_resultStandardScheme getScheme() {
                return new removeSystemProperty_resultStandardScheme();
            }
        }

        public static enum _Fields implements TFieldIdEnum
        {
            SEC(1, "sec");

            private static final Map<String, _Fields> byName;
            private final short _thriftId;
            private final String _fieldName;

            public static _Fields findByThriftId(int fieldId) {
                switch (fieldId) {
                    case 1: {
                        return SEC;
                    }
                }
                return null;
            }

            public static _Fields findByThriftIdOrThrow(int fieldId) {
                _Fields fields = _Fields.findByThriftId(fieldId);
                if (fields == null) {
                    throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
                }
                return fields;
            }

            public static _Fields findByName(String name) {
                return byName.get(name);
            }

            private _Fields(short thriftId, String fieldName) {
                this._thriftId = thriftId;
                this._fieldName = fieldName;
            }

            public short getThriftFieldId() {
                return this._thriftId;
            }

            public String getFieldName() {
                return this._fieldName;
            }

            static {
                byName = new HashMap<String, _Fields>();
                for (_Fields field : EnumSet.allOf(_Fields.class)) {
                    byName.put(field.getFieldName(), field);
                }
            }
        }
    }

    public static class removeSystemProperty_args
    implements TBase<removeSystemProperty_args, _Fields>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("removeSystemProperty_args");
        private static final TField TINFO_FIELD_DESC = new TField("tinfo", 12, 3);
        private static final TField CREDENTIALS_FIELD_DESC = new TField("credentials", 12, 1);
        private static final TField PROPERTY_FIELD_DESC = new TField("property", 11, 2);
        private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
        public TInfo tinfo;
        public TCredentials credentials;
        public String property;
        public static final Map<_Fields, FieldMetaData> metaDataMap;

        public removeSystemProperty_args() {
        }

        public removeSystemProperty_args(TInfo tinfo, TCredentials credentials, String property) {
            this();
            this.tinfo = tinfo;
            this.credentials = credentials;
            this.property = property;
        }

        public removeSystemProperty_args(removeSystemProperty_args other) {
            if (other.isSetTinfo()) {
                this.tinfo = new TInfo(other.tinfo);
            }
            if (other.isSetCredentials()) {
                this.credentials = new TCredentials(other.credentials);
            }
            if (other.isSetProperty()) {
                this.property = other.property;
            }
        }

        public removeSystemProperty_args deepCopy() {
            return new removeSystemProperty_args(this);
        }

        public void clear() {
            this.tinfo = null;
            this.credentials = null;
            this.property = null;
        }

        public TInfo getTinfo() {
            return this.tinfo;
        }

        public removeSystemProperty_args setTinfo(TInfo tinfo) {
            this.tinfo = tinfo;
            return this;
        }

        public void unsetTinfo() {
            this.tinfo = null;
        }

        public boolean isSetTinfo() {
            return this.tinfo != null;
        }

        public void setTinfoIsSet(boolean value) {
            if (!value) {
                this.tinfo = null;
            }
        }

        public TCredentials getCredentials() {
            return this.credentials;
        }

        public removeSystemProperty_args setCredentials(TCredentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public void unsetCredentials() {
            this.credentials = null;
        }

        public boolean isSetCredentials() {
            return this.credentials != null;
        }

        public void setCredentialsIsSet(boolean value) {
            if (!value) {
                this.credentials = null;
            }
        }

        public String getProperty() {
            return this.property;
        }

        public removeSystemProperty_args setProperty(String property) {
            this.property = property;
            return this;
        }

        public void unsetProperty() {
            this.property = null;
        }

        public boolean isSetProperty() {
            return this.property != null;
        }

        public void setPropertyIsSet(boolean value) {
            if (!value) {
                this.property = null;
            }
        }

        public void setFieldValue(_Fields field, Object value) {
            switch (field) {
                case TINFO: {
                    if (value == null) {
                        this.unsetTinfo();
                        break;
                    }
                    this.setTinfo((TInfo)value);
                    break;
                }
                case CREDENTIALS: {
                    if (value == null) {
                        this.unsetCredentials();
                        break;
                    }
                    this.setCredentials((TCredentials)value);
                    break;
                }
                case PROPERTY: {
                    if (value == null) {
                        this.unsetProperty();
                        break;
                    }
                    this.setProperty((String)value);
                }
            }
        }

        public Object getFieldValue(_Fields field) {
            switch (field) {
                case TINFO: {
                    return this.getTinfo();
                }
                case CREDENTIALS: {
                    return this.getCredentials();
                }
                case PROPERTY: {
                    return this.getProperty();
                }
            }
            throw new IllegalStateException();
        }

        public boolean isSet(_Fields field) {
            if (field == null) {
                throw new IllegalArgumentException();
            }
            switch (field) {
                case TINFO: {
                    return this.isSetTinfo();
                }
                case CREDENTIALS: {
                    return this.isSetCredentials();
                }
                case PROPERTY: {
                    return this.isSetProperty();
                }
            }
            throw new IllegalStateException();
        }

        public boolean equals(Object that) {
            if (that == null) {
                return false;
            }
            if (that instanceof removeSystemProperty_args) {
                return this.equals((removeSystemProperty_args)that);
            }
            return false;
        }

        public boolean equals(removeSystemProperty_args that) {
            if (that == null) {
                return false;
            }
            boolean this_present_tinfo = this.isSetTinfo();
            boolean that_present_tinfo = that.isSetTinfo();
            if (this_present_tinfo || that_present_tinfo) {
                if (!this_present_tinfo || !that_present_tinfo) {
                    return false;
                }
                if (!this.tinfo.equals(that.tinfo)) {
                    return false;
                }
            }
            boolean this_present_credentials = this.isSetCredentials();
            boolean that_present_credentials = that.isSetCredentials();
            if (this_present_credentials || that_present_credentials) {
                if (!this_present_credentials || !that_present_credentials) {
                    return false;
                }
                if (!this.credentials.equals(that.credentials)) {
                    return false;
                }
            }
            boolean this_present_property = this.isSetProperty();
            boolean that_present_property = that.isSetProperty();
            if (this_present_property || that_present_property) {
                if (!this_present_property || !that_present_property) {
                    return false;
                }
                if (!this.property.equals(that.property)) {
                    return false;
                }
            }
            return true;
        }

        public int hashCode() {
            return 0;
        }

        public int compareTo(removeSystemProperty_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            removeSystemProperty_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetTinfo()).compareTo(typedOther.isSetTinfo());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetTinfo() && (lastComparison = TBaseHelper.compareTo((Comparable)this.tinfo, (Comparable)typedOther.tinfo)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetCredentials()).compareTo(typedOther.isSetCredentials());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetCredentials() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.credentials), (Comparable)((Object)typedOther.credentials))) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetProperty()).compareTo(typedOther.isSetProperty());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetProperty() && (lastComparison = TBaseHelper.compareTo((String)this.property, (String)typedOther.property)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        public _Fields fieldForId(int fieldId) {
            return _Fields.findByThriftId(fieldId);
        }

        public void read(TProtocol iprot) throws TException {
            schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
        }

        public void write(TProtocol oprot) throws TException {
            schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("removeSystemProperty_args(");
            boolean first = true;
            sb.append("tinfo:");
            if (this.tinfo == null) {
                sb.append("null");
            } else {
                sb.append(this.tinfo);
            }
            first = false;
            if (!first) {
                sb.append(", ");
            }
            sb.append("credentials:");
            if (this.credentials == null) {
                sb.append("null");
            } else {
                sb.append(this.credentials);
            }
            first = false;
            if (!first) {
                sb.append(", ");
            }
            sb.append("property:");
            if (this.property == null) {
                sb.append("null");
            } else {
                sb.append(this.property);
            }
            first = false;
            sb.append(")");
            return sb.toString();
        }

        public void validate() throws TException {
            if (this.tinfo != null) {
                this.tinfo.validate();
            }
            if (this.credentials != null) {
                this.credentials.validate();
            }
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            try {
                this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
            }
            catch (TException te) {
                throw new IOException(te);
            }
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            try {
                this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
            }
            catch (TException te) {
                throw new IOException(te);
            }
        }

        static {
            schemes.put(StandardScheme.class, new removeSystemProperty_argsStandardSchemeFactory());
            schemes.put(TupleScheme.class, new removeSystemProperty_argsTupleSchemeFactory());
            EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
            tmpMap.put(_Fields.TINFO, new FieldMetaData("tinfo", 3, (FieldValueMetaData)new StructMetaData(12, TInfo.class)));
            tmpMap.put(_Fields.CREDENTIALS, new FieldMetaData("credentials", 3, (FieldValueMetaData)new StructMetaData(12, TCredentials.class)));
            tmpMap.put(_Fields.PROPERTY, new FieldMetaData("property", 3, new FieldValueMetaData(11)));
            metaDataMap = Collections.unmodifiableMap(tmpMap);
            FieldMetaData.addStructMetaDataMap(removeSystemProperty_args.class, metaDataMap);
        }

        private static class removeSystemProperty_argsTupleScheme
        extends TupleScheme<removeSystemProperty_args> {
            private removeSystemProperty_argsTupleScheme() {
            }

            public void write(TProtocol prot, removeSystemProperty_args struct) throws TException {
                TTupleProtocol oprot = (TTupleProtocol)prot;
                BitSet optionals = new BitSet();
                if (struct.isSetTinfo()) {
                    optionals.set(0);
                }
                if (struct.isSetCredentials()) {
                    optionals.set(1);
                }
                if (struct.isSetProperty()) {
                    optionals.set(2);
                }
                oprot.writeBitSet(optionals, 3);
                if (struct.isSetTinfo()) {
                    struct.tinfo.write((TProtocol)oprot);
                }
                if (struct.isSetCredentials()) {
                    struct.credentials.write((TProtocol)oprot);
                }
                if (struct.isSetProperty()) {
                    oprot.writeString(struct.property);
                }
            }

            public void read(TProtocol prot, removeSystemProperty_args struct) throws TException {
                TTupleProtocol iprot = (TTupleProtocol)prot;
                BitSet incoming = iprot.readBitSet(3);
                if (incoming.get(0)) {
                    struct.tinfo = new TInfo();
                    struct.tinfo.read((TProtocol)iprot);
                    struct.setTinfoIsSet(true);
                }
                if (incoming.get(1)) {
                    struct.credentials = new TCredentials();
                    struct.credentials.read((TProtocol)iprot);
                    struct.setCredentialsIsSet(true);
                }
                if (incoming.get(2)) {
                    struct.property = iprot.readString();
                    struct.setPropertyIsSet(true);
                }
            }
        }

        private static class removeSystemProperty_argsTupleSchemeFactory
        implements SchemeFactory {
            private removeSystemProperty_argsTupleSchemeFactory() {
            }

            public removeSystemProperty_argsTupleScheme getScheme() {
                return new removeSystemProperty_argsTupleScheme();
            }
        }

        private static class removeSystemProperty_argsStandardScheme
        extends StandardScheme<removeSystemProperty_args> {
            private removeSystemProperty_argsStandardScheme() {
            }

            public void read(TProtocol iprot, removeSystemProperty_args struct) throws TException {
                iprot.readStructBegin();
                while (true) {
                    TField schemeField = iprot.readFieldBegin();
                    if (schemeField.type == 0) break;
                    switch (schemeField.id) {
                        case 3: {
                            if (schemeField.type == 12) {
                                struct.tinfo = new TInfo();
                                struct.tinfo.read(iprot);
                                struct.setTinfoIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        case 1: {
                            if (schemeField.type == 12) {
                                struct.credentials = new TCredentials();
                                struct.credentials.read(iprot);
                                struct.setCredentialsIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        case 2: {
                            if (schemeField.type == 11) {
                                struct.property = iprot.readString();
                                struct.setPropertyIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        default: {
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        }
                    }
                    iprot.readFieldEnd();
                }
                iprot.readStructEnd();
                struct.validate();
            }

            public void write(TProtocol oprot, removeSystemProperty_args struct) throws TException {
                struct.validate();
                oprot.writeStructBegin(STRUCT_DESC);
                if (struct.credentials != null) {
                    oprot.writeFieldBegin(CREDENTIALS_FIELD_DESC);
                    struct.credentials.write(oprot);
                    oprot.writeFieldEnd();
                }
                if (struct.property != null) {
                    oprot.writeFieldBegin(PROPERTY_FIELD_DESC);
                    oprot.writeString(struct.property);
                    oprot.writeFieldEnd();
                }
                if (struct.tinfo != null) {
                    oprot.writeFieldBegin(TINFO_FIELD_DESC);
                    struct.tinfo.write(oprot);
                    oprot.writeFieldEnd();
                }
                oprot.writeFieldStop();
                oprot.writeStructEnd();
            }
        }

        private static class removeSystemProperty_argsStandardSchemeFactory
        implements SchemeFactory {
            private removeSystemProperty_argsStandardSchemeFactory() {
            }

            public removeSystemProperty_argsStandardScheme getScheme() {
                return new removeSystemProperty_argsStandardScheme();
            }
        }

        public static enum _Fields implements TFieldIdEnum
        {
            TINFO(3, "tinfo"),
            CREDENTIALS(1, "credentials"),
            PROPERTY(2, "property");

            private static final Map<String, _Fields> byName;
            private final short _thriftId;
            private final String _fieldName;

            public static _Fields findByThriftId(int fieldId) {
                switch (fieldId) {
                    case 3: {
                        return TINFO;
                    }
                    case 1: {
                        return CREDENTIALS;
                    }
                    case 2: {
                        return PROPERTY;
                    }
                }
                return null;
            }

            public static _Fields findByThriftIdOrThrow(int fieldId) {
                _Fields fields = _Fields.findByThriftId(fieldId);
                if (fields == null) {
                    throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
                }
                return fields;
            }

            public static _Fields findByName(String name) {
                return byName.get(name);
            }

            private _Fields(short thriftId, String fieldName) {
                this._thriftId = thriftId;
                this._fieldName = fieldName;
            }

            public short getThriftFieldId() {
                return this._thriftId;
            }

            public String getFieldName() {
                return this._fieldName;
            }

            static {
                byName = new HashMap<String, _Fields>();
                for (_Fields field : EnumSet.allOf(_Fields.class)) {
                    byName.put(field.getFieldName(), field);
                }
            }
        }
    }

    public static class setSystemProperty_result
    implements TBase<setSystemProperty_result, _Fields>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("setSystemProperty_result");
        private static final TField SEC_FIELD_DESC = new TField("sec", 12, 1);
        private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
        public ThriftSecurityException sec;
        public static final Map<_Fields, FieldMetaData> metaDataMap;

        public setSystemProperty_result() {
        }

        public setSystemProperty_result(ThriftSecurityException sec) {
            this();
            this.sec = sec;
        }

        public setSystemProperty_result(setSystemProperty_result other) {
            if (other.isSetSec()) {
                this.sec = new ThriftSecurityException(other.sec);
            }
        }

        public setSystemProperty_result deepCopy() {
            return new setSystemProperty_result(this);
        }

        public void clear() {
            this.sec = null;
        }

        public ThriftSecurityException getSec() {
            return this.sec;
        }

        public setSystemProperty_result setSec(ThriftSecurityException sec) {
            this.sec = sec;
            return this;
        }

        public void unsetSec() {
            this.sec = null;
        }

        public boolean isSetSec() {
            return this.sec != null;
        }

        public void setSecIsSet(boolean value) {
            if (!value) {
                this.sec = null;
            }
        }

        public void setFieldValue(_Fields field, Object value) {
            switch (field) {
                case SEC: {
                    if (value == null) {
                        this.unsetSec();
                        break;
                    }
                    this.setSec((ThriftSecurityException)value);
                }
            }
        }

        public Object getFieldValue(_Fields field) {
            switch (field) {
                case SEC: {
                    return this.getSec();
                }
            }
            throw new IllegalStateException();
        }

        public boolean isSet(_Fields field) {
            if (field == null) {
                throw new IllegalArgumentException();
            }
            switch (field) {
                case SEC: {
                    return this.isSetSec();
                }
            }
            throw new IllegalStateException();
        }

        public boolean equals(Object that) {
            if (that == null) {
                return false;
            }
            if (that instanceof setSystemProperty_result) {
                return this.equals((setSystemProperty_result)that);
            }
            return false;
        }

        public boolean equals(setSystemProperty_result that) {
            if (that == null) {
                return false;
            }
            boolean this_present_sec = this.isSetSec();
            boolean that_present_sec = that.isSetSec();
            if (this_present_sec || that_present_sec) {
                if (!this_present_sec || !that_present_sec) {
                    return false;
                }
                if (!this.sec.equals(that.sec)) {
                    return false;
                }
            }
            return true;
        }

        public int hashCode() {
            return 0;
        }

        public int compareTo(setSystemProperty_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            setSystemProperty_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSec()).compareTo(typedOther.isSetSec());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSec() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.sec), (Comparable)((Object)typedOther.sec))) != 0) {
                return lastComparison;
            }
            return 0;
        }

        public _Fields fieldForId(int fieldId) {
            return _Fields.findByThriftId(fieldId);
        }

        public void read(TProtocol iprot) throws TException {
            schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
        }

        public void write(TProtocol oprot) throws TException {
            schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("setSystemProperty_result(");
            boolean first = true;
            sb.append("sec:");
            if (this.sec == null) {
                sb.append("null");
            } else {
                sb.append(this.sec);
            }
            first = false;
            sb.append(")");
            return sb.toString();
        }

        public void validate() throws TException {
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            try {
                this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
            }
            catch (TException te) {
                throw new IOException(te);
            }
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            try {
                this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
            }
            catch (TException te) {
                throw new IOException(te);
            }
        }

        static {
            schemes.put(StandardScheme.class, new setSystemProperty_resultStandardSchemeFactory());
            schemes.put(TupleScheme.class, new setSystemProperty_resultTupleSchemeFactory());
            EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
            tmpMap.put(_Fields.SEC, new FieldMetaData("sec", 3, new FieldValueMetaData(12)));
            metaDataMap = Collections.unmodifiableMap(tmpMap);
            FieldMetaData.addStructMetaDataMap(setSystemProperty_result.class, metaDataMap);
        }

        private static class setSystemProperty_resultTupleScheme
        extends TupleScheme<setSystemProperty_result> {
            private setSystemProperty_resultTupleScheme() {
            }

            public void write(TProtocol prot, setSystemProperty_result struct) throws TException {
                TTupleProtocol oprot = (TTupleProtocol)prot;
                BitSet optionals = new BitSet();
                if (struct.isSetSec()) {
                    optionals.set(0);
                }
                oprot.writeBitSet(optionals, 1);
                if (struct.isSetSec()) {
                    struct.sec.write((TProtocol)oprot);
                }
            }

            public void read(TProtocol prot, setSystemProperty_result struct) throws TException {
                TTupleProtocol iprot = (TTupleProtocol)prot;
                BitSet incoming = iprot.readBitSet(1);
                if (incoming.get(0)) {
                    struct.sec = new ThriftSecurityException();
                    struct.sec.read((TProtocol)iprot);
                    struct.setSecIsSet(true);
                }
            }
        }

        private static class setSystemProperty_resultTupleSchemeFactory
        implements SchemeFactory {
            private setSystemProperty_resultTupleSchemeFactory() {
            }

            public setSystemProperty_resultTupleScheme getScheme() {
                return new setSystemProperty_resultTupleScheme();
            }
        }

        private static class setSystemProperty_resultStandardScheme
        extends StandardScheme<setSystemProperty_result> {
            private setSystemProperty_resultStandardScheme() {
            }

            public void read(TProtocol iprot, setSystemProperty_result struct) throws TException {
                iprot.readStructBegin();
                while (true) {
                    TField schemeField = iprot.readFieldBegin();
                    if (schemeField.type == 0) break;
                    switch (schemeField.id) {
                        case 1: {
                            if (schemeField.type == 12) {
                                struct.sec = new ThriftSecurityException();
                                struct.sec.read(iprot);
                                struct.setSecIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        default: {
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        }
                    }
                    iprot.readFieldEnd();
                }
                iprot.readStructEnd();
                struct.validate();
            }

            public void write(TProtocol oprot, setSystemProperty_result struct) throws TException {
                struct.validate();
                oprot.writeStructBegin(STRUCT_DESC);
                if (struct.sec != null) {
                    oprot.writeFieldBegin(SEC_FIELD_DESC);
                    struct.sec.write(oprot);
                    oprot.writeFieldEnd();
                }
                oprot.writeFieldStop();
                oprot.writeStructEnd();
            }
        }

        private static class setSystemProperty_resultStandardSchemeFactory
        implements SchemeFactory {
            private setSystemProperty_resultStandardSchemeFactory() {
            }

            public setSystemProperty_resultStandardScheme getScheme() {
                return new setSystemProperty_resultStandardScheme();
            }
        }

        public static enum _Fields implements TFieldIdEnum
        {
            SEC(1, "sec");

            private static final Map<String, _Fields> byName;
            private final short _thriftId;
            private final String _fieldName;

            public static _Fields findByThriftId(int fieldId) {
                switch (fieldId) {
                    case 1: {
                        return SEC;
                    }
                }
                return null;
            }

            public static _Fields findByThriftIdOrThrow(int fieldId) {
                _Fields fields = _Fields.findByThriftId(fieldId);
                if (fields == null) {
                    throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
                }
                return fields;
            }

            public static _Fields findByName(String name) {
                return byName.get(name);
            }

            private _Fields(short thriftId, String fieldName) {
                this._thriftId = thriftId;
                this._fieldName = fieldName;
            }

            public short getThriftFieldId() {
                return this._thriftId;
            }

            public String getFieldName() {
                return this._fieldName;
            }

            static {
                byName = new HashMap<String, _Fields>();
                for (_Fields field : EnumSet.allOf(_Fields.class)) {
                    byName.put(field.getFieldName(), field);
                }
            }
        }
    }

    public static class setSystemProperty_args
    implements TBase<setSystemProperty_args, _Fields>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("setSystemProperty_args");
        private static final TField TINFO_FIELD_DESC = new TField("tinfo", 12, 4);
        private static final TField CREDENTIALS_FIELD_DESC = new TField("credentials", 12, 1);
        private static final TField PROPERTY_FIELD_DESC = new TField("property", 11, 2);
        private static final TField VALUE_FIELD_DESC = new TField("value", 11, 3);
        private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
        public TInfo tinfo;
        public TCredentials credentials;
        public String property;
        public String value;
        public static final Map<_Fields, FieldMetaData> metaDataMap;

        public setSystemProperty_args() {
        }

        public setSystemProperty_args(TInfo tinfo, TCredentials credentials, String property, String value) {
            this();
            this.tinfo = tinfo;
            this.credentials = credentials;
            this.property = property;
            this.value = value;
        }

        public setSystemProperty_args(setSystemProperty_args other) {
            if (other.isSetTinfo()) {
                this.tinfo = new TInfo(other.tinfo);
            }
            if (other.isSetCredentials()) {
                this.credentials = new TCredentials(other.credentials);
            }
            if (other.isSetProperty()) {
                this.property = other.property;
            }
            if (other.isSetValue()) {
                this.value = other.value;
            }
        }

        public setSystemProperty_args deepCopy() {
            return new setSystemProperty_args(this);
        }

        public void clear() {
            this.tinfo = null;
            this.credentials = null;
            this.property = null;
            this.value = null;
        }

        public TInfo getTinfo() {
            return this.tinfo;
        }

        public setSystemProperty_args setTinfo(TInfo tinfo) {
            this.tinfo = tinfo;
            return this;
        }

        public void unsetTinfo() {
            this.tinfo = null;
        }

        public boolean isSetTinfo() {
            return this.tinfo != null;
        }

        public void setTinfoIsSet(boolean value) {
            if (!value) {
                this.tinfo = null;
            }
        }

        public TCredentials getCredentials() {
            return this.credentials;
        }

        public setSystemProperty_args setCredentials(TCredentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public void unsetCredentials() {
            this.credentials = null;
        }

        public boolean isSetCredentials() {
            return this.credentials != null;
        }

        public void setCredentialsIsSet(boolean value) {
            if (!value) {
                this.credentials = null;
            }
        }

        public String getProperty() {
            return this.property;
        }

        public setSystemProperty_args setProperty(String property) {
            this.property = property;
            return this;
        }

        public void unsetProperty() {
            this.property = null;
        }

        public boolean isSetProperty() {
            return this.property != null;
        }

        public void setPropertyIsSet(boolean value) {
            if (!value) {
                this.property = null;
            }
        }

        public String getValue() {
            return this.value;
        }

        public setSystemProperty_args setValue(String value) {
            this.value = value;
            return this;
        }

        public void unsetValue() {
            this.value = null;
        }

        public boolean isSetValue() {
            return this.value != null;
        }

        public void setValueIsSet(boolean value) {
            if (!value) {
                this.value = null;
            }
        }

        public void setFieldValue(_Fields field, Object value) {
            switch (field) {
                case TINFO: {
                    if (value == null) {
                        this.unsetTinfo();
                        break;
                    }
                    this.setTinfo((TInfo)value);
                    break;
                }
                case CREDENTIALS: {
                    if (value == null) {
                        this.unsetCredentials();
                        break;
                    }
                    this.setCredentials((TCredentials)value);
                    break;
                }
                case PROPERTY: {
                    if (value == null) {
                        this.unsetProperty();
                        break;
                    }
                    this.setProperty((String)value);
                    break;
                }
                case VALUE: {
                    if (value == null) {
                        this.unsetValue();
                        break;
                    }
                    this.setValue((String)value);
                }
            }
        }

        public Object getFieldValue(_Fields field) {
            switch (field) {
                case TINFO: {
                    return this.getTinfo();
                }
                case CREDENTIALS: {
                    return this.getCredentials();
                }
                case PROPERTY: {
                    return this.getProperty();
                }
                case VALUE: {
                    return this.getValue();
                }
            }
            throw new IllegalStateException();
        }

        public boolean isSet(_Fields field) {
            if (field == null) {
                throw new IllegalArgumentException();
            }
            switch (field) {
                case TINFO: {
                    return this.isSetTinfo();
                }
                case CREDENTIALS: {
                    return this.isSetCredentials();
                }
                case PROPERTY: {
                    return this.isSetProperty();
                }
                case VALUE: {
                    return this.isSetValue();
                }
            }
            throw new IllegalStateException();
        }

        public boolean equals(Object that) {
            if (that == null) {
                return false;
            }
            if (that instanceof setSystemProperty_args) {
                return this.equals((setSystemProperty_args)that);
            }
            return false;
        }

        public boolean equals(setSystemProperty_args that) {
            if (that == null) {
                return false;
            }
            boolean this_present_tinfo = this.isSetTinfo();
            boolean that_present_tinfo = that.isSetTinfo();
            if (this_present_tinfo || that_present_tinfo) {
                if (!this_present_tinfo || !that_present_tinfo) {
                    return false;
                }
                if (!this.tinfo.equals(that.tinfo)) {
                    return false;
                }
            }
            boolean this_present_credentials = this.isSetCredentials();
            boolean that_present_credentials = that.isSetCredentials();
            if (this_present_credentials || that_present_credentials) {
                if (!this_present_credentials || !that_present_credentials) {
                    return false;
                }
                if (!this.credentials.equals(that.credentials)) {
                    return false;
                }
            }
            boolean this_present_property = this.isSetProperty();
            boolean that_present_property = that.isSetProperty();
            if (this_present_property || that_present_property) {
                if (!this_present_property || !that_present_property) {
                    return false;
                }
                if (!this.property.equals(that.property)) {
                    return false;
                }
            }
            boolean this_present_value = this.isSetValue();
            boolean that_present_value = that.isSetValue();
            if (this_present_value || that_present_value) {
                if (!this_present_value || !that_present_value) {
                    return false;
                }
                if (!this.value.equals(that.value)) {
                    return false;
                }
            }
            return true;
        }

        public int hashCode() {
            return 0;
        }

        public int compareTo(setSystemProperty_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            setSystemProperty_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetTinfo()).compareTo(typedOther.isSetTinfo());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetTinfo() && (lastComparison = TBaseHelper.compareTo((Comparable)this.tinfo, (Comparable)typedOther.tinfo)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetCredentials()).compareTo(typedOther.isSetCredentials());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetCredentials() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.credentials), (Comparable)((Object)typedOther.credentials))) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetProperty()).compareTo(typedOther.isSetProperty());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetProperty() && (lastComparison = TBaseHelper.compareTo((String)this.property, (String)typedOther.property)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetValue()).compareTo(typedOther.isSetValue());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetValue() && (lastComparison = TBaseHelper.compareTo((String)this.value, (String)typedOther.value)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        public _Fields fieldForId(int fieldId) {
            return _Fields.findByThriftId(fieldId);
        }

        public void read(TProtocol iprot) throws TException {
            schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
        }

        public void write(TProtocol oprot) throws TException {
            schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("setSystemProperty_args(");
            boolean first = true;
            sb.append("tinfo:");
            if (this.tinfo == null) {
                sb.append("null");
            } else {
                sb.append(this.tinfo);
            }
            first = false;
            if (!first) {
                sb.append(", ");
            }
            sb.append("credentials:");
            if (this.credentials == null) {
                sb.append("null");
            } else {
                sb.append(this.credentials);
            }
            first = false;
            if (!first) {
                sb.append(", ");
            }
            sb.append("property:");
            if (this.property == null) {
                sb.append("null");
            } else {
                sb.append(this.property);
            }
            first = false;
            if (!first) {
                sb.append(", ");
            }
            sb.append("value:");
            if (this.value == null) {
                sb.append("null");
            } else {
                sb.append(this.value);
            }
            first = false;
            sb.append(")");
            return sb.toString();
        }

        public void validate() throws TException {
            if (this.tinfo != null) {
                this.tinfo.validate();
            }
            if (this.credentials != null) {
                this.credentials.validate();
            }
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            try {
                this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
            }
            catch (TException te) {
                throw new IOException(te);
            }
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            try {
                this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
            }
            catch (TException te) {
                throw new IOException(te);
            }
        }

        static {
            schemes.put(StandardScheme.class, new setSystemProperty_argsStandardSchemeFactory());
            schemes.put(TupleScheme.class, new setSystemProperty_argsTupleSchemeFactory());
            EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
            tmpMap.put(_Fields.TINFO, new FieldMetaData("tinfo", 3, (FieldValueMetaData)new StructMetaData(12, TInfo.class)));
            tmpMap.put(_Fields.CREDENTIALS, new FieldMetaData("credentials", 3, (FieldValueMetaData)new StructMetaData(12, TCredentials.class)));
            tmpMap.put(_Fields.PROPERTY, new FieldMetaData("property", 3, new FieldValueMetaData(11)));
            tmpMap.put(_Fields.VALUE, new FieldMetaData("value", 3, new FieldValueMetaData(11)));
            metaDataMap = Collections.unmodifiableMap(tmpMap);
            FieldMetaData.addStructMetaDataMap(setSystemProperty_args.class, metaDataMap);
        }

        private static class setSystemProperty_argsTupleScheme
        extends TupleScheme<setSystemProperty_args> {
            private setSystemProperty_argsTupleScheme() {
            }

            public void write(TProtocol prot, setSystemProperty_args struct) throws TException {
                TTupleProtocol oprot = (TTupleProtocol)prot;
                BitSet optionals = new BitSet();
                if (struct.isSetTinfo()) {
                    optionals.set(0);
                }
                if (struct.isSetCredentials()) {
                    optionals.set(1);
                }
                if (struct.isSetProperty()) {
                    optionals.set(2);
                }
                if (struct.isSetValue()) {
                    optionals.set(3);
                }
                oprot.writeBitSet(optionals, 4);
                if (struct.isSetTinfo()) {
                    struct.tinfo.write((TProtocol)oprot);
                }
                if (struct.isSetCredentials()) {
                    struct.credentials.write((TProtocol)oprot);
                }
                if (struct.isSetProperty()) {
                    oprot.writeString(struct.property);
                }
                if (struct.isSetValue()) {
                    oprot.writeString(struct.value);
                }
            }

            public void read(TProtocol prot, setSystemProperty_args struct) throws TException {
                TTupleProtocol iprot = (TTupleProtocol)prot;
                BitSet incoming = iprot.readBitSet(4);
                if (incoming.get(0)) {
                    struct.tinfo = new TInfo();
                    struct.tinfo.read((TProtocol)iprot);
                    struct.setTinfoIsSet(true);
                }
                if (incoming.get(1)) {
                    struct.credentials = new TCredentials();
                    struct.credentials.read((TProtocol)iprot);
                    struct.setCredentialsIsSet(true);
                }
                if (incoming.get(2)) {
                    struct.property = iprot.readString();
                    struct.setPropertyIsSet(true);
                }
                if (incoming.get(3)) {
                    struct.value = iprot.readString();
                    struct.setValueIsSet(true);
                }
            }
        }

        private static class setSystemProperty_argsTupleSchemeFactory
        implements SchemeFactory {
            private setSystemProperty_argsTupleSchemeFactory() {
            }

            public setSystemProperty_argsTupleScheme getScheme() {
                return new setSystemProperty_argsTupleScheme();
            }
        }

        private static class setSystemProperty_argsStandardScheme
        extends StandardScheme<setSystemProperty_args> {
            private setSystemProperty_argsStandardScheme() {
            }

            public void read(TProtocol iprot, setSystemProperty_args struct) throws TException {
                iprot.readStructBegin();
                while (true) {
                    TField schemeField = iprot.readFieldBegin();
                    if (schemeField.type == 0) break;
                    switch (schemeField.id) {
                        case 4: {
                            if (schemeField.type == 12) {
                                struct.tinfo = new TInfo();
                                struct.tinfo.read(iprot);
                                struct.setTinfoIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        case 1: {
                            if (schemeField.type == 12) {
                                struct.credentials = new TCredentials();
                                struct.credentials.read(iprot);
                                struct.setCredentialsIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        case 2: {
                            if (schemeField.type == 11) {
                                struct.property = iprot.readString();
                                struct.setPropertyIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        case 3: {
                            if (schemeField.type == 11) {
                                struct.value = iprot.readString();
                                struct.setValueIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        default: {
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        }
                    }
                    iprot.readFieldEnd();
                }
                iprot.readStructEnd();
                struct.validate();
            }

            public void write(TProtocol oprot, setSystemProperty_args struct) throws TException {
                struct.validate();
                oprot.writeStructBegin(STRUCT_DESC);
                if (struct.credentials != null) {
                    oprot.writeFieldBegin(CREDENTIALS_FIELD_DESC);
                    struct.credentials.write(oprot);
                    oprot.writeFieldEnd();
                }
                if (struct.property != null) {
                    oprot.writeFieldBegin(PROPERTY_FIELD_DESC);
                    oprot.writeString(struct.property);
                    oprot.writeFieldEnd();
                }
                if (struct.value != null) {
                    oprot.writeFieldBegin(VALUE_FIELD_DESC);
                    oprot.writeString(struct.value);
                    oprot.writeFieldEnd();
                }
                if (struct.tinfo != null) {
                    oprot.writeFieldBegin(TINFO_FIELD_DESC);
                    struct.tinfo.write(oprot);
                    oprot.writeFieldEnd();
                }
                oprot.writeFieldStop();
                oprot.writeStructEnd();
            }
        }

        private static class setSystemProperty_argsStandardSchemeFactory
        implements SchemeFactory {
            private setSystemProperty_argsStandardSchemeFactory() {
            }

            public setSystemProperty_argsStandardScheme getScheme() {
                return new setSystemProperty_argsStandardScheme();
            }
        }

        public static enum _Fields implements TFieldIdEnum
        {
            TINFO(4, "tinfo"),
            CREDENTIALS(1, "credentials"),
            PROPERTY(2, "property"),
            VALUE(3, "value");

            private static final Map<String, _Fields> byName;
            private final short _thriftId;
            private final String _fieldName;

            public static _Fields findByThriftId(int fieldId) {
                switch (fieldId) {
                    case 4: {
                        return TINFO;
                    }
                    case 1: {
                        return CREDENTIALS;
                    }
                    case 2: {
                        return PROPERTY;
                    }
                    case 3: {
                        return VALUE;
                    }
                }
                return null;
            }

            public static _Fields findByThriftIdOrThrow(int fieldId) {
                _Fields fields = _Fields.findByThriftId(fieldId);
                if (fields == null) {
                    throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
                }
                return fields;
            }

            public static _Fields findByName(String name) {
                return byName.get(name);
            }

            private _Fields(short thriftId, String fieldName) {
                this._thriftId = thriftId;
                this._fieldName = fieldName;
            }

            public short getThriftFieldId() {
                return this._thriftId;
            }

            public String getFieldName() {
                return this._fieldName;
            }

            static {
                byName = new HashMap<String, _Fields>();
                for (_Fields field : EnumSet.allOf(_Fields.class)) {
                    byName.put(field.getFieldName(), field);
                }
            }
        }
    }

    public static class shutdownTabletServer_result
    implements TBase<shutdownTabletServer_result, _Fields>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("shutdownTabletServer_result");
        private static final TField SEC_FIELD_DESC = new TField("sec", 12, 1);
        private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
        public ThriftSecurityException sec;
        public static final Map<_Fields, FieldMetaData> metaDataMap;

        public shutdownTabletServer_result() {
        }

        public shutdownTabletServer_result(ThriftSecurityException sec) {
            this();
            this.sec = sec;
        }

        public shutdownTabletServer_result(shutdownTabletServer_result other) {
            if (other.isSetSec()) {
                this.sec = new ThriftSecurityException(other.sec);
            }
        }

        public shutdownTabletServer_result deepCopy() {
            return new shutdownTabletServer_result(this);
        }

        public void clear() {
            this.sec = null;
        }

        public ThriftSecurityException getSec() {
            return this.sec;
        }

        public shutdownTabletServer_result setSec(ThriftSecurityException sec) {
            this.sec = sec;
            return this;
        }

        public void unsetSec() {
            this.sec = null;
        }

        public boolean isSetSec() {
            return this.sec != null;
        }

        public void setSecIsSet(boolean value) {
            if (!value) {
                this.sec = null;
            }
        }

        public void setFieldValue(_Fields field, Object value) {
            switch (field) {
                case SEC: {
                    if (value == null) {
                        this.unsetSec();
                        break;
                    }
                    this.setSec((ThriftSecurityException)value);
                }
            }
        }

        public Object getFieldValue(_Fields field) {
            switch (field) {
                case SEC: {
                    return this.getSec();
                }
            }
            throw new IllegalStateException();
        }

        public boolean isSet(_Fields field) {
            if (field == null) {
                throw new IllegalArgumentException();
            }
            switch (field) {
                case SEC: {
                    return this.isSetSec();
                }
            }
            throw new IllegalStateException();
        }

        public boolean equals(Object that) {
            if (that == null) {
                return false;
            }
            if (that instanceof shutdownTabletServer_result) {
                return this.equals((shutdownTabletServer_result)that);
            }
            return false;
        }

        public boolean equals(shutdownTabletServer_result that) {
            if (that == null) {
                return false;
            }
            boolean this_present_sec = this.isSetSec();
            boolean that_present_sec = that.isSetSec();
            if (this_present_sec || that_present_sec) {
                if (!this_present_sec || !that_present_sec) {
                    return false;
                }
                if (!this.sec.equals(that.sec)) {
                    return false;
                }
            }
            return true;
        }

        public int hashCode() {
            return 0;
        }

        public int compareTo(shutdownTabletServer_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            shutdownTabletServer_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSec()).compareTo(typedOther.isSetSec());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSec() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.sec), (Comparable)((Object)typedOther.sec))) != 0) {
                return lastComparison;
            }
            return 0;
        }

        public _Fields fieldForId(int fieldId) {
            return _Fields.findByThriftId(fieldId);
        }

        public void read(TProtocol iprot) throws TException {
            schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
        }

        public void write(TProtocol oprot) throws TException {
            schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("shutdownTabletServer_result(");
            boolean first = true;
            sb.append("sec:");
            if (this.sec == null) {
                sb.append("null");
            } else {
                sb.append(this.sec);
            }
            first = false;
            sb.append(")");
            return sb.toString();
        }

        public void validate() throws TException {
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            try {
                this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
            }
            catch (TException te) {
                throw new IOException(te);
            }
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            try {
                this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
            }
            catch (TException te) {
                throw new IOException(te);
            }
        }

        static {
            schemes.put(StandardScheme.class, new shutdownTabletServer_resultStandardSchemeFactory());
            schemes.put(TupleScheme.class, new shutdownTabletServer_resultTupleSchemeFactory());
            EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
            tmpMap.put(_Fields.SEC, new FieldMetaData("sec", 3, new FieldValueMetaData(12)));
            metaDataMap = Collections.unmodifiableMap(tmpMap);
            FieldMetaData.addStructMetaDataMap(shutdownTabletServer_result.class, metaDataMap);
        }

        private static class shutdownTabletServer_resultTupleScheme
        extends TupleScheme<shutdownTabletServer_result> {
            private shutdownTabletServer_resultTupleScheme() {
            }

            public void write(TProtocol prot, shutdownTabletServer_result struct) throws TException {
                TTupleProtocol oprot = (TTupleProtocol)prot;
                BitSet optionals = new BitSet();
                if (struct.isSetSec()) {
                    optionals.set(0);
                }
                oprot.writeBitSet(optionals, 1);
                if (struct.isSetSec()) {
                    struct.sec.write((TProtocol)oprot);
                }
            }

            public void read(TProtocol prot, shutdownTabletServer_result struct) throws TException {
                TTupleProtocol iprot = (TTupleProtocol)prot;
                BitSet incoming = iprot.readBitSet(1);
                if (incoming.get(0)) {
                    struct.sec = new ThriftSecurityException();
                    struct.sec.read((TProtocol)iprot);
                    struct.setSecIsSet(true);
                }
            }
        }

        private static class shutdownTabletServer_resultTupleSchemeFactory
        implements SchemeFactory {
            private shutdownTabletServer_resultTupleSchemeFactory() {
            }

            public shutdownTabletServer_resultTupleScheme getScheme() {
                return new shutdownTabletServer_resultTupleScheme();
            }
        }

        private static class shutdownTabletServer_resultStandardScheme
        extends StandardScheme<shutdownTabletServer_result> {
            private shutdownTabletServer_resultStandardScheme() {
            }

            public void read(TProtocol iprot, shutdownTabletServer_result struct) throws TException {
                iprot.readStructBegin();
                while (true) {
                    TField schemeField = iprot.readFieldBegin();
                    if (schemeField.type == 0) break;
                    switch (schemeField.id) {
                        case 1: {
                            if (schemeField.type == 12) {
                                struct.sec = new ThriftSecurityException();
                                struct.sec.read(iprot);
                                struct.setSecIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        default: {
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        }
                    }
                    iprot.readFieldEnd();
                }
                iprot.readStructEnd();
                struct.validate();
            }

            public void write(TProtocol oprot, shutdownTabletServer_result struct) throws TException {
                struct.validate();
                oprot.writeStructBegin(STRUCT_DESC);
                if (struct.sec != null) {
                    oprot.writeFieldBegin(SEC_FIELD_DESC);
                    struct.sec.write(oprot);
                    oprot.writeFieldEnd();
                }
                oprot.writeFieldStop();
                oprot.writeStructEnd();
            }
        }

        private static class shutdownTabletServer_resultStandardSchemeFactory
        implements SchemeFactory {
            private shutdownTabletServer_resultStandardSchemeFactory() {
            }

            public shutdownTabletServer_resultStandardScheme getScheme() {
                return new shutdownTabletServer_resultStandardScheme();
            }
        }

        public static enum _Fields implements TFieldIdEnum
        {
            SEC(1, "sec");

            private static final Map<String, _Fields> byName;
            private final short _thriftId;
            private final String _fieldName;

            public static _Fields findByThriftId(int fieldId) {
                switch (fieldId) {
                    case 1: {
                        return SEC;
                    }
                }
                return null;
            }

            public static _Fields findByThriftIdOrThrow(int fieldId) {
                _Fields fields = _Fields.findByThriftId(fieldId);
                if (fields == null) {
                    throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
                }
                return fields;
            }

            public static _Fields findByName(String name) {
                return byName.get(name);
            }

            private _Fields(short thriftId, String fieldName) {
                this._thriftId = thriftId;
                this._fieldName = fieldName;
            }

            public short getThriftFieldId() {
                return this._thriftId;
            }

            public String getFieldName() {
                return this._fieldName;
            }

            static {
                byName = new HashMap<String, _Fields>();
                for (_Fields field : EnumSet.allOf(_Fields.class)) {
                    byName.put(field.getFieldName(), field);
                }
            }
        }
    }

    public static class shutdownTabletServer_args
    implements TBase<shutdownTabletServer_args, _Fields>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("shutdownTabletServer_args");
        private static final TField TINFO_FIELD_DESC = new TField("tinfo", 12, 3);
        private static final TField CREDENTIALS_FIELD_DESC = new TField("credentials", 12, 1);
        private static final TField TABLET_SERVER_FIELD_DESC = new TField("tabletServer", 11, 2);
        private static final TField FORCE_FIELD_DESC = new TField("force", 2, 4);
        private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
        public TInfo tinfo;
        public TCredentials credentials;
        public String tabletServer;
        public boolean force;
        private static final int __FORCE_ISSET_ID = 0;
        private byte __isset_bitfield = 0;
        public static final Map<_Fields, FieldMetaData> metaDataMap;

        public shutdownTabletServer_args() {
        }

        public shutdownTabletServer_args(TInfo tinfo, TCredentials credentials, String tabletServer, boolean force) {
            this();
            this.tinfo = tinfo;
            this.credentials = credentials;
            this.tabletServer = tabletServer;
            this.force = force;
            this.setForceIsSet(true);
        }

        public shutdownTabletServer_args(shutdownTabletServer_args other) {
            this.__isset_bitfield = other.__isset_bitfield;
            if (other.isSetTinfo()) {
                this.tinfo = new TInfo(other.tinfo);
            }
            if (other.isSetCredentials()) {
                this.credentials = new TCredentials(other.credentials);
            }
            if (other.isSetTabletServer()) {
                this.tabletServer = other.tabletServer;
            }
            this.force = other.force;
        }

        public shutdownTabletServer_args deepCopy() {
            return new shutdownTabletServer_args(this);
        }

        public void clear() {
            this.tinfo = null;
            this.credentials = null;
            this.tabletServer = null;
            this.setForceIsSet(false);
            this.force = false;
        }

        public TInfo getTinfo() {
            return this.tinfo;
        }

        public shutdownTabletServer_args setTinfo(TInfo tinfo) {
            this.tinfo = tinfo;
            return this;
        }

        public void unsetTinfo() {
            this.tinfo = null;
        }

        public boolean isSetTinfo() {
            return this.tinfo != null;
        }

        public void setTinfoIsSet(boolean value) {
            if (!value) {
                this.tinfo = null;
            }
        }

        public TCredentials getCredentials() {
            return this.credentials;
        }

        public shutdownTabletServer_args setCredentials(TCredentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public void unsetCredentials() {
            this.credentials = null;
        }

        public boolean isSetCredentials() {
            return this.credentials != null;
        }

        public void setCredentialsIsSet(boolean value) {
            if (!value) {
                this.credentials = null;
            }
        }

        public String getTabletServer() {
            return this.tabletServer;
        }

        public shutdownTabletServer_args setTabletServer(String tabletServer) {
            this.tabletServer = tabletServer;
            return this;
        }

        public void unsetTabletServer() {
            this.tabletServer = null;
        }

        public boolean isSetTabletServer() {
            return this.tabletServer != null;
        }

        public void setTabletServerIsSet(boolean value) {
            if (!value) {
                this.tabletServer = null;
            }
        }

        public boolean isForce() {
            return this.force;
        }

        public shutdownTabletServer_args setForce(boolean force) {
            this.force = force;
            this.setForceIsSet(true);
            return this;
        }

        public void unsetForce() {
            this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
        }

        public boolean isSetForce() {
            return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
        }

        public void setForceIsSet(boolean value) {
            this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
        }

        public void setFieldValue(_Fields field, Object value) {
            switch (field) {
                case TINFO: {
                    if (value == null) {
                        this.unsetTinfo();
                        break;
                    }
                    this.setTinfo((TInfo)value);
                    break;
                }
                case CREDENTIALS: {
                    if (value == null) {
                        this.unsetCredentials();
                        break;
                    }
                    this.setCredentials((TCredentials)value);
                    break;
                }
                case TABLET_SERVER: {
                    if (value == null) {
                        this.unsetTabletServer();
                        break;
                    }
                    this.setTabletServer((String)value);
                    break;
                }
                case FORCE: {
                    if (value == null) {
                        this.unsetForce();
                        break;
                    }
                    this.setForce((Boolean)value);
                }
            }
        }

        public Object getFieldValue(_Fields field) {
            switch (field) {
                case TINFO: {
                    return this.getTinfo();
                }
                case CREDENTIALS: {
                    return this.getCredentials();
                }
                case TABLET_SERVER: {
                    return this.getTabletServer();
                }
                case FORCE: {
                    return this.isForce();
                }
            }
            throw new IllegalStateException();
        }

        public boolean isSet(_Fields field) {
            if (field == null) {
                throw new IllegalArgumentException();
            }
            switch (field) {
                case TINFO: {
                    return this.isSetTinfo();
                }
                case CREDENTIALS: {
                    return this.isSetCredentials();
                }
                case TABLET_SERVER: {
                    return this.isSetTabletServer();
                }
                case FORCE: {
                    return this.isSetForce();
                }
            }
            throw new IllegalStateException();
        }

        public boolean equals(Object that) {
            if (that == null) {
                return false;
            }
            if (that instanceof shutdownTabletServer_args) {
                return this.equals((shutdownTabletServer_args)that);
            }
            return false;
        }

        public boolean equals(shutdownTabletServer_args that) {
            if (that == null) {
                return false;
            }
            boolean this_present_tinfo = this.isSetTinfo();
            boolean that_present_tinfo = that.isSetTinfo();
            if (this_present_tinfo || that_present_tinfo) {
                if (!this_present_tinfo || !that_present_tinfo) {
                    return false;
                }
                if (!this.tinfo.equals(that.tinfo)) {
                    return false;
                }
            }
            boolean this_present_credentials = this.isSetCredentials();
            boolean that_present_credentials = that.isSetCredentials();
            if (this_present_credentials || that_present_credentials) {
                if (!this_present_credentials || !that_present_credentials) {
                    return false;
                }
                if (!this.credentials.equals(that.credentials)) {
                    return false;
                }
            }
            boolean this_present_tabletServer = this.isSetTabletServer();
            boolean that_present_tabletServer = that.isSetTabletServer();
            if (this_present_tabletServer || that_present_tabletServer) {
                if (!this_present_tabletServer || !that_present_tabletServer) {
                    return false;
                }
                if (!this.tabletServer.equals(that.tabletServer)) {
                    return false;
                }
            }
            boolean this_present_force = true;
            boolean that_present_force = true;
            if (this_present_force || that_present_force) {
                if (!this_present_force || !that_present_force) {
                    return false;
                }
                if (this.force != that.force) {
                    return false;
                }
            }
            return true;
        }

        public int hashCode() {
            return 0;
        }

        public int compareTo(shutdownTabletServer_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            shutdownTabletServer_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetTinfo()).compareTo(typedOther.isSetTinfo());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetTinfo() && (lastComparison = TBaseHelper.compareTo((Comparable)this.tinfo, (Comparable)typedOther.tinfo)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetCredentials()).compareTo(typedOther.isSetCredentials());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetCredentials() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.credentials), (Comparable)((Object)typedOther.credentials))) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetTabletServer()).compareTo(typedOther.isSetTabletServer());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetTabletServer() && (lastComparison = TBaseHelper.compareTo((String)this.tabletServer, (String)typedOther.tabletServer)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetForce()).compareTo(typedOther.isSetForce());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetForce() && (lastComparison = TBaseHelper.compareTo((boolean)this.force, (boolean)typedOther.force)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        public _Fields fieldForId(int fieldId) {
            return _Fields.findByThriftId(fieldId);
        }

        public void read(TProtocol iprot) throws TException {
            schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
        }

        public void write(TProtocol oprot) throws TException {
            schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("shutdownTabletServer_args(");
            boolean first = true;
            sb.append("tinfo:");
            if (this.tinfo == null) {
                sb.append("null");
            } else {
                sb.append(this.tinfo);
            }
            first = false;
            if (!first) {
                sb.append(", ");
            }
            sb.append("credentials:");
            if (this.credentials == null) {
                sb.append("null");
            } else {
                sb.append(this.credentials);
            }
            first = false;
            if (!first) {
                sb.append(", ");
            }
            sb.append("tabletServer:");
            if (this.tabletServer == null) {
                sb.append("null");
            } else {
                sb.append(this.tabletServer);
            }
            first = false;
            if (!first) {
                sb.append(", ");
            }
            sb.append("force:");
            sb.append(this.force);
            first = false;
            sb.append(")");
            return sb.toString();
        }

        public void validate() throws TException {
            if (this.tinfo != null) {
                this.tinfo.validate();
            }
            if (this.credentials != null) {
                this.credentials.validate();
            }
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            try {
                this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
            }
            catch (TException te) {
                throw new IOException(te);
            }
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            try {
                this.__isset_bitfield = 0;
                this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
            }
            catch (TException te) {
                throw new IOException(te);
            }
        }

        static {
            schemes.put(StandardScheme.class, new shutdownTabletServer_argsStandardSchemeFactory());
            schemes.put(TupleScheme.class, new shutdownTabletServer_argsTupleSchemeFactory());
            EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
            tmpMap.put(_Fields.TINFO, new FieldMetaData("tinfo", 3, (FieldValueMetaData)new StructMetaData(12, TInfo.class)));
            tmpMap.put(_Fields.CREDENTIALS, new FieldMetaData("credentials", 3, (FieldValueMetaData)new StructMetaData(12, TCredentials.class)));
            tmpMap.put(_Fields.TABLET_SERVER, new FieldMetaData("tabletServer", 3, new FieldValueMetaData(11)));
            tmpMap.put(_Fields.FORCE, new FieldMetaData("force", 3, new FieldValueMetaData(2)));
            metaDataMap = Collections.unmodifiableMap(tmpMap);
            FieldMetaData.addStructMetaDataMap(shutdownTabletServer_args.class, metaDataMap);
        }

        private static class shutdownTabletServer_argsTupleScheme
        extends TupleScheme<shutdownTabletServer_args> {
            private shutdownTabletServer_argsTupleScheme() {
            }

            public void write(TProtocol prot, shutdownTabletServer_args struct) throws TException {
                TTupleProtocol oprot = (TTupleProtocol)prot;
                BitSet optionals = new BitSet();
                if (struct.isSetTinfo()) {
                    optionals.set(0);
                }
                if (struct.isSetCredentials()) {
                    optionals.set(1);
                }
                if (struct.isSetTabletServer()) {
                    optionals.set(2);
                }
                if (struct.isSetForce()) {
                    optionals.set(3);
                }
                oprot.writeBitSet(optionals, 4);
                if (struct.isSetTinfo()) {
                    struct.tinfo.write((TProtocol)oprot);
                }
                if (struct.isSetCredentials()) {
                    struct.credentials.write((TProtocol)oprot);
                }
                if (struct.isSetTabletServer()) {
                    oprot.writeString(struct.tabletServer);
                }
                if (struct.isSetForce()) {
                    oprot.writeBool(struct.force);
                }
            }

            public void read(TProtocol prot, shutdownTabletServer_args struct) throws TException {
                TTupleProtocol iprot = (TTupleProtocol)prot;
                BitSet incoming = iprot.readBitSet(4);
                if (incoming.get(0)) {
                    struct.tinfo = new TInfo();
                    struct.tinfo.read((TProtocol)iprot);
                    struct.setTinfoIsSet(true);
                }
                if (incoming.get(1)) {
                    struct.credentials = new TCredentials();
                    struct.credentials.read((TProtocol)iprot);
                    struct.setCredentialsIsSet(true);
                }
                if (incoming.get(2)) {
                    struct.tabletServer = iprot.readString();
                    struct.setTabletServerIsSet(true);
                }
                if (incoming.get(3)) {
                    struct.force = iprot.readBool();
                    struct.setForceIsSet(true);
                }
            }
        }

        private static class shutdownTabletServer_argsTupleSchemeFactory
        implements SchemeFactory {
            private shutdownTabletServer_argsTupleSchemeFactory() {
            }

            public shutdownTabletServer_argsTupleScheme getScheme() {
                return new shutdownTabletServer_argsTupleScheme();
            }
        }

        private static class shutdownTabletServer_argsStandardScheme
        extends StandardScheme<shutdownTabletServer_args> {
            private shutdownTabletServer_argsStandardScheme() {
            }

            public void read(TProtocol iprot, shutdownTabletServer_args struct) throws TException {
                iprot.readStructBegin();
                while (true) {
                    TField schemeField = iprot.readFieldBegin();
                    if (schemeField.type == 0) break;
                    switch (schemeField.id) {
                        case 3: {
                            if (schemeField.type == 12) {
                                struct.tinfo = new TInfo();
                                struct.tinfo.read(iprot);
                                struct.setTinfoIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        case 1: {
                            if (schemeField.type == 12) {
                                struct.credentials = new TCredentials();
                                struct.credentials.read(iprot);
                                struct.setCredentialsIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        case 2: {
                            if (schemeField.type == 11) {
                                struct.tabletServer = iprot.readString();
                                struct.setTabletServerIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        case 4: {
                            if (schemeField.type == 2) {
                                struct.force = iprot.readBool();
                                struct.setForceIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        default: {
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        }
                    }
                    iprot.readFieldEnd();
                }
                iprot.readStructEnd();
                struct.validate();
            }

            public void write(TProtocol oprot, shutdownTabletServer_args struct) throws TException {
                struct.validate();
                oprot.writeStructBegin(STRUCT_DESC);
                if (struct.credentials != null) {
                    oprot.writeFieldBegin(CREDENTIALS_FIELD_DESC);
                    struct.credentials.write(oprot);
                    oprot.writeFieldEnd();
                }
                if (struct.tabletServer != null) {
                    oprot.writeFieldBegin(TABLET_SERVER_FIELD_DESC);
                    oprot.writeString(struct.tabletServer);
                    oprot.writeFieldEnd();
                }
                if (struct.tinfo != null) {
                    oprot.writeFieldBegin(TINFO_FIELD_DESC);
                    struct.tinfo.write(oprot);
                    oprot.writeFieldEnd();
                }
                oprot.writeFieldBegin(FORCE_FIELD_DESC);
                oprot.writeBool(struct.force);
                oprot.writeFieldEnd();
                oprot.writeFieldStop();
                oprot.writeStructEnd();
            }
        }

        private static class shutdownTabletServer_argsStandardSchemeFactory
        implements SchemeFactory {
            private shutdownTabletServer_argsStandardSchemeFactory() {
            }

            public shutdownTabletServer_argsStandardScheme getScheme() {
                return new shutdownTabletServer_argsStandardScheme();
            }
        }

        public static enum _Fields implements TFieldIdEnum
        {
            TINFO(3, "tinfo"),
            CREDENTIALS(1, "credentials"),
            TABLET_SERVER(2, "tabletServer"),
            FORCE(4, "force");

            private static final Map<String, _Fields> byName;
            private final short _thriftId;
            private final String _fieldName;

            public static _Fields findByThriftId(int fieldId) {
                switch (fieldId) {
                    case 3: {
                        return TINFO;
                    }
                    case 1: {
                        return CREDENTIALS;
                    }
                    case 2: {
                        return TABLET_SERVER;
                    }
                    case 4: {
                        return FORCE;
                    }
                }
                return null;
            }

            public static _Fields findByThriftIdOrThrow(int fieldId) {
                _Fields fields = _Fields.findByThriftId(fieldId);
                if (fields == null) {
                    throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
                }
                return fields;
            }

            public static _Fields findByName(String name) {
                return byName.get(name);
            }

            private _Fields(short thriftId, String fieldName) {
                this._thriftId = thriftId;
                this._fieldName = fieldName;
            }

            public short getThriftFieldId() {
                return this._thriftId;
            }

            public String getFieldName() {
                return this._fieldName;
            }

            static {
                byName = new HashMap<String, _Fields>();
                for (_Fields field : EnumSet.allOf(_Fields.class)) {
                    byName.put(field.getFieldName(), field);
                }
            }
        }
    }

    public static class shutdown_result
    implements TBase<shutdown_result, _Fields>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("shutdown_result");
        private static final TField SEC_FIELD_DESC = new TField("sec", 12, 1);
        private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
        public ThriftSecurityException sec;
        public static final Map<_Fields, FieldMetaData> metaDataMap;

        public shutdown_result() {
        }

        public shutdown_result(ThriftSecurityException sec) {
            this();
            this.sec = sec;
        }

        public shutdown_result(shutdown_result other) {
            if (other.isSetSec()) {
                this.sec = new ThriftSecurityException(other.sec);
            }
        }

        public shutdown_result deepCopy() {
            return new shutdown_result(this);
        }

        public void clear() {
            this.sec = null;
        }

        public ThriftSecurityException getSec() {
            return this.sec;
        }

        public shutdown_result setSec(ThriftSecurityException sec) {
            this.sec = sec;
            return this;
        }

        public void unsetSec() {
            this.sec = null;
        }

        public boolean isSetSec() {
            return this.sec != null;
        }

        public void setSecIsSet(boolean value) {
            if (!value) {
                this.sec = null;
            }
        }

        public void setFieldValue(_Fields field, Object value) {
            switch (field) {
                case SEC: {
                    if (value == null) {
                        this.unsetSec();
                        break;
                    }
                    this.setSec((ThriftSecurityException)value);
                }
            }
        }

        public Object getFieldValue(_Fields field) {
            switch (field) {
                case SEC: {
                    return this.getSec();
                }
            }
            throw new IllegalStateException();
        }

        public boolean isSet(_Fields field) {
            if (field == null) {
                throw new IllegalArgumentException();
            }
            switch (field) {
                case SEC: {
                    return this.isSetSec();
                }
            }
            throw new IllegalStateException();
        }

        public boolean equals(Object that) {
            if (that == null) {
                return false;
            }
            if (that instanceof shutdown_result) {
                return this.equals((shutdown_result)that);
            }
            return false;
        }

        public boolean equals(shutdown_result that) {
            if (that == null) {
                return false;
            }
            boolean this_present_sec = this.isSetSec();
            boolean that_present_sec = that.isSetSec();
            if (this_present_sec || that_present_sec) {
                if (!this_present_sec || !that_present_sec) {
                    return false;
                }
                if (!this.sec.equals(that.sec)) {
                    return false;
                }
            }
            return true;
        }

        public int hashCode() {
            return 0;
        }

        public int compareTo(shutdown_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            shutdown_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSec()).compareTo(typedOther.isSetSec());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSec() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.sec), (Comparable)((Object)typedOther.sec))) != 0) {
                return lastComparison;
            }
            return 0;
        }

        public _Fields fieldForId(int fieldId) {
            return _Fields.findByThriftId(fieldId);
        }

        public void read(TProtocol iprot) throws TException {
            schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
        }

        public void write(TProtocol oprot) throws TException {
            schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("shutdown_result(");
            boolean first = true;
            sb.append("sec:");
            if (this.sec == null) {
                sb.append("null");
            } else {
                sb.append(this.sec);
            }
            first = false;
            sb.append(")");
            return sb.toString();
        }

        public void validate() throws TException {
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            try {
                this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
            }
            catch (TException te) {
                throw new IOException(te);
            }
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            try {
                this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
            }
            catch (TException te) {
                throw new IOException(te);
            }
        }

        static {
            schemes.put(StandardScheme.class, new shutdown_resultStandardSchemeFactory());
            schemes.put(TupleScheme.class, new shutdown_resultTupleSchemeFactory());
            EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
            tmpMap.put(_Fields.SEC, new FieldMetaData("sec", 3, new FieldValueMetaData(12)));
            metaDataMap = Collections.unmodifiableMap(tmpMap);
            FieldMetaData.addStructMetaDataMap(shutdown_result.class, metaDataMap);
        }

        private static class shutdown_resultTupleScheme
        extends TupleScheme<shutdown_result> {
            private shutdown_resultTupleScheme() {
            }

            public void write(TProtocol prot, shutdown_result struct) throws TException {
                TTupleProtocol oprot = (TTupleProtocol)prot;
                BitSet optionals = new BitSet();
                if (struct.isSetSec()) {
                    optionals.set(0);
                }
                oprot.writeBitSet(optionals, 1);
                if (struct.isSetSec()) {
                    struct.sec.write((TProtocol)oprot);
                }
            }

            public void read(TProtocol prot, shutdown_result struct) throws TException {
                TTupleProtocol iprot = (TTupleProtocol)prot;
                BitSet incoming = iprot.readBitSet(1);
                if (incoming.get(0)) {
                    struct.sec = new ThriftSecurityException();
                    struct.sec.read((TProtocol)iprot);
                    struct.setSecIsSet(true);
                }
            }
        }

        private static class shutdown_resultTupleSchemeFactory
        implements SchemeFactory {
            private shutdown_resultTupleSchemeFactory() {
            }

            public shutdown_resultTupleScheme getScheme() {
                return new shutdown_resultTupleScheme();
            }
        }

        private static class shutdown_resultStandardScheme
        extends StandardScheme<shutdown_result> {
            private shutdown_resultStandardScheme() {
            }

            public void read(TProtocol iprot, shutdown_result struct) throws TException {
                iprot.readStructBegin();
                while (true) {
                    TField schemeField = iprot.readFieldBegin();
                    if (schemeField.type == 0) break;
                    switch (schemeField.id) {
                        case 1: {
                            if (schemeField.type == 12) {
                                struct.sec = new ThriftSecurityException();
                                struct.sec.read(iprot);
                                struct.setSecIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        default: {
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        }
                    }
                    iprot.readFieldEnd();
                }
                iprot.readStructEnd();
                struct.validate();
            }

            public void write(TProtocol oprot, shutdown_result struct) throws TException {
                struct.validate();
                oprot.writeStructBegin(STRUCT_DESC);
                if (struct.sec != null) {
                    oprot.writeFieldBegin(SEC_FIELD_DESC);
                    struct.sec.write(oprot);
                    oprot.writeFieldEnd();
                }
                oprot.writeFieldStop();
                oprot.writeStructEnd();
            }
        }

        private static class shutdown_resultStandardSchemeFactory
        implements SchemeFactory {
            private shutdown_resultStandardSchemeFactory() {
            }

            public shutdown_resultStandardScheme getScheme() {
                return new shutdown_resultStandardScheme();
            }
        }

        public static enum _Fields implements TFieldIdEnum
        {
            SEC(1, "sec");

            private static final Map<String, _Fields> byName;
            private final short _thriftId;
            private final String _fieldName;

            public static _Fields findByThriftId(int fieldId) {
                switch (fieldId) {
                    case 1: {
                        return SEC;
                    }
                }
                return null;
            }

            public static _Fields findByThriftIdOrThrow(int fieldId) {
                _Fields fields = _Fields.findByThriftId(fieldId);
                if (fields == null) {
                    throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
                }
                return fields;
            }

            public static _Fields findByName(String name) {
                return byName.get(name);
            }

            private _Fields(short thriftId, String fieldName) {
                this._thriftId = thriftId;
                this._fieldName = fieldName;
            }

            public short getThriftFieldId() {
                return this._thriftId;
            }

            public String getFieldName() {
                return this._fieldName;
            }

            static {
                byName = new HashMap<String, _Fields>();
                for (_Fields field : EnumSet.allOf(_Fields.class)) {
                    byName.put(field.getFieldName(), field);
                }
            }
        }
    }

    public static class shutdown_args
    implements TBase<shutdown_args, _Fields>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("shutdown_args");
        private static final TField TINFO_FIELD_DESC = new TField("tinfo", 12, 3);
        private static final TField CREDENTIALS_FIELD_DESC = new TField("credentials", 12, 1);
        private static final TField STOP_TABLET_SERVERS_FIELD_DESC = new TField("stopTabletServers", 2, 2);
        private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
        public TInfo tinfo;
        public TCredentials credentials;
        public boolean stopTabletServers;
        private static final int __STOPTABLETSERVERS_ISSET_ID = 0;
        private byte __isset_bitfield = 0;
        public static final Map<_Fields, FieldMetaData> metaDataMap;

        public shutdown_args() {
        }

        public shutdown_args(TInfo tinfo, TCredentials credentials, boolean stopTabletServers) {
            this();
            this.tinfo = tinfo;
            this.credentials = credentials;
            this.stopTabletServers = stopTabletServers;
            this.setStopTabletServersIsSet(true);
        }

        public shutdown_args(shutdown_args other) {
            this.__isset_bitfield = other.__isset_bitfield;
            if (other.isSetTinfo()) {
                this.tinfo = new TInfo(other.tinfo);
            }
            if (other.isSetCredentials()) {
                this.credentials = new TCredentials(other.credentials);
            }
            this.stopTabletServers = other.stopTabletServers;
        }

        public shutdown_args deepCopy() {
            return new shutdown_args(this);
        }

        public void clear() {
            this.tinfo = null;
            this.credentials = null;
            this.setStopTabletServersIsSet(false);
            this.stopTabletServers = false;
        }

        public TInfo getTinfo() {
            return this.tinfo;
        }

        public shutdown_args setTinfo(TInfo tinfo) {
            this.tinfo = tinfo;
            return this;
        }

        public void unsetTinfo() {
            this.tinfo = null;
        }

        public boolean isSetTinfo() {
            return this.tinfo != null;
        }

        public void setTinfoIsSet(boolean value) {
            if (!value) {
                this.tinfo = null;
            }
        }

        public TCredentials getCredentials() {
            return this.credentials;
        }

        public shutdown_args setCredentials(TCredentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public void unsetCredentials() {
            this.credentials = null;
        }

        public boolean isSetCredentials() {
            return this.credentials != null;
        }

        public void setCredentialsIsSet(boolean value) {
            if (!value) {
                this.credentials = null;
            }
        }

        public boolean isStopTabletServers() {
            return this.stopTabletServers;
        }

        public shutdown_args setStopTabletServers(boolean stopTabletServers) {
            this.stopTabletServers = stopTabletServers;
            this.setStopTabletServersIsSet(true);
            return this;
        }

        public void unsetStopTabletServers() {
            this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
        }

        public boolean isSetStopTabletServers() {
            return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
        }

        public void setStopTabletServersIsSet(boolean value) {
            this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
        }

        public void setFieldValue(_Fields field, Object value) {
            switch (field) {
                case TINFO: {
                    if (value == null) {
                        this.unsetTinfo();
                        break;
                    }
                    this.setTinfo((TInfo)value);
                    break;
                }
                case CREDENTIALS: {
                    if (value == null) {
                        this.unsetCredentials();
                        break;
                    }
                    this.setCredentials((TCredentials)value);
                    break;
                }
                case STOP_TABLET_SERVERS: {
                    if (value == null) {
                        this.unsetStopTabletServers();
                        break;
                    }
                    this.setStopTabletServers((Boolean)value);
                }
            }
        }

        public Object getFieldValue(_Fields field) {
            switch (field) {
                case TINFO: {
                    return this.getTinfo();
                }
                case CREDENTIALS: {
                    return this.getCredentials();
                }
                case STOP_TABLET_SERVERS: {
                    return this.isStopTabletServers();
                }
            }
            throw new IllegalStateException();
        }

        public boolean isSet(_Fields field) {
            if (field == null) {
                throw new IllegalArgumentException();
            }
            switch (field) {
                case TINFO: {
                    return this.isSetTinfo();
                }
                case CREDENTIALS: {
                    return this.isSetCredentials();
                }
                case STOP_TABLET_SERVERS: {
                    return this.isSetStopTabletServers();
                }
            }
            throw new IllegalStateException();
        }

        public boolean equals(Object that) {
            if (that == null) {
                return false;
            }
            if (that instanceof shutdown_args) {
                return this.equals((shutdown_args)that);
            }
            return false;
        }

        public boolean equals(shutdown_args that) {
            if (that == null) {
                return false;
            }
            boolean this_present_tinfo = this.isSetTinfo();
            boolean that_present_tinfo = that.isSetTinfo();
            if (this_present_tinfo || that_present_tinfo) {
                if (!this_present_tinfo || !that_present_tinfo) {
                    return false;
                }
                if (!this.tinfo.equals(that.tinfo)) {
                    return false;
                }
            }
            boolean this_present_credentials = this.isSetCredentials();
            boolean that_present_credentials = that.isSetCredentials();
            if (this_present_credentials || that_present_credentials) {
                if (!this_present_credentials || !that_present_credentials) {
                    return false;
                }
                if (!this.credentials.equals(that.credentials)) {
                    return false;
                }
            }
            boolean this_present_stopTabletServers = true;
            boolean that_present_stopTabletServers = true;
            if (this_present_stopTabletServers || that_present_stopTabletServers) {
                if (!this_present_stopTabletServers || !that_present_stopTabletServers) {
                    return false;
                }
                if (this.stopTabletServers != that.stopTabletServers) {
                    return false;
                }
            }
            return true;
        }

        public int hashCode() {
            return 0;
        }

        public int compareTo(shutdown_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            shutdown_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetTinfo()).compareTo(typedOther.isSetTinfo());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetTinfo() && (lastComparison = TBaseHelper.compareTo((Comparable)this.tinfo, (Comparable)typedOther.tinfo)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetCredentials()).compareTo(typedOther.isSetCredentials());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetCredentials() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.credentials), (Comparable)((Object)typedOther.credentials))) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetStopTabletServers()).compareTo(typedOther.isSetStopTabletServers());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetStopTabletServers() && (lastComparison = TBaseHelper.compareTo((boolean)this.stopTabletServers, (boolean)typedOther.stopTabletServers)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        public _Fields fieldForId(int fieldId) {
            return _Fields.findByThriftId(fieldId);
        }

        public void read(TProtocol iprot) throws TException {
            schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
        }

        public void write(TProtocol oprot) throws TException {
            schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("shutdown_args(");
            boolean first = true;
            sb.append("tinfo:");
            if (this.tinfo == null) {
                sb.append("null");
            } else {
                sb.append(this.tinfo);
            }
            first = false;
            if (!first) {
                sb.append(", ");
            }
            sb.append("credentials:");
            if (this.credentials == null) {
                sb.append("null");
            } else {
                sb.append(this.credentials);
            }
            first = false;
            if (!first) {
                sb.append(", ");
            }
            sb.append("stopTabletServers:");
            sb.append(this.stopTabletServers);
            first = false;
            sb.append(")");
            return sb.toString();
        }

        public void validate() throws TException {
            if (this.tinfo != null) {
                this.tinfo.validate();
            }
            if (this.credentials != null) {
                this.credentials.validate();
            }
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            try {
                this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
            }
            catch (TException te) {
                throw new IOException(te);
            }
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            try {
                this.__isset_bitfield = 0;
                this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
            }
            catch (TException te) {
                throw new IOException(te);
            }
        }

        static {
            schemes.put(StandardScheme.class, new shutdown_argsStandardSchemeFactory());
            schemes.put(TupleScheme.class, new shutdown_argsTupleSchemeFactory());
            EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
            tmpMap.put(_Fields.TINFO, new FieldMetaData("tinfo", 3, (FieldValueMetaData)new StructMetaData(12, TInfo.class)));
            tmpMap.put(_Fields.CREDENTIALS, new FieldMetaData("credentials", 3, (FieldValueMetaData)new StructMetaData(12, TCredentials.class)));
            tmpMap.put(_Fields.STOP_TABLET_SERVERS, new FieldMetaData("stopTabletServers", 3, new FieldValueMetaData(2)));
            metaDataMap = Collections.unmodifiableMap(tmpMap);
            FieldMetaData.addStructMetaDataMap(shutdown_args.class, metaDataMap);
        }

        private static class shutdown_argsTupleScheme
        extends TupleScheme<shutdown_args> {
            private shutdown_argsTupleScheme() {
            }

            public void write(TProtocol prot, shutdown_args struct) throws TException {
                TTupleProtocol oprot = (TTupleProtocol)prot;
                BitSet optionals = new BitSet();
                if (struct.isSetTinfo()) {
                    optionals.set(0);
                }
                if (struct.isSetCredentials()) {
                    optionals.set(1);
                }
                if (struct.isSetStopTabletServers()) {
                    optionals.set(2);
                }
                oprot.writeBitSet(optionals, 3);
                if (struct.isSetTinfo()) {
                    struct.tinfo.write((TProtocol)oprot);
                }
                if (struct.isSetCredentials()) {
                    struct.credentials.write((TProtocol)oprot);
                }
                if (struct.isSetStopTabletServers()) {
                    oprot.writeBool(struct.stopTabletServers);
                }
            }

            public void read(TProtocol prot, shutdown_args struct) throws TException {
                TTupleProtocol iprot = (TTupleProtocol)prot;
                BitSet incoming = iprot.readBitSet(3);
                if (incoming.get(0)) {
                    struct.tinfo = new TInfo();
                    struct.tinfo.read((TProtocol)iprot);
                    struct.setTinfoIsSet(true);
                }
                if (incoming.get(1)) {
                    struct.credentials = new TCredentials();
                    struct.credentials.read((TProtocol)iprot);
                    struct.setCredentialsIsSet(true);
                }
                if (incoming.get(2)) {
                    struct.stopTabletServers = iprot.readBool();
                    struct.setStopTabletServersIsSet(true);
                }
            }
        }

        private static class shutdown_argsTupleSchemeFactory
        implements SchemeFactory {
            private shutdown_argsTupleSchemeFactory() {
            }

            public shutdown_argsTupleScheme getScheme() {
                return new shutdown_argsTupleScheme();
            }
        }

        private static class shutdown_argsStandardScheme
        extends StandardScheme<shutdown_args> {
            private shutdown_argsStandardScheme() {
            }

            public void read(TProtocol iprot, shutdown_args struct) throws TException {
                iprot.readStructBegin();
                while (true) {
                    TField schemeField = iprot.readFieldBegin();
                    if (schemeField.type == 0) break;
                    switch (schemeField.id) {
                        case 3: {
                            if (schemeField.type == 12) {
                                struct.tinfo = new TInfo();
                                struct.tinfo.read(iprot);
                                struct.setTinfoIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        case 1: {
                            if (schemeField.type == 12) {
                                struct.credentials = new TCredentials();
                                struct.credentials.read(iprot);
                                struct.setCredentialsIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        case 2: {
                            if (schemeField.type == 2) {
                                struct.stopTabletServers = iprot.readBool();
                                struct.setStopTabletServersIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        default: {
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        }
                    }
                    iprot.readFieldEnd();
                }
                iprot.readStructEnd();
                struct.validate();
            }

            public void write(TProtocol oprot, shutdown_args struct) throws TException {
                struct.validate();
                oprot.writeStructBegin(STRUCT_DESC);
                if (struct.credentials != null) {
                    oprot.writeFieldBegin(CREDENTIALS_FIELD_DESC);
                    struct.credentials.write(oprot);
                    oprot.writeFieldEnd();
                }
                oprot.writeFieldBegin(STOP_TABLET_SERVERS_FIELD_DESC);
                oprot.writeBool(struct.stopTabletServers);
                oprot.writeFieldEnd();
                if (struct.tinfo != null) {
                    oprot.writeFieldBegin(TINFO_FIELD_DESC);
                    struct.tinfo.write(oprot);
                    oprot.writeFieldEnd();
                }
                oprot.writeFieldStop();
                oprot.writeStructEnd();
            }
        }

        private static class shutdown_argsStandardSchemeFactory
        implements SchemeFactory {
            private shutdown_argsStandardSchemeFactory() {
            }

            public shutdown_argsStandardScheme getScheme() {
                return new shutdown_argsStandardScheme();
            }
        }

        public static enum _Fields implements TFieldIdEnum
        {
            TINFO(3, "tinfo"),
            CREDENTIALS(1, "credentials"),
            STOP_TABLET_SERVERS(2, "stopTabletServers");

            private static final Map<String, _Fields> byName;
            private final short _thriftId;
            private final String _fieldName;

            public static _Fields findByThriftId(int fieldId) {
                switch (fieldId) {
                    case 3: {
                        return TINFO;
                    }
                    case 1: {
                        return CREDENTIALS;
                    }
                    case 2: {
                        return STOP_TABLET_SERVERS;
                    }
                }
                return null;
            }

            public static _Fields findByThriftIdOrThrow(int fieldId) {
                _Fields fields = _Fields.findByThriftId(fieldId);
                if (fields == null) {
                    throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
                }
                return fields;
            }

            public static _Fields findByName(String name) {
                return byName.get(name);
            }

            private _Fields(short thriftId, String fieldName) {
                this._thriftId = thriftId;
                this._fieldName = fieldName;
            }

            public short getThriftFieldId() {
                return this._thriftId;
            }

            public String getFieldName() {
                return this._fieldName;
            }

            static {
                byName = new HashMap<String, _Fields>();
                for (_Fields field : EnumSet.allOf(_Fields.class)) {
                    byName.put(field.getFieldName(), field);
                }
            }
        }
    }

    public static class setMasterGoalState_result
    implements TBase<setMasterGoalState_result, _Fields>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("setMasterGoalState_result");
        private static final TField SEC_FIELD_DESC = new TField("sec", 12, 1);
        private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
        public ThriftSecurityException sec;
        public static final Map<_Fields, FieldMetaData> metaDataMap;

        public setMasterGoalState_result() {
        }

        public setMasterGoalState_result(ThriftSecurityException sec) {
            this();
            this.sec = sec;
        }

        public setMasterGoalState_result(setMasterGoalState_result other) {
            if (other.isSetSec()) {
                this.sec = new ThriftSecurityException(other.sec);
            }
        }

        public setMasterGoalState_result deepCopy() {
            return new setMasterGoalState_result(this);
        }

        public void clear() {
            this.sec = null;
        }

        public ThriftSecurityException getSec() {
            return this.sec;
        }

        public setMasterGoalState_result setSec(ThriftSecurityException sec) {
            this.sec = sec;
            return this;
        }

        public void unsetSec() {
            this.sec = null;
        }

        public boolean isSetSec() {
            return this.sec != null;
        }

        public void setSecIsSet(boolean value) {
            if (!value) {
                this.sec = null;
            }
        }

        public void setFieldValue(_Fields field, Object value) {
            switch (field) {
                case SEC: {
                    if (value == null) {
                        this.unsetSec();
                        break;
                    }
                    this.setSec((ThriftSecurityException)value);
                }
            }
        }

        public Object getFieldValue(_Fields field) {
            switch (field) {
                case SEC: {
                    return this.getSec();
                }
            }
            throw new IllegalStateException();
        }

        public boolean isSet(_Fields field) {
            if (field == null) {
                throw new IllegalArgumentException();
            }
            switch (field) {
                case SEC: {
                    return this.isSetSec();
                }
            }
            throw new IllegalStateException();
        }

        public boolean equals(Object that) {
            if (that == null) {
                return false;
            }
            if (that instanceof setMasterGoalState_result) {
                return this.equals((setMasterGoalState_result)that);
            }
            return false;
        }

        public boolean equals(setMasterGoalState_result that) {
            if (that == null) {
                return false;
            }
            boolean this_present_sec = this.isSetSec();
            boolean that_present_sec = that.isSetSec();
            if (this_present_sec || that_present_sec) {
                if (!this_present_sec || !that_present_sec) {
                    return false;
                }
                if (!this.sec.equals(that.sec)) {
                    return false;
                }
            }
            return true;
        }

        public int hashCode() {
            return 0;
        }

        public int compareTo(setMasterGoalState_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            setMasterGoalState_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSec()).compareTo(typedOther.isSetSec());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSec() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.sec), (Comparable)((Object)typedOther.sec))) != 0) {
                return lastComparison;
            }
            return 0;
        }

        public _Fields fieldForId(int fieldId) {
            return _Fields.findByThriftId(fieldId);
        }

        public void read(TProtocol iprot) throws TException {
            schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
        }

        public void write(TProtocol oprot) throws TException {
            schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("setMasterGoalState_result(");
            boolean first = true;
            sb.append("sec:");
            if (this.sec == null) {
                sb.append("null");
            } else {
                sb.append(this.sec);
            }
            first = false;
            sb.append(")");
            return sb.toString();
        }

        public void validate() throws TException {
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            try {
                this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
            }
            catch (TException te) {
                throw new IOException(te);
            }
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            try {
                this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
            }
            catch (TException te) {
                throw new IOException(te);
            }
        }

        static {
            schemes.put(StandardScheme.class, new setMasterGoalState_resultStandardSchemeFactory());
            schemes.put(TupleScheme.class, new setMasterGoalState_resultTupleSchemeFactory());
            EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
            tmpMap.put(_Fields.SEC, new FieldMetaData("sec", 3, new FieldValueMetaData(12)));
            metaDataMap = Collections.unmodifiableMap(tmpMap);
            FieldMetaData.addStructMetaDataMap(setMasterGoalState_result.class, metaDataMap);
        }

        private static class setMasterGoalState_resultTupleScheme
        extends TupleScheme<setMasterGoalState_result> {
            private setMasterGoalState_resultTupleScheme() {
            }

            public void write(TProtocol prot, setMasterGoalState_result struct) throws TException {
                TTupleProtocol oprot = (TTupleProtocol)prot;
                BitSet optionals = new BitSet();
                if (struct.isSetSec()) {
                    optionals.set(0);
                }
                oprot.writeBitSet(optionals, 1);
                if (struct.isSetSec()) {
                    struct.sec.write((TProtocol)oprot);
                }
            }

            public void read(TProtocol prot, setMasterGoalState_result struct) throws TException {
                TTupleProtocol iprot = (TTupleProtocol)prot;
                BitSet incoming = iprot.readBitSet(1);
                if (incoming.get(0)) {
                    struct.sec = new ThriftSecurityException();
                    struct.sec.read((TProtocol)iprot);
                    struct.setSecIsSet(true);
                }
            }
        }

        private static class setMasterGoalState_resultTupleSchemeFactory
        implements SchemeFactory {
            private setMasterGoalState_resultTupleSchemeFactory() {
            }

            public setMasterGoalState_resultTupleScheme getScheme() {
                return new setMasterGoalState_resultTupleScheme();
            }
        }

        private static class setMasterGoalState_resultStandardScheme
        extends StandardScheme<setMasterGoalState_result> {
            private setMasterGoalState_resultStandardScheme() {
            }

            public void read(TProtocol iprot, setMasterGoalState_result struct) throws TException {
                iprot.readStructBegin();
                while (true) {
                    TField schemeField = iprot.readFieldBegin();
                    if (schemeField.type == 0) break;
                    switch (schemeField.id) {
                        case 1: {
                            if (schemeField.type == 12) {
                                struct.sec = new ThriftSecurityException();
                                struct.sec.read(iprot);
                                struct.setSecIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        default: {
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        }
                    }
                    iprot.readFieldEnd();
                }
                iprot.readStructEnd();
                struct.validate();
            }

            public void write(TProtocol oprot, setMasterGoalState_result struct) throws TException {
                struct.validate();
                oprot.writeStructBegin(STRUCT_DESC);
                if (struct.sec != null) {
                    oprot.writeFieldBegin(SEC_FIELD_DESC);
                    struct.sec.write(oprot);
                    oprot.writeFieldEnd();
                }
                oprot.writeFieldStop();
                oprot.writeStructEnd();
            }
        }

        private static class setMasterGoalState_resultStandardSchemeFactory
        implements SchemeFactory {
            private setMasterGoalState_resultStandardSchemeFactory() {
            }

            public setMasterGoalState_resultStandardScheme getScheme() {
                return new setMasterGoalState_resultStandardScheme();
            }
        }

        public static enum _Fields implements TFieldIdEnum
        {
            SEC(1, "sec");

            private static final Map<String, _Fields> byName;
            private final short _thriftId;
            private final String _fieldName;

            public static _Fields findByThriftId(int fieldId) {
                switch (fieldId) {
                    case 1: {
                        return SEC;
                    }
                }
                return null;
            }

            public static _Fields findByThriftIdOrThrow(int fieldId) {
                _Fields fields = _Fields.findByThriftId(fieldId);
                if (fields == null) {
                    throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
                }
                return fields;
            }

            public static _Fields findByName(String name) {
                return byName.get(name);
            }

            private _Fields(short thriftId, String fieldName) {
                this._thriftId = thriftId;
                this._fieldName = fieldName;
            }

            public short getThriftFieldId() {
                return this._thriftId;
            }

            public String getFieldName() {
                return this._fieldName;
            }

            static {
                byName = new HashMap<String, _Fields>();
                for (_Fields field : EnumSet.allOf(_Fields.class)) {
                    byName.put(field.getFieldName(), field);
                }
            }
        }
    }

    public static class setMasterGoalState_args
    implements TBase<setMasterGoalState_args, _Fields>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("setMasterGoalState_args");
        private static final TField TINFO_FIELD_DESC = new TField("tinfo", 12, 3);
        private static final TField CREDENTIALS_FIELD_DESC = new TField("credentials", 12, 1);
        private static final TField STATE_FIELD_DESC = new TField("state", 8, 2);
        private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
        public TInfo tinfo;
        public TCredentials credentials;
        public MasterGoalState state;
        public static final Map<_Fields, FieldMetaData> metaDataMap;

        public setMasterGoalState_args() {
        }

        public setMasterGoalState_args(TInfo tinfo, TCredentials credentials, MasterGoalState state) {
            this();
            this.tinfo = tinfo;
            this.credentials = credentials;
            this.state = state;
        }

        public setMasterGoalState_args(setMasterGoalState_args other) {
            if (other.isSetTinfo()) {
                this.tinfo = new TInfo(other.tinfo);
            }
            if (other.isSetCredentials()) {
                this.credentials = new TCredentials(other.credentials);
            }
            if (other.isSetState()) {
                this.state = other.state;
            }
        }

        public setMasterGoalState_args deepCopy() {
            return new setMasterGoalState_args(this);
        }

        public void clear() {
            this.tinfo = null;
            this.credentials = null;
            this.state = null;
        }

        public TInfo getTinfo() {
            return this.tinfo;
        }

        public setMasterGoalState_args setTinfo(TInfo tinfo) {
            this.tinfo = tinfo;
            return this;
        }

        public void unsetTinfo() {
            this.tinfo = null;
        }

        public boolean isSetTinfo() {
            return this.tinfo != null;
        }

        public void setTinfoIsSet(boolean value) {
            if (!value) {
                this.tinfo = null;
            }
        }

        public TCredentials getCredentials() {
            return this.credentials;
        }

        public setMasterGoalState_args setCredentials(TCredentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public void unsetCredentials() {
            this.credentials = null;
        }

        public boolean isSetCredentials() {
            return this.credentials != null;
        }

        public void setCredentialsIsSet(boolean value) {
            if (!value) {
                this.credentials = null;
            }
        }

        public MasterGoalState getState() {
            return this.state;
        }

        public setMasterGoalState_args setState(MasterGoalState state) {
            this.state = state;
            return this;
        }

        public void unsetState() {
            this.state = null;
        }

        public boolean isSetState() {
            return this.state != null;
        }

        public void setStateIsSet(boolean value) {
            if (!value) {
                this.state = null;
            }
        }

        public void setFieldValue(_Fields field, Object value) {
            switch (field) {
                case TINFO: {
                    if (value == null) {
                        this.unsetTinfo();
                        break;
                    }
                    this.setTinfo((TInfo)value);
                    break;
                }
                case CREDENTIALS: {
                    if (value == null) {
                        this.unsetCredentials();
                        break;
                    }
                    this.setCredentials((TCredentials)value);
                    break;
                }
                case STATE: {
                    if (value == null) {
                        this.unsetState();
                        break;
                    }
                    this.setState((MasterGoalState)((Object)value));
                }
            }
        }

        public Object getFieldValue(_Fields field) {
            switch (field) {
                case TINFO: {
                    return this.getTinfo();
                }
                case CREDENTIALS: {
                    return this.getCredentials();
                }
                case STATE: {
                    return this.getState();
                }
            }
            throw new IllegalStateException();
        }

        public boolean isSet(_Fields field) {
            if (field == null) {
                throw new IllegalArgumentException();
            }
            switch (field) {
                case TINFO: {
                    return this.isSetTinfo();
                }
                case CREDENTIALS: {
                    return this.isSetCredentials();
                }
                case STATE: {
                    return this.isSetState();
                }
            }
            throw new IllegalStateException();
        }

        public boolean equals(Object that) {
            if (that == null) {
                return false;
            }
            if (that instanceof setMasterGoalState_args) {
                return this.equals((setMasterGoalState_args)that);
            }
            return false;
        }

        public boolean equals(setMasterGoalState_args that) {
            if (that == null) {
                return false;
            }
            boolean this_present_tinfo = this.isSetTinfo();
            boolean that_present_tinfo = that.isSetTinfo();
            if (this_present_tinfo || that_present_tinfo) {
                if (!this_present_tinfo || !that_present_tinfo) {
                    return false;
                }
                if (!this.tinfo.equals(that.tinfo)) {
                    return false;
                }
            }
            boolean this_present_credentials = this.isSetCredentials();
            boolean that_present_credentials = that.isSetCredentials();
            if (this_present_credentials || that_present_credentials) {
                if (!this_present_credentials || !that_present_credentials) {
                    return false;
                }
                if (!this.credentials.equals(that.credentials)) {
                    return false;
                }
            }
            boolean this_present_state = this.isSetState();
            boolean that_present_state = that.isSetState();
            if (this_present_state || that_present_state) {
                if (!this_present_state || !that_present_state) {
                    return false;
                }
                if (!this.state.equals((Object)that.state)) {
                    return false;
                }
            }
            return true;
        }

        public int hashCode() {
            return 0;
        }

        public int compareTo(setMasterGoalState_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            setMasterGoalState_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetTinfo()).compareTo(typedOther.isSetTinfo());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetTinfo() && (lastComparison = TBaseHelper.compareTo((Comparable)this.tinfo, (Comparable)typedOther.tinfo)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetCredentials()).compareTo(typedOther.isSetCredentials());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetCredentials() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.credentials), (Comparable)((Object)typedOther.credentials))) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetState()).compareTo(typedOther.isSetState());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetState() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.state), (Comparable)((Object)typedOther.state))) != 0) {
                return lastComparison;
            }
            return 0;
        }

        public _Fields fieldForId(int fieldId) {
            return _Fields.findByThriftId(fieldId);
        }

        public void read(TProtocol iprot) throws TException {
            schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
        }

        public void write(TProtocol oprot) throws TException {
            schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("setMasterGoalState_args(");
            boolean first = true;
            sb.append("tinfo:");
            if (this.tinfo == null) {
                sb.append("null");
            } else {
                sb.append(this.tinfo);
            }
            first = false;
            if (!first) {
                sb.append(", ");
            }
            sb.append("credentials:");
            if (this.credentials == null) {
                sb.append("null");
            } else {
                sb.append(this.credentials);
            }
            first = false;
            if (!first) {
                sb.append(", ");
            }
            sb.append("state:");
            if (this.state == null) {
                sb.append("null");
            } else {
                sb.append((Object)this.state);
            }
            first = false;
            sb.append(")");
            return sb.toString();
        }

        public void validate() throws TException {
            if (this.tinfo != null) {
                this.tinfo.validate();
            }
            if (this.credentials != null) {
                this.credentials.validate();
            }
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            try {
                this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
            }
            catch (TException te) {
                throw new IOException(te);
            }
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            try {
                this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
            }
            catch (TException te) {
                throw new IOException(te);
            }
        }

        static {
            schemes.put(StandardScheme.class, new setMasterGoalState_argsStandardSchemeFactory());
            schemes.put(TupleScheme.class, new setMasterGoalState_argsTupleSchemeFactory());
            EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
            tmpMap.put(_Fields.TINFO, new FieldMetaData("tinfo", 3, (FieldValueMetaData)new StructMetaData(12, TInfo.class)));
            tmpMap.put(_Fields.CREDENTIALS, new FieldMetaData("credentials", 3, (FieldValueMetaData)new StructMetaData(12, TCredentials.class)));
            tmpMap.put(_Fields.STATE, new FieldMetaData("state", 3, (FieldValueMetaData)new EnumMetaData(16, MasterGoalState.class)));
            metaDataMap = Collections.unmodifiableMap(tmpMap);
            FieldMetaData.addStructMetaDataMap(setMasterGoalState_args.class, metaDataMap);
        }

        private static class setMasterGoalState_argsTupleScheme
        extends TupleScheme<setMasterGoalState_args> {
            private setMasterGoalState_argsTupleScheme() {
            }

            public void write(TProtocol prot, setMasterGoalState_args struct) throws TException {
                TTupleProtocol oprot = (TTupleProtocol)prot;
                BitSet optionals = new BitSet();
                if (struct.isSetTinfo()) {
                    optionals.set(0);
                }
                if (struct.isSetCredentials()) {
                    optionals.set(1);
                }
                if (struct.isSetState()) {
                    optionals.set(2);
                }
                oprot.writeBitSet(optionals, 3);
                if (struct.isSetTinfo()) {
                    struct.tinfo.write((TProtocol)oprot);
                }
                if (struct.isSetCredentials()) {
                    struct.credentials.write((TProtocol)oprot);
                }
                if (struct.isSetState()) {
                    oprot.writeI32(struct.state.getValue());
                }
            }

            public void read(TProtocol prot, setMasterGoalState_args struct) throws TException {
                TTupleProtocol iprot = (TTupleProtocol)prot;
                BitSet incoming = iprot.readBitSet(3);
                if (incoming.get(0)) {
                    struct.tinfo = new TInfo();
                    struct.tinfo.read((TProtocol)iprot);
                    struct.setTinfoIsSet(true);
                }
                if (incoming.get(1)) {
                    struct.credentials = new TCredentials();
                    struct.credentials.read((TProtocol)iprot);
                    struct.setCredentialsIsSet(true);
                }
                if (incoming.get(2)) {
                    struct.state = MasterGoalState.findByValue(iprot.readI32());
                    struct.setStateIsSet(true);
                }
            }
        }

        private static class setMasterGoalState_argsTupleSchemeFactory
        implements SchemeFactory {
            private setMasterGoalState_argsTupleSchemeFactory() {
            }

            public setMasterGoalState_argsTupleScheme getScheme() {
                return new setMasterGoalState_argsTupleScheme();
            }
        }

        private static class setMasterGoalState_argsStandardScheme
        extends StandardScheme<setMasterGoalState_args> {
            private setMasterGoalState_argsStandardScheme() {
            }

            public void read(TProtocol iprot, setMasterGoalState_args struct) throws TException {
                iprot.readStructBegin();
                while (true) {
                    TField schemeField = iprot.readFieldBegin();
                    if (schemeField.type == 0) break;
                    switch (schemeField.id) {
                        case 3: {
                            if (schemeField.type == 12) {
                                struct.tinfo = new TInfo();
                                struct.tinfo.read(iprot);
                                struct.setTinfoIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        case 1: {
                            if (schemeField.type == 12) {
                                struct.credentials = new TCredentials();
                                struct.credentials.read(iprot);
                                struct.setCredentialsIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        case 2: {
                            if (schemeField.type == 8) {
                                struct.state = MasterGoalState.findByValue(iprot.readI32());
                                struct.setStateIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        default: {
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        }
                    }
                    iprot.readFieldEnd();
                }
                iprot.readStructEnd();
                struct.validate();
            }

            public void write(TProtocol oprot, setMasterGoalState_args struct) throws TException {
                struct.validate();
                oprot.writeStructBegin(STRUCT_DESC);
                if (struct.credentials != null) {
                    oprot.writeFieldBegin(CREDENTIALS_FIELD_DESC);
                    struct.credentials.write(oprot);
                    oprot.writeFieldEnd();
                }
                if (struct.state != null) {
                    oprot.writeFieldBegin(STATE_FIELD_DESC);
                    oprot.writeI32(struct.state.getValue());
                    oprot.writeFieldEnd();
                }
                if (struct.tinfo != null) {
                    oprot.writeFieldBegin(TINFO_FIELD_DESC);
                    struct.tinfo.write(oprot);
                    oprot.writeFieldEnd();
                }
                oprot.writeFieldStop();
                oprot.writeStructEnd();
            }
        }

        private static class setMasterGoalState_argsStandardSchemeFactory
        implements SchemeFactory {
            private setMasterGoalState_argsStandardSchemeFactory() {
            }

            public setMasterGoalState_argsStandardScheme getScheme() {
                return new setMasterGoalState_argsStandardScheme();
            }
        }

        public static enum _Fields implements TFieldIdEnum
        {
            TINFO(3, "tinfo"),
            CREDENTIALS(1, "credentials"),
            STATE(2, "state");

            private static final Map<String, _Fields> byName;
            private final short _thriftId;
            private final String _fieldName;

            public static _Fields findByThriftId(int fieldId) {
                switch (fieldId) {
                    case 3: {
                        return TINFO;
                    }
                    case 1: {
                        return CREDENTIALS;
                    }
                    case 2: {
                        return STATE;
                    }
                }
                return null;
            }

            public static _Fields findByThriftIdOrThrow(int fieldId) {
                _Fields fields = _Fields.findByThriftId(fieldId);
                if (fields == null) {
                    throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
                }
                return fields;
            }

            public static _Fields findByName(String name) {
                return byName.get(name);
            }

            private _Fields(short thriftId, String fieldName) {
                this._thriftId = thriftId;
                this._fieldName = fieldName;
            }

            public short getThriftFieldId() {
                return this._thriftId;
            }

            public String getFieldName() {
                return this._fieldName;
            }

            static {
                byName = new HashMap<String, _Fields>();
                for (_Fields field : EnumSet.allOf(_Fields.class)) {
                    byName.put(field.getFieldName(), field);
                }
            }
        }
    }

    public static class removeNamespaceProperty_result
    implements TBase<removeNamespaceProperty_result, _Fields>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("removeNamespaceProperty_result");
        private static final TField SEC_FIELD_DESC = new TField("sec", 12, 1);
        private static final TField TOPE_FIELD_DESC = new TField("tope", 12, 2);
        private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
        public ThriftSecurityException sec;
        public ThriftTableOperationException tope;
        public static final Map<_Fields, FieldMetaData> metaDataMap;

        public removeNamespaceProperty_result() {
        }

        public removeNamespaceProperty_result(ThriftSecurityException sec, ThriftTableOperationException tope) {
            this();
            this.sec = sec;
            this.tope = tope;
        }

        public removeNamespaceProperty_result(removeNamespaceProperty_result other) {
            if (other.isSetSec()) {
                this.sec = new ThriftSecurityException(other.sec);
            }
            if (other.isSetTope()) {
                this.tope = new ThriftTableOperationException(other.tope);
            }
        }

        public removeNamespaceProperty_result deepCopy() {
            return new removeNamespaceProperty_result(this);
        }

        public void clear() {
            this.sec = null;
            this.tope = null;
        }

        public ThriftSecurityException getSec() {
            return this.sec;
        }

        public removeNamespaceProperty_result setSec(ThriftSecurityException sec) {
            this.sec = sec;
            return this;
        }

        public void unsetSec() {
            this.sec = null;
        }

        public boolean isSetSec() {
            return this.sec != null;
        }

        public void setSecIsSet(boolean value) {
            if (!value) {
                this.sec = null;
            }
        }

        public ThriftTableOperationException getTope() {
            return this.tope;
        }

        public removeNamespaceProperty_result setTope(ThriftTableOperationException tope) {
            this.tope = tope;
            return this;
        }

        public void unsetTope() {
            this.tope = null;
        }

        public boolean isSetTope() {
            return this.tope != null;
        }

        public void setTopeIsSet(boolean value) {
            if (!value) {
                this.tope = null;
            }
        }

        public void setFieldValue(_Fields field, Object value) {
            switch (field) {
                case SEC: {
                    if (value == null) {
                        this.unsetSec();
                        break;
                    }
                    this.setSec((ThriftSecurityException)value);
                    break;
                }
                case TOPE: {
                    if (value == null) {
                        this.unsetTope();
                        break;
                    }
                    this.setTope((ThriftTableOperationException)value);
                }
            }
        }

        public Object getFieldValue(_Fields field) {
            switch (field) {
                case SEC: {
                    return this.getSec();
                }
                case TOPE: {
                    return this.getTope();
                }
            }
            throw new IllegalStateException();
        }

        public boolean isSet(_Fields field) {
            if (field == null) {
                throw new IllegalArgumentException();
            }
            switch (field) {
                case SEC: {
                    return this.isSetSec();
                }
                case TOPE: {
                    return this.isSetTope();
                }
            }
            throw new IllegalStateException();
        }

        public boolean equals(Object that) {
            if (that == null) {
                return false;
            }
            if (that instanceof removeNamespaceProperty_result) {
                return this.equals((removeNamespaceProperty_result)that);
            }
            return false;
        }

        public boolean equals(removeNamespaceProperty_result that) {
            if (that == null) {
                return false;
            }
            boolean this_present_sec = this.isSetSec();
            boolean that_present_sec = that.isSetSec();
            if (this_present_sec || that_present_sec) {
                if (!this_present_sec || !that_present_sec) {
                    return false;
                }
                if (!this.sec.equals(that.sec)) {
                    return false;
                }
            }
            boolean this_present_tope = this.isSetTope();
            boolean that_present_tope = that.isSetTope();
            if (this_present_tope || that_present_tope) {
                if (!this_present_tope || !that_present_tope) {
                    return false;
                }
                if (!this.tope.equals(that.tope)) {
                    return false;
                }
            }
            return true;
        }

        public int hashCode() {
            return 0;
        }

        public int compareTo(removeNamespaceProperty_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            removeNamespaceProperty_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSec()).compareTo(typedOther.isSetSec());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSec() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.sec), (Comparable)((Object)typedOther.sec))) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetTope()).compareTo(typedOther.isSetTope());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetTope() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.tope), (Comparable)((Object)typedOther.tope))) != 0) {
                return lastComparison;
            }
            return 0;
        }

        public _Fields fieldForId(int fieldId) {
            return _Fields.findByThriftId(fieldId);
        }

        public void read(TProtocol iprot) throws TException {
            schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
        }

        public void write(TProtocol oprot) throws TException {
            schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("removeNamespaceProperty_result(");
            boolean first = true;
            sb.append("sec:");
            if (this.sec == null) {
                sb.append("null");
            } else {
                sb.append(this.sec);
            }
            first = false;
            if (!first) {
                sb.append(", ");
            }
            sb.append("tope:");
            if (this.tope == null) {
                sb.append("null");
            } else {
                sb.append(this.tope);
            }
            first = false;
            sb.append(")");
            return sb.toString();
        }

        public void validate() throws TException {
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            try {
                this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
            }
            catch (TException te) {
                throw new IOException(te);
            }
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            try {
                this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
            }
            catch (TException te) {
                throw new IOException(te);
            }
        }

        static {
            schemes.put(StandardScheme.class, new removeNamespaceProperty_resultStandardSchemeFactory());
            schemes.put(TupleScheme.class, new removeNamespaceProperty_resultTupleSchemeFactory());
            EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
            tmpMap.put(_Fields.SEC, new FieldMetaData("sec", 3, new FieldValueMetaData(12)));
            tmpMap.put(_Fields.TOPE, new FieldMetaData("tope", 3, new FieldValueMetaData(12)));
            metaDataMap = Collections.unmodifiableMap(tmpMap);
            FieldMetaData.addStructMetaDataMap(removeNamespaceProperty_result.class, metaDataMap);
        }

        private static class removeNamespaceProperty_resultTupleScheme
        extends TupleScheme<removeNamespaceProperty_result> {
            private removeNamespaceProperty_resultTupleScheme() {
            }

            public void write(TProtocol prot, removeNamespaceProperty_result struct) throws TException {
                TTupleProtocol oprot = (TTupleProtocol)prot;
                BitSet optionals = new BitSet();
                if (struct.isSetSec()) {
                    optionals.set(0);
                }
                if (struct.isSetTope()) {
                    optionals.set(1);
                }
                oprot.writeBitSet(optionals, 2);
                if (struct.isSetSec()) {
                    struct.sec.write((TProtocol)oprot);
                }
                if (struct.isSetTope()) {
                    struct.tope.write((TProtocol)oprot);
                }
            }

            public void read(TProtocol prot, removeNamespaceProperty_result struct) throws TException {
                TTupleProtocol iprot = (TTupleProtocol)prot;
                BitSet incoming = iprot.readBitSet(2);
                if (incoming.get(0)) {
                    struct.sec = new ThriftSecurityException();
                    struct.sec.read((TProtocol)iprot);
                    struct.setSecIsSet(true);
                }
                if (incoming.get(1)) {
                    struct.tope = new ThriftTableOperationException();
                    struct.tope.read((TProtocol)iprot);
                    struct.setTopeIsSet(true);
                }
            }
        }

        private static class removeNamespaceProperty_resultTupleSchemeFactory
        implements SchemeFactory {
            private removeNamespaceProperty_resultTupleSchemeFactory() {
            }

            public removeNamespaceProperty_resultTupleScheme getScheme() {
                return new removeNamespaceProperty_resultTupleScheme();
            }
        }

        private static class removeNamespaceProperty_resultStandardScheme
        extends StandardScheme<removeNamespaceProperty_result> {
            private removeNamespaceProperty_resultStandardScheme() {
            }

            public void read(TProtocol iprot, removeNamespaceProperty_result struct) throws TException {
                iprot.readStructBegin();
                while (true) {
                    TField schemeField = iprot.readFieldBegin();
                    if (schemeField.type == 0) break;
                    switch (schemeField.id) {
                        case 1: {
                            if (schemeField.type == 12) {
                                struct.sec = new ThriftSecurityException();
                                struct.sec.read(iprot);
                                struct.setSecIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        case 2: {
                            if (schemeField.type == 12) {
                                struct.tope = new ThriftTableOperationException();
                                struct.tope.read(iprot);
                                struct.setTopeIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        default: {
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        }
                    }
                    iprot.readFieldEnd();
                }
                iprot.readStructEnd();
                struct.validate();
            }

            public void write(TProtocol oprot, removeNamespaceProperty_result struct) throws TException {
                struct.validate();
                oprot.writeStructBegin(STRUCT_DESC);
                if (struct.sec != null) {
                    oprot.writeFieldBegin(SEC_FIELD_DESC);
                    struct.sec.write(oprot);
                    oprot.writeFieldEnd();
                }
                if (struct.tope != null) {
                    oprot.writeFieldBegin(TOPE_FIELD_DESC);
                    struct.tope.write(oprot);
                    oprot.writeFieldEnd();
                }
                oprot.writeFieldStop();
                oprot.writeStructEnd();
            }
        }

        private static class removeNamespaceProperty_resultStandardSchemeFactory
        implements SchemeFactory {
            private removeNamespaceProperty_resultStandardSchemeFactory() {
            }

            public removeNamespaceProperty_resultStandardScheme getScheme() {
                return new removeNamespaceProperty_resultStandardScheme();
            }
        }

        public static enum _Fields implements TFieldIdEnum
        {
            SEC(1, "sec"),
            TOPE(2, "tope");

            private static final Map<String, _Fields> byName;
            private final short _thriftId;
            private final String _fieldName;

            public static _Fields findByThriftId(int fieldId) {
                switch (fieldId) {
                    case 1: {
                        return SEC;
                    }
                    case 2: {
                        return TOPE;
                    }
                }
                return null;
            }

            public static _Fields findByThriftIdOrThrow(int fieldId) {
                _Fields fields = _Fields.findByThriftId(fieldId);
                if (fields == null) {
                    throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
                }
                return fields;
            }

            public static _Fields findByName(String name) {
                return byName.get(name);
            }

            private _Fields(short thriftId, String fieldName) {
                this._thriftId = thriftId;
                this._fieldName = fieldName;
            }

            public short getThriftFieldId() {
                return this._thriftId;
            }

            public String getFieldName() {
                return this._fieldName;
            }

            static {
                byName = new HashMap<String, _Fields>();
                for (_Fields field : EnumSet.allOf(_Fields.class)) {
                    byName.put(field.getFieldName(), field);
                }
            }
        }
    }

    public static class removeNamespaceProperty_args
    implements TBase<removeNamespaceProperty_args, _Fields>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("removeNamespaceProperty_args");
        private static final TField TINFO_FIELD_DESC = new TField("tinfo", 12, 4);
        private static final TField CREDENTIALS_FIELD_DESC = new TField("credentials", 12, 1);
        private static final TField NS_FIELD_DESC = new TField("ns", 11, 2);
        private static final TField PROPERTY_FIELD_DESC = new TField("property", 11, 3);
        private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
        public TInfo tinfo;
        public TCredentials credentials;
        public String ns;
        public String property;
        public static final Map<_Fields, FieldMetaData> metaDataMap;

        public removeNamespaceProperty_args() {
        }

        public removeNamespaceProperty_args(TInfo tinfo, TCredentials credentials, String ns, String property) {
            this();
            this.tinfo = tinfo;
            this.credentials = credentials;
            this.ns = ns;
            this.property = property;
        }

        public removeNamespaceProperty_args(removeNamespaceProperty_args other) {
            if (other.isSetTinfo()) {
                this.tinfo = new TInfo(other.tinfo);
            }
            if (other.isSetCredentials()) {
                this.credentials = new TCredentials(other.credentials);
            }
            if (other.isSetNs()) {
                this.ns = other.ns;
            }
            if (other.isSetProperty()) {
                this.property = other.property;
            }
        }

        public removeNamespaceProperty_args deepCopy() {
            return new removeNamespaceProperty_args(this);
        }

        public void clear() {
            this.tinfo = null;
            this.credentials = null;
            this.ns = null;
            this.property = null;
        }

        public TInfo getTinfo() {
            return this.tinfo;
        }

        public removeNamespaceProperty_args setTinfo(TInfo tinfo) {
            this.tinfo = tinfo;
            return this;
        }

        public void unsetTinfo() {
            this.tinfo = null;
        }

        public boolean isSetTinfo() {
            return this.tinfo != null;
        }

        public void setTinfoIsSet(boolean value) {
            if (!value) {
                this.tinfo = null;
            }
        }

        public TCredentials getCredentials() {
            return this.credentials;
        }

        public removeNamespaceProperty_args setCredentials(TCredentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public void unsetCredentials() {
            this.credentials = null;
        }

        public boolean isSetCredentials() {
            return this.credentials != null;
        }

        public void setCredentialsIsSet(boolean value) {
            if (!value) {
                this.credentials = null;
            }
        }

        public String getNs() {
            return this.ns;
        }

        public removeNamespaceProperty_args setNs(String ns) {
            this.ns = ns;
            return this;
        }

        public void unsetNs() {
            this.ns = null;
        }

        public boolean isSetNs() {
            return this.ns != null;
        }

        public void setNsIsSet(boolean value) {
            if (!value) {
                this.ns = null;
            }
        }

        public String getProperty() {
            return this.property;
        }

        public removeNamespaceProperty_args setProperty(String property) {
            this.property = property;
            return this;
        }

        public void unsetProperty() {
            this.property = null;
        }

        public boolean isSetProperty() {
            return this.property != null;
        }

        public void setPropertyIsSet(boolean value) {
            if (!value) {
                this.property = null;
            }
        }

        public void setFieldValue(_Fields field, Object value) {
            switch (field) {
                case TINFO: {
                    if (value == null) {
                        this.unsetTinfo();
                        break;
                    }
                    this.setTinfo((TInfo)value);
                    break;
                }
                case CREDENTIALS: {
                    if (value == null) {
                        this.unsetCredentials();
                        break;
                    }
                    this.setCredentials((TCredentials)value);
                    break;
                }
                case NS: {
                    if (value == null) {
                        this.unsetNs();
                        break;
                    }
                    this.setNs((String)value);
                    break;
                }
                case PROPERTY: {
                    if (value == null) {
                        this.unsetProperty();
                        break;
                    }
                    this.setProperty((String)value);
                }
            }
        }

        public Object getFieldValue(_Fields field) {
            switch (field) {
                case TINFO: {
                    return this.getTinfo();
                }
                case CREDENTIALS: {
                    return this.getCredentials();
                }
                case NS: {
                    return this.getNs();
                }
                case PROPERTY: {
                    return this.getProperty();
                }
            }
            throw new IllegalStateException();
        }

        public boolean isSet(_Fields field) {
            if (field == null) {
                throw new IllegalArgumentException();
            }
            switch (field) {
                case TINFO: {
                    return this.isSetTinfo();
                }
                case CREDENTIALS: {
                    return this.isSetCredentials();
                }
                case NS: {
                    return this.isSetNs();
                }
                case PROPERTY: {
                    return this.isSetProperty();
                }
            }
            throw new IllegalStateException();
        }

        public boolean equals(Object that) {
            if (that == null) {
                return false;
            }
            if (that instanceof removeNamespaceProperty_args) {
                return this.equals((removeNamespaceProperty_args)that);
            }
            return false;
        }

        public boolean equals(removeNamespaceProperty_args that) {
            if (that == null) {
                return false;
            }
            boolean this_present_tinfo = this.isSetTinfo();
            boolean that_present_tinfo = that.isSetTinfo();
            if (this_present_tinfo || that_present_tinfo) {
                if (!this_present_tinfo || !that_present_tinfo) {
                    return false;
                }
                if (!this.tinfo.equals(that.tinfo)) {
                    return false;
                }
            }
            boolean this_present_credentials = this.isSetCredentials();
            boolean that_present_credentials = that.isSetCredentials();
            if (this_present_credentials || that_present_credentials) {
                if (!this_present_credentials || !that_present_credentials) {
                    return false;
                }
                if (!this.credentials.equals(that.credentials)) {
                    return false;
                }
            }
            boolean this_present_ns = this.isSetNs();
            boolean that_present_ns = that.isSetNs();
            if (this_present_ns || that_present_ns) {
                if (!this_present_ns || !that_present_ns) {
                    return false;
                }
                if (!this.ns.equals(that.ns)) {
                    return false;
                }
            }
            boolean this_present_property = this.isSetProperty();
            boolean that_present_property = that.isSetProperty();
            if (this_present_property || that_present_property) {
                if (!this_present_property || !that_present_property) {
                    return false;
                }
                if (!this.property.equals(that.property)) {
                    return false;
                }
            }
            return true;
        }

        public int hashCode() {
            return 0;
        }

        public int compareTo(removeNamespaceProperty_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            removeNamespaceProperty_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetTinfo()).compareTo(typedOther.isSetTinfo());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetTinfo() && (lastComparison = TBaseHelper.compareTo((Comparable)this.tinfo, (Comparable)typedOther.tinfo)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetCredentials()).compareTo(typedOther.isSetCredentials());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetCredentials() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.credentials), (Comparable)((Object)typedOther.credentials))) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetNs()).compareTo(typedOther.isSetNs());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetNs() && (lastComparison = TBaseHelper.compareTo((String)this.ns, (String)typedOther.ns)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetProperty()).compareTo(typedOther.isSetProperty());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetProperty() && (lastComparison = TBaseHelper.compareTo((String)this.property, (String)typedOther.property)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        public _Fields fieldForId(int fieldId) {
            return _Fields.findByThriftId(fieldId);
        }

        public void read(TProtocol iprot) throws TException {
            schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
        }

        public void write(TProtocol oprot) throws TException {
            schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("removeNamespaceProperty_args(");
            boolean first = true;
            sb.append("tinfo:");
            if (this.tinfo == null) {
                sb.append("null");
            } else {
                sb.append(this.tinfo);
            }
            first = false;
            if (!first) {
                sb.append(", ");
            }
            sb.append("credentials:");
            if (this.credentials == null) {
                sb.append("null");
            } else {
                sb.append(this.credentials);
            }
            first = false;
            if (!first) {
                sb.append(", ");
            }
            sb.append("ns:");
            if (this.ns == null) {
                sb.append("null");
            } else {
                sb.append(this.ns);
            }
            first = false;
            if (!first) {
                sb.append(", ");
            }
            sb.append("property:");
            if (this.property == null) {
                sb.append("null");
            } else {
                sb.append(this.property);
            }
            first = false;
            sb.append(")");
            return sb.toString();
        }

        public void validate() throws TException {
            if (this.tinfo != null) {
                this.tinfo.validate();
            }
            if (this.credentials != null) {
                this.credentials.validate();
            }
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            try {
                this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
            }
            catch (TException te) {
                throw new IOException(te);
            }
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            try {
                this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
            }
            catch (TException te) {
                throw new IOException(te);
            }
        }

        static {
            schemes.put(StandardScheme.class, new removeNamespaceProperty_argsStandardSchemeFactory());
            schemes.put(TupleScheme.class, new removeNamespaceProperty_argsTupleSchemeFactory());
            EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
            tmpMap.put(_Fields.TINFO, new FieldMetaData("tinfo", 3, (FieldValueMetaData)new StructMetaData(12, TInfo.class)));
            tmpMap.put(_Fields.CREDENTIALS, new FieldMetaData("credentials", 3, (FieldValueMetaData)new StructMetaData(12, TCredentials.class)));
            tmpMap.put(_Fields.NS, new FieldMetaData("ns", 3, new FieldValueMetaData(11)));
            tmpMap.put(_Fields.PROPERTY, new FieldMetaData("property", 3, new FieldValueMetaData(11)));
            metaDataMap = Collections.unmodifiableMap(tmpMap);
            FieldMetaData.addStructMetaDataMap(removeNamespaceProperty_args.class, metaDataMap);
        }

        private static class removeNamespaceProperty_argsTupleScheme
        extends TupleScheme<removeNamespaceProperty_args> {
            private removeNamespaceProperty_argsTupleScheme() {
            }

            public void write(TProtocol prot, removeNamespaceProperty_args struct) throws TException {
                TTupleProtocol oprot = (TTupleProtocol)prot;
                BitSet optionals = new BitSet();
                if (struct.isSetTinfo()) {
                    optionals.set(0);
                }
                if (struct.isSetCredentials()) {
                    optionals.set(1);
                }
                if (struct.isSetNs()) {
                    optionals.set(2);
                }
                if (struct.isSetProperty()) {
                    optionals.set(3);
                }
                oprot.writeBitSet(optionals, 4);
                if (struct.isSetTinfo()) {
                    struct.tinfo.write((TProtocol)oprot);
                }
                if (struct.isSetCredentials()) {
                    struct.credentials.write((TProtocol)oprot);
                }
                if (struct.isSetNs()) {
                    oprot.writeString(struct.ns);
                }
                if (struct.isSetProperty()) {
                    oprot.writeString(struct.property);
                }
            }

            public void read(TProtocol prot, removeNamespaceProperty_args struct) throws TException {
                TTupleProtocol iprot = (TTupleProtocol)prot;
                BitSet incoming = iprot.readBitSet(4);
                if (incoming.get(0)) {
                    struct.tinfo = new TInfo();
                    struct.tinfo.read((TProtocol)iprot);
                    struct.setTinfoIsSet(true);
                }
                if (incoming.get(1)) {
                    struct.credentials = new TCredentials();
                    struct.credentials.read((TProtocol)iprot);
                    struct.setCredentialsIsSet(true);
                }
                if (incoming.get(2)) {
                    struct.ns = iprot.readString();
                    struct.setNsIsSet(true);
                }
                if (incoming.get(3)) {
                    struct.property = iprot.readString();
                    struct.setPropertyIsSet(true);
                }
            }
        }

        private static class removeNamespaceProperty_argsTupleSchemeFactory
        implements SchemeFactory {
            private removeNamespaceProperty_argsTupleSchemeFactory() {
            }

            public removeNamespaceProperty_argsTupleScheme getScheme() {
                return new removeNamespaceProperty_argsTupleScheme();
            }
        }

        private static class removeNamespaceProperty_argsStandardScheme
        extends StandardScheme<removeNamespaceProperty_args> {
            private removeNamespaceProperty_argsStandardScheme() {
            }

            public void read(TProtocol iprot, removeNamespaceProperty_args struct) throws TException {
                iprot.readStructBegin();
                while (true) {
                    TField schemeField = iprot.readFieldBegin();
                    if (schemeField.type == 0) break;
                    switch (schemeField.id) {
                        case 4: {
                            if (schemeField.type == 12) {
                                struct.tinfo = new TInfo();
                                struct.tinfo.read(iprot);
                                struct.setTinfoIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        case 1: {
                            if (schemeField.type == 12) {
                                struct.credentials = new TCredentials();
                                struct.credentials.read(iprot);
                                struct.setCredentialsIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        case 2: {
                            if (schemeField.type == 11) {
                                struct.ns = iprot.readString();
                                struct.setNsIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        case 3: {
                            if (schemeField.type == 11) {
                                struct.property = iprot.readString();
                                struct.setPropertyIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        default: {
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        }
                    }
                    iprot.readFieldEnd();
                }
                iprot.readStructEnd();
                struct.validate();
            }

            public void write(TProtocol oprot, removeNamespaceProperty_args struct) throws TException {
                struct.validate();
                oprot.writeStructBegin(STRUCT_DESC);
                if (struct.credentials != null) {
                    oprot.writeFieldBegin(CREDENTIALS_FIELD_DESC);
                    struct.credentials.write(oprot);
                    oprot.writeFieldEnd();
                }
                if (struct.ns != null) {
                    oprot.writeFieldBegin(NS_FIELD_DESC);
                    oprot.writeString(struct.ns);
                    oprot.writeFieldEnd();
                }
                if (struct.property != null) {
                    oprot.writeFieldBegin(PROPERTY_FIELD_DESC);
                    oprot.writeString(struct.property);
                    oprot.writeFieldEnd();
                }
                if (struct.tinfo != null) {
                    oprot.writeFieldBegin(TINFO_FIELD_DESC);
                    struct.tinfo.write(oprot);
                    oprot.writeFieldEnd();
                }
                oprot.writeFieldStop();
                oprot.writeStructEnd();
            }
        }

        private static class removeNamespaceProperty_argsStandardSchemeFactory
        implements SchemeFactory {
            private removeNamespaceProperty_argsStandardSchemeFactory() {
            }

            public removeNamespaceProperty_argsStandardScheme getScheme() {
                return new removeNamespaceProperty_argsStandardScheme();
            }
        }

        public static enum _Fields implements TFieldIdEnum
        {
            TINFO(4, "tinfo"),
            CREDENTIALS(1, "credentials"),
            NS(2, "ns"),
            PROPERTY(3, "property");

            private static final Map<String, _Fields> byName;
            private final short _thriftId;
            private final String _fieldName;

            public static _Fields findByThriftId(int fieldId) {
                switch (fieldId) {
                    case 4: {
                        return TINFO;
                    }
                    case 1: {
                        return CREDENTIALS;
                    }
                    case 2: {
                        return NS;
                    }
                    case 3: {
                        return PROPERTY;
                    }
                }
                return null;
            }

            public static _Fields findByThriftIdOrThrow(int fieldId) {
                _Fields fields = _Fields.findByThriftId(fieldId);
                if (fields == null) {
                    throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
                }
                return fields;
            }

            public static _Fields findByName(String name) {
                return byName.get(name);
            }

            private _Fields(short thriftId, String fieldName) {
                this._thriftId = thriftId;
                this._fieldName = fieldName;
            }

            public short getThriftFieldId() {
                return this._thriftId;
            }

            public String getFieldName() {
                return this._fieldName;
            }

            static {
                byName = new HashMap<String, _Fields>();
                for (_Fields field : EnumSet.allOf(_Fields.class)) {
                    byName.put(field.getFieldName(), field);
                }
            }
        }
    }

    public static class setNamespaceProperty_result
    implements TBase<setNamespaceProperty_result, _Fields>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("setNamespaceProperty_result");
        private static final TField SEC_FIELD_DESC = new TField("sec", 12, 1);
        private static final TField TOPE_FIELD_DESC = new TField("tope", 12, 2);
        private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
        public ThriftSecurityException sec;
        public ThriftTableOperationException tope;
        public static final Map<_Fields, FieldMetaData> metaDataMap;

        public setNamespaceProperty_result() {
        }

        public setNamespaceProperty_result(ThriftSecurityException sec, ThriftTableOperationException tope) {
            this();
            this.sec = sec;
            this.tope = tope;
        }

        public setNamespaceProperty_result(setNamespaceProperty_result other) {
            if (other.isSetSec()) {
                this.sec = new ThriftSecurityException(other.sec);
            }
            if (other.isSetTope()) {
                this.tope = new ThriftTableOperationException(other.tope);
            }
        }

        public setNamespaceProperty_result deepCopy() {
            return new setNamespaceProperty_result(this);
        }

        public void clear() {
            this.sec = null;
            this.tope = null;
        }

        public ThriftSecurityException getSec() {
            return this.sec;
        }

        public setNamespaceProperty_result setSec(ThriftSecurityException sec) {
            this.sec = sec;
            return this;
        }

        public void unsetSec() {
            this.sec = null;
        }

        public boolean isSetSec() {
            return this.sec != null;
        }

        public void setSecIsSet(boolean value) {
            if (!value) {
                this.sec = null;
            }
        }

        public ThriftTableOperationException getTope() {
            return this.tope;
        }

        public setNamespaceProperty_result setTope(ThriftTableOperationException tope) {
            this.tope = tope;
            return this;
        }

        public void unsetTope() {
            this.tope = null;
        }

        public boolean isSetTope() {
            return this.tope != null;
        }

        public void setTopeIsSet(boolean value) {
            if (!value) {
                this.tope = null;
            }
        }

        public void setFieldValue(_Fields field, Object value) {
            switch (field) {
                case SEC: {
                    if (value == null) {
                        this.unsetSec();
                        break;
                    }
                    this.setSec((ThriftSecurityException)value);
                    break;
                }
                case TOPE: {
                    if (value == null) {
                        this.unsetTope();
                        break;
                    }
                    this.setTope((ThriftTableOperationException)value);
                }
            }
        }

        public Object getFieldValue(_Fields field) {
            switch (field) {
                case SEC: {
                    return this.getSec();
                }
                case TOPE: {
                    return this.getTope();
                }
            }
            throw new IllegalStateException();
        }

        public boolean isSet(_Fields field) {
            if (field == null) {
                throw new IllegalArgumentException();
            }
            switch (field) {
                case SEC: {
                    return this.isSetSec();
                }
                case TOPE: {
                    return this.isSetTope();
                }
            }
            throw new IllegalStateException();
        }

        public boolean equals(Object that) {
            if (that == null) {
                return false;
            }
            if (that instanceof setNamespaceProperty_result) {
                return this.equals((setNamespaceProperty_result)that);
            }
            return false;
        }

        public boolean equals(setNamespaceProperty_result that) {
            if (that == null) {
                return false;
            }
            boolean this_present_sec = this.isSetSec();
            boolean that_present_sec = that.isSetSec();
            if (this_present_sec || that_present_sec) {
                if (!this_present_sec || !that_present_sec) {
                    return false;
                }
                if (!this.sec.equals(that.sec)) {
                    return false;
                }
            }
            boolean this_present_tope = this.isSetTope();
            boolean that_present_tope = that.isSetTope();
            if (this_present_tope || that_present_tope) {
                if (!this_present_tope || !that_present_tope) {
                    return false;
                }
                if (!this.tope.equals(that.tope)) {
                    return false;
                }
            }
            return true;
        }

        public int hashCode() {
            return 0;
        }

        public int compareTo(setNamespaceProperty_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            setNamespaceProperty_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSec()).compareTo(typedOther.isSetSec());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSec() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.sec), (Comparable)((Object)typedOther.sec))) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetTope()).compareTo(typedOther.isSetTope());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetTope() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.tope), (Comparable)((Object)typedOther.tope))) != 0) {
                return lastComparison;
            }
            return 0;
        }

        public _Fields fieldForId(int fieldId) {
            return _Fields.findByThriftId(fieldId);
        }

        public void read(TProtocol iprot) throws TException {
            schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
        }

        public void write(TProtocol oprot) throws TException {
            schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("setNamespaceProperty_result(");
            boolean first = true;
            sb.append("sec:");
            if (this.sec == null) {
                sb.append("null");
            } else {
                sb.append(this.sec);
            }
            first = false;
            if (!first) {
                sb.append(", ");
            }
            sb.append("tope:");
            if (this.tope == null) {
                sb.append("null");
            } else {
                sb.append(this.tope);
            }
            first = false;
            sb.append(")");
            return sb.toString();
        }

        public void validate() throws TException {
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            try {
                this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
            }
            catch (TException te) {
                throw new IOException(te);
            }
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            try {
                this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
            }
            catch (TException te) {
                throw new IOException(te);
            }
        }

        static {
            schemes.put(StandardScheme.class, new setNamespaceProperty_resultStandardSchemeFactory());
            schemes.put(TupleScheme.class, new setNamespaceProperty_resultTupleSchemeFactory());
            EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
            tmpMap.put(_Fields.SEC, new FieldMetaData("sec", 3, new FieldValueMetaData(12)));
            tmpMap.put(_Fields.TOPE, new FieldMetaData("tope", 3, new FieldValueMetaData(12)));
            metaDataMap = Collections.unmodifiableMap(tmpMap);
            FieldMetaData.addStructMetaDataMap(setNamespaceProperty_result.class, metaDataMap);
        }

        private static class setNamespaceProperty_resultTupleScheme
        extends TupleScheme<setNamespaceProperty_result> {
            private setNamespaceProperty_resultTupleScheme() {
            }

            public void write(TProtocol prot, setNamespaceProperty_result struct) throws TException {
                TTupleProtocol oprot = (TTupleProtocol)prot;
                BitSet optionals = new BitSet();
                if (struct.isSetSec()) {
                    optionals.set(0);
                }
                if (struct.isSetTope()) {
                    optionals.set(1);
                }
                oprot.writeBitSet(optionals, 2);
                if (struct.isSetSec()) {
                    struct.sec.write((TProtocol)oprot);
                }
                if (struct.isSetTope()) {
                    struct.tope.write((TProtocol)oprot);
                }
            }

            public void read(TProtocol prot, setNamespaceProperty_result struct) throws TException {
                TTupleProtocol iprot = (TTupleProtocol)prot;
                BitSet incoming = iprot.readBitSet(2);
                if (incoming.get(0)) {
                    struct.sec = new ThriftSecurityException();
                    struct.sec.read((TProtocol)iprot);
                    struct.setSecIsSet(true);
                }
                if (incoming.get(1)) {
                    struct.tope = new ThriftTableOperationException();
                    struct.tope.read((TProtocol)iprot);
                    struct.setTopeIsSet(true);
                }
            }
        }

        private static class setNamespaceProperty_resultTupleSchemeFactory
        implements SchemeFactory {
            private setNamespaceProperty_resultTupleSchemeFactory() {
            }

            public setNamespaceProperty_resultTupleScheme getScheme() {
                return new setNamespaceProperty_resultTupleScheme();
            }
        }

        private static class setNamespaceProperty_resultStandardScheme
        extends StandardScheme<setNamespaceProperty_result> {
            private setNamespaceProperty_resultStandardScheme() {
            }

            public void read(TProtocol iprot, setNamespaceProperty_result struct) throws TException {
                iprot.readStructBegin();
                while (true) {
                    TField schemeField = iprot.readFieldBegin();
                    if (schemeField.type == 0) break;
                    switch (schemeField.id) {
                        case 1: {
                            if (schemeField.type == 12) {
                                struct.sec = new ThriftSecurityException();
                                struct.sec.read(iprot);
                                struct.setSecIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        case 2: {
                            if (schemeField.type == 12) {
                                struct.tope = new ThriftTableOperationException();
                                struct.tope.read(iprot);
                                struct.setTopeIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        default: {
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        }
                    }
                    iprot.readFieldEnd();
                }
                iprot.readStructEnd();
                struct.validate();
            }

            public void write(TProtocol oprot, setNamespaceProperty_result struct) throws TException {
                struct.validate();
                oprot.writeStructBegin(STRUCT_DESC);
                if (struct.sec != null) {
                    oprot.writeFieldBegin(SEC_FIELD_DESC);
                    struct.sec.write(oprot);
                    oprot.writeFieldEnd();
                }
                if (struct.tope != null) {
                    oprot.writeFieldBegin(TOPE_FIELD_DESC);
                    struct.tope.write(oprot);
                    oprot.writeFieldEnd();
                }
                oprot.writeFieldStop();
                oprot.writeStructEnd();
            }
        }

        private static class setNamespaceProperty_resultStandardSchemeFactory
        implements SchemeFactory {
            private setNamespaceProperty_resultStandardSchemeFactory() {
            }

            public setNamespaceProperty_resultStandardScheme getScheme() {
                return new setNamespaceProperty_resultStandardScheme();
            }
        }

        public static enum _Fields implements TFieldIdEnum
        {
            SEC(1, "sec"),
            TOPE(2, "tope");

            private static final Map<String, _Fields> byName;
            private final short _thriftId;
            private final String _fieldName;

            public static _Fields findByThriftId(int fieldId) {
                switch (fieldId) {
                    case 1: {
                        return SEC;
                    }
                    case 2: {
                        return TOPE;
                    }
                }
                return null;
            }

            public static _Fields findByThriftIdOrThrow(int fieldId) {
                _Fields fields = _Fields.findByThriftId(fieldId);
                if (fields == null) {
                    throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
                }
                return fields;
            }

            public static _Fields findByName(String name) {
                return byName.get(name);
            }

            private _Fields(short thriftId, String fieldName) {
                this._thriftId = thriftId;
                this._fieldName = fieldName;
            }

            public short getThriftFieldId() {
                return this._thriftId;
            }

            public String getFieldName() {
                return this._fieldName;
            }

            static {
                byName = new HashMap<String, _Fields>();
                for (_Fields field : EnumSet.allOf(_Fields.class)) {
                    byName.put(field.getFieldName(), field);
                }
            }
        }
    }

    public static class setNamespaceProperty_args
    implements TBase<setNamespaceProperty_args, _Fields>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("setNamespaceProperty_args");
        private static final TField TINFO_FIELD_DESC = new TField("tinfo", 12, 5);
        private static final TField CREDENTIALS_FIELD_DESC = new TField("credentials", 12, 1);
        private static final TField NS_FIELD_DESC = new TField("ns", 11, 2);
        private static final TField PROPERTY_FIELD_DESC = new TField("property", 11, 3);
        private static final TField VALUE_FIELD_DESC = new TField("value", 11, 4);
        private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
        public TInfo tinfo;
        public TCredentials credentials;
        public String ns;
        public String property;
        public String value;
        public static final Map<_Fields, FieldMetaData> metaDataMap;

        public setNamespaceProperty_args() {
        }

        public setNamespaceProperty_args(TInfo tinfo, TCredentials credentials, String ns, String property, String value) {
            this();
            this.tinfo = tinfo;
            this.credentials = credentials;
            this.ns = ns;
            this.property = property;
            this.value = value;
        }

        public setNamespaceProperty_args(setNamespaceProperty_args other) {
            if (other.isSetTinfo()) {
                this.tinfo = new TInfo(other.tinfo);
            }
            if (other.isSetCredentials()) {
                this.credentials = new TCredentials(other.credentials);
            }
            if (other.isSetNs()) {
                this.ns = other.ns;
            }
            if (other.isSetProperty()) {
                this.property = other.property;
            }
            if (other.isSetValue()) {
                this.value = other.value;
            }
        }

        public setNamespaceProperty_args deepCopy() {
            return new setNamespaceProperty_args(this);
        }

        public void clear() {
            this.tinfo = null;
            this.credentials = null;
            this.ns = null;
            this.property = null;
            this.value = null;
        }

        public TInfo getTinfo() {
            return this.tinfo;
        }

        public setNamespaceProperty_args setTinfo(TInfo tinfo) {
            this.tinfo = tinfo;
            return this;
        }

        public void unsetTinfo() {
            this.tinfo = null;
        }

        public boolean isSetTinfo() {
            return this.tinfo != null;
        }

        public void setTinfoIsSet(boolean value) {
            if (!value) {
                this.tinfo = null;
            }
        }

        public TCredentials getCredentials() {
            return this.credentials;
        }

        public setNamespaceProperty_args setCredentials(TCredentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public void unsetCredentials() {
            this.credentials = null;
        }

        public boolean isSetCredentials() {
            return this.credentials != null;
        }

        public void setCredentialsIsSet(boolean value) {
            if (!value) {
                this.credentials = null;
            }
        }

        public String getNs() {
            return this.ns;
        }

        public setNamespaceProperty_args setNs(String ns) {
            this.ns = ns;
            return this;
        }

        public void unsetNs() {
            this.ns = null;
        }

        public boolean isSetNs() {
            return this.ns != null;
        }

        public void setNsIsSet(boolean value) {
            if (!value) {
                this.ns = null;
            }
        }

        public String getProperty() {
            return this.property;
        }

        public setNamespaceProperty_args setProperty(String property) {
            this.property = property;
            return this;
        }

        public void unsetProperty() {
            this.property = null;
        }

        public boolean isSetProperty() {
            return this.property != null;
        }

        public void setPropertyIsSet(boolean value) {
            if (!value) {
                this.property = null;
            }
        }

        public String getValue() {
            return this.value;
        }

        public setNamespaceProperty_args setValue(String value) {
            this.value = value;
            return this;
        }

        public void unsetValue() {
            this.value = null;
        }

        public boolean isSetValue() {
            return this.value != null;
        }

        public void setValueIsSet(boolean value) {
            if (!value) {
                this.value = null;
            }
        }

        public void setFieldValue(_Fields field, Object value) {
            switch (field) {
                case TINFO: {
                    if (value == null) {
                        this.unsetTinfo();
                        break;
                    }
                    this.setTinfo((TInfo)value);
                    break;
                }
                case CREDENTIALS: {
                    if (value == null) {
                        this.unsetCredentials();
                        break;
                    }
                    this.setCredentials((TCredentials)value);
                    break;
                }
                case NS: {
                    if (value == null) {
                        this.unsetNs();
                        break;
                    }
                    this.setNs((String)value);
                    break;
                }
                case PROPERTY: {
                    if (value == null) {
                        this.unsetProperty();
                        break;
                    }
                    this.setProperty((String)value);
                    break;
                }
                case VALUE: {
                    if (value == null) {
                        this.unsetValue();
                        break;
                    }
                    this.setValue((String)value);
                }
            }
        }

        public Object getFieldValue(_Fields field) {
            switch (field) {
                case TINFO: {
                    return this.getTinfo();
                }
                case CREDENTIALS: {
                    return this.getCredentials();
                }
                case NS: {
                    return this.getNs();
                }
                case PROPERTY: {
                    return this.getProperty();
                }
                case VALUE: {
                    return this.getValue();
                }
            }
            throw new IllegalStateException();
        }

        public boolean isSet(_Fields field) {
            if (field == null) {
                throw new IllegalArgumentException();
            }
            switch (field) {
                case TINFO: {
                    return this.isSetTinfo();
                }
                case CREDENTIALS: {
                    return this.isSetCredentials();
                }
                case NS: {
                    return this.isSetNs();
                }
                case PROPERTY: {
                    return this.isSetProperty();
                }
                case VALUE: {
                    return this.isSetValue();
                }
            }
            throw new IllegalStateException();
        }

        public boolean equals(Object that) {
            if (that == null) {
                return false;
            }
            if (that instanceof setNamespaceProperty_args) {
                return this.equals((setNamespaceProperty_args)that);
            }
            return false;
        }

        public boolean equals(setNamespaceProperty_args that) {
            if (that == null) {
                return false;
            }
            boolean this_present_tinfo = this.isSetTinfo();
            boolean that_present_tinfo = that.isSetTinfo();
            if (this_present_tinfo || that_present_tinfo) {
                if (!this_present_tinfo || !that_present_tinfo) {
                    return false;
                }
                if (!this.tinfo.equals(that.tinfo)) {
                    return false;
                }
            }
            boolean this_present_credentials = this.isSetCredentials();
            boolean that_present_credentials = that.isSetCredentials();
            if (this_present_credentials || that_present_credentials) {
                if (!this_present_credentials || !that_present_credentials) {
                    return false;
                }
                if (!this.credentials.equals(that.credentials)) {
                    return false;
                }
            }
            boolean this_present_ns = this.isSetNs();
            boolean that_present_ns = that.isSetNs();
            if (this_present_ns || that_present_ns) {
                if (!this_present_ns || !that_present_ns) {
                    return false;
                }
                if (!this.ns.equals(that.ns)) {
                    return false;
                }
            }
            boolean this_present_property = this.isSetProperty();
            boolean that_present_property = that.isSetProperty();
            if (this_present_property || that_present_property) {
                if (!this_present_property || !that_present_property) {
                    return false;
                }
                if (!this.property.equals(that.property)) {
                    return false;
                }
            }
            boolean this_present_value = this.isSetValue();
            boolean that_present_value = that.isSetValue();
            if (this_present_value || that_present_value) {
                if (!this_present_value || !that_present_value) {
                    return false;
                }
                if (!this.value.equals(that.value)) {
                    return false;
                }
            }
            return true;
        }

        public int hashCode() {
            return 0;
        }

        public int compareTo(setNamespaceProperty_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            setNamespaceProperty_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetTinfo()).compareTo(typedOther.isSetTinfo());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetTinfo() && (lastComparison = TBaseHelper.compareTo((Comparable)this.tinfo, (Comparable)typedOther.tinfo)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetCredentials()).compareTo(typedOther.isSetCredentials());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetCredentials() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.credentials), (Comparable)((Object)typedOther.credentials))) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetNs()).compareTo(typedOther.isSetNs());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetNs() && (lastComparison = TBaseHelper.compareTo((String)this.ns, (String)typedOther.ns)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetProperty()).compareTo(typedOther.isSetProperty());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetProperty() && (lastComparison = TBaseHelper.compareTo((String)this.property, (String)typedOther.property)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetValue()).compareTo(typedOther.isSetValue());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetValue() && (lastComparison = TBaseHelper.compareTo((String)this.value, (String)typedOther.value)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        public _Fields fieldForId(int fieldId) {
            return _Fields.findByThriftId(fieldId);
        }

        public void read(TProtocol iprot) throws TException {
            schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
        }

        public void write(TProtocol oprot) throws TException {
            schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("setNamespaceProperty_args(");
            boolean first = true;
            sb.append("tinfo:");
            if (this.tinfo == null) {
                sb.append("null");
            } else {
                sb.append(this.tinfo);
            }
            first = false;
            if (!first) {
                sb.append(", ");
            }
            sb.append("credentials:");
            if (this.credentials == null) {
                sb.append("null");
            } else {
                sb.append(this.credentials);
            }
            first = false;
            if (!first) {
                sb.append(", ");
            }
            sb.append("ns:");
            if (this.ns == null) {
                sb.append("null");
            } else {
                sb.append(this.ns);
            }
            first = false;
            if (!first) {
                sb.append(", ");
            }
            sb.append("property:");
            if (this.property == null) {
                sb.append("null");
            } else {
                sb.append(this.property);
            }
            first = false;
            if (!first) {
                sb.append(", ");
            }
            sb.append("value:");
            if (this.value == null) {
                sb.append("null");
            } else {
                sb.append(this.value);
            }
            first = false;
            sb.append(")");
            return sb.toString();
        }

        public void validate() throws TException {
            if (this.tinfo != null) {
                this.tinfo.validate();
            }
            if (this.credentials != null) {
                this.credentials.validate();
            }
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            try {
                this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
            }
            catch (TException te) {
                throw new IOException(te);
            }
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            try {
                this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
            }
            catch (TException te) {
                throw new IOException(te);
            }
        }

        static {
            schemes.put(StandardScheme.class, new setNamespaceProperty_argsStandardSchemeFactory());
            schemes.put(TupleScheme.class, new setNamespaceProperty_argsTupleSchemeFactory());
            EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
            tmpMap.put(_Fields.TINFO, new FieldMetaData("tinfo", 3, (FieldValueMetaData)new StructMetaData(12, TInfo.class)));
            tmpMap.put(_Fields.CREDENTIALS, new FieldMetaData("credentials", 3, (FieldValueMetaData)new StructMetaData(12, TCredentials.class)));
            tmpMap.put(_Fields.NS, new FieldMetaData("ns", 3, new FieldValueMetaData(11)));
            tmpMap.put(_Fields.PROPERTY, new FieldMetaData("property", 3, new FieldValueMetaData(11)));
            tmpMap.put(_Fields.VALUE, new FieldMetaData("value", 3, new FieldValueMetaData(11)));
            metaDataMap = Collections.unmodifiableMap(tmpMap);
            FieldMetaData.addStructMetaDataMap(setNamespaceProperty_args.class, metaDataMap);
        }

        private static class setNamespaceProperty_argsTupleScheme
        extends TupleScheme<setNamespaceProperty_args> {
            private setNamespaceProperty_argsTupleScheme() {
            }

            public void write(TProtocol prot, setNamespaceProperty_args struct) throws TException {
                TTupleProtocol oprot = (TTupleProtocol)prot;
                BitSet optionals = new BitSet();
                if (struct.isSetTinfo()) {
                    optionals.set(0);
                }
                if (struct.isSetCredentials()) {
                    optionals.set(1);
                }
                if (struct.isSetNs()) {
                    optionals.set(2);
                }
                if (struct.isSetProperty()) {
                    optionals.set(3);
                }
                if (struct.isSetValue()) {
                    optionals.set(4);
                }
                oprot.writeBitSet(optionals, 5);
                if (struct.isSetTinfo()) {
                    struct.tinfo.write((TProtocol)oprot);
                }
                if (struct.isSetCredentials()) {
                    struct.credentials.write((TProtocol)oprot);
                }
                if (struct.isSetNs()) {
                    oprot.writeString(struct.ns);
                }
                if (struct.isSetProperty()) {
                    oprot.writeString(struct.property);
                }
                if (struct.isSetValue()) {
                    oprot.writeString(struct.value);
                }
            }

            public void read(TProtocol prot, setNamespaceProperty_args struct) throws TException {
                TTupleProtocol iprot = (TTupleProtocol)prot;
                BitSet incoming = iprot.readBitSet(5);
                if (incoming.get(0)) {
                    struct.tinfo = new TInfo();
                    struct.tinfo.read((TProtocol)iprot);
                    struct.setTinfoIsSet(true);
                }
                if (incoming.get(1)) {
                    struct.credentials = new TCredentials();
                    struct.credentials.read((TProtocol)iprot);
                    struct.setCredentialsIsSet(true);
                }
                if (incoming.get(2)) {
                    struct.ns = iprot.readString();
                    struct.setNsIsSet(true);
                }
                if (incoming.get(3)) {
                    struct.property = iprot.readString();
                    struct.setPropertyIsSet(true);
                }
                if (incoming.get(4)) {
                    struct.value = iprot.readString();
                    struct.setValueIsSet(true);
                }
            }
        }

        private static class setNamespaceProperty_argsTupleSchemeFactory
        implements SchemeFactory {
            private setNamespaceProperty_argsTupleSchemeFactory() {
            }

            public setNamespaceProperty_argsTupleScheme getScheme() {
                return new setNamespaceProperty_argsTupleScheme();
            }
        }

        private static class setNamespaceProperty_argsStandardScheme
        extends StandardScheme<setNamespaceProperty_args> {
            private setNamespaceProperty_argsStandardScheme() {
            }

            public void read(TProtocol iprot, setNamespaceProperty_args struct) throws TException {
                iprot.readStructBegin();
                while (true) {
                    TField schemeField = iprot.readFieldBegin();
                    if (schemeField.type == 0) break;
                    switch (schemeField.id) {
                        case 5: {
                            if (schemeField.type == 12) {
                                struct.tinfo = new TInfo();
                                struct.tinfo.read(iprot);
                                struct.setTinfoIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        case 1: {
                            if (schemeField.type == 12) {
                                struct.credentials = new TCredentials();
                                struct.credentials.read(iprot);
                                struct.setCredentialsIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        case 2: {
                            if (schemeField.type == 11) {
                                struct.ns = iprot.readString();
                                struct.setNsIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        case 3: {
                            if (schemeField.type == 11) {
                                struct.property = iprot.readString();
                                struct.setPropertyIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        case 4: {
                            if (schemeField.type == 11) {
                                struct.value = iprot.readString();
                                struct.setValueIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        default: {
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        }
                    }
                    iprot.readFieldEnd();
                }
                iprot.readStructEnd();
                struct.validate();
            }

            public void write(TProtocol oprot, setNamespaceProperty_args struct) throws TException {
                struct.validate();
                oprot.writeStructBegin(STRUCT_DESC);
                if (struct.credentials != null) {
                    oprot.writeFieldBegin(CREDENTIALS_FIELD_DESC);
                    struct.credentials.write(oprot);
                    oprot.writeFieldEnd();
                }
                if (struct.ns != null) {
                    oprot.writeFieldBegin(NS_FIELD_DESC);
                    oprot.writeString(struct.ns);
                    oprot.writeFieldEnd();
                }
                if (struct.property != null) {
                    oprot.writeFieldBegin(PROPERTY_FIELD_DESC);
                    oprot.writeString(struct.property);
                    oprot.writeFieldEnd();
                }
                if (struct.value != null) {
                    oprot.writeFieldBegin(VALUE_FIELD_DESC);
                    oprot.writeString(struct.value);
                    oprot.writeFieldEnd();
                }
                if (struct.tinfo != null) {
                    oprot.writeFieldBegin(TINFO_FIELD_DESC);
                    struct.tinfo.write(oprot);
                    oprot.writeFieldEnd();
                }
                oprot.writeFieldStop();
                oprot.writeStructEnd();
            }
        }

        private static class setNamespaceProperty_argsStandardSchemeFactory
        implements SchemeFactory {
            private setNamespaceProperty_argsStandardSchemeFactory() {
            }

            public setNamespaceProperty_argsStandardScheme getScheme() {
                return new setNamespaceProperty_argsStandardScheme();
            }
        }

        public static enum _Fields implements TFieldIdEnum
        {
            TINFO(5, "tinfo"),
            CREDENTIALS(1, "credentials"),
            NS(2, "ns"),
            PROPERTY(3, "property"),
            VALUE(4, "value");

            private static final Map<String, _Fields> byName;
            private final short _thriftId;
            private final String _fieldName;

            public static _Fields findByThriftId(int fieldId) {
                switch (fieldId) {
                    case 5: {
                        return TINFO;
                    }
                    case 1: {
                        return CREDENTIALS;
                    }
                    case 2: {
                        return NS;
                    }
                    case 3: {
                        return PROPERTY;
                    }
                    case 4: {
                        return VALUE;
                    }
                }
                return null;
            }

            public static _Fields findByThriftIdOrThrow(int fieldId) {
                _Fields fields = _Fields.findByThriftId(fieldId);
                if (fields == null) {
                    throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
                }
                return fields;
            }

            public static _Fields findByName(String name) {
                return byName.get(name);
            }

            private _Fields(short thriftId, String fieldName) {
                this._thriftId = thriftId;
                this._fieldName = fieldName;
            }

            public short getThriftFieldId() {
                return this._thriftId;
            }

            public String getFieldName() {
                return this._fieldName;
            }

            static {
                byName = new HashMap<String, _Fields>();
                for (_Fields field : EnumSet.allOf(_Fields.class)) {
                    byName.put(field.getFieldName(), field);
                }
            }
        }
    }

    public static class removeTableProperty_result
    implements TBase<removeTableProperty_result, _Fields>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("removeTableProperty_result");
        private static final TField SEC_FIELD_DESC = new TField("sec", 12, 1);
        private static final TField TOPE_FIELD_DESC = new TField("tope", 12, 2);
        private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
        public ThriftSecurityException sec;
        public ThriftTableOperationException tope;
        public static final Map<_Fields, FieldMetaData> metaDataMap;

        public removeTableProperty_result() {
        }

        public removeTableProperty_result(ThriftSecurityException sec, ThriftTableOperationException tope) {
            this();
            this.sec = sec;
            this.tope = tope;
        }

        public removeTableProperty_result(removeTableProperty_result other) {
            if (other.isSetSec()) {
                this.sec = new ThriftSecurityException(other.sec);
            }
            if (other.isSetTope()) {
                this.tope = new ThriftTableOperationException(other.tope);
            }
        }

        public removeTableProperty_result deepCopy() {
            return new removeTableProperty_result(this);
        }

        public void clear() {
            this.sec = null;
            this.tope = null;
        }

        public ThriftSecurityException getSec() {
            return this.sec;
        }

        public removeTableProperty_result setSec(ThriftSecurityException sec) {
            this.sec = sec;
            return this;
        }

        public void unsetSec() {
            this.sec = null;
        }

        public boolean isSetSec() {
            return this.sec != null;
        }

        public void setSecIsSet(boolean value) {
            if (!value) {
                this.sec = null;
            }
        }

        public ThriftTableOperationException getTope() {
            return this.tope;
        }

        public removeTableProperty_result setTope(ThriftTableOperationException tope) {
            this.tope = tope;
            return this;
        }

        public void unsetTope() {
            this.tope = null;
        }

        public boolean isSetTope() {
            return this.tope != null;
        }

        public void setTopeIsSet(boolean value) {
            if (!value) {
                this.tope = null;
            }
        }

        public void setFieldValue(_Fields field, Object value) {
            switch (field) {
                case SEC: {
                    if (value == null) {
                        this.unsetSec();
                        break;
                    }
                    this.setSec((ThriftSecurityException)value);
                    break;
                }
                case TOPE: {
                    if (value == null) {
                        this.unsetTope();
                        break;
                    }
                    this.setTope((ThriftTableOperationException)value);
                }
            }
        }

        public Object getFieldValue(_Fields field) {
            switch (field) {
                case SEC: {
                    return this.getSec();
                }
                case TOPE: {
                    return this.getTope();
                }
            }
            throw new IllegalStateException();
        }

        public boolean isSet(_Fields field) {
            if (field == null) {
                throw new IllegalArgumentException();
            }
            switch (field) {
                case SEC: {
                    return this.isSetSec();
                }
                case TOPE: {
                    return this.isSetTope();
                }
            }
            throw new IllegalStateException();
        }

        public boolean equals(Object that) {
            if (that == null) {
                return false;
            }
            if (that instanceof removeTableProperty_result) {
                return this.equals((removeTableProperty_result)that);
            }
            return false;
        }

        public boolean equals(removeTableProperty_result that) {
            if (that == null) {
                return false;
            }
            boolean this_present_sec = this.isSetSec();
            boolean that_present_sec = that.isSetSec();
            if (this_present_sec || that_present_sec) {
                if (!this_present_sec || !that_present_sec) {
                    return false;
                }
                if (!this.sec.equals(that.sec)) {
                    return false;
                }
            }
            boolean this_present_tope = this.isSetTope();
            boolean that_present_tope = that.isSetTope();
            if (this_present_tope || that_present_tope) {
                if (!this_present_tope || !that_present_tope) {
                    return false;
                }
                if (!this.tope.equals(that.tope)) {
                    return false;
                }
            }
            return true;
        }

        public int hashCode() {
            return 0;
        }

        public int compareTo(removeTableProperty_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            removeTableProperty_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSec()).compareTo(typedOther.isSetSec());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSec() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.sec), (Comparable)((Object)typedOther.sec))) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetTope()).compareTo(typedOther.isSetTope());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetTope() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.tope), (Comparable)((Object)typedOther.tope))) != 0) {
                return lastComparison;
            }
            return 0;
        }

        public _Fields fieldForId(int fieldId) {
            return _Fields.findByThriftId(fieldId);
        }

        public void read(TProtocol iprot) throws TException {
            schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
        }

        public void write(TProtocol oprot) throws TException {
            schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("removeTableProperty_result(");
            boolean first = true;
            sb.append("sec:");
            if (this.sec == null) {
                sb.append("null");
            } else {
                sb.append(this.sec);
            }
            first = false;
            if (!first) {
                sb.append(", ");
            }
            sb.append("tope:");
            if (this.tope == null) {
                sb.append("null");
            } else {
                sb.append(this.tope);
            }
            first = false;
            sb.append(")");
            return sb.toString();
        }

        public void validate() throws TException {
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            try {
                this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
            }
            catch (TException te) {
                throw new IOException(te);
            }
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            try {
                this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
            }
            catch (TException te) {
                throw new IOException(te);
            }
        }

        static {
            schemes.put(StandardScheme.class, new removeTableProperty_resultStandardSchemeFactory());
            schemes.put(TupleScheme.class, new removeTableProperty_resultTupleSchemeFactory());
            EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
            tmpMap.put(_Fields.SEC, new FieldMetaData("sec", 3, new FieldValueMetaData(12)));
            tmpMap.put(_Fields.TOPE, new FieldMetaData("tope", 3, new FieldValueMetaData(12)));
            metaDataMap = Collections.unmodifiableMap(tmpMap);
            FieldMetaData.addStructMetaDataMap(removeTableProperty_result.class, metaDataMap);
        }

        private static class removeTableProperty_resultTupleScheme
        extends TupleScheme<removeTableProperty_result> {
            private removeTableProperty_resultTupleScheme() {
            }

            public void write(TProtocol prot, removeTableProperty_result struct) throws TException {
                TTupleProtocol oprot = (TTupleProtocol)prot;
                BitSet optionals = new BitSet();
                if (struct.isSetSec()) {
                    optionals.set(0);
                }
                if (struct.isSetTope()) {
                    optionals.set(1);
                }
                oprot.writeBitSet(optionals, 2);
                if (struct.isSetSec()) {
                    struct.sec.write((TProtocol)oprot);
                }
                if (struct.isSetTope()) {
                    struct.tope.write((TProtocol)oprot);
                }
            }

            public void read(TProtocol prot, removeTableProperty_result struct) throws TException {
                TTupleProtocol iprot = (TTupleProtocol)prot;
                BitSet incoming = iprot.readBitSet(2);
                if (incoming.get(0)) {
                    struct.sec = new ThriftSecurityException();
                    struct.sec.read((TProtocol)iprot);
                    struct.setSecIsSet(true);
                }
                if (incoming.get(1)) {
                    struct.tope = new ThriftTableOperationException();
                    struct.tope.read((TProtocol)iprot);
                    struct.setTopeIsSet(true);
                }
            }
        }

        private static class removeTableProperty_resultTupleSchemeFactory
        implements SchemeFactory {
            private removeTableProperty_resultTupleSchemeFactory() {
            }

            public removeTableProperty_resultTupleScheme getScheme() {
                return new removeTableProperty_resultTupleScheme();
            }
        }

        private static class removeTableProperty_resultStandardScheme
        extends StandardScheme<removeTableProperty_result> {
            private removeTableProperty_resultStandardScheme() {
            }

            public void read(TProtocol iprot, removeTableProperty_result struct) throws TException {
                iprot.readStructBegin();
                while (true) {
                    TField schemeField = iprot.readFieldBegin();
                    if (schemeField.type == 0) break;
                    switch (schemeField.id) {
                        case 1: {
                            if (schemeField.type == 12) {
                                struct.sec = new ThriftSecurityException();
                                struct.sec.read(iprot);
                                struct.setSecIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        case 2: {
                            if (schemeField.type == 12) {
                                struct.tope = new ThriftTableOperationException();
                                struct.tope.read(iprot);
                                struct.setTopeIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        default: {
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        }
                    }
                    iprot.readFieldEnd();
                }
                iprot.readStructEnd();
                struct.validate();
            }

            public void write(TProtocol oprot, removeTableProperty_result struct) throws TException {
                struct.validate();
                oprot.writeStructBegin(STRUCT_DESC);
                if (struct.sec != null) {
                    oprot.writeFieldBegin(SEC_FIELD_DESC);
                    struct.sec.write(oprot);
                    oprot.writeFieldEnd();
                }
                if (struct.tope != null) {
                    oprot.writeFieldBegin(TOPE_FIELD_DESC);
                    struct.tope.write(oprot);
                    oprot.writeFieldEnd();
                }
                oprot.writeFieldStop();
                oprot.writeStructEnd();
            }
        }

        private static class removeTableProperty_resultStandardSchemeFactory
        implements SchemeFactory {
            private removeTableProperty_resultStandardSchemeFactory() {
            }

            public removeTableProperty_resultStandardScheme getScheme() {
                return new removeTableProperty_resultStandardScheme();
            }
        }

        public static enum _Fields implements TFieldIdEnum
        {
            SEC(1, "sec"),
            TOPE(2, "tope");

            private static final Map<String, _Fields> byName;
            private final short _thriftId;
            private final String _fieldName;

            public static _Fields findByThriftId(int fieldId) {
                switch (fieldId) {
                    case 1: {
                        return SEC;
                    }
                    case 2: {
                        return TOPE;
                    }
                }
                return null;
            }

            public static _Fields findByThriftIdOrThrow(int fieldId) {
                _Fields fields = _Fields.findByThriftId(fieldId);
                if (fields == null) {
                    throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
                }
                return fields;
            }

            public static _Fields findByName(String name) {
                return byName.get(name);
            }

            private _Fields(short thriftId, String fieldName) {
                this._thriftId = thriftId;
                this._fieldName = fieldName;
            }

            public short getThriftFieldId() {
                return this._thriftId;
            }

            public String getFieldName() {
                return this._fieldName;
            }

            static {
                byName = new HashMap<String, _Fields>();
                for (_Fields field : EnumSet.allOf(_Fields.class)) {
                    byName.put(field.getFieldName(), field);
                }
            }
        }
    }

    public static class removeTableProperty_args
    implements TBase<removeTableProperty_args, _Fields>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("removeTableProperty_args");
        private static final TField TINFO_FIELD_DESC = new TField("tinfo", 12, 4);
        private static final TField CREDENTIALS_FIELD_DESC = new TField("credentials", 12, 1);
        private static final TField TABLE_NAME_FIELD_DESC = new TField("tableName", 11, 2);
        private static final TField PROPERTY_FIELD_DESC = new TField("property", 11, 3);
        private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
        public TInfo tinfo;
        public TCredentials credentials;
        public String tableName;
        public String property;
        public static final Map<_Fields, FieldMetaData> metaDataMap;

        public removeTableProperty_args() {
        }

        public removeTableProperty_args(TInfo tinfo, TCredentials credentials, String tableName, String property) {
            this();
            this.tinfo = tinfo;
            this.credentials = credentials;
            this.tableName = tableName;
            this.property = property;
        }

        public removeTableProperty_args(removeTableProperty_args other) {
            if (other.isSetTinfo()) {
                this.tinfo = new TInfo(other.tinfo);
            }
            if (other.isSetCredentials()) {
                this.credentials = new TCredentials(other.credentials);
            }
            if (other.isSetTableName()) {
                this.tableName = other.tableName;
            }
            if (other.isSetProperty()) {
                this.property = other.property;
            }
        }

        public removeTableProperty_args deepCopy() {
            return new removeTableProperty_args(this);
        }

        public void clear() {
            this.tinfo = null;
            this.credentials = null;
            this.tableName = null;
            this.property = null;
        }

        public TInfo getTinfo() {
            return this.tinfo;
        }

        public removeTableProperty_args setTinfo(TInfo tinfo) {
            this.tinfo = tinfo;
            return this;
        }

        public void unsetTinfo() {
            this.tinfo = null;
        }

        public boolean isSetTinfo() {
            return this.tinfo != null;
        }

        public void setTinfoIsSet(boolean value) {
            if (!value) {
                this.tinfo = null;
            }
        }

        public TCredentials getCredentials() {
            return this.credentials;
        }

        public removeTableProperty_args setCredentials(TCredentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public void unsetCredentials() {
            this.credentials = null;
        }

        public boolean isSetCredentials() {
            return this.credentials != null;
        }

        public void setCredentialsIsSet(boolean value) {
            if (!value) {
                this.credentials = null;
            }
        }

        public String getTableName() {
            return this.tableName;
        }

        public removeTableProperty_args setTableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public void unsetTableName() {
            this.tableName = null;
        }

        public boolean isSetTableName() {
            return this.tableName != null;
        }

        public void setTableNameIsSet(boolean value) {
            if (!value) {
                this.tableName = null;
            }
        }

        public String getProperty() {
            return this.property;
        }

        public removeTableProperty_args setProperty(String property) {
            this.property = property;
            return this;
        }

        public void unsetProperty() {
            this.property = null;
        }

        public boolean isSetProperty() {
            return this.property != null;
        }

        public void setPropertyIsSet(boolean value) {
            if (!value) {
                this.property = null;
            }
        }

        public void setFieldValue(_Fields field, Object value) {
            switch (field) {
                case TINFO: {
                    if (value == null) {
                        this.unsetTinfo();
                        break;
                    }
                    this.setTinfo((TInfo)value);
                    break;
                }
                case CREDENTIALS: {
                    if (value == null) {
                        this.unsetCredentials();
                        break;
                    }
                    this.setCredentials((TCredentials)value);
                    break;
                }
                case TABLE_NAME: {
                    if (value == null) {
                        this.unsetTableName();
                        break;
                    }
                    this.setTableName((String)value);
                    break;
                }
                case PROPERTY: {
                    if (value == null) {
                        this.unsetProperty();
                        break;
                    }
                    this.setProperty((String)value);
                }
            }
        }

        public Object getFieldValue(_Fields field) {
            switch (field) {
                case TINFO: {
                    return this.getTinfo();
                }
                case CREDENTIALS: {
                    return this.getCredentials();
                }
                case TABLE_NAME: {
                    return this.getTableName();
                }
                case PROPERTY: {
                    return this.getProperty();
                }
            }
            throw new IllegalStateException();
        }

        public boolean isSet(_Fields field) {
            if (field == null) {
                throw new IllegalArgumentException();
            }
            switch (field) {
                case TINFO: {
                    return this.isSetTinfo();
                }
                case CREDENTIALS: {
                    return this.isSetCredentials();
                }
                case TABLE_NAME: {
                    return this.isSetTableName();
                }
                case PROPERTY: {
                    return this.isSetProperty();
                }
            }
            throw new IllegalStateException();
        }

        public boolean equals(Object that) {
            if (that == null) {
                return false;
            }
            if (that instanceof removeTableProperty_args) {
                return this.equals((removeTableProperty_args)that);
            }
            return false;
        }

        public boolean equals(removeTableProperty_args that) {
            if (that == null) {
                return false;
            }
            boolean this_present_tinfo = this.isSetTinfo();
            boolean that_present_tinfo = that.isSetTinfo();
            if (this_present_tinfo || that_present_tinfo) {
                if (!this_present_tinfo || !that_present_tinfo) {
                    return false;
                }
                if (!this.tinfo.equals(that.tinfo)) {
                    return false;
                }
            }
            boolean this_present_credentials = this.isSetCredentials();
            boolean that_present_credentials = that.isSetCredentials();
            if (this_present_credentials || that_present_credentials) {
                if (!this_present_credentials || !that_present_credentials) {
                    return false;
                }
                if (!this.credentials.equals(that.credentials)) {
                    return false;
                }
            }
            boolean this_present_tableName = this.isSetTableName();
            boolean that_present_tableName = that.isSetTableName();
            if (this_present_tableName || that_present_tableName) {
                if (!this_present_tableName || !that_present_tableName) {
                    return false;
                }
                if (!this.tableName.equals(that.tableName)) {
                    return false;
                }
            }
            boolean this_present_property = this.isSetProperty();
            boolean that_present_property = that.isSetProperty();
            if (this_present_property || that_present_property) {
                if (!this_present_property || !that_present_property) {
                    return false;
                }
                if (!this.property.equals(that.property)) {
                    return false;
                }
            }
            return true;
        }

        public int hashCode() {
            return 0;
        }

        public int compareTo(removeTableProperty_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            removeTableProperty_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetTinfo()).compareTo(typedOther.isSetTinfo());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetTinfo() && (lastComparison = TBaseHelper.compareTo((Comparable)this.tinfo, (Comparable)typedOther.tinfo)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetCredentials()).compareTo(typedOther.isSetCredentials());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetCredentials() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.credentials), (Comparable)((Object)typedOther.credentials))) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetTableName()).compareTo(typedOther.isSetTableName());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetTableName() && (lastComparison = TBaseHelper.compareTo((String)this.tableName, (String)typedOther.tableName)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetProperty()).compareTo(typedOther.isSetProperty());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetProperty() && (lastComparison = TBaseHelper.compareTo((String)this.property, (String)typedOther.property)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        public _Fields fieldForId(int fieldId) {
            return _Fields.findByThriftId(fieldId);
        }

        public void read(TProtocol iprot) throws TException {
            schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
        }

        public void write(TProtocol oprot) throws TException {
            schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("removeTableProperty_args(");
            boolean first = true;
            sb.append("tinfo:");
            if (this.tinfo == null) {
                sb.append("null");
            } else {
                sb.append(this.tinfo);
            }
            first = false;
            if (!first) {
                sb.append(", ");
            }
            sb.append("credentials:");
            if (this.credentials == null) {
                sb.append("null");
            } else {
                sb.append(this.credentials);
            }
            first = false;
            if (!first) {
                sb.append(", ");
            }
            sb.append("tableName:");
            if (this.tableName == null) {
                sb.append("null");
            } else {
                sb.append(this.tableName);
            }
            first = false;
            if (!first) {
                sb.append(", ");
            }
            sb.append("property:");
            if (this.property == null) {
                sb.append("null");
            } else {
                sb.append(this.property);
            }
            first = false;
            sb.append(")");
            return sb.toString();
        }

        public void validate() throws TException {
            if (this.tinfo != null) {
                this.tinfo.validate();
            }
            if (this.credentials != null) {
                this.credentials.validate();
            }
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            try {
                this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
            }
            catch (TException te) {
                throw new IOException(te);
            }
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            try {
                this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
            }
            catch (TException te) {
                throw new IOException(te);
            }
        }

        static {
            schemes.put(StandardScheme.class, new removeTableProperty_argsStandardSchemeFactory());
            schemes.put(TupleScheme.class, new removeTableProperty_argsTupleSchemeFactory());
            EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
            tmpMap.put(_Fields.TINFO, new FieldMetaData("tinfo", 3, (FieldValueMetaData)new StructMetaData(12, TInfo.class)));
            tmpMap.put(_Fields.CREDENTIALS, new FieldMetaData("credentials", 3, (FieldValueMetaData)new StructMetaData(12, TCredentials.class)));
            tmpMap.put(_Fields.TABLE_NAME, new FieldMetaData("tableName", 3, new FieldValueMetaData(11)));
            tmpMap.put(_Fields.PROPERTY, new FieldMetaData("property", 3, new FieldValueMetaData(11)));
            metaDataMap = Collections.unmodifiableMap(tmpMap);
            FieldMetaData.addStructMetaDataMap(removeTableProperty_args.class, metaDataMap);
        }

        private static class removeTableProperty_argsTupleScheme
        extends TupleScheme<removeTableProperty_args> {
            private removeTableProperty_argsTupleScheme() {
            }

            public void write(TProtocol prot, removeTableProperty_args struct) throws TException {
                TTupleProtocol oprot = (TTupleProtocol)prot;
                BitSet optionals = new BitSet();
                if (struct.isSetTinfo()) {
                    optionals.set(0);
                }
                if (struct.isSetCredentials()) {
                    optionals.set(1);
                }
                if (struct.isSetTableName()) {
                    optionals.set(2);
                }
                if (struct.isSetProperty()) {
                    optionals.set(3);
                }
                oprot.writeBitSet(optionals, 4);
                if (struct.isSetTinfo()) {
                    struct.tinfo.write((TProtocol)oprot);
                }
                if (struct.isSetCredentials()) {
                    struct.credentials.write((TProtocol)oprot);
                }
                if (struct.isSetTableName()) {
                    oprot.writeString(struct.tableName);
                }
                if (struct.isSetProperty()) {
                    oprot.writeString(struct.property);
                }
            }

            public void read(TProtocol prot, removeTableProperty_args struct) throws TException {
                TTupleProtocol iprot = (TTupleProtocol)prot;
                BitSet incoming = iprot.readBitSet(4);
                if (incoming.get(0)) {
                    struct.tinfo = new TInfo();
                    struct.tinfo.read((TProtocol)iprot);
                    struct.setTinfoIsSet(true);
                }
                if (incoming.get(1)) {
                    struct.credentials = new TCredentials();
                    struct.credentials.read((TProtocol)iprot);
                    struct.setCredentialsIsSet(true);
                }
                if (incoming.get(2)) {
                    struct.tableName = iprot.readString();
                    struct.setTableNameIsSet(true);
                }
                if (incoming.get(3)) {
                    struct.property = iprot.readString();
                    struct.setPropertyIsSet(true);
                }
            }
        }

        private static class removeTableProperty_argsTupleSchemeFactory
        implements SchemeFactory {
            private removeTableProperty_argsTupleSchemeFactory() {
            }

            public removeTableProperty_argsTupleScheme getScheme() {
                return new removeTableProperty_argsTupleScheme();
            }
        }

        private static class removeTableProperty_argsStandardScheme
        extends StandardScheme<removeTableProperty_args> {
            private removeTableProperty_argsStandardScheme() {
            }

            public void read(TProtocol iprot, removeTableProperty_args struct) throws TException {
                iprot.readStructBegin();
                while (true) {
                    TField schemeField = iprot.readFieldBegin();
                    if (schemeField.type == 0) break;
                    switch (schemeField.id) {
                        case 4: {
                            if (schemeField.type == 12) {
                                struct.tinfo = new TInfo();
                                struct.tinfo.read(iprot);
                                struct.setTinfoIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        case 1: {
                            if (schemeField.type == 12) {
                                struct.credentials = new TCredentials();
                                struct.credentials.read(iprot);
                                struct.setCredentialsIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        case 2: {
                            if (schemeField.type == 11) {
                                struct.tableName = iprot.readString();
                                struct.setTableNameIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        case 3: {
                            if (schemeField.type == 11) {
                                struct.property = iprot.readString();
                                struct.setPropertyIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        default: {
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        }
                    }
                    iprot.readFieldEnd();
                }
                iprot.readStructEnd();
                struct.validate();
            }

            public void write(TProtocol oprot, removeTableProperty_args struct) throws TException {
                struct.validate();
                oprot.writeStructBegin(STRUCT_DESC);
                if (struct.credentials != null) {
                    oprot.writeFieldBegin(CREDENTIALS_FIELD_DESC);
                    struct.credentials.write(oprot);
                    oprot.writeFieldEnd();
                }
                if (struct.tableName != null) {
                    oprot.writeFieldBegin(TABLE_NAME_FIELD_DESC);
                    oprot.writeString(struct.tableName);
                    oprot.writeFieldEnd();
                }
                if (struct.property != null) {
                    oprot.writeFieldBegin(PROPERTY_FIELD_DESC);
                    oprot.writeString(struct.property);
                    oprot.writeFieldEnd();
                }
                if (struct.tinfo != null) {
                    oprot.writeFieldBegin(TINFO_FIELD_DESC);
                    struct.tinfo.write(oprot);
                    oprot.writeFieldEnd();
                }
                oprot.writeFieldStop();
                oprot.writeStructEnd();
            }
        }

        private static class removeTableProperty_argsStandardSchemeFactory
        implements SchemeFactory {
            private removeTableProperty_argsStandardSchemeFactory() {
            }

            public removeTableProperty_argsStandardScheme getScheme() {
                return new removeTableProperty_argsStandardScheme();
            }
        }

        public static enum _Fields implements TFieldIdEnum
        {
            TINFO(4, "tinfo"),
            CREDENTIALS(1, "credentials"),
            TABLE_NAME(2, "tableName"),
            PROPERTY(3, "property");

            private static final Map<String, _Fields> byName;
            private final short _thriftId;
            private final String _fieldName;

            public static _Fields findByThriftId(int fieldId) {
                switch (fieldId) {
                    case 4: {
                        return TINFO;
                    }
                    case 1: {
                        return CREDENTIALS;
                    }
                    case 2: {
                        return TABLE_NAME;
                    }
                    case 3: {
                        return PROPERTY;
                    }
                }
                return null;
            }

            public static _Fields findByThriftIdOrThrow(int fieldId) {
                _Fields fields = _Fields.findByThriftId(fieldId);
                if (fields == null) {
                    throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
                }
                return fields;
            }

            public static _Fields findByName(String name) {
                return byName.get(name);
            }

            private _Fields(short thriftId, String fieldName) {
                this._thriftId = thriftId;
                this._fieldName = fieldName;
            }

            public short getThriftFieldId() {
                return this._thriftId;
            }

            public String getFieldName() {
                return this._fieldName;
            }

            static {
                byName = new HashMap<String, _Fields>();
                for (_Fields field : EnumSet.allOf(_Fields.class)) {
                    byName.put(field.getFieldName(), field);
                }
            }
        }
    }

    public static class setTableProperty_result
    implements TBase<setTableProperty_result, _Fields>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("setTableProperty_result");
        private static final TField SEC_FIELD_DESC = new TField("sec", 12, 1);
        private static final TField TOPE_FIELD_DESC = new TField("tope", 12, 2);
        private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
        public ThriftSecurityException sec;
        public ThriftTableOperationException tope;
        public static final Map<_Fields, FieldMetaData> metaDataMap;

        public setTableProperty_result() {
        }

        public setTableProperty_result(ThriftSecurityException sec, ThriftTableOperationException tope) {
            this();
            this.sec = sec;
            this.tope = tope;
        }

        public setTableProperty_result(setTableProperty_result other) {
            if (other.isSetSec()) {
                this.sec = new ThriftSecurityException(other.sec);
            }
            if (other.isSetTope()) {
                this.tope = new ThriftTableOperationException(other.tope);
            }
        }

        public setTableProperty_result deepCopy() {
            return new setTableProperty_result(this);
        }

        public void clear() {
            this.sec = null;
            this.tope = null;
        }

        public ThriftSecurityException getSec() {
            return this.sec;
        }

        public setTableProperty_result setSec(ThriftSecurityException sec) {
            this.sec = sec;
            return this;
        }

        public void unsetSec() {
            this.sec = null;
        }

        public boolean isSetSec() {
            return this.sec != null;
        }

        public void setSecIsSet(boolean value) {
            if (!value) {
                this.sec = null;
            }
        }

        public ThriftTableOperationException getTope() {
            return this.tope;
        }

        public setTableProperty_result setTope(ThriftTableOperationException tope) {
            this.tope = tope;
            return this;
        }

        public void unsetTope() {
            this.tope = null;
        }

        public boolean isSetTope() {
            return this.tope != null;
        }

        public void setTopeIsSet(boolean value) {
            if (!value) {
                this.tope = null;
            }
        }

        public void setFieldValue(_Fields field, Object value) {
            switch (field) {
                case SEC: {
                    if (value == null) {
                        this.unsetSec();
                        break;
                    }
                    this.setSec((ThriftSecurityException)value);
                    break;
                }
                case TOPE: {
                    if (value == null) {
                        this.unsetTope();
                        break;
                    }
                    this.setTope((ThriftTableOperationException)value);
                }
            }
        }

        public Object getFieldValue(_Fields field) {
            switch (field) {
                case SEC: {
                    return this.getSec();
                }
                case TOPE: {
                    return this.getTope();
                }
            }
            throw new IllegalStateException();
        }

        public boolean isSet(_Fields field) {
            if (field == null) {
                throw new IllegalArgumentException();
            }
            switch (field) {
                case SEC: {
                    return this.isSetSec();
                }
                case TOPE: {
                    return this.isSetTope();
                }
            }
            throw new IllegalStateException();
        }

        public boolean equals(Object that) {
            if (that == null) {
                return false;
            }
            if (that instanceof setTableProperty_result) {
                return this.equals((setTableProperty_result)that);
            }
            return false;
        }

        public boolean equals(setTableProperty_result that) {
            if (that == null) {
                return false;
            }
            boolean this_present_sec = this.isSetSec();
            boolean that_present_sec = that.isSetSec();
            if (this_present_sec || that_present_sec) {
                if (!this_present_sec || !that_present_sec) {
                    return false;
                }
                if (!this.sec.equals(that.sec)) {
                    return false;
                }
            }
            boolean this_present_tope = this.isSetTope();
            boolean that_present_tope = that.isSetTope();
            if (this_present_tope || that_present_tope) {
                if (!this_present_tope || !that_present_tope) {
                    return false;
                }
                if (!this.tope.equals(that.tope)) {
                    return false;
                }
            }
            return true;
        }

        public int hashCode() {
            return 0;
        }

        public int compareTo(setTableProperty_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            setTableProperty_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSec()).compareTo(typedOther.isSetSec());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSec() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.sec), (Comparable)((Object)typedOther.sec))) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetTope()).compareTo(typedOther.isSetTope());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetTope() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.tope), (Comparable)((Object)typedOther.tope))) != 0) {
                return lastComparison;
            }
            return 0;
        }

        public _Fields fieldForId(int fieldId) {
            return _Fields.findByThriftId(fieldId);
        }

        public void read(TProtocol iprot) throws TException {
            schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
        }

        public void write(TProtocol oprot) throws TException {
            schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("setTableProperty_result(");
            boolean first = true;
            sb.append("sec:");
            if (this.sec == null) {
                sb.append("null");
            } else {
                sb.append(this.sec);
            }
            first = false;
            if (!first) {
                sb.append(", ");
            }
            sb.append("tope:");
            if (this.tope == null) {
                sb.append("null");
            } else {
                sb.append(this.tope);
            }
            first = false;
            sb.append(")");
            return sb.toString();
        }

        public void validate() throws TException {
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            try {
                this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
            }
            catch (TException te) {
                throw new IOException(te);
            }
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            try {
                this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
            }
            catch (TException te) {
                throw new IOException(te);
            }
        }

        static {
            schemes.put(StandardScheme.class, new setTableProperty_resultStandardSchemeFactory());
            schemes.put(TupleScheme.class, new setTableProperty_resultTupleSchemeFactory());
            EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
            tmpMap.put(_Fields.SEC, new FieldMetaData("sec", 3, new FieldValueMetaData(12)));
            tmpMap.put(_Fields.TOPE, new FieldMetaData("tope", 3, new FieldValueMetaData(12)));
            metaDataMap = Collections.unmodifiableMap(tmpMap);
            FieldMetaData.addStructMetaDataMap(setTableProperty_result.class, metaDataMap);
        }

        private static class setTableProperty_resultTupleScheme
        extends TupleScheme<setTableProperty_result> {
            private setTableProperty_resultTupleScheme() {
            }

            public void write(TProtocol prot, setTableProperty_result struct) throws TException {
                TTupleProtocol oprot = (TTupleProtocol)prot;
                BitSet optionals = new BitSet();
                if (struct.isSetSec()) {
                    optionals.set(0);
                }
                if (struct.isSetTope()) {
                    optionals.set(1);
                }
                oprot.writeBitSet(optionals, 2);
                if (struct.isSetSec()) {
                    struct.sec.write((TProtocol)oprot);
                }
                if (struct.isSetTope()) {
                    struct.tope.write((TProtocol)oprot);
                }
            }

            public void read(TProtocol prot, setTableProperty_result struct) throws TException {
                TTupleProtocol iprot = (TTupleProtocol)prot;
                BitSet incoming = iprot.readBitSet(2);
                if (incoming.get(0)) {
                    struct.sec = new ThriftSecurityException();
                    struct.sec.read((TProtocol)iprot);
                    struct.setSecIsSet(true);
                }
                if (incoming.get(1)) {
                    struct.tope = new ThriftTableOperationException();
                    struct.tope.read((TProtocol)iprot);
                    struct.setTopeIsSet(true);
                }
            }
        }

        private static class setTableProperty_resultTupleSchemeFactory
        implements SchemeFactory {
            private setTableProperty_resultTupleSchemeFactory() {
            }

            public setTableProperty_resultTupleScheme getScheme() {
                return new setTableProperty_resultTupleScheme();
            }
        }

        private static class setTableProperty_resultStandardScheme
        extends StandardScheme<setTableProperty_result> {
            private setTableProperty_resultStandardScheme() {
            }

            public void read(TProtocol iprot, setTableProperty_result struct) throws TException {
                iprot.readStructBegin();
                while (true) {
                    TField schemeField = iprot.readFieldBegin();
                    if (schemeField.type == 0) break;
                    switch (schemeField.id) {
                        case 1: {
                            if (schemeField.type == 12) {
                                struct.sec = new ThriftSecurityException();
                                struct.sec.read(iprot);
                                struct.setSecIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        case 2: {
                            if (schemeField.type == 12) {
                                struct.tope = new ThriftTableOperationException();
                                struct.tope.read(iprot);
                                struct.setTopeIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        default: {
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        }
                    }
                    iprot.readFieldEnd();
                }
                iprot.readStructEnd();
                struct.validate();
            }

            public void write(TProtocol oprot, setTableProperty_result struct) throws TException {
                struct.validate();
                oprot.writeStructBegin(STRUCT_DESC);
                if (struct.sec != null) {
                    oprot.writeFieldBegin(SEC_FIELD_DESC);
                    struct.sec.write(oprot);
                    oprot.writeFieldEnd();
                }
                if (struct.tope != null) {
                    oprot.writeFieldBegin(TOPE_FIELD_DESC);
                    struct.tope.write(oprot);
                    oprot.writeFieldEnd();
                }
                oprot.writeFieldStop();
                oprot.writeStructEnd();
            }
        }

        private static class setTableProperty_resultStandardSchemeFactory
        implements SchemeFactory {
            private setTableProperty_resultStandardSchemeFactory() {
            }

            public setTableProperty_resultStandardScheme getScheme() {
                return new setTableProperty_resultStandardScheme();
            }
        }

        public static enum _Fields implements TFieldIdEnum
        {
            SEC(1, "sec"),
            TOPE(2, "tope");

            private static final Map<String, _Fields> byName;
            private final short _thriftId;
            private final String _fieldName;

            public static _Fields findByThriftId(int fieldId) {
                switch (fieldId) {
                    case 1: {
                        return SEC;
                    }
                    case 2: {
                        return TOPE;
                    }
                }
                return null;
            }

            public static _Fields findByThriftIdOrThrow(int fieldId) {
                _Fields fields = _Fields.findByThriftId(fieldId);
                if (fields == null) {
                    throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
                }
                return fields;
            }

            public static _Fields findByName(String name) {
                return byName.get(name);
            }

            private _Fields(short thriftId, String fieldName) {
                this._thriftId = thriftId;
                this._fieldName = fieldName;
            }

            public short getThriftFieldId() {
                return this._thriftId;
            }

            public String getFieldName() {
                return this._fieldName;
            }

            static {
                byName = new HashMap<String, _Fields>();
                for (_Fields field : EnumSet.allOf(_Fields.class)) {
                    byName.put(field.getFieldName(), field);
                }
            }
        }
    }

    public static class setTableProperty_args
    implements TBase<setTableProperty_args, _Fields>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("setTableProperty_args");
        private static final TField TINFO_FIELD_DESC = new TField("tinfo", 12, 5);
        private static final TField CREDENTIALS_FIELD_DESC = new TField("credentials", 12, 1);
        private static final TField TABLE_NAME_FIELD_DESC = new TField("tableName", 11, 2);
        private static final TField PROPERTY_FIELD_DESC = new TField("property", 11, 3);
        private static final TField VALUE_FIELD_DESC = new TField("value", 11, 4);
        private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
        public TInfo tinfo;
        public TCredentials credentials;
        public String tableName;
        public String property;
        public String value;
        public static final Map<_Fields, FieldMetaData> metaDataMap;

        public setTableProperty_args() {
        }

        public setTableProperty_args(TInfo tinfo, TCredentials credentials, String tableName, String property, String value) {
            this();
            this.tinfo = tinfo;
            this.credentials = credentials;
            this.tableName = tableName;
            this.property = property;
            this.value = value;
        }

        public setTableProperty_args(setTableProperty_args other) {
            if (other.isSetTinfo()) {
                this.tinfo = new TInfo(other.tinfo);
            }
            if (other.isSetCredentials()) {
                this.credentials = new TCredentials(other.credentials);
            }
            if (other.isSetTableName()) {
                this.tableName = other.tableName;
            }
            if (other.isSetProperty()) {
                this.property = other.property;
            }
            if (other.isSetValue()) {
                this.value = other.value;
            }
        }

        public setTableProperty_args deepCopy() {
            return new setTableProperty_args(this);
        }

        public void clear() {
            this.tinfo = null;
            this.credentials = null;
            this.tableName = null;
            this.property = null;
            this.value = null;
        }

        public TInfo getTinfo() {
            return this.tinfo;
        }

        public setTableProperty_args setTinfo(TInfo tinfo) {
            this.tinfo = tinfo;
            return this;
        }

        public void unsetTinfo() {
            this.tinfo = null;
        }

        public boolean isSetTinfo() {
            return this.tinfo != null;
        }

        public void setTinfoIsSet(boolean value) {
            if (!value) {
                this.tinfo = null;
            }
        }

        public TCredentials getCredentials() {
            return this.credentials;
        }

        public setTableProperty_args setCredentials(TCredentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public void unsetCredentials() {
            this.credentials = null;
        }

        public boolean isSetCredentials() {
            return this.credentials != null;
        }

        public void setCredentialsIsSet(boolean value) {
            if (!value) {
                this.credentials = null;
            }
        }

        public String getTableName() {
            return this.tableName;
        }

        public setTableProperty_args setTableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public void unsetTableName() {
            this.tableName = null;
        }

        public boolean isSetTableName() {
            return this.tableName != null;
        }

        public void setTableNameIsSet(boolean value) {
            if (!value) {
                this.tableName = null;
            }
        }

        public String getProperty() {
            return this.property;
        }

        public setTableProperty_args setProperty(String property) {
            this.property = property;
            return this;
        }

        public void unsetProperty() {
            this.property = null;
        }

        public boolean isSetProperty() {
            return this.property != null;
        }

        public void setPropertyIsSet(boolean value) {
            if (!value) {
                this.property = null;
            }
        }

        public String getValue() {
            return this.value;
        }

        public setTableProperty_args setValue(String value) {
            this.value = value;
            return this;
        }

        public void unsetValue() {
            this.value = null;
        }

        public boolean isSetValue() {
            return this.value != null;
        }

        public void setValueIsSet(boolean value) {
            if (!value) {
                this.value = null;
            }
        }

        public void setFieldValue(_Fields field, Object value) {
            switch (field) {
                case TINFO: {
                    if (value == null) {
                        this.unsetTinfo();
                        break;
                    }
                    this.setTinfo((TInfo)value);
                    break;
                }
                case CREDENTIALS: {
                    if (value == null) {
                        this.unsetCredentials();
                        break;
                    }
                    this.setCredentials((TCredentials)value);
                    break;
                }
                case TABLE_NAME: {
                    if (value == null) {
                        this.unsetTableName();
                        break;
                    }
                    this.setTableName((String)value);
                    break;
                }
                case PROPERTY: {
                    if (value == null) {
                        this.unsetProperty();
                        break;
                    }
                    this.setProperty((String)value);
                    break;
                }
                case VALUE: {
                    if (value == null) {
                        this.unsetValue();
                        break;
                    }
                    this.setValue((String)value);
                }
            }
        }

        public Object getFieldValue(_Fields field) {
            switch (field) {
                case TINFO: {
                    return this.getTinfo();
                }
                case CREDENTIALS: {
                    return this.getCredentials();
                }
                case TABLE_NAME: {
                    return this.getTableName();
                }
                case PROPERTY: {
                    return this.getProperty();
                }
                case VALUE: {
                    return this.getValue();
                }
            }
            throw new IllegalStateException();
        }

        public boolean isSet(_Fields field) {
            if (field == null) {
                throw new IllegalArgumentException();
            }
            switch (field) {
                case TINFO: {
                    return this.isSetTinfo();
                }
                case CREDENTIALS: {
                    return this.isSetCredentials();
                }
                case TABLE_NAME: {
                    return this.isSetTableName();
                }
                case PROPERTY: {
                    return this.isSetProperty();
                }
                case VALUE: {
                    return this.isSetValue();
                }
            }
            throw new IllegalStateException();
        }

        public boolean equals(Object that) {
            if (that == null) {
                return false;
            }
            if (that instanceof setTableProperty_args) {
                return this.equals((setTableProperty_args)that);
            }
            return false;
        }

        public boolean equals(setTableProperty_args that) {
            if (that == null) {
                return false;
            }
            boolean this_present_tinfo = this.isSetTinfo();
            boolean that_present_tinfo = that.isSetTinfo();
            if (this_present_tinfo || that_present_tinfo) {
                if (!this_present_tinfo || !that_present_tinfo) {
                    return false;
                }
                if (!this.tinfo.equals(that.tinfo)) {
                    return false;
                }
            }
            boolean this_present_credentials = this.isSetCredentials();
            boolean that_present_credentials = that.isSetCredentials();
            if (this_present_credentials || that_present_credentials) {
                if (!this_present_credentials || !that_present_credentials) {
                    return false;
                }
                if (!this.credentials.equals(that.credentials)) {
                    return false;
                }
            }
            boolean this_present_tableName = this.isSetTableName();
            boolean that_present_tableName = that.isSetTableName();
            if (this_present_tableName || that_present_tableName) {
                if (!this_present_tableName || !that_present_tableName) {
                    return false;
                }
                if (!this.tableName.equals(that.tableName)) {
                    return false;
                }
            }
            boolean this_present_property = this.isSetProperty();
            boolean that_present_property = that.isSetProperty();
            if (this_present_property || that_present_property) {
                if (!this_present_property || !that_present_property) {
                    return false;
                }
                if (!this.property.equals(that.property)) {
                    return false;
                }
            }
            boolean this_present_value = this.isSetValue();
            boolean that_present_value = that.isSetValue();
            if (this_present_value || that_present_value) {
                if (!this_present_value || !that_present_value) {
                    return false;
                }
                if (!this.value.equals(that.value)) {
                    return false;
                }
            }
            return true;
        }

        public int hashCode() {
            return 0;
        }

        public int compareTo(setTableProperty_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            setTableProperty_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetTinfo()).compareTo(typedOther.isSetTinfo());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetTinfo() && (lastComparison = TBaseHelper.compareTo((Comparable)this.tinfo, (Comparable)typedOther.tinfo)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetCredentials()).compareTo(typedOther.isSetCredentials());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetCredentials() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.credentials), (Comparable)((Object)typedOther.credentials))) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetTableName()).compareTo(typedOther.isSetTableName());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetTableName() && (lastComparison = TBaseHelper.compareTo((String)this.tableName, (String)typedOther.tableName)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetProperty()).compareTo(typedOther.isSetProperty());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetProperty() && (lastComparison = TBaseHelper.compareTo((String)this.property, (String)typedOther.property)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetValue()).compareTo(typedOther.isSetValue());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetValue() && (lastComparison = TBaseHelper.compareTo((String)this.value, (String)typedOther.value)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        public _Fields fieldForId(int fieldId) {
            return _Fields.findByThriftId(fieldId);
        }

        public void read(TProtocol iprot) throws TException {
            schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
        }

        public void write(TProtocol oprot) throws TException {
            schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("setTableProperty_args(");
            boolean first = true;
            sb.append("tinfo:");
            if (this.tinfo == null) {
                sb.append("null");
            } else {
                sb.append(this.tinfo);
            }
            first = false;
            if (!first) {
                sb.append(", ");
            }
            sb.append("credentials:");
            if (this.credentials == null) {
                sb.append("null");
            } else {
                sb.append(this.credentials);
            }
            first = false;
            if (!first) {
                sb.append(", ");
            }
            sb.append("tableName:");
            if (this.tableName == null) {
                sb.append("null");
            } else {
                sb.append(this.tableName);
            }
            first = false;
            if (!first) {
                sb.append(", ");
            }
            sb.append("property:");
            if (this.property == null) {
                sb.append("null");
            } else {
                sb.append(this.property);
            }
            first = false;
            if (!first) {
                sb.append(", ");
            }
            sb.append("value:");
            if (this.value == null) {
                sb.append("null");
            } else {
                sb.append(this.value);
            }
            first = false;
            sb.append(")");
            return sb.toString();
        }

        public void validate() throws TException {
            if (this.tinfo != null) {
                this.tinfo.validate();
            }
            if (this.credentials != null) {
                this.credentials.validate();
            }
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            try {
                this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
            }
            catch (TException te) {
                throw new IOException(te);
            }
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            try {
                this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
            }
            catch (TException te) {
                throw new IOException(te);
            }
        }

        static {
            schemes.put(StandardScheme.class, new setTableProperty_argsStandardSchemeFactory());
            schemes.put(TupleScheme.class, new setTableProperty_argsTupleSchemeFactory());
            EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
            tmpMap.put(_Fields.TINFO, new FieldMetaData("tinfo", 3, (FieldValueMetaData)new StructMetaData(12, TInfo.class)));
            tmpMap.put(_Fields.CREDENTIALS, new FieldMetaData("credentials", 3, (FieldValueMetaData)new StructMetaData(12, TCredentials.class)));
            tmpMap.put(_Fields.TABLE_NAME, new FieldMetaData("tableName", 3, new FieldValueMetaData(11)));
            tmpMap.put(_Fields.PROPERTY, new FieldMetaData("property", 3, new FieldValueMetaData(11)));
            tmpMap.put(_Fields.VALUE, new FieldMetaData("value", 3, new FieldValueMetaData(11)));
            metaDataMap = Collections.unmodifiableMap(tmpMap);
            FieldMetaData.addStructMetaDataMap(setTableProperty_args.class, metaDataMap);
        }

        private static class setTableProperty_argsTupleScheme
        extends TupleScheme<setTableProperty_args> {
            private setTableProperty_argsTupleScheme() {
            }

            public void write(TProtocol prot, setTableProperty_args struct) throws TException {
                TTupleProtocol oprot = (TTupleProtocol)prot;
                BitSet optionals = new BitSet();
                if (struct.isSetTinfo()) {
                    optionals.set(0);
                }
                if (struct.isSetCredentials()) {
                    optionals.set(1);
                }
                if (struct.isSetTableName()) {
                    optionals.set(2);
                }
                if (struct.isSetProperty()) {
                    optionals.set(3);
                }
                if (struct.isSetValue()) {
                    optionals.set(4);
                }
                oprot.writeBitSet(optionals, 5);
                if (struct.isSetTinfo()) {
                    struct.tinfo.write((TProtocol)oprot);
                }
                if (struct.isSetCredentials()) {
                    struct.credentials.write((TProtocol)oprot);
                }
                if (struct.isSetTableName()) {
                    oprot.writeString(struct.tableName);
                }
                if (struct.isSetProperty()) {
                    oprot.writeString(struct.property);
                }
                if (struct.isSetValue()) {
                    oprot.writeString(struct.value);
                }
            }

            public void read(TProtocol prot, setTableProperty_args struct) throws TException {
                TTupleProtocol iprot = (TTupleProtocol)prot;
                BitSet incoming = iprot.readBitSet(5);
                if (incoming.get(0)) {
                    struct.tinfo = new TInfo();
                    struct.tinfo.read((TProtocol)iprot);
                    struct.setTinfoIsSet(true);
                }
                if (incoming.get(1)) {
                    struct.credentials = new TCredentials();
                    struct.credentials.read((TProtocol)iprot);
                    struct.setCredentialsIsSet(true);
                }
                if (incoming.get(2)) {
                    struct.tableName = iprot.readString();
                    struct.setTableNameIsSet(true);
                }
                if (incoming.get(3)) {
                    struct.property = iprot.readString();
                    struct.setPropertyIsSet(true);
                }
                if (incoming.get(4)) {
                    struct.value = iprot.readString();
                    struct.setValueIsSet(true);
                }
            }
        }

        private static class setTableProperty_argsTupleSchemeFactory
        implements SchemeFactory {
            private setTableProperty_argsTupleSchemeFactory() {
            }

            public setTableProperty_argsTupleScheme getScheme() {
                return new setTableProperty_argsTupleScheme();
            }
        }

        private static class setTableProperty_argsStandardScheme
        extends StandardScheme<setTableProperty_args> {
            private setTableProperty_argsStandardScheme() {
            }

            public void read(TProtocol iprot, setTableProperty_args struct) throws TException {
                iprot.readStructBegin();
                while (true) {
                    TField schemeField = iprot.readFieldBegin();
                    if (schemeField.type == 0) break;
                    switch (schemeField.id) {
                        case 5: {
                            if (schemeField.type == 12) {
                                struct.tinfo = new TInfo();
                                struct.tinfo.read(iprot);
                                struct.setTinfoIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        case 1: {
                            if (schemeField.type == 12) {
                                struct.credentials = new TCredentials();
                                struct.credentials.read(iprot);
                                struct.setCredentialsIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        case 2: {
                            if (schemeField.type == 11) {
                                struct.tableName = iprot.readString();
                                struct.setTableNameIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        case 3: {
                            if (schemeField.type == 11) {
                                struct.property = iprot.readString();
                                struct.setPropertyIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        case 4: {
                            if (schemeField.type == 11) {
                                struct.value = iprot.readString();
                                struct.setValueIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        default: {
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        }
                    }
                    iprot.readFieldEnd();
                }
                iprot.readStructEnd();
                struct.validate();
            }

            public void write(TProtocol oprot, setTableProperty_args struct) throws TException {
                struct.validate();
                oprot.writeStructBegin(STRUCT_DESC);
                if (struct.credentials != null) {
                    oprot.writeFieldBegin(CREDENTIALS_FIELD_DESC);
                    struct.credentials.write(oprot);
                    oprot.writeFieldEnd();
                }
                if (struct.tableName != null) {
                    oprot.writeFieldBegin(TABLE_NAME_FIELD_DESC);
                    oprot.writeString(struct.tableName);
                    oprot.writeFieldEnd();
                }
                if (struct.property != null) {
                    oprot.writeFieldBegin(PROPERTY_FIELD_DESC);
                    oprot.writeString(struct.property);
                    oprot.writeFieldEnd();
                }
                if (struct.value != null) {
                    oprot.writeFieldBegin(VALUE_FIELD_DESC);
                    oprot.writeString(struct.value);
                    oprot.writeFieldEnd();
                }
                if (struct.tinfo != null) {
                    oprot.writeFieldBegin(TINFO_FIELD_DESC);
                    struct.tinfo.write(oprot);
                    oprot.writeFieldEnd();
                }
                oprot.writeFieldStop();
                oprot.writeStructEnd();
            }
        }

        private static class setTableProperty_argsStandardSchemeFactory
        implements SchemeFactory {
            private setTableProperty_argsStandardSchemeFactory() {
            }

            public setTableProperty_argsStandardScheme getScheme() {
                return new setTableProperty_argsStandardScheme();
            }
        }

        public static enum _Fields implements TFieldIdEnum
        {
            TINFO(5, "tinfo"),
            CREDENTIALS(1, "credentials"),
            TABLE_NAME(2, "tableName"),
            PROPERTY(3, "property"),
            VALUE(4, "value");

            private static final Map<String, _Fields> byName;
            private final short _thriftId;
            private final String _fieldName;

            public static _Fields findByThriftId(int fieldId) {
                switch (fieldId) {
                    case 5: {
                        return TINFO;
                    }
                    case 1: {
                        return CREDENTIALS;
                    }
                    case 2: {
                        return TABLE_NAME;
                    }
                    case 3: {
                        return PROPERTY;
                    }
                    case 4: {
                        return VALUE;
                    }
                }
                return null;
            }

            public static _Fields findByThriftIdOrThrow(int fieldId) {
                _Fields fields = _Fields.findByThriftId(fieldId);
                if (fields == null) {
                    throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
                }
                return fields;
            }

            public static _Fields findByName(String name) {
                return byName.get(name);
            }

            private _Fields(short thriftId, String fieldName) {
                this._thriftId = thriftId;
                this._fieldName = fieldName;
            }

            public short getThriftFieldId() {
                return this._thriftId;
            }

            public String getFieldName() {
                return this._fieldName;
            }

            static {
                byName = new HashMap<String, _Fields>();
                for (_Fields field : EnumSet.allOf(_Fields.class)) {
                    byName.put(field.getFieldName(), field);
                }
            }
        }
    }

    public static class waitForFlush_result
    implements TBase<waitForFlush_result, _Fields>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("waitForFlush_result");
        private static final TField SEC_FIELD_DESC = new TField("sec", 12, 1);
        private static final TField TOPE_FIELD_DESC = new TField("tope", 12, 2);
        private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
        public ThriftSecurityException sec;
        public ThriftTableOperationException tope;
        public static final Map<_Fields, FieldMetaData> metaDataMap;

        public waitForFlush_result() {
        }

        public waitForFlush_result(ThriftSecurityException sec, ThriftTableOperationException tope) {
            this();
            this.sec = sec;
            this.tope = tope;
        }

        public waitForFlush_result(waitForFlush_result other) {
            if (other.isSetSec()) {
                this.sec = new ThriftSecurityException(other.sec);
            }
            if (other.isSetTope()) {
                this.tope = new ThriftTableOperationException(other.tope);
            }
        }

        public waitForFlush_result deepCopy() {
            return new waitForFlush_result(this);
        }

        public void clear() {
            this.sec = null;
            this.tope = null;
        }

        public ThriftSecurityException getSec() {
            return this.sec;
        }

        public waitForFlush_result setSec(ThriftSecurityException sec) {
            this.sec = sec;
            return this;
        }

        public void unsetSec() {
            this.sec = null;
        }

        public boolean isSetSec() {
            return this.sec != null;
        }

        public void setSecIsSet(boolean value) {
            if (!value) {
                this.sec = null;
            }
        }

        public ThriftTableOperationException getTope() {
            return this.tope;
        }

        public waitForFlush_result setTope(ThriftTableOperationException tope) {
            this.tope = tope;
            return this;
        }

        public void unsetTope() {
            this.tope = null;
        }

        public boolean isSetTope() {
            return this.tope != null;
        }

        public void setTopeIsSet(boolean value) {
            if (!value) {
                this.tope = null;
            }
        }

        public void setFieldValue(_Fields field, Object value) {
            switch (field) {
                case SEC: {
                    if (value == null) {
                        this.unsetSec();
                        break;
                    }
                    this.setSec((ThriftSecurityException)value);
                    break;
                }
                case TOPE: {
                    if (value == null) {
                        this.unsetTope();
                        break;
                    }
                    this.setTope((ThriftTableOperationException)value);
                }
            }
        }

        public Object getFieldValue(_Fields field) {
            switch (field) {
                case SEC: {
                    return this.getSec();
                }
                case TOPE: {
                    return this.getTope();
                }
            }
            throw new IllegalStateException();
        }

        public boolean isSet(_Fields field) {
            if (field == null) {
                throw new IllegalArgumentException();
            }
            switch (field) {
                case SEC: {
                    return this.isSetSec();
                }
                case TOPE: {
                    return this.isSetTope();
                }
            }
            throw new IllegalStateException();
        }

        public boolean equals(Object that) {
            if (that == null) {
                return false;
            }
            if (that instanceof waitForFlush_result) {
                return this.equals((waitForFlush_result)that);
            }
            return false;
        }

        public boolean equals(waitForFlush_result that) {
            if (that == null) {
                return false;
            }
            boolean this_present_sec = this.isSetSec();
            boolean that_present_sec = that.isSetSec();
            if (this_present_sec || that_present_sec) {
                if (!this_present_sec || !that_present_sec) {
                    return false;
                }
                if (!this.sec.equals(that.sec)) {
                    return false;
                }
            }
            boolean this_present_tope = this.isSetTope();
            boolean that_present_tope = that.isSetTope();
            if (this_present_tope || that_present_tope) {
                if (!this_present_tope || !that_present_tope) {
                    return false;
                }
                if (!this.tope.equals(that.tope)) {
                    return false;
                }
            }
            return true;
        }

        public int hashCode() {
            return 0;
        }

        public int compareTo(waitForFlush_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            waitForFlush_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSec()).compareTo(typedOther.isSetSec());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSec() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.sec), (Comparable)((Object)typedOther.sec))) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetTope()).compareTo(typedOther.isSetTope());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetTope() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.tope), (Comparable)((Object)typedOther.tope))) != 0) {
                return lastComparison;
            }
            return 0;
        }

        public _Fields fieldForId(int fieldId) {
            return _Fields.findByThriftId(fieldId);
        }

        public void read(TProtocol iprot) throws TException {
            schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
        }

        public void write(TProtocol oprot) throws TException {
            schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("waitForFlush_result(");
            boolean first = true;
            sb.append("sec:");
            if (this.sec == null) {
                sb.append("null");
            } else {
                sb.append(this.sec);
            }
            first = false;
            if (!first) {
                sb.append(", ");
            }
            sb.append("tope:");
            if (this.tope == null) {
                sb.append("null");
            } else {
                sb.append(this.tope);
            }
            first = false;
            sb.append(")");
            return sb.toString();
        }

        public void validate() throws TException {
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            try {
                this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
            }
            catch (TException te) {
                throw new IOException(te);
            }
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            try {
                this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
            }
            catch (TException te) {
                throw new IOException(te);
            }
        }

        static {
            schemes.put(StandardScheme.class, new waitForFlush_resultStandardSchemeFactory());
            schemes.put(TupleScheme.class, new waitForFlush_resultTupleSchemeFactory());
            EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
            tmpMap.put(_Fields.SEC, new FieldMetaData("sec", 3, new FieldValueMetaData(12)));
            tmpMap.put(_Fields.TOPE, new FieldMetaData("tope", 3, new FieldValueMetaData(12)));
            metaDataMap = Collections.unmodifiableMap(tmpMap);
            FieldMetaData.addStructMetaDataMap(waitForFlush_result.class, metaDataMap);
        }

        private static class waitForFlush_resultTupleScheme
        extends TupleScheme<waitForFlush_result> {
            private waitForFlush_resultTupleScheme() {
            }

            public void write(TProtocol prot, waitForFlush_result struct) throws TException {
                TTupleProtocol oprot = (TTupleProtocol)prot;
                BitSet optionals = new BitSet();
                if (struct.isSetSec()) {
                    optionals.set(0);
                }
                if (struct.isSetTope()) {
                    optionals.set(1);
                }
                oprot.writeBitSet(optionals, 2);
                if (struct.isSetSec()) {
                    struct.sec.write((TProtocol)oprot);
                }
                if (struct.isSetTope()) {
                    struct.tope.write((TProtocol)oprot);
                }
            }

            public void read(TProtocol prot, waitForFlush_result struct) throws TException {
                TTupleProtocol iprot = (TTupleProtocol)prot;
                BitSet incoming = iprot.readBitSet(2);
                if (incoming.get(0)) {
                    struct.sec = new ThriftSecurityException();
                    struct.sec.read((TProtocol)iprot);
                    struct.setSecIsSet(true);
                }
                if (incoming.get(1)) {
                    struct.tope = new ThriftTableOperationException();
                    struct.tope.read((TProtocol)iprot);
                    struct.setTopeIsSet(true);
                }
            }
        }

        private static class waitForFlush_resultTupleSchemeFactory
        implements SchemeFactory {
            private waitForFlush_resultTupleSchemeFactory() {
            }

            public waitForFlush_resultTupleScheme getScheme() {
                return new waitForFlush_resultTupleScheme();
            }
        }

        private static class waitForFlush_resultStandardScheme
        extends StandardScheme<waitForFlush_result> {
            private waitForFlush_resultStandardScheme() {
            }

            public void read(TProtocol iprot, waitForFlush_result struct) throws TException {
                iprot.readStructBegin();
                while (true) {
                    TField schemeField = iprot.readFieldBegin();
                    if (schemeField.type == 0) break;
                    switch (schemeField.id) {
                        case 1: {
                            if (schemeField.type == 12) {
                                struct.sec = new ThriftSecurityException();
                                struct.sec.read(iprot);
                                struct.setSecIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        case 2: {
                            if (schemeField.type == 12) {
                                struct.tope = new ThriftTableOperationException();
                                struct.tope.read(iprot);
                                struct.setTopeIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        default: {
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        }
                    }
                    iprot.readFieldEnd();
                }
                iprot.readStructEnd();
                struct.validate();
            }

            public void write(TProtocol oprot, waitForFlush_result struct) throws TException {
                struct.validate();
                oprot.writeStructBegin(STRUCT_DESC);
                if (struct.sec != null) {
                    oprot.writeFieldBegin(SEC_FIELD_DESC);
                    struct.sec.write(oprot);
                    oprot.writeFieldEnd();
                }
                if (struct.tope != null) {
                    oprot.writeFieldBegin(TOPE_FIELD_DESC);
                    struct.tope.write(oprot);
                    oprot.writeFieldEnd();
                }
                oprot.writeFieldStop();
                oprot.writeStructEnd();
            }
        }

        private static class waitForFlush_resultStandardSchemeFactory
        implements SchemeFactory {
            private waitForFlush_resultStandardSchemeFactory() {
            }

            public waitForFlush_resultStandardScheme getScheme() {
                return new waitForFlush_resultStandardScheme();
            }
        }

        public static enum _Fields implements TFieldIdEnum
        {
            SEC(1, "sec"),
            TOPE(2, "tope");

            private static final Map<String, _Fields> byName;
            private final short _thriftId;
            private final String _fieldName;

            public static _Fields findByThriftId(int fieldId) {
                switch (fieldId) {
                    case 1: {
                        return SEC;
                    }
                    case 2: {
                        return TOPE;
                    }
                }
                return null;
            }

            public static _Fields findByThriftIdOrThrow(int fieldId) {
                _Fields fields = _Fields.findByThriftId(fieldId);
                if (fields == null) {
                    throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
                }
                return fields;
            }

            public static _Fields findByName(String name) {
                return byName.get(name);
            }

            private _Fields(short thriftId, String fieldName) {
                this._thriftId = thriftId;
                this._fieldName = fieldName;
            }

            public short getThriftFieldId() {
                return this._thriftId;
            }

            public String getFieldName() {
                return this._fieldName;
            }

            static {
                byName = new HashMap<String, _Fields>();
                for (_Fields field : EnumSet.allOf(_Fields.class)) {
                    byName.put(field.getFieldName(), field);
                }
            }
        }
    }

    public static class waitForFlush_args
    implements TBase<waitForFlush_args, _Fields>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("waitForFlush_args");
        private static final TField TINFO_FIELD_DESC = new TField("tinfo", 12, 5);
        private static final TField CREDENTIALS_FIELD_DESC = new TField("credentials", 12, 1);
        private static final TField TABLE_NAME_FIELD_DESC = new TField("tableName", 11, 2);
        private static final TField START_ROW_FIELD_DESC = new TField("startRow", 11, 6);
        private static final TField END_ROW_FIELD_DESC = new TField("endRow", 11, 7);
        private static final TField FLUSH_ID_FIELD_DESC = new TField("flushID", 10, 3);
        private static final TField MAX_LOOPS_FIELD_DESC = new TField("maxLoops", 10, 4);
        private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
        public TInfo tinfo;
        public TCredentials credentials;
        public String tableName;
        public ByteBuffer startRow;
        public ByteBuffer endRow;
        public long flushID;
        public long maxLoops;
        private static final int __FLUSHID_ISSET_ID = 0;
        private static final int __MAXLOOPS_ISSET_ID = 1;
        private byte __isset_bitfield = 0;
        public static final Map<_Fields, FieldMetaData> metaDataMap;

        public waitForFlush_args() {
        }

        public waitForFlush_args(TInfo tinfo, TCredentials credentials, String tableName, ByteBuffer startRow, ByteBuffer endRow, long flushID, long maxLoops) {
            this();
            this.tinfo = tinfo;
            this.credentials = credentials;
            this.tableName = tableName;
            this.startRow = startRow;
            this.endRow = endRow;
            this.flushID = flushID;
            this.setFlushIDIsSet(true);
            this.maxLoops = maxLoops;
            this.setMaxLoopsIsSet(true);
        }

        public waitForFlush_args(waitForFlush_args other) {
            this.__isset_bitfield = other.__isset_bitfield;
            if (other.isSetTinfo()) {
                this.tinfo = new TInfo(other.tinfo);
            }
            if (other.isSetCredentials()) {
                this.credentials = new TCredentials(other.credentials);
            }
            if (other.isSetTableName()) {
                this.tableName = other.tableName;
            }
            if (other.isSetStartRow()) {
                this.startRow = TBaseHelper.copyBinary((ByteBuffer)other.startRow);
            }
            if (other.isSetEndRow()) {
                this.endRow = TBaseHelper.copyBinary((ByteBuffer)other.endRow);
            }
            this.flushID = other.flushID;
            this.maxLoops = other.maxLoops;
        }

        public waitForFlush_args deepCopy() {
            return new waitForFlush_args(this);
        }

        public void clear() {
            this.tinfo = null;
            this.credentials = null;
            this.tableName = null;
            this.startRow = null;
            this.endRow = null;
            this.setFlushIDIsSet(false);
            this.flushID = 0L;
            this.setMaxLoopsIsSet(false);
            this.maxLoops = 0L;
        }

        public TInfo getTinfo() {
            return this.tinfo;
        }

        public waitForFlush_args setTinfo(TInfo tinfo) {
            this.tinfo = tinfo;
            return this;
        }

        public void unsetTinfo() {
            this.tinfo = null;
        }

        public boolean isSetTinfo() {
            return this.tinfo != null;
        }

        public void setTinfoIsSet(boolean value) {
            if (!value) {
                this.tinfo = null;
            }
        }

        public TCredentials getCredentials() {
            return this.credentials;
        }

        public waitForFlush_args setCredentials(TCredentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public void unsetCredentials() {
            this.credentials = null;
        }

        public boolean isSetCredentials() {
            return this.credentials != null;
        }

        public void setCredentialsIsSet(boolean value) {
            if (!value) {
                this.credentials = null;
            }
        }

        public String getTableName() {
            return this.tableName;
        }

        public waitForFlush_args setTableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public void unsetTableName() {
            this.tableName = null;
        }

        public boolean isSetTableName() {
            return this.tableName != null;
        }

        public void setTableNameIsSet(boolean value) {
            if (!value) {
                this.tableName = null;
            }
        }

        public byte[] getStartRow() {
            this.setStartRow(TBaseHelper.rightSize((ByteBuffer)this.startRow));
            return this.startRow == null ? null : this.startRow.array();
        }

        public ByteBuffer bufferForStartRow() {
            return this.startRow;
        }

        public waitForFlush_args setStartRow(byte[] startRow) {
            this.setStartRow(startRow == null ? (ByteBuffer)null : ByteBuffer.wrap(startRow));
            return this;
        }

        public waitForFlush_args setStartRow(ByteBuffer startRow) {
            this.startRow = startRow;
            return this;
        }

        public void unsetStartRow() {
            this.startRow = null;
        }

        public boolean isSetStartRow() {
            return this.startRow != null;
        }

        public void setStartRowIsSet(boolean value) {
            if (!value) {
                this.startRow = null;
            }
        }

        public byte[] getEndRow() {
            this.setEndRow(TBaseHelper.rightSize((ByteBuffer)this.endRow));
            return this.endRow == null ? null : this.endRow.array();
        }

        public ByteBuffer bufferForEndRow() {
            return this.endRow;
        }

        public waitForFlush_args setEndRow(byte[] endRow) {
            this.setEndRow(endRow == null ? (ByteBuffer)null : ByteBuffer.wrap(endRow));
            return this;
        }

        public waitForFlush_args setEndRow(ByteBuffer endRow) {
            this.endRow = endRow;
            return this;
        }

        public void unsetEndRow() {
            this.endRow = null;
        }

        public boolean isSetEndRow() {
            return this.endRow != null;
        }

        public void setEndRowIsSet(boolean value) {
            if (!value) {
                this.endRow = null;
            }
        }

        public long getFlushID() {
            return this.flushID;
        }

        public waitForFlush_args setFlushID(long flushID) {
            this.flushID = flushID;
            this.setFlushIDIsSet(true);
            return this;
        }

        public void unsetFlushID() {
            this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
        }

        public boolean isSetFlushID() {
            return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
        }

        public void setFlushIDIsSet(boolean value) {
            this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
        }

        public long getMaxLoops() {
            return this.maxLoops;
        }

        public waitForFlush_args setMaxLoops(long maxLoops) {
            this.maxLoops = maxLoops;
            this.setMaxLoopsIsSet(true);
            return this;
        }

        public void unsetMaxLoops() {
            this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)1);
        }

        public boolean isSetMaxLoops() {
            return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)1);
        }

        public void setMaxLoopsIsSet(boolean value) {
            this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)1, (boolean)value);
        }

        public void setFieldValue(_Fields field, Object value) {
            switch (field) {
                case TINFO: {
                    if (value == null) {
                        this.unsetTinfo();
                        break;
                    }
                    this.setTinfo((TInfo)value);
                    break;
                }
                case CREDENTIALS: {
                    if (value == null) {
                        this.unsetCredentials();
                        break;
                    }
                    this.setCredentials((TCredentials)value);
                    break;
                }
                case TABLE_NAME: {
                    if (value == null) {
                        this.unsetTableName();
                        break;
                    }
                    this.setTableName((String)value);
                    break;
                }
                case START_ROW: {
                    if (value == null) {
                        this.unsetStartRow();
                        break;
                    }
                    this.setStartRow((ByteBuffer)value);
                    break;
                }
                case END_ROW: {
                    if (value == null) {
                        this.unsetEndRow();
                        break;
                    }
                    this.setEndRow((ByteBuffer)value);
                    break;
                }
                case FLUSH_ID: {
                    if (value == null) {
                        this.unsetFlushID();
                        break;
                    }
                    this.setFlushID((Long)value);
                    break;
                }
                case MAX_LOOPS: {
                    if (value == null) {
                        this.unsetMaxLoops();
                        break;
                    }
                    this.setMaxLoops((Long)value);
                }
            }
        }

        public Object getFieldValue(_Fields field) {
            switch (field) {
                case TINFO: {
                    return this.getTinfo();
                }
                case CREDENTIALS: {
                    return this.getCredentials();
                }
                case TABLE_NAME: {
                    return this.getTableName();
                }
                case START_ROW: {
                    return this.getStartRow();
                }
                case END_ROW: {
                    return this.getEndRow();
                }
                case FLUSH_ID: {
                    return this.getFlushID();
                }
                case MAX_LOOPS: {
                    return this.getMaxLoops();
                }
            }
            throw new IllegalStateException();
        }

        public boolean isSet(_Fields field) {
            if (field == null) {
                throw new IllegalArgumentException();
            }
            switch (field) {
                case TINFO: {
                    return this.isSetTinfo();
                }
                case CREDENTIALS: {
                    return this.isSetCredentials();
                }
                case TABLE_NAME: {
                    return this.isSetTableName();
                }
                case START_ROW: {
                    return this.isSetStartRow();
                }
                case END_ROW: {
                    return this.isSetEndRow();
                }
                case FLUSH_ID: {
                    return this.isSetFlushID();
                }
                case MAX_LOOPS: {
                    return this.isSetMaxLoops();
                }
            }
            throw new IllegalStateException();
        }

        public boolean equals(Object that) {
            if (that == null) {
                return false;
            }
            if (that instanceof waitForFlush_args) {
                return this.equals((waitForFlush_args)that);
            }
            return false;
        }

        public boolean equals(waitForFlush_args that) {
            if (that == null) {
                return false;
            }
            boolean this_present_tinfo = this.isSetTinfo();
            boolean that_present_tinfo = that.isSetTinfo();
            if (this_present_tinfo || that_present_tinfo) {
                if (!this_present_tinfo || !that_present_tinfo) {
                    return false;
                }
                if (!this.tinfo.equals(that.tinfo)) {
                    return false;
                }
            }
            boolean this_present_credentials = this.isSetCredentials();
            boolean that_present_credentials = that.isSetCredentials();
            if (this_present_credentials || that_present_credentials) {
                if (!this_present_credentials || !that_present_credentials) {
                    return false;
                }
                if (!this.credentials.equals(that.credentials)) {
                    return false;
                }
            }
            boolean this_present_tableName = this.isSetTableName();
            boolean that_present_tableName = that.isSetTableName();
            if (this_present_tableName || that_present_tableName) {
                if (!this_present_tableName || !that_present_tableName) {
                    return false;
                }
                if (!this.tableName.equals(that.tableName)) {
                    return false;
                }
            }
            boolean this_present_startRow = this.isSetStartRow();
            boolean that_present_startRow = that.isSetStartRow();
            if (this_present_startRow || that_present_startRow) {
                if (!this_present_startRow || !that_present_startRow) {
                    return false;
                }
                if (!this.startRow.equals(that.startRow)) {
                    return false;
                }
            }
            boolean this_present_endRow = this.isSetEndRow();
            boolean that_present_endRow = that.isSetEndRow();
            if (this_present_endRow || that_present_endRow) {
                if (!this_present_endRow || !that_present_endRow) {
                    return false;
                }
                if (!this.endRow.equals(that.endRow)) {
                    return false;
                }
            }
            boolean this_present_flushID = true;
            boolean that_present_flushID = true;
            if (this_present_flushID || that_present_flushID) {
                if (!this_present_flushID || !that_present_flushID) {
                    return false;
                }
                if (this.flushID != that.flushID) {
                    return false;
                }
            }
            boolean this_present_maxLoops = true;
            boolean that_present_maxLoops = true;
            if (this_present_maxLoops || that_present_maxLoops) {
                if (!this_present_maxLoops || !that_present_maxLoops) {
                    return false;
                }
                if (this.maxLoops != that.maxLoops) {
                    return false;
                }
            }
            return true;
        }

        public int hashCode() {
            return 0;
        }

        public int compareTo(waitForFlush_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            waitForFlush_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetTinfo()).compareTo(typedOther.isSetTinfo());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetTinfo() && (lastComparison = TBaseHelper.compareTo((Comparable)this.tinfo, (Comparable)typedOther.tinfo)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetCredentials()).compareTo(typedOther.isSetCredentials());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetCredentials() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.credentials), (Comparable)((Object)typedOther.credentials))) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetTableName()).compareTo(typedOther.isSetTableName());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetTableName() && (lastComparison = TBaseHelper.compareTo((String)this.tableName, (String)typedOther.tableName)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetStartRow()).compareTo(typedOther.isSetStartRow());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetStartRow() && (lastComparison = TBaseHelper.compareTo((Comparable)this.startRow, (Comparable)typedOther.startRow)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetEndRow()).compareTo(typedOther.isSetEndRow());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetEndRow() && (lastComparison = TBaseHelper.compareTo((Comparable)this.endRow, (Comparable)typedOther.endRow)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetFlushID()).compareTo(typedOther.isSetFlushID());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetFlushID() && (lastComparison = TBaseHelper.compareTo((long)this.flushID, (long)typedOther.flushID)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetMaxLoops()).compareTo(typedOther.isSetMaxLoops());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetMaxLoops() && (lastComparison = TBaseHelper.compareTo((long)this.maxLoops, (long)typedOther.maxLoops)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        public _Fields fieldForId(int fieldId) {
            return _Fields.findByThriftId(fieldId);
        }

        public void read(TProtocol iprot) throws TException {
            schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
        }

        public void write(TProtocol oprot) throws TException {
            schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("waitForFlush_args(");
            boolean first = true;
            sb.append("tinfo:");
            if (this.tinfo == null) {
                sb.append("null");
            } else {
                sb.append(this.tinfo);
            }
            first = false;
            if (!first) {
                sb.append(", ");
            }
            sb.append("credentials:");
            if (this.credentials == null) {
                sb.append("null");
            } else {
                sb.append(this.credentials);
            }
            first = false;
            if (!first) {
                sb.append(", ");
            }
            sb.append("tableName:");
            if (this.tableName == null) {
                sb.append("null");
            } else {
                sb.append(this.tableName);
            }
            first = false;
            if (!first) {
                sb.append(", ");
            }
            sb.append("startRow:");
            if (this.startRow == null) {
                sb.append("null");
            } else {
                TBaseHelper.toString((ByteBuffer)this.startRow, (StringBuilder)sb);
            }
            first = false;
            if (!first) {
                sb.append(", ");
            }
            sb.append("endRow:");
            if (this.endRow == null) {
                sb.append("null");
            } else {
                TBaseHelper.toString((ByteBuffer)this.endRow, (StringBuilder)sb);
            }
            first = false;
            if (!first) {
                sb.append(", ");
            }
            sb.append("flushID:");
            sb.append(this.flushID);
            first = false;
            if (!first) {
                sb.append(", ");
            }
            sb.append("maxLoops:");
            sb.append(this.maxLoops);
            first = false;
            sb.append(")");
            return sb.toString();
        }

        public void validate() throws TException {
            if (this.tinfo != null) {
                this.tinfo.validate();
            }
            if (this.credentials != null) {
                this.credentials.validate();
            }
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            try {
                this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
            }
            catch (TException te) {
                throw new IOException(te);
            }
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            try {
                this.__isset_bitfield = 0;
                this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
            }
            catch (TException te) {
                throw new IOException(te);
            }
        }

        static {
            schemes.put(StandardScheme.class, new waitForFlush_argsStandardSchemeFactory());
            schemes.put(TupleScheme.class, new waitForFlush_argsTupleSchemeFactory());
            EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
            tmpMap.put(_Fields.TINFO, new FieldMetaData("tinfo", 3, (FieldValueMetaData)new StructMetaData(12, TInfo.class)));
            tmpMap.put(_Fields.CREDENTIALS, new FieldMetaData("credentials", 3, (FieldValueMetaData)new StructMetaData(12, TCredentials.class)));
            tmpMap.put(_Fields.TABLE_NAME, new FieldMetaData("tableName", 3, new FieldValueMetaData(11)));
            tmpMap.put(_Fields.START_ROW, new FieldMetaData("startRow", 3, new FieldValueMetaData(11, true)));
            tmpMap.put(_Fields.END_ROW, new FieldMetaData("endRow", 3, new FieldValueMetaData(11, true)));
            tmpMap.put(_Fields.FLUSH_ID, new FieldMetaData("flushID", 3, new FieldValueMetaData(10)));
            tmpMap.put(_Fields.MAX_LOOPS, new FieldMetaData("maxLoops", 3, new FieldValueMetaData(10)));
            metaDataMap = Collections.unmodifiableMap(tmpMap);
            FieldMetaData.addStructMetaDataMap(waitForFlush_args.class, metaDataMap);
        }

        private static class waitForFlush_argsTupleScheme
        extends TupleScheme<waitForFlush_args> {
            private waitForFlush_argsTupleScheme() {
            }

            public void write(TProtocol prot, waitForFlush_args struct) throws TException {
                TTupleProtocol oprot = (TTupleProtocol)prot;
                BitSet optionals = new BitSet();
                if (struct.isSetTinfo()) {
                    optionals.set(0);
                }
                if (struct.isSetCredentials()) {
                    optionals.set(1);
                }
                if (struct.isSetTableName()) {
                    optionals.set(2);
                }
                if (struct.isSetStartRow()) {
                    optionals.set(3);
                }
                if (struct.isSetEndRow()) {
                    optionals.set(4);
                }
                if (struct.isSetFlushID()) {
                    optionals.set(5);
                }
                if (struct.isSetMaxLoops()) {
                    optionals.set(6);
                }
                oprot.writeBitSet(optionals, 7);
                if (struct.isSetTinfo()) {
                    struct.tinfo.write((TProtocol)oprot);
                }
                if (struct.isSetCredentials()) {
                    struct.credentials.write((TProtocol)oprot);
                }
                if (struct.isSetTableName()) {
                    oprot.writeString(struct.tableName);
                }
                if (struct.isSetStartRow()) {
                    oprot.writeBinary(struct.startRow);
                }
                if (struct.isSetEndRow()) {
                    oprot.writeBinary(struct.endRow);
                }
                if (struct.isSetFlushID()) {
                    oprot.writeI64(struct.flushID);
                }
                if (struct.isSetMaxLoops()) {
                    oprot.writeI64(struct.maxLoops);
                }
            }

            public void read(TProtocol prot, waitForFlush_args struct) throws TException {
                TTupleProtocol iprot = (TTupleProtocol)prot;
                BitSet incoming = iprot.readBitSet(7);
                if (incoming.get(0)) {
                    struct.tinfo = new TInfo();
                    struct.tinfo.read((TProtocol)iprot);
                    struct.setTinfoIsSet(true);
                }
                if (incoming.get(1)) {
                    struct.credentials = new TCredentials();
                    struct.credentials.read((TProtocol)iprot);
                    struct.setCredentialsIsSet(true);
                }
                if (incoming.get(2)) {
                    struct.tableName = iprot.readString();
                    struct.setTableNameIsSet(true);
                }
                if (incoming.get(3)) {
                    struct.startRow = iprot.readBinary();
                    struct.setStartRowIsSet(true);
                }
                if (incoming.get(4)) {
                    struct.endRow = iprot.readBinary();
                    struct.setEndRowIsSet(true);
                }
                if (incoming.get(5)) {
                    struct.flushID = iprot.readI64();
                    struct.setFlushIDIsSet(true);
                }
                if (incoming.get(6)) {
                    struct.maxLoops = iprot.readI64();
                    struct.setMaxLoopsIsSet(true);
                }
            }
        }

        private static class waitForFlush_argsTupleSchemeFactory
        implements SchemeFactory {
            private waitForFlush_argsTupleSchemeFactory() {
            }

            public waitForFlush_argsTupleScheme getScheme() {
                return new waitForFlush_argsTupleScheme();
            }
        }

        private static class waitForFlush_argsStandardScheme
        extends StandardScheme<waitForFlush_args> {
            private waitForFlush_argsStandardScheme() {
            }

            public void read(TProtocol iprot, waitForFlush_args struct) throws TException {
                iprot.readStructBegin();
                while (true) {
                    TField schemeField = iprot.readFieldBegin();
                    if (schemeField.type == 0) break;
                    switch (schemeField.id) {
                        case 5: {
                            if (schemeField.type == 12) {
                                struct.tinfo = new TInfo();
                                struct.tinfo.read(iprot);
                                struct.setTinfoIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        case 1: {
                            if (schemeField.type == 12) {
                                struct.credentials = new TCredentials();
                                struct.credentials.read(iprot);
                                struct.setCredentialsIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        case 2: {
                            if (schemeField.type == 11) {
                                struct.tableName = iprot.readString();
                                struct.setTableNameIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        case 6: {
                            if (schemeField.type == 11) {
                                struct.startRow = iprot.readBinary();
                                struct.setStartRowIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        case 7: {
                            if (schemeField.type == 11) {
                                struct.endRow = iprot.readBinary();
                                struct.setEndRowIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        case 3: {
                            if (schemeField.type == 10) {
                                struct.flushID = iprot.readI64();
                                struct.setFlushIDIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        case 4: {
                            if (schemeField.type == 10) {
                                struct.maxLoops = iprot.readI64();
                                struct.setMaxLoopsIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        default: {
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        }
                    }
                    iprot.readFieldEnd();
                }
                iprot.readStructEnd();
                struct.validate();
            }

            public void write(TProtocol oprot, waitForFlush_args struct) throws TException {
                struct.validate();
                oprot.writeStructBegin(STRUCT_DESC);
                if (struct.credentials != null) {
                    oprot.writeFieldBegin(CREDENTIALS_FIELD_DESC);
                    struct.credentials.write(oprot);
                    oprot.writeFieldEnd();
                }
                if (struct.tableName != null) {
                    oprot.writeFieldBegin(TABLE_NAME_FIELD_DESC);
                    oprot.writeString(struct.tableName);
                    oprot.writeFieldEnd();
                }
                oprot.writeFieldBegin(FLUSH_ID_FIELD_DESC);
                oprot.writeI64(struct.flushID);
                oprot.writeFieldEnd();
                oprot.writeFieldBegin(MAX_LOOPS_FIELD_DESC);
                oprot.writeI64(struct.maxLoops);
                oprot.writeFieldEnd();
                if (struct.tinfo != null) {
                    oprot.writeFieldBegin(TINFO_FIELD_DESC);
                    struct.tinfo.write(oprot);
                    oprot.writeFieldEnd();
                }
                if (struct.startRow != null) {
                    oprot.writeFieldBegin(START_ROW_FIELD_DESC);
                    oprot.writeBinary(struct.startRow);
                    oprot.writeFieldEnd();
                }
                if (struct.endRow != null) {
                    oprot.writeFieldBegin(END_ROW_FIELD_DESC);
                    oprot.writeBinary(struct.endRow);
                    oprot.writeFieldEnd();
                }
                oprot.writeFieldStop();
                oprot.writeStructEnd();
            }
        }

        private static class waitForFlush_argsStandardSchemeFactory
        implements SchemeFactory {
            private waitForFlush_argsStandardSchemeFactory() {
            }

            public waitForFlush_argsStandardScheme getScheme() {
                return new waitForFlush_argsStandardScheme();
            }
        }

        public static enum _Fields implements TFieldIdEnum
        {
            TINFO(5, "tinfo"),
            CREDENTIALS(1, "credentials"),
            TABLE_NAME(2, "tableName"),
            START_ROW(6, "startRow"),
            END_ROW(7, "endRow"),
            FLUSH_ID(3, "flushID"),
            MAX_LOOPS(4, "maxLoops");

            private static final Map<String, _Fields> byName;
            private final short _thriftId;
            private final String _fieldName;

            public static _Fields findByThriftId(int fieldId) {
                switch (fieldId) {
                    case 5: {
                        return TINFO;
                    }
                    case 1: {
                        return CREDENTIALS;
                    }
                    case 2: {
                        return TABLE_NAME;
                    }
                    case 6: {
                        return START_ROW;
                    }
                    case 7: {
                        return END_ROW;
                    }
                    case 3: {
                        return FLUSH_ID;
                    }
                    case 4: {
                        return MAX_LOOPS;
                    }
                }
                return null;
            }

            public static _Fields findByThriftIdOrThrow(int fieldId) {
                _Fields fields = _Fields.findByThriftId(fieldId);
                if (fields == null) {
                    throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
                }
                return fields;
            }

            public static _Fields findByName(String name) {
                return byName.get(name);
            }

            private _Fields(short thriftId, String fieldName) {
                this._thriftId = thriftId;
                this._fieldName = fieldName;
            }

            public short getThriftFieldId() {
                return this._thriftId;
            }

            public String getFieldName() {
                return this._fieldName;
            }

            static {
                byName = new HashMap<String, _Fields>();
                for (_Fields field : EnumSet.allOf(_Fields.class)) {
                    byName.put(field.getFieldName(), field);
                }
            }
        }
    }

    public static class initiateFlush_result
    implements TBase<initiateFlush_result, _Fields>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("initiateFlush_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 10, 0);
        private static final TField SEC_FIELD_DESC = new TField("sec", 12, 1);
        private static final TField TOPE_FIELD_DESC = new TField("tope", 12, 2);
        private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
        public long success;
        public ThriftSecurityException sec;
        public ThriftTableOperationException tope;
        private static final int __SUCCESS_ISSET_ID = 0;
        private byte __isset_bitfield = 0;
        public static final Map<_Fields, FieldMetaData> metaDataMap;

        public initiateFlush_result() {
        }

        public initiateFlush_result(long success2, ThriftSecurityException sec, ThriftTableOperationException tope) {
            this();
            this.success = success2;
            this.setSuccessIsSet(true);
            this.sec = sec;
            this.tope = tope;
        }

        public initiateFlush_result(initiateFlush_result other) {
            this.__isset_bitfield = other.__isset_bitfield;
            this.success = other.success;
            if (other.isSetSec()) {
                this.sec = new ThriftSecurityException(other.sec);
            }
            if (other.isSetTope()) {
                this.tope = new ThriftTableOperationException(other.tope);
            }
        }

        public initiateFlush_result deepCopy() {
            return new initiateFlush_result(this);
        }

        public void clear() {
            this.setSuccessIsSet(false);
            this.success = 0L;
            this.sec = null;
            this.tope = null;
        }

        public long getSuccess() {
            return this.success;
        }

        public initiateFlush_result setSuccess(long success2) {
            this.success = success2;
            this.setSuccessIsSet(true);
            return this;
        }

        public void unsetSuccess() {
            this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
        }

        public boolean isSetSuccess() {
            return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
        }

        public void setSuccessIsSet(boolean value) {
            this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
        }

        public ThriftSecurityException getSec() {
            return this.sec;
        }

        public initiateFlush_result setSec(ThriftSecurityException sec) {
            this.sec = sec;
            return this;
        }

        public void unsetSec() {
            this.sec = null;
        }

        public boolean isSetSec() {
            return this.sec != null;
        }

        public void setSecIsSet(boolean value) {
            if (!value) {
                this.sec = null;
            }
        }

        public ThriftTableOperationException getTope() {
            return this.tope;
        }

        public initiateFlush_result setTope(ThriftTableOperationException tope) {
            this.tope = tope;
            return this;
        }

        public void unsetTope() {
            this.tope = null;
        }

        public boolean isSetTope() {
            return this.tope != null;
        }

        public void setTopeIsSet(boolean value) {
            if (!value) {
                this.tope = null;
            }
        }

        public void setFieldValue(_Fields field, Object value) {
            switch (field) {
                case SUCCESS: {
                    if (value == null) {
                        this.unsetSuccess();
                        break;
                    }
                    this.setSuccess((Long)value);
                    break;
                }
                case SEC: {
                    if (value == null) {
                        this.unsetSec();
                        break;
                    }
                    this.setSec((ThriftSecurityException)value);
                    break;
                }
                case TOPE: {
                    if (value == null) {
                        this.unsetTope();
                        break;
                    }
                    this.setTope((ThriftTableOperationException)value);
                }
            }
        }

        public Object getFieldValue(_Fields field) {
            switch (field) {
                case SUCCESS: {
                    return this.getSuccess();
                }
                case SEC: {
                    return this.getSec();
                }
                case TOPE: {
                    return this.getTope();
                }
            }
            throw new IllegalStateException();
        }

        public boolean isSet(_Fields field) {
            if (field == null) {
                throw new IllegalArgumentException();
            }
            switch (field) {
                case SUCCESS: {
                    return this.isSetSuccess();
                }
                case SEC: {
                    return this.isSetSec();
                }
                case TOPE: {
                    return this.isSetTope();
                }
            }
            throw new IllegalStateException();
        }

        public boolean equals(Object that) {
            if (that == null) {
                return false;
            }
            if (that instanceof initiateFlush_result) {
                return this.equals((initiateFlush_result)that);
            }
            return false;
        }

        public boolean equals(initiateFlush_result that) {
            if (that == null) {
                return false;
            }
            boolean this_present_success = true;
            boolean that_present_success = true;
            if (this_present_success || that_present_success) {
                if (!this_present_success || !that_present_success) {
                    return false;
                }
                if (this.success != that.success) {
                    return false;
                }
            }
            boolean this_present_sec = this.isSetSec();
            boolean that_present_sec = that.isSetSec();
            if (this_present_sec || that_present_sec) {
                if (!this_present_sec || !that_present_sec) {
                    return false;
                }
                if (!this.sec.equals(that.sec)) {
                    return false;
                }
            }
            boolean this_present_tope = this.isSetTope();
            boolean that_present_tope = that.isSetTope();
            if (this_present_tope || that_present_tope) {
                if (!this_present_tope || !that_present_tope) {
                    return false;
                }
                if (!this.tope.equals(that.tope)) {
                    return false;
                }
            }
            return true;
        }

        public int hashCode() {
            return 0;
        }

        public int compareTo(initiateFlush_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            initiateFlush_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo((long)this.success, (long)typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSec()).compareTo(typedOther.isSetSec());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSec() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.sec), (Comparable)((Object)typedOther.sec))) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetTope()).compareTo(typedOther.isSetTope());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetTope() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.tope), (Comparable)((Object)typedOther.tope))) != 0) {
                return lastComparison;
            }
            return 0;
        }

        public _Fields fieldForId(int fieldId) {
            return _Fields.findByThriftId(fieldId);
        }

        public void read(TProtocol iprot) throws TException {
            schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
        }

        public void write(TProtocol oprot) throws TException {
            schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("initiateFlush_result(");
            boolean first = true;
            sb.append("success:");
            sb.append(this.success);
            first = false;
            if (!first) {
                sb.append(", ");
            }
            sb.append("sec:");
            if (this.sec == null) {
                sb.append("null");
            } else {
                sb.append(this.sec);
            }
            first = false;
            if (!first) {
                sb.append(", ");
            }
            sb.append("tope:");
            if (this.tope == null) {
                sb.append("null");
            } else {
                sb.append(this.tope);
            }
            first = false;
            sb.append(")");
            return sb.toString();
        }

        public void validate() throws TException {
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            try {
                this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
            }
            catch (TException te) {
                throw new IOException(te);
            }
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            try {
                this.__isset_bitfield = 0;
                this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
            }
            catch (TException te) {
                throw new IOException(te);
            }
        }

        static {
            schemes.put(StandardScheme.class, new initiateFlush_resultStandardSchemeFactory());
            schemes.put(TupleScheme.class, new initiateFlush_resultTupleSchemeFactory());
            EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
            tmpMap.put(_Fields.SUCCESS, new FieldMetaData("success", 3, new FieldValueMetaData(10)));
            tmpMap.put(_Fields.SEC, new FieldMetaData("sec", 3, new FieldValueMetaData(12)));
            tmpMap.put(_Fields.TOPE, new FieldMetaData("tope", 3, new FieldValueMetaData(12)));
            metaDataMap = Collections.unmodifiableMap(tmpMap);
            FieldMetaData.addStructMetaDataMap(initiateFlush_result.class, metaDataMap);
        }

        private static class initiateFlush_resultTupleScheme
        extends TupleScheme<initiateFlush_result> {
            private initiateFlush_resultTupleScheme() {
            }

            public void write(TProtocol prot, initiateFlush_result struct) throws TException {
                TTupleProtocol oprot = (TTupleProtocol)prot;
                BitSet optionals = new BitSet();
                if (struct.isSetSuccess()) {
                    optionals.set(0);
                }
                if (struct.isSetSec()) {
                    optionals.set(1);
                }
                if (struct.isSetTope()) {
                    optionals.set(2);
                }
                oprot.writeBitSet(optionals, 3);
                if (struct.isSetSuccess()) {
                    oprot.writeI64(struct.success);
                }
                if (struct.isSetSec()) {
                    struct.sec.write((TProtocol)oprot);
                }
                if (struct.isSetTope()) {
                    struct.tope.write((TProtocol)oprot);
                }
            }

            public void read(TProtocol prot, initiateFlush_result struct) throws TException {
                TTupleProtocol iprot = (TTupleProtocol)prot;
                BitSet incoming = iprot.readBitSet(3);
                if (incoming.get(0)) {
                    struct.success = iprot.readI64();
                    struct.setSuccessIsSet(true);
                }
                if (incoming.get(1)) {
                    struct.sec = new ThriftSecurityException();
                    struct.sec.read((TProtocol)iprot);
                    struct.setSecIsSet(true);
                }
                if (incoming.get(2)) {
                    struct.tope = new ThriftTableOperationException();
                    struct.tope.read((TProtocol)iprot);
                    struct.setTopeIsSet(true);
                }
            }
        }

        private static class initiateFlush_resultTupleSchemeFactory
        implements SchemeFactory {
            private initiateFlush_resultTupleSchemeFactory() {
            }

            public initiateFlush_resultTupleScheme getScheme() {
                return new initiateFlush_resultTupleScheme();
            }
        }

        private static class initiateFlush_resultStandardScheme
        extends StandardScheme<initiateFlush_result> {
            private initiateFlush_resultStandardScheme() {
            }

            public void read(TProtocol iprot, initiateFlush_result struct) throws TException {
                iprot.readStructBegin();
                while (true) {
                    TField schemeField = iprot.readFieldBegin();
                    if (schemeField.type == 0) break;
                    switch (schemeField.id) {
                        case 0: {
                            if (schemeField.type == 10) {
                                struct.success = iprot.readI64();
                                struct.setSuccessIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        case 1: {
                            if (schemeField.type == 12) {
                                struct.sec = new ThriftSecurityException();
                                struct.sec.read(iprot);
                                struct.setSecIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        case 2: {
                            if (schemeField.type == 12) {
                                struct.tope = new ThriftTableOperationException();
                                struct.tope.read(iprot);
                                struct.setTopeIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        default: {
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        }
                    }
                    iprot.readFieldEnd();
                }
                iprot.readStructEnd();
                struct.validate();
            }

            public void write(TProtocol oprot, initiateFlush_result struct) throws TException {
                struct.validate();
                oprot.writeStructBegin(STRUCT_DESC);
                if (struct.isSetSuccess()) {
                    oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                    oprot.writeI64(struct.success);
                    oprot.writeFieldEnd();
                }
                if (struct.sec != null) {
                    oprot.writeFieldBegin(SEC_FIELD_DESC);
                    struct.sec.write(oprot);
                    oprot.writeFieldEnd();
                }
                if (struct.tope != null) {
                    oprot.writeFieldBegin(TOPE_FIELD_DESC);
                    struct.tope.write(oprot);
                    oprot.writeFieldEnd();
                }
                oprot.writeFieldStop();
                oprot.writeStructEnd();
            }
        }

        private static class initiateFlush_resultStandardSchemeFactory
        implements SchemeFactory {
            private initiateFlush_resultStandardSchemeFactory() {
            }

            public initiateFlush_resultStandardScheme getScheme() {
                return new initiateFlush_resultStandardScheme();
            }
        }

        public static enum _Fields implements TFieldIdEnum
        {
            SUCCESS(0, "success"),
            SEC(1, "sec"),
            TOPE(2, "tope");

            private static final Map<String, _Fields> byName;
            private final short _thriftId;
            private final String _fieldName;

            public static _Fields findByThriftId(int fieldId) {
                switch (fieldId) {
                    case 0: {
                        return SUCCESS;
                    }
                    case 1: {
                        return SEC;
                    }
                    case 2: {
                        return TOPE;
                    }
                }
                return null;
            }

            public static _Fields findByThriftIdOrThrow(int fieldId) {
                _Fields fields = _Fields.findByThriftId(fieldId);
                if (fields == null) {
                    throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
                }
                return fields;
            }

            public static _Fields findByName(String name) {
                return byName.get(name);
            }

            private _Fields(short thriftId, String fieldName) {
                this._thriftId = thriftId;
                this._fieldName = fieldName;
            }

            public short getThriftFieldId() {
                return this._thriftId;
            }

            public String getFieldName() {
                return this._fieldName;
            }

            static {
                byName = new HashMap<String, _Fields>();
                for (_Fields field : EnumSet.allOf(_Fields.class)) {
                    byName.put(field.getFieldName(), field);
                }
            }
        }
    }

    public static class initiateFlush_args
    implements TBase<initiateFlush_args, _Fields>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("initiateFlush_args");
        private static final TField TINFO_FIELD_DESC = new TField("tinfo", 12, 3);
        private static final TField CREDENTIALS_FIELD_DESC = new TField("credentials", 12, 1);
        private static final TField TABLE_NAME_FIELD_DESC = new TField("tableName", 11, 2);
        private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
        public TInfo tinfo;
        public TCredentials credentials;
        public String tableName;
        public static final Map<_Fields, FieldMetaData> metaDataMap;

        public initiateFlush_args() {
        }

        public initiateFlush_args(TInfo tinfo, TCredentials credentials, String tableName) {
            this();
            this.tinfo = tinfo;
            this.credentials = credentials;
            this.tableName = tableName;
        }

        public initiateFlush_args(initiateFlush_args other) {
            if (other.isSetTinfo()) {
                this.tinfo = new TInfo(other.tinfo);
            }
            if (other.isSetCredentials()) {
                this.credentials = new TCredentials(other.credentials);
            }
            if (other.isSetTableName()) {
                this.tableName = other.tableName;
            }
        }

        public initiateFlush_args deepCopy() {
            return new initiateFlush_args(this);
        }

        public void clear() {
            this.tinfo = null;
            this.credentials = null;
            this.tableName = null;
        }

        public TInfo getTinfo() {
            return this.tinfo;
        }

        public initiateFlush_args setTinfo(TInfo tinfo) {
            this.tinfo = tinfo;
            return this;
        }

        public void unsetTinfo() {
            this.tinfo = null;
        }

        public boolean isSetTinfo() {
            return this.tinfo != null;
        }

        public void setTinfoIsSet(boolean value) {
            if (!value) {
                this.tinfo = null;
            }
        }

        public TCredentials getCredentials() {
            return this.credentials;
        }

        public initiateFlush_args setCredentials(TCredentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public void unsetCredentials() {
            this.credentials = null;
        }

        public boolean isSetCredentials() {
            return this.credentials != null;
        }

        public void setCredentialsIsSet(boolean value) {
            if (!value) {
                this.credentials = null;
            }
        }

        public String getTableName() {
            return this.tableName;
        }

        public initiateFlush_args setTableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public void unsetTableName() {
            this.tableName = null;
        }

        public boolean isSetTableName() {
            return this.tableName != null;
        }

        public void setTableNameIsSet(boolean value) {
            if (!value) {
                this.tableName = null;
            }
        }

        public void setFieldValue(_Fields field, Object value) {
            switch (field) {
                case TINFO: {
                    if (value == null) {
                        this.unsetTinfo();
                        break;
                    }
                    this.setTinfo((TInfo)value);
                    break;
                }
                case CREDENTIALS: {
                    if (value == null) {
                        this.unsetCredentials();
                        break;
                    }
                    this.setCredentials((TCredentials)value);
                    break;
                }
                case TABLE_NAME: {
                    if (value == null) {
                        this.unsetTableName();
                        break;
                    }
                    this.setTableName((String)value);
                }
            }
        }

        public Object getFieldValue(_Fields field) {
            switch (field) {
                case TINFO: {
                    return this.getTinfo();
                }
                case CREDENTIALS: {
                    return this.getCredentials();
                }
                case TABLE_NAME: {
                    return this.getTableName();
                }
            }
            throw new IllegalStateException();
        }

        public boolean isSet(_Fields field) {
            if (field == null) {
                throw new IllegalArgumentException();
            }
            switch (field) {
                case TINFO: {
                    return this.isSetTinfo();
                }
                case CREDENTIALS: {
                    return this.isSetCredentials();
                }
                case TABLE_NAME: {
                    return this.isSetTableName();
                }
            }
            throw new IllegalStateException();
        }

        public boolean equals(Object that) {
            if (that == null) {
                return false;
            }
            if (that instanceof initiateFlush_args) {
                return this.equals((initiateFlush_args)that);
            }
            return false;
        }

        public boolean equals(initiateFlush_args that) {
            if (that == null) {
                return false;
            }
            boolean this_present_tinfo = this.isSetTinfo();
            boolean that_present_tinfo = that.isSetTinfo();
            if (this_present_tinfo || that_present_tinfo) {
                if (!this_present_tinfo || !that_present_tinfo) {
                    return false;
                }
                if (!this.tinfo.equals(that.tinfo)) {
                    return false;
                }
            }
            boolean this_present_credentials = this.isSetCredentials();
            boolean that_present_credentials = that.isSetCredentials();
            if (this_present_credentials || that_present_credentials) {
                if (!this_present_credentials || !that_present_credentials) {
                    return false;
                }
                if (!this.credentials.equals(that.credentials)) {
                    return false;
                }
            }
            boolean this_present_tableName = this.isSetTableName();
            boolean that_present_tableName = that.isSetTableName();
            if (this_present_tableName || that_present_tableName) {
                if (!this_present_tableName || !that_present_tableName) {
                    return false;
                }
                if (!this.tableName.equals(that.tableName)) {
                    return false;
                }
            }
            return true;
        }

        public int hashCode() {
            return 0;
        }

        public int compareTo(initiateFlush_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            initiateFlush_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetTinfo()).compareTo(typedOther.isSetTinfo());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetTinfo() && (lastComparison = TBaseHelper.compareTo((Comparable)this.tinfo, (Comparable)typedOther.tinfo)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetCredentials()).compareTo(typedOther.isSetCredentials());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetCredentials() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.credentials), (Comparable)((Object)typedOther.credentials))) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetTableName()).compareTo(typedOther.isSetTableName());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetTableName() && (lastComparison = TBaseHelper.compareTo((String)this.tableName, (String)typedOther.tableName)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        public _Fields fieldForId(int fieldId) {
            return _Fields.findByThriftId(fieldId);
        }

        public void read(TProtocol iprot) throws TException {
            schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
        }

        public void write(TProtocol oprot) throws TException {
            schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("initiateFlush_args(");
            boolean first = true;
            sb.append("tinfo:");
            if (this.tinfo == null) {
                sb.append("null");
            } else {
                sb.append(this.tinfo);
            }
            first = false;
            if (!first) {
                sb.append(", ");
            }
            sb.append("credentials:");
            if (this.credentials == null) {
                sb.append("null");
            } else {
                sb.append(this.credentials);
            }
            first = false;
            if (!first) {
                sb.append(", ");
            }
            sb.append("tableName:");
            if (this.tableName == null) {
                sb.append("null");
            } else {
                sb.append(this.tableName);
            }
            first = false;
            sb.append(")");
            return sb.toString();
        }

        public void validate() throws TException {
            if (this.tinfo != null) {
                this.tinfo.validate();
            }
            if (this.credentials != null) {
                this.credentials.validate();
            }
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            try {
                this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
            }
            catch (TException te) {
                throw new IOException(te);
            }
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            try {
                this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
            }
            catch (TException te) {
                throw new IOException(te);
            }
        }

        static {
            schemes.put(StandardScheme.class, new initiateFlush_argsStandardSchemeFactory());
            schemes.put(TupleScheme.class, new initiateFlush_argsTupleSchemeFactory());
            EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
            tmpMap.put(_Fields.TINFO, new FieldMetaData("tinfo", 3, (FieldValueMetaData)new StructMetaData(12, TInfo.class)));
            tmpMap.put(_Fields.CREDENTIALS, new FieldMetaData("credentials", 3, (FieldValueMetaData)new StructMetaData(12, TCredentials.class)));
            tmpMap.put(_Fields.TABLE_NAME, new FieldMetaData("tableName", 3, new FieldValueMetaData(11)));
            metaDataMap = Collections.unmodifiableMap(tmpMap);
            FieldMetaData.addStructMetaDataMap(initiateFlush_args.class, metaDataMap);
        }

        private static class initiateFlush_argsTupleScheme
        extends TupleScheme<initiateFlush_args> {
            private initiateFlush_argsTupleScheme() {
            }

            public void write(TProtocol prot, initiateFlush_args struct) throws TException {
                TTupleProtocol oprot = (TTupleProtocol)prot;
                BitSet optionals = new BitSet();
                if (struct.isSetTinfo()) {
                    optionals.set(0);
                }
                if (struct.isSetCredentials()) {
                    optionals.set(1);
                }
                if (struct.isSetTableName()) {
                    optionals.set(2);
                }
                oprot.writeBitSet(optionals, 3);
                if (struct.isSetTinfo()) {
                    struct.tinfo.write((TProtocol)oprot);
                }
                if (struct.isSetCredentials()) {
                    struct.credentials.write((TProtocol)oprot);
                }
                if (struct.isSetTableName()) {
                    oprot.writeString(struct.tableName);
                }
            }

            public void read(TProtocol prot, initiateFlush_args struct) throws TException {
                TTupleProtocol iprot = (TTupleProtocol)prot;
                BitSet incoming = iprot.readBitSet(3);
                if (incoming.get(0)) {
                    struct.tinfo = new TInfo();
                    struct.tinfo.read((TProtocol)iprot);
                    struct.setTinfoIsSet(true);
                }
                if (incoming.get(1)) {
                    struct.credentials = new TCredentials();
                    struct.credentials.read((TProtocol)iprot);
                    struct.setCredentialsIsSet(true);
                }
                if (incoming.get(2)) {
                    struct.tableName = iprot.readString();
                    struct.setTableNameIsSet(true);
                }
            }
        }

        private static class initiateFlush_argsTupleSchemeFactory
        implements SchemeFactory {
            private initiateFlush_argsTupleSchemeFactory() {
            }

            public initiateFlush_argsTupleScheme getScheme() {
                return new initiateFlush_argsTupleScheme();
            }
        }

        private static class initiateFlush_argsStandardScheme
        extends StandardScheme<initiateFlush_args> {
            private initiateFlush_argsStandardScheme() {
            }

            public void read(TProtocol iprot, initiateFlush_args struct) throws TException {
                iprot.readStructBegin();
                while (true) {
                    TField schemeField = iprot.readFieldBegin();
                    if (schemeField.type == 0) break;
                    switch (schemeField.id) {
                        case 3: {
                            if (schemeField.type == 12) {
                                struct.tinfo = new TInfo();
                                struct.tinfo.read(iprot);
                                struct.setTinfoIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        case 1: {
                            if (schemeField.type == 12) {
                                struct.credentials = new TCredentials();
                                struct.credentials.read(iprot);
                                struct.setCredentialsIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        case 2: {
                            if (schemeField.type == 11) {
                                struct.tableName = iprot.readString();
                                struct.setTableNameIsSet(true);
                                break;
                            }
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                            break;
                        }
                        default: {
                            TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        }
                    }
                    iprot.readFieldEnd();
                }
                iprot.readStructEnd();
                struct.validate();
            }

            public void write(TProtocol oprot, initiateFlush_args struct) throws TException {
                struct.validate();
                oprot.writeStructBegin(STRUCT_DESC);
                if (struct.credentials != null) {
                    oprot.writeFieldBegin(CREDENTIALS_FIELD_DESC);
                    struct.credentials.write(oprot);
                    oprot.writeFieldEnd();
                }
                if (struct.tableName != null) {
                    oprot.writeFieldBegin(TABLE_NAME_FIELD_DESC);
                    oprot.writeString(struct.tableName);
                    oprot.writeFieldEnd();
                }
                if (struct.tinfo != null) {
                    oprot.writeFieldBegin(TINFO_FIELD_DESC);
                    struct.tinfo.write(oprot);
                    oprot.writeFieldEnd();
                }
                oprot.writeFieldStop();
                oprot.writeStructEnd();
            }
        }

        private static class initiateFlush_argsStandardSchemeFactory
        implements SchemeFactory {
            private initiateFlush_argsStandardSchemeFactory() {
            }

            public initiateFlush_argsStandardScheme getScheme() {
                return new initiateFlush_argsStandardScheme();
            }
        }

        public static enum _Fields implements TFieldIdEnum
        {
            TINFO(3, "tinfo"),
            CREDENTIALS(1, "credentials"),
            TABLE_NAME(2, "tableName");

            private static final Map<String, _Fields> byName;
            private final short _thriftId;
            private final String _fieldName;

            public static _Fields findByThriftId(int fieldId) {
                switch (fieldId) {
                    case 3: {
                        return TINFO;
                    }
                    case 1: {
                        return CREDENTIALS;
                    }
                    case 2: {
                        return TABLE_NAME;
                    }
                }
                return null;
            }

            public static _Fields findByThriftIdOrThrow(int fieldId) {
                _Fields fields = _Fields.findByThriftId(fieldId);
                if (fields == null) {
                    throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
                }
                return fields;
            }

            public static _Fields findByName(String name) {
                return byName.get(name);
            }

            private _Fields(short thriftId, String fieldName) {
                this._thriftId = thriftId;
                this._fieldName = fieldName;
            }

            public short getThriftFieldId() {
                return this._thriftId;
            }

            public String getFieldName() {
                return this._fieldName;
            }

            static {
                byName = new HashMap<String, _Fields>();
                for (_Fields field : EnumSet.allOf(_Fields.class)) {
                    byName.put(field.getFieldName(), field);
                }
            }
        }
    }

    public static class Processor<I extends Iface>
    extends FateService.Processor<I>
    implements TProcessor {
        private static final Logger LOGGER = LoggerFactory.getLogger((String)Processor.class.getName());

        public Processor(I iface) {
            super(iface, Processor.getProcessMap(new HashMap<String, ProcessFunction<I, ? extends TBase>>()));
        }

        protected Processor(I iface, Map<String, ProcessFunction<I, ? extends TBase>> processMap) {
            super(iface, Processor.getProcessMap(processMap));
        }

        private static <I extends Iface> Map<String, ProcessFunction<I, ? extends TBase>> getProcessMap(Map<String, ProcessFunction<I, ? extends TBase>> processMap) {
            processMap.put("initiateFlush", new initiateFlush());
            processMap.put("waitForFlush", new waitForFlush());
            processMap.put("setTableProperty", new setTableProperty());
            processMap.put("removeTableProperty", new removeTableProperty());
            processMap.put("setNamespaceProperty", new setNamespaceProperty());
            processMap.put("removeNamespaceProperty", new removeNamespaceProperty());
            processMap.put("setMasterGoalState", new setMasterGoalState());
            processMap.put("shutdown", new shutdown());
            processMap.put("shutdownTabletServer", new shutdownTabletServer());
            processMap.put("setSystemProperty", new setSystemProperty());
            processMap.put("removeSystemProperty", new removeSystemProperty());
            processMap.put("getMasterStats", new getMasterStats());
            processMap.put("reportSplitExtent", new reportSplitExtent());
            processMap.put("reportTabletStatus", new reportTabletStatus());
            return processMap;
        }

        public static class reportTabletStatus<I extends Iface>
        extends ProcessFunction<I, reportTabletStatus_args> {
            public reportTabletStatus() {
                super("reportTabletStatus");
            }

            public reportTabletStatus_args getEmptyArgsInstance() {
                return new reportTabletStatus_args();
            }

            protected boolean isOneway() {
                return true;
            }

            public TBase getResult(I iface, reportTabletStatus_args args) throws TException {
                iface.reportTabletStatus(args.tinfo, args.credentials, args.serverName, args.status, args.tablet);
                return null;
            }
        }

        public static class reportSplitExtent<I extends Iface>
        extends ProcessFunction<I, reportSplitExtent_args> {
            public reportSplitExtent() {
                super("reportSplitExtent");
            }

            public reportSplitExtent_args getEmptyArgsInstance() {
                return new reportSplitExtent_args();
            }

            protected boolean isOneway() {
                return true;
            }

            public TBase getResult(I iface, reportSplitExtent_args args) throws TException {
                iface.reportSplitExtent(args.tinfo, args.credentials, args.serverName, args.split);
                return null;
            }
        }

        public static class getMasterStats<I extends Iface>
        extends ProcessFunction<I, getMasterStats_args> {
            public getMasterStats() {
                super("getMasterStats");
            }

            public getMasterStats_args getEmptyArgsInstance() {
                return new getMasterStats_args();
            }

            protected boolean isOneway() {
                return false;
            }

            public getMasterStats_result getResult(I iface, getMasterStats_args args) throws TException {
                getMasterStats_result result = new getMasterStats_result();
                try {
                    result.success = iface.getMasterStats(args.tinfo, args.credentials);
                }
                catch (ThriftSecurityException sec) {
                    result.sec = sec;
                }
                return result;
            }
        }

        public static class removeSystemProperty<I extends Iface>
        extends ProcessFunction<I, removeSystemProperty_args> {
            public removeSystemProperty() {
                super("removeSystemProperty");
            }

            public removeSystemProperty_args getEmptyArgsInstance() {
                return new removeSystemProperty_args();
            }

            protected boolean isOneway() {
                return false;
            }

            public removeSystemProperty_result getResult(I iface, removeSystemProperty_args args) throws TException {
                removeSystemProperty_result result = new removeSystemProperty_result();
                try {
                    iface.removeSystemProperty(args.tinfo, args.credentials, args.property);
                }
                catch (ThriftSecurityException sec) {
                    result.sec = sec;
                }
                return result;
            }
        }

        public static class setSystemProperty<I extends Iface>
        extends ProcessFunction<I, setSystemProperty_args> {
            public setSystemProperty() {
                super("setSystemProperty");
            }

            public setSystemProperty_args getEmptyArgsInstance() {
                return new setSystemProperty_args();
            }

            protected boolean isOneway() {
                return false;
            }

            public setSystemProperty_result getResult(I iface, setSystemProperty_args args) throws TException {
                setSystemProperty_result result = new setSystemProperty_result();
                try {
                    iface.setSystemProperty(args.tinfo, args.credentials, args.property, args.value);
                }
                catch (ThriftSecurityException sec) {
                    result.sec = sec;
                }
                return result;
            }
        }

        public static class shutdownTabletServer<I extends Iface>
        extends ProcessFunction<I, shutdownTabletServer_args> {
            public shutdownTabletServer() {
                super("shutdownTabletServer");
            }

            public shutdownTabletServer_args getEmptyArgsInstance() {
                return new shutdownTabletServer_args();
            }

            protected boolean isOneway() {
                return false;
            }

            public shutdownTabletServer_result getResult(I iface, shutdownTabletServer_args args) throws TException {
                shutdownTabletServer_result result = new shutdownTabletServer_result();
                try {
                    iface.shutdownTabletServer(args.tinfo, args.credentials, args.tabletServer, args.force);
                }
                catch (ThriftSecurityException sec) {
                    result.sec = sec;
                }
                return result;
            }
        }

        public static class shutdown<I extends Iface>
        extends ProcessFunction<I, shutdown_args> {
            public shutdown() {
                super("shutdown");
            }

            public shutdown_args getEmptyArgsInstance() {
                return new shutdown_args();
            }

            protected boolean isOneway() {
                return false;
            }

            public shutdown_result getResult(I iface, shutdown_args args) throws TException {
                shutdown_result result = new shutdown_result();
                try {
                    iface.shutdown(args.tinfo, args.credentials, args.stopTabletServers);
                }
                catch (ThriftSecurityException sec) {
                    result.sec = sec;
                }
                return result;
            }
        }

        public static class setMasterGoalState<I extends Iface>
        extends ProcessFunction<I, setMasterGoalState_args> {
            public setMasterGoalState() {
                super("setMasterGoalState");
            }

            public setMasterGoalState_args getEmptyArgsInstance() {
                return new setMasterGoalState_args();
            }

            protected boolean isOneway() {
                return false;
            }

            public setMasterGoalState_result getResult(I iface, setMasterGoalState_args args) throws TException {
                setMasterGoalState_result result = new setMasterGoalState_result();
                try {
                    iface.setMasterGoalState(args.tinfo, args.credentials, args.state);
                }
                catch (ThriftSecurityException sec) {
                    result.sec = sec;
                }
                return result;
            }
        }

        public static class removeNamespaceProperty<I extends Iface>
        extends ProcessFunction<I, removeNamespaceProperty_args> {
            public removeNamespaceProperty() {
                super("removeNamespaceProperty");
            }

            public removeNamespaceProperty_args getEmptyArgsInstance() {
                return new removeNamespaceProperty_args();
            }

            protected boolean isOneway() {
                return false;
            }

            public removeNamespaceProperty_result getResult(I iface, removeNamespaceProperty_args args) throws TException {
                removeNamespaceProperty_result result = new removeNamespaceProperty_result();
                try {
                    iface.removeNamespaceProperty(args.tinfo, args.credentials, args.ns, args.property);
                }
                catch (ThriftSecurityException sec) {
                    result.sec = sec;
                }
                catch (ThriftTableOperationException tope) {
                    result.tope = tope;
                }
                return result;
            }
        }

        public static class setNamespaceProperty<I extends Iface>
        extends ProcessFunction<I, setNamespaceProperty_args> {
            public setNamespaceProperty() {
                super("setNamespaceProperty");
            }

            public setNamespaceProperty_args getEmptyArgsInstance() {
                return new setNamespaceProperty_args();
            }

            protected boolean isOneway() {
                return false;
            }

            public setNamespaceProperty_result getResult(I iface, setNamespaceProperty_args args) throws TException {
                setNamespaceProperty_result result = new setNamespaceProperty_result();
                try {
                    iface.setNamespaceProperty(args.tinfo, args.credentials, args.ns, args.property, args.value);
                }
                catch (ThriftSecurityException sec) {
                    result.sec = sec;
                }
                catch (ThriftTableOperationException tope) {
                    result.tope = tope;
                }
                return result;
            }
        }

        public static class removeTableProperty<I extends Iface>
        extends ProcessFunction<I, removeTableProperty_args> {
            public removeTableProperty() {
                super("removeTableProperty");
            }

            public removeTableProperty_args getEmptyArgsInstance() {
                return new removeTableProperty_args();
            }

            protected boolean isOneway() {
                return false;
            }

            public removeTableProperty_result getResult(I iface, removeTableProperty_args args) throws TException {
                removeTableProperty_result result = new removeTableProperty_result();
                try {
                    iface.removeTableProperty(args.tinfo, args.credentials, args.tableName, args.property);
                }
                catch (ThriftSecurityException sec) {
                    result.sec = sec;
                }
                catch (ThriftTableOperationException tope) {
                    result.tope = tope;
                }
                return result;
            }
        }

        public static class setTableProperty<I extends Iface>
        extends ProcessFunction<I, setTableProperty_args> {
            public setTableProperty() {
                super("setTableProperty");
            }

            public setTableProperty_args getEmptyArgsInstance() {
                return new setTableProperty_args();
            }

            protected boolean isOneway() {
                return false;
            }

            public setTableProperty_result getResult(I iface, setTableProperty_args args) throws TException {
                setTableProperty_result result = new setTableProperty_result();
                try {
                    iface.setTableProperty(args.tinfo, args.credentials, args.tableName, args.property, args.value);
                }
                catch (ThriftSecurityException sec) {
                    result.sec = sec;
                }
                catch (ThriftTableOperationException tope) {
                    result.tope = tope;
                }
                return result;
            }
        }

        public static class waitForFlush<I extends Iface>
        extends ProcessFunction<I, waitForFlush_args> {
            public waitForFlush() {
                super("waitForFlush");
            }

            public waitForFlush_args getEmptyArgsInstance() {
                return new waitForFlush_args();
            }

            protected boolean isOneway() {
                return false;
            }

            public waitForFlush_result getResult(I iface, waitForFlush_args args) throws TException {
                waitForFlush_result result = new waitForFlush_result();
                try {
                    iface.waitForFlush(args.tinfo, args.credentials, args.tableName, args.startRow, args.endRow, args.flushID, args.maxLoops);
                }
                catch (ThriftSecurityException sec) {
                    result.sec = sec;
                }
                catch (ThriftTableOperationException tope) {
                    result.tope = tope;
                }
                return result;
            }
        }

        public static class initiateFlush<I extends Iface>
        extends ProcessFunction<I, initiateFlush_args> {
            public initiateFlush() {
                super("initiateFlush");
            }

            public initiateFlush_args getEmptyArgsInstance() {
                return new initiateFlush_args();
            }

            protected boolean isOneway() {
                return false;
            }

            public initiateFlush_result getResult(I iface, initiateFlush_args args) throws TException {
                initiateFlush_result result = new initiateFlush_result();
                try {
                    result.success = iface.initiateFlush(args.tinfo, args.credentials, args.tableName);
                    result.setSuccessIsSet(true);
                }
                catch (ThriftSecurityException sec) {
                    result.sec = sec;
                }
                catch (ThriftTableOperationException tope) {
                    result.tope = tope;
                }
                return result;
            }
        }
    }

    public static class AsyncClient
    extends FateService.AsyncClient
    implements AsyncIface {
        public AsyncClient(TProtocolFactory protocolFactory, TAsyncClientManager clientManager, TNonblockingTransport transport) {
            super(protocolFactory, clientManager, transport);
        }

        @Override
        public void initiateFlush(TInfo tinfo, TCredentials credentials, String tableName, AsyncMethodCallback<initiateFlush_call> resultHandler) throws TException {
            this.checkReady();
            initiateFlush_call method_call = new initiateFlush_call(tinfo, credentials, tableName, resultHandler, this, this.___protocolFactory, this.___transport);
            this.___currentMethod = method_call;
            this.___manager.call((TAsyncMethodCall)method_call);
        }

        @Override
        public void waitForFlush(TInfo tinfo, TCredentials credentials, String tableName, ByteBuffer startRow, ByteBuffer endRow, long flushID, long maxLoops, AsyncMethodCallback<waitForFlush_call> resultHandler) throws TException {
            this.checkReady();
            waitForFlush_call method_call = new waitForFlush_call(tinfo, credentials, tableName, startRow, endRow, flushID, maxLoops, resultHandler, this, this.___protocolFactory, this.___transport);
            this.___currentMethod = method_call;
            this.___manager.call((TAsyncMethodCall)method_call);
        }

        @Override
        public void setTableProperty(TInfo tinfo, TCredentials credentials, String tableName, String property, String value, AsyncMethodCallback<setTableProperty_call> resultHandler) throws TException {
            this.checkReady();
            setTableProperty_call method_call = new setTableProperty_call(tinfo, credentials, tableName, property, value, resultHandler, this, this.___protocolFactory, this.___transport);
            this.___currentMethod = method_call;
            this.___manager.call((TAsyncMethodCall)method_call);
        }

        @Override
        public void removeTableProperty(TInfo tinfo, TCredentials credentials, String tableName, String property, AsyncMethodCallback<removeTableProperty_call> resultHandler) throws TException {
            this.checkReady();
            removeTableProperty_call method_call = new removeTableProperty_call(tinfo, credentials, tableName, property, resultHandler, this, this.___protocolFactory, this.___transport);
            this.___currentMethod = method_call;
            this.___manager.call((TAsyncMethodCall)method_call);
        }

        @Override
        public void setNamespaceProperty(TInfo tinfo, TCredentials credentials, String ns, String property, String value, AsyncMethodCallback<setNamespaceProperty_call> resultHandler) throws TException {
            this.checkReady();
            setNamespaceProperty_call method_call = new setNamespaceProperty_call(tinfo, credentials, ns, property, value, resultHandler, this, this.___protocolFactory, this.___transport);
            this.___currentMethod = method_call;
            this.___manager.call((TAsyncMethodCall)method_call);
        }

        @Override
        public void removeNamespaceProperty(TInfo tinfo, TCredentials credentials, String ns, String property, AsyncMethodCallback<removeNamespaceProperty_call> resultHandler) throws TException {
            this.checkReady();
            removeNamespaceProperty_call method_call = new removeNamespaceProperty_call(tinfo, credentials, ns, property, resultHandler, this, this.___protocolFactory, this.___transport);
            this.___currentMethod = method_call;
            this.___manager.call((TAsyncMethodCall)method_call);
        }

        @Override
        public void setMasterGoalState(TInfo tinfo, TCredentials credentials, MasterGoalState state, AsyncMethodCallback<setMasterGoalState_call> resultHandler) throws TException {
            this.checkReady();
            setMasterGoalState_call method_call = new setMasterGoalState_call(tinfo, credentials, state, resultHandler, this, this.___protocolFactory, this.___transport);
            this.___currentMethod = method_call;
            this.___manager.call((TAsyncMethodCall)method_call);
        }

        @Override
        public void shutdown(TInfo tinfo, TCredentials credentials, boolean stopTabletServers, AsyncMethodCallback<shutdown_call> resultHandler) throws TException {
            this.checkReady();
            shutdown_call method_call = new shutdown_call(tinfo, credentials, stopTabletServers, resultHandler, this, this.___protocolFactory, this.___transport);
            this.___currentMethod = method_call;
            this.___manager.call((TAsyncMethodCall)method_call);
        }

        @Override
        public void shutdownTabletServer(TInfo tinfo, TCredentials credentials, String tabletServer, boolean force, AsyncMethodCallback<shutdownTabletServer_call> resultHandler) throws TException {
            this.checkReady();
            shutdownTabletServer_call method_call = new shutdownTabletServer_call(tinfo, credentials, tabletServer, force, resultHandler, this, this.___protocolFactory, this.___transport);
            this.___currentMethod = method_call;
            this.___manager.call((TAsyncMethodCall)method_call);
        }

        @Override
        public void setSystemProperty(TInfo tinfo, TCredentials credentials, String property, String value, AsyncMethodCallback<setSystemProperty_call> resultHandler) throws TException {
            this.checkReady();
            setSystemProperty_call method_call = new setSystemProperty_call(tinfo, credentials, property, value, resultHandler, this, this.___protocolFactory, this.___transport);
            this.___currentMethod = method_call;
            this.___manager.call((TAsyncMethodCall)method_call);
        }

        @Override
        public void removeSystemProperty(TInfo tinfo, TCredentials credentials, String property, AsyncMethodCallback<removeSystemProperty_call> resultHandler) throws TException {
            this.checkReady();
            removeSystemProperty_call method_call = new removeSystemProperty_call(tinfo, credentials, property, resultHandler, this, this.___protocolFactory, this.___transport);
            this.___currentMethod = method_call;
            this.___manager.call((TAsyncMethodCall)method_call);
        }

        @Override
        public void getMasterStats(TInfo tinfo, TCredentials credentials, AsyncMethodCallback<getMasterStats_call> resultHandler) throws TException {
            this.checkReady();
            getMasterStats_call method_call = new getMasterStats_call(tinfo, credentials, resultHandler, this, this.___protocolFactory, this.___transport);
            this.___currentMethod = method_call;
            this.___manager.call((TAsyncMethodCall)method_call);
        }

        @Override
        public void reportSplitExtent(TInfo tinfo, TCredentials credentials, String serverName, TabletSplit split, AsyncMethodCallback<reportSplitExtent_call> resultHandler) throws TException {
            this.checkReady();
            reportSplitExtent_call method_call = new reportSplitExtent_call(tinfo, credentials, serverName, split, resultHandler, this, this.___protocolFactory, this.___transport);
            this.___currentMethod = method_call;
            this.___manager.call((TAsyncMethodCall)method_call);
        }

        @Override
        public void reportTabletStatus(TInfo tinfo, TCredentials credentials, String serverName, TabletLoadState status, TKeyExtent tablet, AsyncMethodCallback<reportTabletStatus_call> resultHandler) throws TException {
            this.checkReady();
            reportTabletStatus_call method_call = new reportTabletStatus_call(tinfo, credentials, serverName, status, tablet, resultHandler, this, this.___protocolFactory, this.___transport);
            this.___currentMethod = method_call;
            this.___manager.call((TAsyncMethodCall)method_call);
        }

        public static class reportTabletStatus_call
        extends TAsyncMethodCall {
            private TInfo tinfo;
            private TCredentials credentials;
            private String serverName;
            private TabletLoadState status;
            private TKeyExtent tablet;

            public reportTabletStatus_call(TInfo tinfo, TCredentials credentials, String serverName, TabletLoadState status, TKeyExtent tablet, AsyncMethodCallback<reportTabletStatus_call> resultHandler, TAsyncClient client, TProtocolFactory protocolFactory, TNonblockingTransport transport) throws TException {
                super(client, protocolFactory, transport, resultHandler, true);
                this.tinfo = tinfo;
                this.credentials = credentials;
                this.serverName = serverName;
                this.status = status;
                this.tablet = tablet;
            }

            public void write_args(TProtocol prot) throws TException {
                prot.writeMessageBegin(new TMessage("reportTabletStatus", 1, 0));
                reportTabletStatus_args args = new reportTabletStatus_args();
                args.setTinfo(this.tinfo);
                args.setCredentials(this.credentials);
                args.setServerName(this.serverName);
                args.setStatus(this.status);
                args.setTablet(this.tablet);
                args.write(prot);
                prot.writeMessageEnd();
            }

            public void getResult() throws TException {
                if (this.getState() != TAsyncMethodCall.State.RESPONSE_READ) {
                    throw new IllegalStateException("Method call not finished!");
                }
                TMemoryInputTransport memoryTransport = new TMemoryInputTransport(this.getFrameBuffer().array());
                TProtocol prot = this.client.getProtocolFactory().getProtocol((TTransport)memoryTransport);
            }
        }

        public static class reportSplitExtent_call
        extends TAsyncMethodCall {
            private TInfo tinfo;
            private TCredentials credentials;
            private String serverName;
            private TabletSplit split;

            public reportSplitExtent_call(TInfo tinfo, TCredentials credentials, String serverName, TabletSplit split, AsyncMethodCallback<reportSplitExtent_call> resultHandler, TAsyncClient client, TProtocolFactory protocolFactory, TNonblockingTransport transport) throws TException {
                super(client, protocolFactory, transport, resultHandler, true);
                this.tinfo = tinfo;
                this.credentials = credentials;
                this.serverName = serverName;
                this.split = split;
            }

            public void write_args(TProtocol prot) throws TException {
                prot.writeMessageBegin(new TMessage("reportSplitExtent", 1, 0));
                reportSplitExtent_args args = new reportSplitExtent_args();
                args.setTinfo(this.tinfo);
                args.setCredentials(this.credentials);
                args.setServerName(this.serverName);
                args.setSplit(this.split);
                args.write(prot);
                prot.writeMessageEnd();
            }

            public void getResult() throws TException {
                if (this.getState() != TAsyncMethodCall.State.RESPONSE_READ) {
                    throw new IllegalStateException("Method call not finished!");
                }
                TMemoryInputTransport memoryTransport = new TMemoryInputTransport(this.getFrameBuffer().array());
                TProtocol prot = this.client.getProtocolFactory().getProtocol((TTransport)memoryTransport);
            }
        }

        public static class getMasterStats_call
        extends TAsyncMethodCall {
            private TInfo tinfo;
            private TCredentials credentials;

            public getMasterStats_call(TInfo tinfo, TCredentials credentials, AsyncMethodCallback<getMasterStats_call> resultHandler, TAsyncClient client, TProtocolFactory protocolFactory, TNonblockingTransport transport) throws TException {
                super(client, protocolFactory, transport, resultHandler, false);
                this.tinfo = tinfo;
                this.credentials = credentials;
            }

            public void write_args(TProtocol prot) throws TException {
                prot.writeMessageBegin(new TMessage("getMasterStats", 1, 0));
                getMasterStats_args args = new getMasterStats_args();
                args.setTinfo(this.tinfo);
                args.setCredentials(this.credentials);
                args.write(prot);
                prot.writeMessageEnd();
            }

            public MasterMonitorInfo getResult() throws ThriftSecurityException, TException {
                if (this.getState() != TAsyncMethodCall.State.RESPONSE_READ) {
                    throw new IllegalStateException("Method call not finished!");
                }
                TMemoryInputTransport memoryTransport = new TMemoryInputTransport(this.getFrameBuffer().array());
                TProtocol prot = this.client.getProtocolFactory().getProtocol((TTransport)memoryTransport);
                return new Client(prot).recv_getMasterStats();
            }
        }

        public static class removeSystemProperty_call
        extends TAsyncMethodCall {
            private TInfo tinfo;
            private TCredentials credentials;
            private String property;

            public removeSystemProperty_call(TInfo tinfo, TCredentials credentials, String property, AsyncMethodCallback<removeSystemProperty_call> resultHandler, TAsyncClient client, TProtocolFactory protocolFactory, TNonblockingTransport transport) throws TException {
                super(client, protocolFactory, transport, resultHandler, false);
                this.tinfo = tinfo;
                this.credentials = credentials;
                this.property = property;
            }

            public void write_args(TProtocol prot) throws TException {
                prot.writeMessageBegin(new TMessage("removeSystemProperty", 1, 0));
                removeSystemProperty_args args = new removeSystemProperty_args();
                args.setTinfo(this.tinfo);
                args.setCredentials(this.credentials);
                args.setProperty(this.property);
                args.write(prot);
                prot.writeMessageEnd();
            }

            public void getResult() throws ThriftSecurityException, TException {
                if (this.getState() != TAsyncMethodCall.State.RESPONSE_READ) {
                    throw new IllegalStateException("Method call not finished!");
                }
                TMemoryInputTransport memoryTransport = new TMemoryInputTransport(this.getFrameBuffer().array());
                TProtocol prot = this.client.getProtocolFactory().getProtocol((TTransport)memoryTransport);
                new Client(prot).recv_removeSystemProperty();
            }
        }

        public static class setSystemProperty_call
        extends TAsyncMethodCall {
            private TInfo tinfo;
            private TCredentials credentials;
            private String property;
            private String value;

            public setSystemProperty_call(TInfo tinfo, TCredentials credentials, String property, String value, AsyncMethodCallback<setSystemProperty_call> resultHandler, TAsyncClient client, TProtocolFactory protocolFactory, TNonblockingTransport transport) throws TException {
                super(client, protocolFactory, transport, resultHandler, false);
                this.tinfo = tinfo;
                this.credentials = credentials;
                this.property = property;
                this.value = value;
            }

            public void write_args(TProtocol prot) throws TException {
                prot.writeMessageBegin(new TMessage("setSystemProperty", 1, 0));
                setSystemProperty_args args = new setSystemProperty_args();
                args.setTinfo(this.tinfo);
                args.setCredentials(this.credentials);
                args.setProperty(this.property);
                args.setValue(this.value);
                args.write(prot);
                prot.writeMessageEnd();
            }

            public void getResult() throws ThriftSecurityException, TException {
                if (this.getState() != TAsyncMethodCall.State.RESPONSE_READ) {
                    throw new IllegalStateException("Method call not finished!");
                }
                TMemoryInputTransport memoryTransport = new TMemoryInputTransport(this.getFrameBuffer().array());
                TProtocol prot = this.client.getProtocolFactory().getProtocol((TTransport)memoryTransport);
                new Client(prot).recv_setSystemProperty();
            }
        }

        public static class shutdownTabletServer_call
        extends TAsyncMethodCall {
            private TInfo tinfo;
            private TCredentials credentials;
            private String tabletServer;
            private boolean force;

            public shutdownTabletServer_call(TInfo tinfo, TCredentials credentials, String tabletServer, boolean force, AsyncMethodCallback<shutdownTabletServer_call> resultHandler, TAsyncClient client, TProtocolFactory protocolFactory, TNonblockingTransport transport) throws TException {
                super(client, protocolFactory, transport, resultHandler, false);
                this.tinfo = tinfo;
                this.credentials = credentials;
                this.tabletServer = tabletServer;
                this.force = force;
            }

            public void write_args(TProtocol prot) throws TException {
                prot.writeMessageBegin(new TMessage("shutdownTabletServer", 1, 0));
                shutdownTabletServer_args args = new shutdownTabletServer_args();
                args.setTinfo(this.tinfo);
                args.setCredentials(this.credentials);
                args.setTabletServer(this.tabletServer);
                args.setForce(this.force);
                args.write(prot);
                prot.writeMessageEnd();
            }

            public void getResult() throws ThriftSecurityException, TException {
                if (this.getState() != TAsyncMethodCall.State.RESPONSE_READ) {
                    throw new IllegalStateException("Method call not finished!");
                }
                TMemoryInputTransport memoryTransport = new TMemoryInputTransport(this.getFrameBuffer().array());
                TProtocol prot = this.client.getProtocolFactory().getProtocol((TTransport)memoryTransport);
                new Client(prot).recv_shutdownTabletServer();
            }
        }

        public static class shutdown_call
        extends TAsyncMethodCall {
            private TInfo tinfo;
            private TCredentials credentials;
            private boolean stopTabletServers;

            public shutdown_call(TInfo tinfo, TCredentials credentials, boolean stopTabletServers, AsyncMethodCallback<shutdown_call> resultHandler, TAsyncClient client, TProtocolFactory protocolFactory, TNonblockingTransport transport) throws TException {
                super(client, protocolFactory, transport, resultHandler, false);
                this.tinfo = tinfo;
                this.credentials = credentials;
                this.stopTabletServers = stopTabletServers;
            }

            public void write_args(TProtocol prot) throws TException {
                prot.writeMessageBegin(new TMessage("shutdown", 1, 0));
                shutdown_args args = new shutdown_args();
                args.setTinfo(this.tinfo);
                args.setCredentials(this.credentials);
                args.setStopTabletServers(this.stopTabletServers);
                args.write(prot);
                prot.writeMessageEnd();
            }

            public void getResult() throws ThriftSecurityException, TException {
                if (this.getState() != TAsyncMethodCall.State.RESPONSE_READ) {
                    throw new IllegalStateException("Method call not finished!");
                }
                TMemoryInputTransport memoryTransport = new TMemoryInputTransport(this.getFrameBuffer().array());
                TProtocol prot = this.client.getProtocolFactory().getProtocol((TTransport)memoryTransport);
                new Client(prot).recv_shutdown();
            }
        }

        public static class setMasterGoalState_call
        extends TAsyncMethodCall {
            private TInfo tinfo;
            private TCredentials credentials;
            private MasterGoalState state;

            public setMasterGoalState_call(TInfo tinfo, TCredentials credentials, MasterGoalState state, AsyncMethodCallback<setMasterGoalState_call> resultHandler, TAsyncClient client, TProtocolFactory protocolFactory, TNonblockingTransport transport) throws TException {
                super(client, protocolFactory, transport, resultHandler, false);
                this.tinfo = tinfo;
                this.credentials = credentials;
                this.state = state;
            }

            public void write_args(TProtocol prot) throws TException {
                prot.writeMessageBegin(new TMessage("setMasterGoalState", 1, 0));
                setMasterGoalState_args args = new setMasterGoalState_args();
                args.setTinfo(this.tinfo);
                args.setCredentials(this.credentials);
                args.setState(this.state);
                args.write(prot);
                prot.writeMessageEnd();
            }

            public void getResult() throws ThriftSecurityException, TException {
                if (this.getState() != TAsyncMethodCall.State.RESPONSE_READ) {
                    throw new IllegalStateException("Method call not finished!");
                }
                TMemoryInputTransport memoryTransport = new TMemoryInputTransport(this.getFrameBuffer().array());
                TProtocol prot = this.client.getProtocolFactory().getProtocol((TTransport)memoryTransport);
                new Client(prot).recv_setMasterGoalState();
            }
        }

        public static class removeNamespaceProperty_call
        extends TAsyncMethodCall {
            private TInfo tinfo;
            private TCredentials credentials;
            private String ns;
            private String property;

            public removeNamespaceProperty_call(TInfo tinfo, TCredentials credentials, String ns, String property, AsyncMethodCallback<removeNamespaceProperty_call> resultHandler, TAsyncClient client, TProtocolFactory protocolFactory, TNonblockingTransport transport) throws TException {
                super(client, protocolFactory, transport, resultHandler, false);
                this.tinfo = tinfo;
                this.credentials = credentials;
                this.ns = ns;
                this.property = property;
            }

            public void write_args(TProtocol prot) throws TException {
                prot.writeMessageBegin(new TMessage("removeNamespaceProperty", 1, 0));
                removeNamespaceProperty_args args = new removeNamespaceProperty_args();
                args.setTinfo(this.tinfo);
                args.setCredentials(this.credentials);
                args.setNs(this.ns);
                args.setProperty(this.property);
                args.write(prot);
                prot.writeMessageEnd();
            }

            public void getResult() throws ThriftSecurityException, ThriftTableOperationException, TException {
                if (this.getState() != TAsyncMethodCall.State.RESPONSE_READ) {
                    throw new IllegalStateException("Method call not finished!");
                }
                TMemoryInputTransport memoryTransport = new TMemoryInputTransport(this.getFrameBuffer().array());
                TProtocol prot = this.client.getProtocolFactory().getProtocol((TTransport)memoryTransport);
                new Client(prot).recv_removeNamespaceProperty();
            }
        }

        public static class setNamespaceProperty_call
        extends TAsyncMethodCall {
            private TInfo tinfo;
            private TCredentials credentials;
            private String ns;
            private String property;
            private String value;

            public setNamespaceProperty_call(TInfo tinfo, TCredentials credentials, String ns, String property, String value, AsyncMethodCallback<setNamespaceProperty_call> resultHandler, TAsyncClient client, TProtocolFactory protocolFactory, TNonblockingTransport transport) throws TException {
                super(client, protocolFactory, transport, resultHandler, false);
                this.tinfo = tinfo;
                this.credentials = credentials;
                this.ns = ns;
                this.property = property;
                this.value = value;
            }

            public void write_args(TProtocol prot) throws TException {
                prot.writeMessageBegin(new TMessage("setNamespaceProperty", 1, 0));
                setNamespaceProperty_args args = new setNamespaceProperty_args();
                args.setTinfo(this.tinfo);
                args.setCredentials(this.credentials);
                args.setNs(this.ns);
                args.setProperty(this.property);
                args.setValue(this.value);
                args.write(prot);
                prot.writeMessageEnd();
            }

            public void getResult() throws ThriftSecurityException, ThriftTableOperationException, TException {
                if (this.getState() != TAsyncMethodCall.State.RESPONSE_READ) {
                    throw new IllegalStateException("Method call not finished!");
                }
                TMemoryInputTransport memoryTransport = new TMemoryInputTransport(this.getFrameBuffer().array());
                TProtocol prot = this.client.getProtocolFactory().getProtocol((TTransport)memoryTransport);
                new Client(prot).recv_setNamespaceProperty();
            }
        }

        public static class removeTableProperty_call
        extends TAsyncMethodCall {
            private TInfo tinfo;
            private TCredentials credentials;
            private String tableName;
            private String property;

            public removeTableProperty_call(TInfo tinfo, TCredentials credentials, String tableName, String property, AsyncMethodCallback<removeTableProperty_call> resultHandler, TAsyncClient client, TProtocolFactory protocolFactory, TNonblockingTransport transport) throws TException {
                super(client, protocolFactory, transport, resultHandler, false);
                this.tinfo = tinfo;
                this.credentials = credentials;
                this.tableName = tableName;
                this.property = property;
            }

            public void write_args(TProtocol prot) throws TException {
                prot.writeMessageBegin(new TMessage("removeTableProperty", 1, 0));
                removeTableProperty_args args = new removeTableProperty_args();
                args.setTinfo(this.tinfo);
                args.setCredentials(this.credentials);
                args.setTableName(this.tableName);
                args.setProperty(this.property);
                args.write(prot);
                prot.writeMessageEnd();
            }

            public void getResult() throws ThriftSecurityException, ThriftTableOperationException, TException {
                if (this.getState() != TAsyncMethodCall.State.RESPONSE_READ) {
                    throw new IllegalStateException("Method call not finished!");
                }
                TMemoryInputTransport memoryTransport = new TMemoryInputTransport(this.getFrameBuffer().array());
                TProtocol prot = this.client.getProtocolFactory().getProtocol((TTransport)memoryTransport);
                new Client(prot).recv_removeTableProperty();
            }
        }

        public static class setTableProperty_call
        extends TAsyncMethodCall {
            private TInfo tinfo;
            private TCredentials credentials;
            private String tableName;
            private String property;
            private String value;

            public setTableProperty_call(TInfo tinfo, TCredentials credentials, String tableName, String property, String value, AsyncMethodCallback<setTableProperty_call> resultHandler, TAsyncClient client, TProtocolFactory protocolFactory, TNonblockingTransport transport) throws TException {
                super(client, protocolFactory, transport, resultHandler, false);
                this.tinfo = tinfo;
                this.credentials = credentials;
                this.tableName = tableName;
                this.property = property;
                this.value = value;
            }

            public void write_args(TProtocol prot) throws TException {
                prot.writeMessageBegin(new TMessage("setTableProperty", 1, 0));
                setTableProperty_args args = new setTableProperty_args();
                args.setTinfo(this.tinfo);
                args.setCredentials(this.credentials);
                args.setTableName(this.tableName);
                args.setProperty(this.property);
                args.setValue(this.value);
                args.write(prot);
                prot.writeMessageEnd();
            }

            public void getResult() throws ThriftSecurityException, ThriftTableOperationException, TException {
                if (this.getState() != TAsyncMethodCall.State.RESPONSE_READ) {
                    throw new IllegalStateException("Method call not finished!");
                }
                TMemoryInputTransport memoryTransport = new TMemoryInputTransport(this.getFrameBuffer().array());
                TProtocol prot = this.client.getProtocolFactory().getProtocol((TTransport)memoryTransport);
                new Client(prot).recv_setTableProperty();
            }
        }

        public static class waitForFlush_call
        extends TAsyncMethodCall {
            private TInfo tinfo;
            private TCredentials credentials;
            private String tableName;
            private ByteBuffer startRow;
            private ByteBuffer endRow;
            private long flushID;
            private long maxLoops;

            public waitForFlush_call(TInfo tinfo, TCredentials credentials, String tableName, ByteBuffer startRow, ByteBuffer endRow, long flushID, long maxLoops, AsyncMethodCallback<waitForFlush_call> resultHandler, TAsyncClient client, TProtocolFactory protocolFactory, TNonblockingTransport transport) throws TException {
                super(client, protocolFactory, transport, resultHandler, false);
                this.tinfo = tinfo;
                this.credentials = credentials;
                this.tableName = tableName;
                this.startRow = startRow;
                this.endRow = endRow;
                this.flushID = flushID;
                this.maxLoops = maxLoops;
            }

            public void write_args(TProtocol prot) throws TException {
                prot.writeMessageBegin(new TMessage("waitForFlush", 1, 0));
                waitForFlush_args args = new waitForFlush_args();
                args.setTinfo(this.tinfo);
                args.setCredentials(this.credentials);
                args.setTableName(this.tableName);
                args.setStartRow(this.startRow);
                args.setEndRow(this.endRow);
                args.setFlushID(this.flushID);
                args.setMaxLoops(this.maxLoops);
                args.write(prot);
                prot.writeMessageEnd();
            }

            public void getResult() throws ThriftSecurityException, ThriftTableOperationException, TException {
                if (this.getState() != TAsyncMethodCall.State.RESPONSE_READ) {
                    throw new IllegalStateException("Method call not finished!");
                }
                TMemoryInputTransport memoryTransport = new TMemoryInputTransport(this.getFrameBuffer().array());
                TProtocol prot = this.client.getProtocolFactory().getProtocol((TTransport)memoryTransport);
                new Client(prot).recv_waitForFlush();
            }
        }

        public static class initiateFlush_call
        extends TAsyncMethodCall {
            private TInfo tinfo;
            private TCredentials credentials;
            private String tableName;

            public initiateFlush_call(TInfo tinfo, TCredentials credentials, String tableName, AsyncMethodCallback<initiateFlush_call> resultHandler, TAsyncClient client, TProtocolFactory protocolFactory, TNonblockingTransport transport) throws TException {
                super(client, protocolFactory, transport, resultHandler, false);
                this.tinfo = tinfo;
                this.credentials = credentials;
                this.tableName = tableName;
            }

            public void write_args(TProtocol prot) throws TException {
                prot.writeMessageBegin(new TMessage("initiateFlush", 1, 0));
                initiateFlush_args args = new initiateFlush_args();
                args.setTinfo(this.tinfo);
                args.setCredentials(this.credentials);
                args.setTableName(this.tableName);
                args.write(prot);
                prot.writeMessageEnd();
            }

            public long getResult() throws ThriftSecurityException, ThriftTableOperationException, TException {
                if (this.getState() != TAsyncMethodCall.State.RESPONSE_READ) {
                    throw new IllegalStateException("Method call not finished!");
                }
                TMemoryInputTransport memoryTransport = new TMemoryInputTransport(this.getFrameBuffer().array());
                TProtocol prot = this.client.getProtocolFactory().getProtocol((TTransport)memoryTransport);
                return new Client(prot).recv_initiateFlush();
            }
        }

        public static class Factory
        implements TAsyncClientFactory<AsyncClient> {
            private TAsyncClientManager clientManager;
            private TProtocolFactory protocolFactory;

            public Factory(TAsyncClientManager clientManager, TProtocolFactory protocolFactory) {
                this.clientManager = clientManager;
                this.protocolFactory = protocolFactory;
            }

            public AsyncClient getAsyncClient(TNonblockingTransport transport) {
                return new AsyncClient(this.protocolFactory, this.clientManager, transport);
            }
        }
    }

    public static class Client
    extends FateService.Client
    implements Iface {
        public Client(TProtocol prot) {
            super(prot, prot);
        }

        public Client(TProtocol iprot, TProtocol oprot) {
            super(iprot, oprot);
        }

        @Override
        public long initiateFlush(TInfo tinfo, TCredentials credentials, String tableName) throws ThriftSecurityException, ThriftTableOperationException, TException {
            this.send_initiateFlush(tinfo, credentials, tableName);
            return this.recv_initiateFlush();
        }

        public void send_initiateFlush(TInfo tinfo, TCredentials credentials, String tableName) throws TException {
            initiateFlush_args args = new initiateFlush_args();
            args.setTinfo(tinfo);
            args.setCredentials(credentials);
            args.setTableName(tableName);
            this.sendBase("initiateFlush", args);
        }

        public long recv_initiateFlush() throws ThriftSecurityException, ThriftTableOperationException, TException {
            initiateFlush_result result = new initiateFlush_result();
            this.receiveBase(result, "initiateFlush");
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.sec != null) {
                throw result.sec;
            }
            if (result.tope != null) {
                throw result.tope;
            }
            throw new TApplicationException(5, "initiateFlush failed: unknown result");
        }

        @Override
        public void waitForFlush(TInfo tinfo, TCredentials credentials, String tableName, ByteBuffer startRow, ByteBuffer endRow, long flushID, long maxLoops) throws ThriftSecurityException, ThriftTableOperationException, TException {
            this.send_waitForFlush(tinfo, credentials, tableName, startRow, endRow, flushID, maxLoops);
            this.recv_waitForFlush();
        }

        public void send_waitForFlush(TInfo tinfo, TCredentials credentials, String tableName, ByteBuffer startRow, ByteBuffer endRow, long flushID, long maxLoops) throws TException {
            waitForFlush_args args = new waitForFlush_args();
            args.setTinfo(tinfo);
            args.setCredentials(credentials);
            args.setTableName(tableName);
            args.setStartRow(startRow);
            args.setEndRow(endRow);
            args.setFlushID(flushID);
            args.setMaxLoops(maxLoops);
            this.sendBase("waitForFlush", args);
        }

        public void recv_waitForFlush() throws ThriftSecurityException, ThriftTableOperationException, TException {
            waitForFlush_result result = new waitForFlush_result();
            this.receiveBase(result, "waitForFlush");
            if (result.sec != null) {
                throw result.sec;
            }
            if (result.tope != null) {
                throw result.tope;
            }
        }

        @Override
        public void setTableProperty(TInfo tinfo, TCredentials credentials, String tableName, String property, String value) throws ThriftSecurityException, ThriftTableOperationException, TException {
            this.send_setTableProperty(tinfo, credentials, tableName, property, value);
            this.recv_setTableProperty();
        }

        public void send_setTableProperty(TInfo tinfo, TCredentials credentials, String tableName, String property, String value) throws TException {
            setTableProperty_args args = new setTableProperty_args();
            args.setTinfo(tinfo);
            args.setCredentials(credentials);
            args.setTableName(tableName);
            args.setProperty(property);
            args.setValue(value);
            this.sendBase("setTableProperty", args);
        }

        public void recv_setTableProperty() throws ThriftSecurityException, ThriftTableOperationException, TException {
            setTableProperty_result result = new setTableProperty_result();
            this.receiveBase(result, "setTableProperty");
            if (result.sec != null) {
                throw result.sec;
            }
            if (result.tope != null) {
                throw result.tope;
            }
        }

        @Override
        public void removeTableProperty(TInfo tinfo, TCredentials credentials, String tableName, String property) throws ThriftSecurityException, ThriftTableOperationException, TException {
            this.send_removeTableProperty(tinfo, credentials, tableName, property);
            this.recv_removeTableProperty();
        }

        public void send_removeTableProperty(TInfo tinfo, TCredentials credentials, String tableName, String property) throws TException {
            removeTableProperty_args args = new removeTableProperty_args();
            args.setTinfo(tinfo);
            args.setCredentials(credentials);
            args.setTableName(tableName);
            args.setProperty(property);
            this.sendBase("removeTableProperty", args);
        }

        public void recv_removeTableProperty() throws ThriftSecurityException, ThriftTableOperationException, TException {
            removeTableProperty_result result = new removeTableProperty_result();
            this.receiveBase(result, "removeTableProperty");
            if (result.sec != null) {
                throw result.sec;
            }
            if (result.tope != null) {
                throw result.tope;
            }
        }

        @Override
        public void setNamespaceProperty(TInfo tinfo, TCredentials credentials, String ns, String property, String value) throws ThriftSecurityException, ThriftTableOperationException, TException {
            this.send_setNamespaceProperty(tinfo, credentials, ns, property, value);
            this.recv_setNamespaceProperty();
        }

        public void send_setNamespaceProperty(TInfo tinfo, TCredentials credentials, String ns, String property, String value) throws TException {
            setNamespaceProperty_args args = new setNamespaceProperty_args();
            args.setTinfo(tinfo);
            args.setCredentials(credentials);
            args.setNs(ns);
            args.setProperty(property);
            args.setValue(value);
            this.sendBase("setNamespaceProperty", args);
        }

        public void recv_setNamespaceProperty() throws ThriftSecurityException, ThriftTableOperationException, TException {
            setNamespaceProperty_result result = new setNamespaceProperty_result();
            this.receiveBase(result, "setNamespaceProperty");
            if (result.sec != null) {
                throw result.sec;
            }
            if (result.tope != null) {
                throw result.tope;
            }
        }

        @Override
        public void removeNamespaceProperty(TInfo tinfo, TCredentials credentials, String ns, String property) throws ThriftSecurityException, ThriftTableOperationException, TException {
            this.send_removeNamespaceProperty(tinfo, credentials, ns, property);
            this.recv_removeNamespaceProperty();
        }

        public void send_removeNamespaceProperty(TInfo tinfo, TCredentials credentials, String ns, String property) throws TException {
            removeNamespaceProperty_args args = new removeNamespaceProperty_args();
            args.setTinfo(tinfo);
            args.setCredentials(credentials);
            args.setNs(ns);
            args.setProperty(property);
            this.sendBase("removeNamespaceProperty", args);
        }

        public void recv_removeNamespaceProperty() throws ThriftSecurityException, ThriftTableOperationException, TException {
            removeNamespaceProperty_result result = new removeNamespaceProperty_result();
            this.receiveBase(result, "removeNamespaceProperty");
            if (result.sec != null) {
                throw result.sec;
            }
            if (result.tope != null) {
                throw result.tope;
            }
        }

        @Override
        public void setMasterGoalState(TInfo tinfo, TCredentials credentials, MasterGoalState state) throws ThriftSecurityException, TException {
            this.send_setMasterGoalState(tinfo, credentials, state);
            this.recv_setMasterGoalState();
        }

        public void send_setMasterGoalState(TInfo tinfo, TCredentials credentials, MasterGoalState state) throws TException {
            setMasterGoalState_args args = new setMasterGoalState_args();
            args.setTinfo(tinfo);
            args.setCredentials(credentials);
            args.setState(state);
            this.sendBase("setMasterGoalState", args);
        }

        public void recv_setMasterGoalState() throws ThriftSecurityException, TException {
            setMasterGoalState_result result = new setMasterGoalState_result();
            this.receiveBase(result, "setMasterGoalState");
            if (result.sec != null) {
                throw result.sec;
            }
        }

        @Override
        public void shutdown(TInfo tinfo, TCredentials credentials, boolean stopTabletServers) throws ThriftSecurityException, TException {
            this.send_shutdown(tinfo, credentials, stopTabletServers);
            this.recv_shutdown();
        }

        public void send_shutdown(TInfo tinfo, TCredentials credentials, boolean stopTabletServers) throws TException {
            shutdown_args args = new shutdown_args();
            args.setTinfo(tinfo);
            args.setCredentials(credentials);
            args.setStopTabletServers(stopTabletServers);
            this.sendBase("shutdown", args);
        }

        public void recv_shutdown() throws ThriftSecurityException, TException {
            shutdown_result result = new shutdown_result();
            this.receiveBase(result, "shutdown");
            if (result.sec != null) {
                throw result.sec;
            }
        }

        @Override
        public void shutdownTabletServer(TInfo tinfo, TCredentials credentials, String tabletServer, boolean force) throws ThriftSecurityException, TException {
            this.send_shutdownTabletServer(tinfo, credentials, tabletServer, force);
            this.recv_shutdownTabletServer();
        }

        public void send_shutdownTabletServer(TInfo tinfo, TCredentials credentials, String tabletServer, boolean force) throws TException {
            shutdownTabletServer_args args = new shutdownTabletServer_args();
            args.setTinfo(tinfo);
            args.setCredentials(credentials);
            args.setTabletServer(tabletServer);
            args.setForce(force);
            this.sendBase("shutdownTabletServer", args);
        }

        public void recv_shutdownTabletServer() throws ThriftSecurityException, TException {
            shutdownTabletServer_result result = new shutdownTabletServer_result();
            this.receiveBase(result, "shutdownTabletServer");
            if (result.sec != null) {
                throw result.sec;
            }
        }

        @Override
        public void setSystemProperty(TInfo tinfo, TCredentials credentials, String property, String value) throws ThriftSecurityException, TException {
            this.send_setSystemProperty(tinfo, credentials, property, value);
            this.recv_setSystemProperty();
        }

        public void send_setSystemProperty(TInfo tinfo, TCredentials credentials, String property, String value) throws TException {
            setSystemProperty_args args = new setSystemProperty_args();
            args.setTinfo(tinfo);
            args.setCredentials(credentials);
            args.setProperty(property);
            args.setValue(value);
            this.sendBase("setSystemProperty", args);
        }

        public void recv_setSystemProperty() throws ThriftSecurityException, TException {
            setSystemProperty_result result = new setSystemProperty_result();
            this.receiveBase(result, "setSystemProperty");
            if (result.sec != null) {
                throw result.sec;
            }
        }

        @Override
        public void removeSystemProperty(TInfo tinfo, TCredentials credentials, String property) throws ThriftSecurityException, TException {
            this.send_removeSystemProperty(tinfo, credentials, property);
            this.recv_removeSystemProperty();
        }

        public void send_removeSystemProperty(TInfo tinfo, TCredentials credentials, String property) throws TException {
            removeSystemProperty_args args = new removeSystemProperty_args();
            args.setTinfo(tinfo);
            args.setCredentials(credentials);
            args.setProperty(property);
            this.sendBase("removeSystemProperty", args);
        }

        public void recv_removeSystemProperty() throws ThriftSecurityException, TException {
            removeSystemProperty_result result = new removeSystemProperty_result();
            this.receiveBase(result, "removeSystemProperty");
            if (result.sec != null) {
                throw result.sec;
            }
        }

        @Override
        public MasterMonitorInfo getMasterStats(TInfo tinfo, TCredentials credentials) throws ThriftSecurityException, TException {
            this.send_getMasterStats(tinfo, credentials);
            return this.recv_getMasterStats();
        }

        public void send_getMasterStats(TInfo tinfo, TCredentials credentials) throws TException {
            getMasterStats_args args = new getMasterStats_args();
            args.setTinfo(tinfo);
            args.setCredentials(credentials);
            this.sendBase("getMasterStats", args);
        }

        public MasterMonitorInfo recv_getMasterStats() throws ThriftSecurityException, TException {
            getMasterStats_result result = new getMasterStats_result();
            this.receiveBase(result, "getMasterStats");
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.sec != null) {
                throw result.sec;
            }
            throw new TApplicationException(5, "getMasterStats failed: unknown result");
        }

        @Override
        public void reportSplitExtent(TInfo tinfo, TCredentials credentials, String serverName, TabletSplit split) throws TException {
            this.send_reportSplitExtent(tinfo, credentials, serverName, split);
        }

        public void send_reportSplitExtent(TInfo tinfo, TCredentials credentials, String serverName, TabletSplit split) throws TException {
            reportSplitExtent_args args = new reportSplitExtent_args();
            args.setTinfo(tinfo);
            args.setCredentials(credentials);
            args.setServerName(serverName);
            args.setSplit(split);
            this.sendBase("reportSplitExtent", args);
        }

        @Override
        public void reportTabletStatus(TInfo tinfo, TCredentials credentials, String serverName, TabletLoadState status, TKeyExtent tablet) throws TException {
            this.send_reportTabletStatus(tinfo, credentials, serverName, status, tablet);
        }

        public void send_reportTabletStatus(TInfo tinfo, TCredentials credentials, String serverName, TabletLoadState status, TKeyExtent tablet) throws TException {
            reportTabletStatus_args args = new reportTabletStatus_args();
            args.setTinfo(tinfo);
            args.setCredentials(credentials);
            args.setServerName(serverName);
            args.setStatus(status);
            args.setTablet(tablet);
            this.sendBase("reportTabletStatus", args);
        }

        public static class Factory
        implements TServiceClientFactory<Client> {
            public Client getClient(TProtocol prot) {
                return new Client(prot);
            }

            public Client getClient(TProtocol iprot, TProtocol oprot) {
                return new Client(iprot, oprot);
            }
        }
    }

    public static interface AsyncIface
    extends FateService.AsyncIface {
        public void initiateFlush(TInfo var1, TCredentials var2, String var3, AsyncMethodCallback<AsyncClient.initiateFlush_call> var4) throws TException;

        public void waitForFlush(TInfo var1, TCredentials var2, String var3, ByteBuffer var4, ByteBuffer var5, long var6, long var8, AsyncMethodCallback<AsyncClient.waitForFlush_call> var10) throws TException;

        public void setTableProperty(TInfo var1, TCredentials var2, String var3, String var4, String var5, AsyncMethodCallback<AsyncClient.setTableProperty_call> var6) throws TException;

        public void removeTableProperty(TInfo var1, TCredentials var2, String var3, String var4, AsyncMethodCallback<AsyncClient.removeTableProperty_call> var5) throws TException;

        public void setNamespaceProperty(TInfo var1, TCredentials var2, String var3, String var4, String var5, AsyncMethodCallback<AsyncClient.setNamespaceProperty_call> var6) throws TException;

        public void removeNamespaceProperty(TInfo var1, TCredentials var2, String var3, String var4, AsyncMethodCallback<AsyncClient.removeNamespaceProperty_call> var5) throws TException;

        public void setMasterGoalState(TInfo var1, TCredentials var2, MasterGoalState var3, AsyncMethodCallback<AsyncClient.setMasterGoalState_call> var4) throws TException;

        public void shutdown(TInfo var1, TCredentials var2, boolean var3, AsyncMethodCallback<AsyncClient.shutdown_call> var4) throws TException;

        public void shutdownTabletServer(TInfo var1, TCredentials var2, String var3, boolean var4, AsyncMethodCallback<AsyncClient.shutdownTabletServer_call> var5) throws TException;

        public void setSystemProperty(TInfo var1, TCredentials var2, String var3, String var4, AsyncMethodCallback<AsyncClient.setSystemProperty_call> var5) throws TException;

        public void removeSystemProperty(TInfo var1, TCredentials var2, String var3, AsyncMethodCallback<AsyncClient.removeSystemProperty_call> var4) throws TException;

        public void getMasterStats(TInfo var1, TCredentials var2, AsyncMethodCallback<AsyncClient.getMasterStats_call> var3) throws TException;

        public void reportSplitExtent(TInfo var1, TCredentials var2, String var3, TabletSplit var4, AsyncMethodCallback<AsyncClient.reportSplitExtent_call> var5) throws TException;

        public void reportTabletStatus(TInfo var1, TCredentials var2, String var3, TabletLoadState var4, TKeyExtent var5, AsyncMethodCallback<AsyncClient.reportTabletStatus_call> var6) throws TException;
    }

    public static interface Iface
    extends FateService.Iface {
        public long initiateFlush(TInfo var1, TCredentials var2, String var3) throws ThriftSecurityException, ThriftTableOperationException, TException;

        public void waitForFlush(TInfo var1, TCredentials var2, String var3, ByteBuffer var4, ByteBuffer var5, long var6, long var8) throws ThriftSecurityException, ThriftTableOperationException, TException;

        public void setTableProperty(TInfo var1, TCredentials var2, String var3, String var4, String var5) throws ThriftSecurityException, ThriftTableOperationException, TException;

        public void removeTableProperty(TInfo var1, TCredentials var2, String var3, String var4) throws ThriftSecurityException, ThriftTableOperationException, TException;

        public void setNamespaceProperty(TInfo var1, TCredentials var2, String var3, String var4, String var5) throws ThriftSecurityException, ThriftTableOperationException, TException;

        public void removeNamespaceProperty(TInfo var1, TCredentials var2, String var3, String var4) throws ThriftSecurityException, ThriftTableOperationException, TException;

        public void setMasterGoalState(TInfo var1, TCredentials var2, MasterGoalState var3) throws ThriftSecurityException, TException;

        public void shutdown(TInfo var1, TCredentials var2, boolean var3) throws ThriftSecurityException, TException;

        public void shutdownTabletServer(TInfo var1, TCredentials var2, String var3, boolean var4) throws ThriftSecurityException, TException;

        public void setSystemProperty(TInfo var1, TCredentials var2, String var3, String var4) throws ThriftSecurityException, TException;

        public void removeSystemProperty(TInfo var1, TCredentials var2, String var3) throws ThriftSecurityException, TException;

        public MasterMonitorInfo getMasterStats(TInfo var1, TCredentials var2) throws ThriftSecurityException, TException;

        public void reportSplitExtent(TInfo var1, TCredentials var2, String var3, TabletSplit var4) throws TException;

        public void reportTabletStatus(TInfo var1, TCredentials var2, String var3, TabletLoadState var4, TKeyExtent var5) throws TException;
    }
}

