/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iterators.user;

import java.util.Iterator;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.iterators.LongCombiner;
import org.apache.accumulo.core.iterators.OptionDescriber;

public class SummingCombiner
extends LongCombiner {
    @Override
    public Long typedReduce(Key key, Iterator<Long> iter) {
        long sum = 0L;
        while (iter.hasNext()) {
            Long next = iter.next();
            sum = SummingCombiner.safeAdd(sum, next);
        }
        return sum;
    }

    @Override
    public OptionDescriber.IteratorOptions describeOptions() {
        OptionDescriber.IteratorOptions io = super.describeOptions();
        io.setName("sum");
        io.setDescription("SummingCombiner interprets Values as Longs and adds them together.  A variety of encodings (variable length, fixed length, or string) are available");
        return io;
    }
}

