/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iterators.system;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.file.FileSKVIterator;
import org.apache.accumulo.core.file.NoSuchMetaStoreException;
import org.apache.accumulo.core.file.map.MapFileUtil;
import org.apache.accumulo.core.iterators.IterationInterruptedException;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.system.InterruptibleIterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.MapFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.log4j.Logger;

public class MapFileIterator
implements FileSKVIterator {
    private static final Logger log = Logger.getLogger(MapFileIterator.class);
    private MapFile.Reader reader;
    private Value topValue;
    private Key topKey;
    private AtomicBoolean interruptFlag;
    private int interruptCheckCount = 0;
    private FileSystem fs;
    private String dirName;

    public MapFileIterator(AccumuloConfiguration acuconf, FileSystem fs, String dir, Configuration conf) throws IOException {
        this.reader = MapFileUtil.openMapFile(acuconf, fs, dir, conf);
        this.fs = fs;
        this.dirName = dir;
    }

    @Override
    public void setInterruptFlag(AtomicBoolean flag) {
        this.interruptFlag = flag;
    }

    @Override
    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasTop() {
        return this.topKey != null;
    }

    @Override
    public void next() throws IOException {
        if (this.interruptFlag != null && this.interruptCheckCount++ % 100 == 0 && this.interruptFlag.get()) {
            throw new IterationInterruptedException();
        }
        this.reader.next((WritableComparable)this.topKey, (Writable)this.topValue);
    }

    @Override
    public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
        if (columnFamilies.size() != 0 || inclusive) {
            throw new IllegalArgumentException("I do not know how to filter column families");
        }
        if (range == null) {
            throw new IllegalArgumentException("Cannot seek to null range");
        }
        if (this.interruptFlag != null && this.interruptFlag.get()) {
            throw new IterationInterruptedException();
        }
        Key key = range.getStartKey();
        if (key == null) {
            key = new Key();
        }
        this.reader.seek((WritableComparable)key);
        while (this.hasTop() && range.beforeStartKey(this.getTopKey())) {
            this.next();
        }
    }

    @Override
    public Key getTopKey() {
        return this.topKey;
    }

    @Override
    public Value getTopValue() {
        return this.topValue;
    }

    @Override
    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        try {
            SortedKeyValueIterator<Key, Value> other = env.reserveMapFileReader(this.dirName);
            ((InterruptibleIterator)other).setInterruptFlag(this.interruptFlag);
            log.debug((Object)("deep copying MapFile: " + this + " -> " + other));
            return other;
        }
        catch (IOException e) {
            log.error((Object)"failed to clone map file reader", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public Key getFirstKey() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Key getLastKey() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DataInputStream getMetaStore(String name) throws IOException {
        Path path = new Path(this.dirName, name);
        if (!this.fs.exists(path)) {
            throw new NoSuchMetaStoreException("name = " + name);
        }
        return this.fs.open(path);
    }

    @Override
    public void closeDeepCopies() throws IOException {
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

