/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.file.rfile;

import com.beust.jcommander.Parameter;
import java.util.ArrayList;
import java.util.List;
import org.apache.accumulo.core.cli.Help;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.file.blockfile.impl.CachableBlockFile;
import org.apache.accumulo.core.file.rfile.RFile;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class SplitLarge {
    public static void main(String[] args) throws Exception {
        Configuration conf = CachedConfiguration.getInstance();
        FileSystem fs = FileSystem.get((Configuration)conf);
        long maxSize = 0xA00000L;
        Opts opts = new Opts();
        opts.parseArgs(SplitLarge.class.getName(), args, new Object[0]);
        for (String file : opts.files) {
            DefaultConfiguration aconf = DefaultConfiguration.getDefaultConfiguration();
            Path path = new Path(file);
            CachableBlockFile.Reader rdr = new CachableBlockFile.Reader(fs, path, conf, null, null, (AccumuloConfiguration)aconf);
            RFile.Reader iter = new RFile.Reader(rdr);
            if (!file.endsWith(".rf")) {
                throw new IllegalArgumentException("File must end with .rf");
            }
            String smallName = file.substring(0, file.length() - 3) + "_small.rf";
            String largeName = file.substring(0, file.length() - 3) + "_large.rf";
            int blockSize = (int)aconf.getMemoryInBytes(Property.TABLE_FILE_BLOCK_SIZE);
            RFile.Writer small = new RFile.Writer(new CachableBlockFile.Writer(fs, new Path(smallName), "gz", conf, aconf), blockSize);
            small.startDefaultLocalityGroup();
            RFile.Writer large = new RFile.Writer(new CachableBlockFile.Writer(fs, new Path(largeName), "gz", conf, aconf), blockSize);
            large.startDefaultLocalityGroup();
            iter.seek(new Range(), new ArrayList<ByteSequence>(), false);
            while (iter.hasTop()) {
                Key key = iter.getTopKey();
                Value value = iter.getTopValue();
                if ((long)(key.getSize() + value.getSize()) < maxSize) {
                    small.append(key, value);
                } else {
                    large.append(key, value);
                }
                iter.next();
            }
            iter.close();
            large.close();
            small.close();
        }
    }

    static class Opts
    extends Help {
        @Parameter(names={"-m"}, description="the maximum size of the key/value pair to shunt to the small file")
        long maxSize = 0xA00000L;
        @Parameter(description="<file.rf> { <file.rf> ... }")
        List<String> files = new ArrayList<String>();

        Opts() {
        }
    }
}

