/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.file.rfile;

import com.beust.jcommander.IParameterValidator;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.accumulo.core.cli.Help;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.file.FileSKVWriter;
import org.apache.accumulo.core.file.rfile.RFileOperations;
import org.apache.accumulo.core.file.rfile.bcfile.Compression;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;

public class CreateEmpty {
    private static final Logger log = Logger.getLogger(CreateEmpty.class);

    public static void main(String[] args) throws Exception {
        Configuration conf = CachedConfiguration.getInstance();
        Opts opts = new Opts();
        opts.parseArgs(CreateEmpty.class.getName(), args, new Object[0]);
        for (String arg : opts.files) {
            Path path = new Path(arg);
            log.info((Object)("Writing to file '" + path + "'"));
            FileSKVWriter writer = new RFileOperations().openWriter(arg, path.getFileSystem(conf), conf, DefaultConfiguration.getDefaultConfiguration(), opts.codec);
            writer.close();
        }
    }

    static class Opts
    extends Help {
        @Parameter(names={"-c", "--codec"}, description="the compression codec to use.", validateWith=IsSupportedCompressionAlgorithm.class)
        String codec = "none";
        @Parameter(description=" <path> { <path> ... } Each path given is a URL. Relative paths are resolved according to the default filesystem defined in your Hadoop configuration, which is usually an HDFS instance.", required=true, validateWith=NamedLikeRFile.class)
        List<String> files = new ArrayList<String>();

        Opts() {
        }
    }

    public static class IsSupportedCompressionAlgorithm
    implements IParameterValidator {
        public void validate(String name, String value) throws ParameterException {
            Object[] algorithms = Compression.getSupportedAlgorithms();
            if (!Arrays.asList(algorithms).contains(value)) {
                throw new ParameterException("Compression codec must be one of " + Arrays.toString(algorithms));
            }
        }
    }

    public static class NamedLikeRFile
    implements IParameterValidator {
        public void validate(String name, String value) throws ParameterException {
            if (!value.endsWith(".rf")) {
                throw new ParameterException("File must end with .rf and '" + value + "' does not.");
            }
        }
    }
}

