/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.lexicoder;

import org.apache.accumulo.core.client.lexicoder.Lexicoder;

public class UIntegerLexicoder
implements Lexicoder<Integer> {
    @Override
    public byte[] encode(Integer i) {
        int index;
        int shift = 56;
        int prefix = i < 0 ? 255 : 0;
        for (index = 0; index < 4 && (i >>> shift & 0xFF) == prefix; ++index) {
            shift -= 8;
        }
        byte[] ret = new byte[5 - index];
        ret[0] = (byte)(4 - index);
        for (index = 1; index < ret.length; ++index) {
            ret[index] = (byte)(i >>> shift);
            shift -= 8;
        }
        if (i < 0) {
            ret[0] = (byte)(8 - ret[0]);
        }
        return ret;
    }

    @Override
    public Integer decode(byte[] data) {
        if (data[0] < 0 || data[0] > 8) {
            throw new IllegalArgumentException("Unexpected length " + (0xFF & data[0]));
        }
        int i = 0;
        int shift = 0;
        for (int idx = data.length - 1; idx >= 1; --idx) {
            i = (int)((long)i + (((long)data[idx] & 0xFFL) << shift));
            shift += 8;
        }
        if (data[0] > 4) {
            i |= -1 << (8 - data[0] << 3);
        }
        return i;
    }
}

