/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.lexicoder;

import org.apache.accumulo.core.client.lexicoder.Lexicoder;
import org.apache.accumulo.core.client.lexicoder.ULongLexicoder;

public class DoubleLexicoder
implements Lexicoder<Double> {
    private ULongLexicoder longEncoder = new ULongLexicoder();

    @Override
    public byte[] encode(Double d) {
        long l = Double.doubleToRawLongBits(d);
        l = l < 0L ? (l ^= 0xFFFFFFFFFFFFFFFFL) : (l ^= Long.MIN_VALUE);
        return this.longEncoder.encode(l);
    }

    @Override
    public Double decode(byte[] data) {
        long l = this.longEncoder.decode(data);
        l = l < 0L ? (l ^= Long.MIN_VALUE) : (l ^= 0xFFFFFFFFFFFFFFFFL);
        return Double.longBitsToDouble(l);
    }
}

