/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.impl;

import org.apache.accumulo.core.util.ArgumentChecker;
import org.apache.accumulo.core.util.SslConnectionParams;

class ThriftTransportKey {
    private final String location;
    private final int port;
    private final long timeout;
    private final SslConnectionParams sslParams;
    private int hash = -1;

    ThriftTransportKey(String location, long timeout, SslConnectionParams sslParams) {
        ArgumentChecker.notNull(location);
        String[] locationAndPort = location.split(":", 2);
        if (locationAndPort.length != 2) {
            throw new IllegalArgumentException("Location was expected to contain port but did not. location=" + location);
        }
        this.location = locationAndPort[0];
        this.port = Integer.parseInt(locationAndPort[1]);
        this.timeout = timeout;
        this.sslParams = sslParams;
    }

    String getLocation() {
        return this.location;
    }

    int getPort() {
        return this.port;
    }

    long getTimeout() {
        return this.timeout;
    }

    public boolean isSsl() {
        return this.sslParams != null;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ThriftTransportKey)) {
            return false;
        }
        ThriftTransportKey ttk = (ThriftTransportKey)o;
        return this.location.equals(ttk.location) && this.port == ttk.port && this.timeout == ttk.timeout && (!this.isSsl() || ttk.isSsl() && this.sslParams.equals(ttk.sslParams));
    }

    public int hashCode() {
        if (this.hash == -1) {
            this.hash = this.toString().hashCode();
        }
        return this.hash;
    }

    public String toString() {
        return (this.isSsl() ? "ssl:" : "") + this.location + ":" + Integer.toString(this.port) + " (" + Long.toString(this.timeout) + ")";
    }

    public SslConnectionParams getSslParams() {
        return this.sslParams;
    }
}

