/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.impl;

import java.util.Iterator;
import java.util.Map;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.commons.configuration.Configuration;

public class ServerConfigurationUtil {
    public static AccumuloConfiguration getConfiguration(Instance instance) {
        return instance.getConfiguration();
    }

    public static AccumuloConfiguration convertClientConfig(final AccumuloConfiguration base, final Configuration config) {
        return new AccumuloConfiguration(){

            @Override
            public String get(Property property) {
                if (config.containsKey(property.getKey())) {
                    return config.getString(property.getKey());
                }
                return base.get(property);
            }

            @Override
            public void getProperties(Map<String, String> props, AccumuloConfiguration.PropertyFilter filter) {
                base.getProperties(props, filter);
                Iterator keyIter = config.getKeys();
                while (keyIter.hasNext()) {
                    String key = (String)keyIter.next();
                    if (!filter.accept(key)) continue;
                    props.put(key, config.getString(key));
                }
            }
        };
    }
}

