/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.impl;

import java.net.UnknownHostException;
import java.util.List;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.NamespaceNotFoundException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.impl.ClientExec;
import org.apache.accumulo.core.client.impl.ClientExecReturn;
import org.apache.accumulo.core.client.impl.ServerConfigurationUtil;
import org.apache.accumulo.core.client.impl.ThriftTransportPool;
import org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.client.impl.thrift.ThriftTableOperationException;
import org.apache.accumulo.core.master.thrift.MasterClientService;
import org.apache.accumulo.core.util.ArgumentChecker;
import org.apache.accumulo.core.util.ThriftUtil;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.log4j.Logger;
import org.apache.thrift.TServiceClient;
import org.apache.thrift.transport.TTransportException;

public class MasterClient {
    private static final Logger log = Logger.getLogger(MasterClient.class);

    public static MasterClientService.Client getConnectionWithRetry(Instance instance) {
        ArgumentChecker.notNull(instance);
        MasterClientService.Client result;
        while ((result = MasterClient.getConnection(instance)) == null) {
            UtilWaitThread.sleep(250L);
        }
        return result;
    }

    public static MasterClientService.Client getConnection(Instance instance) {
        List<String> locations = instance.getMasterLocations();
        if (locations.size() == 0) {
            log.debug((Object)"No masters...");
            return null;
        }
        String master = locations.get(0);
        if (master.endsWith(":0")) {
            return null;
        }
        try {
            MasterClientService.Client client = ThriftUtil.getClientNoTimeout(new MasterClientService.Client.Factory(), master, ServerConfigurationUtil.getConfiguration(instance));
            return client;
        }
        catch (TTransportException tte) {
            if (tte.getCause().getClass().equals(UnknownHostException.class)) {
                throw new RuntimeException(tte);
            }
            log.debug((Object)("Failed to connect to master=" + master + ", will retry... "), (Throwable)tte);
            return null;
        }
    }

    public static void close(MasterClientService.Iface iface) {
        TServiceClient client = (TServiceClient)iface;
        if (client != null && client.getInputProtocol() != null && client.getInputProtocol().getTransport() != null) {
            ThriftTransportPool.getInstance().returnTransport(client.getInputProtocol().getTransport());
        } else {
            log.debug((Object)"Attempt to close null connection to the master", (Throwable)new Exception());
        }
    }

    public static <T> T execute(Instance instance, ClientExecReturn<T, MasterClientService.Client> exec) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        MasterClientService.Client client = null;
        while (true) {
            try {
                client = MasterClient.getConnectionWithRetry(instance);
                T t = exec.execute(client);
                return t;
            }
            catch (TTransportException tte) {
                log.debug((Object)"MasterClient request failed, retrying ... ", (Throwable)tte);
                UtilWaitThread.sleep(100L);
                continue;
            }
            catch (ThriftSecurityException e) {
                throw new AccumuloSecurityException(e.user, e.code, (Throwable)((Object)e));
            }
            catch (AccumuloException e) {
                throw e;
            }
            catch (ThriftTableOperationException e) {
                switch (e.getType()) {
                    case NAMESPACE_NOTFOUND: {
                        throw new TableNotFoundException(e.getTableName(), new NamespaceNotFoundException(e));
                    }
                    case NOTFOUND: {
                        throw new TableNotFoundException(e);
                    }
                }
                throw new AccumuloException((Throwable)((Object)e));
            }
            catch (Exception e) {
                throw new AccumuloException(e);
            }
            finally {
                if (client == null) continue;
                MasterClient.close(client);
                continue;
            }
            break;
        }
    }

    public static void executeGeneric(Instance instance, ClientExec<MasterClientService.Client> exec) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        MasterClientService.Client client = null;
        while (true) {
            try {
                client = MasterClient.getConnectionWithRetry(instance);
                exec.execute(client);
            }
            catch (TTransportException tte) {
                log.debug((Object)"MasterClient request failed, retrying ... ", (Throwable)tte);
                UtilWaitThread.sleep(100L);
                continue;
            }
            catch (ThriftSecurityException e) {
                throw new AccumuloSecurityException(e.user, e.code, (Throwable)((Object)e));
            }
            catch (AccumuloException e) {
                throw e;
            }
            catch (ThriftTableOperationException e) {
                switch (e.getType()) {
                    case NAMESPACE_NOTFOUND: {
                        throw new TableNotFoundException(e.getTableName(), new NamespaceNotFoundException(e));
                    }
                    case NOTFOUND: {
                        throw new TableNotFoundException(e);
                    }
                }
                throw new AccumuloException((Throwable)((Object)e));
            }
            catch (Exception e) {
                throw new AccumuloException(e);
            }
            finally {
                if (client == null) continue;
                MasterClient.close(client);
                continue;
            }
            break;
        }
    }

    public static void executeTable(Instance instance, ClientExec<MasterClientService.Client> exec) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        MasterClient.executeGeneric(instance, exec);
    }

    public static void executeNamespace(Instance instance, ClientExec<MasterClientService.Client> exec) throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException {
        block2: {
            try {
                MasterClient.executeGeneric(instance, exec);
            }
            catch (TableNotFoundException e) {
                if (!(e.getCause() instanceof NamespaceNotFoundException)) break block2;
                throw (NamespaceNotFoundException)e.getCause();
            }
        }
    }

    public static void execute(Instance instance, ClientExec<MasterClientService.Client> exec) throws AccumuloException, AccumuloSecurityException {
        try {
            MasterClient.executeGeneric(instance, exec);
        }
        catch (TableNotFoundException e) {
            throw new AssertionError((Object)e);
        }
    }
}

