/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.ActiveScan;
import org.apache.accumulo.core.client.admin.ScanState;
import org.apache.accumulo.core.client.admin.ScanType;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.data.Column;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.data.thrift.IterInfo;
import org.apache.accumulo.core.data.thrift.TColumn;
import org.apache.accumulo.core.security.Authorizations;

public class ActiveScanImpl
extends ActiveScan {
    private long scanid;
    private String client;
    private String table;
    private long age;
    private long idle;
    private ScanType type;
    private ScanState state;
    private KeyExtent extent;
    private List<Column> columns;
    private List<String> ssiList;
    private Map<String, Map<String, String>> ssio;
    private String user;
    private Authorizations authorizations;

    ActiveScanImpl(Instance instance, org.apache.accumulo.core.tabletserver.thrift.ActiveScan activeScan) throws TableNotFoundException {
        this.client = activeScan.client;
        this.user = activeScan.user;
        this.age = activeScan.age;
        this.idle = activeScan.idleTime;
        this.table = Tables.getTableName(instance, activeScan.tableId);
        this.type = ScanType.valueOf(activeScan.getType().name());
        this.state = ScanState.valueOf(activeScan.state.name());
        this.extent = new KeyExtent(activeScan.extent);
        this.authorizations = new Authorizations(activeScan.authorizations);
        this.columns = new ArrayList<Column>(activeScan.columns.size());
        for (TColumn tcolumn : activeScan.columns) {
            this.columns.add(new Column(tcolumn));
        }
        this.ssiList = new ArrayList<String>();
        for (IterInfo ii : activeScan.ssiList) {
            this.ssiList.add(ii.iterName + "=" + ii.priority + "," + ii.className);
        }
        this.ssio = activeScan.ssio;
    }

    @Override
    public long getScanid() {
        return this.scanid;
    }

    @Override
    public String getClient() {
        return this.client;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public String getTable() {
        return this.table;
    }

    @Override
    public long getAge() {
        return this.age;
    }

    @Override
    public long getLastContactTime() {
        return this.idle;
    }

    @Override
    public ScanType getType() {
        return this.type;
    }

    @Override
    public ScanState getState() {
        return this.state;
    }

    @Override
    public KeyExtent getExtent() {
        return this.extent;
    }

    @Override
    public List<Column> getColumns() {
        return this.columns;
    }

    @Override
    public List<String> getSsiList() {
        return this.ssiList;
    }

    @Override
    public Map<String, Map<String, String>> getSsio() {
        return this.ssio;
    }

    @Override
    public Authorizations getAuthorizations() {
        return this.authorizations;
    }

    @Override
    public long getIdleTime() {
        return this.idle;
    }
}

