/*
 * Decompiled with CFR 0.152.
 */
package org.hypertable.thrift;

import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.hypertable.thriftgen.HqlService;

public class ThriftClient
extends HqlService.Client {
    private TFramedTransport transport;
    private boolean do_close = false;

    public ThriftClient(TProtocol protocol) {
        super(protocol);
    }

    public static ThriftClient create(String host, int port, int timeout_ms, boolean do_open) throws TTransportException, TException {
        TFramedTransport transport = new TFramedTransport((TTransport)new TSocket(host, port, timeout_ms));
        ThriftClient client = new ThriftClient((TProtocol)new TBinaryProtocol((TTransport)transport));
        client.transport = transport;
        if (do_open) {
            client.open();
        }
        return client;
    }

    public static ThriftClient create(String host, int port) throws TTransportException, TException {
        return ThriftClient.create(host, port, 1600000, true);
    }

    public void open() throws TTransportException, TException {
        this.transport.open();
        this.do_close = true;
    }

    public void close() {
        if (this.do_close) {
            this.transport.close();
            this.do_close = false;
        }
    }
}

