/*
 * Decompiled with CFR 0.152.
 */
package org.hypertable.thrift;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class SerializedCellsWriter {
    private ByteBuffer mBuffer;
    private boolean mFinalized = false;
    private boolean mGrow = false;

    public SerializedCellsWriter(int size) {
        this.mBuffer = ByteBuffer.allocate(size);
        this.mBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.mGrow = false;
    }

    public SerializedCellsWriter(int size, boolean grow) {
        this.mBuffer = ByteBuffer.allocate(size);
        this.mBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.mGrow = grow;
    }

    public boolean add_serialized_cell_array(byte[] serialized_cells) {
        int length = serialized_cells.length - 1;
        if (length >= this.mBuffer.remaining() && this.mBuffer.position() > 0) {
            if (!this.mGrow) {
                return false;
            }
            ByteBuffer newBuffer = ByteBuffer.allocate((this.mBuffer.capacity() + length) * 3 / 2);
            newBuffer.order(ByteOrder.LITTLE_ENDIAN);
            newBuffer.put(this.mBuffer.array(), 0, this.mBuffer.position());
            this.mBuffer = newBuffer;
        }
        this.mBuffer.put(serialized_cells, 0, length);
        return true;
    }

    public boolean add(String row, String column_family, String column_qualifier, long timestamp, ByteBuffer value) {
        byte[] row_bytes = row.getBytes();
        byte[] column_family_bytes = column_family.getBytes();
        byte[] column_qualifier_bytes = column_qualifier.getBytes();
        return this.add(row_bytes, 0, row_bytes.length, column_family_bytes, 0, column_family_bytes.length, column_qualifier_bytes, 0, column_qualifier_bytes.length, timestamp, value.array(), value.arrayOffset(), value.limit(), (byte)-1);
    }

    public boolean add_delete(String row, long timestamp) {
        byte[] row_bytes = row.getBytes();
        return this.add(row_bytes, 0, row_bytes.length, null, 0, 0, null, 0, 0, timestamp, null, 0, 0, (byte)0);
    }

    public boolean add_delete(String row, String column_family, long timestamp) {
        byte[] row_bytes = row.getBytes();
        byte[] column_family_bytes = column_family.getBytes();
        return this.add(row_bytes, 0, row_bytes.length, column_family_bytes, 0, column_family_bytes.length, null, 0, 0, timestamp, null, 0, 0, (byte)1);
    }

    public boolean add_delete(String row, String column_family, String column_qualifier, long timestamp) {
        byte[] row_bytes = row.getBytes();
        byte[] column_family_bytes = column_family.getBytes();
        byte[] column_qualifier_bytes = column_qualifier.getBytes();
        return this.add(row_bytes, 0, row_bytes.length, column_family_bytes, 0, column_family_bytes.length, column_qualifier_bytes, 0, column_qualifier_bytes.length, timestamp, null, 0, 0, (byte)2);
    }

    public boolean add(ByteBuffer row, ByteBuffer column_family, ByteBuffer column_qualifier, long timestamp, ByteBuffer value) {
        return this.add(row.array(), row.arrayOffset(), row.limit(), column_family.array(), column_family.arrayOffset(), column_family.limit(), column_qualifier.array(), column_qualifier.arrayOffset(), column_qualifier.limit(), timestamp, value.array(), value.arrayOffset(), value.limit(), (byte)-1);
    }

    public boolean add_delete(ByteBuffer row, long timestamp) {
        return this.add(row.array(), row.arrayOffset(), row.limit(), null, 0, 0, null, 0, 0, timestamp, null, 0, 0, (byte)0);
    }

    public boolean add_delete(ByteBuffer row, ByteBuffer column_family, long timestamp) {
        return this.add(row.array(), row.arrayOffset(), row.limit(), column_family.array(), column_family.arrayOffset(), column_family.limit(), null, 0, 0, timestamp, null, 0, 0, (byte)1);
    }

    public boolean add_delete(ByteBuffer row, ByteBuffer column_family, ByteBuffer column_qualifier, long timestamp) {
        return this.add(row.array(), row.arrayOffset(), row.limit(), column_family.array(), column_family.arrayOffset(), column_family.limit(), column_qualifier.array(), column_qualifier.arrayOffset(), column_qualifier.limit(), timestamp, null, 0, 0, (byte)2);
    }

    public boolean add(byte[] row, int row_offset, int row_length, byte[] column_family, int column_family_offset, int column_family_length, byte[] column_qualifier, int column_qualifier_offset, int column_qualifier_length, long timestamp, byte[] value, int value_offset, int value_length, byte flag) {
        int length = 9 + row_length + column_family_length + column_qualifier_length + value_length;
        byte control = 0;
        if (timestamp == -9223372036854775806L) {
            control = (byte)(control | 0x20);
        } else if (timestamp != -9223372036854775807L) {
            control = (byte)(control | 0x40);
            length += 8;
        }
        if (length >= this.mBuffer.remaining()) {
            if (this.mBuffer.position() > 0) {
                if (!this.mGrow) {
                    return false;
                }
                ByteBuffer newBuffer = ByteBuffer.allocate((this.mBuffer.capacity() + length) * 3 / 2);
                newBuffer.order(ByteOrder.LITTLE_ENDIAN);
                newBuffer.put(this.mBuffer.array(), 0, this.mBuffer.position());
                this.mBuffer = newBuffer;
            } else {
                this.mBuffer = ByteBuffer.allocate(length + 1);
                this.mBuffer.order(ByteOrder.LITTLE_ENDIAN);
            }
        }
        this.mBuffer.put(control);
        if ((control & 0x40) != 0) {
            this.mBuffer.putLong(timestamp);
        }
        if ((control & 0xFFFFFF80) != 0 && (control & 0x10) == 0) {
            this.mBuffer.putLong(0L);
        }
        this.mBuffer.put(row, row_offset, row_length);
        this.mBuffer.put((byte)0);
        if (column_family_length > 0) {
            this.mBuffer.put(column_family, column_family_offset, column_family_length);
        }
        this.mBuffer.put((byte)0);
        if (column_qualifier_length > 0) {
            this.mBuffer.put(column_qualifier, column_qualifier_offset, column_qualifier_length);
        }
        this.mBuffer.put((byte)0);
        this.mBuffer.putInt(value_length);
        this.mBuffer.put(value, value_offset, value_length);
        this.mBuffer.put(flag);
        return true;
    }

    public boolean add_delete(byte[] row, int row_offset, int row_length, long timestamp) {
        return this.add(row, row_offset, row_length, null, 0, 0, null, 0, 0, timestamp, null, 0, 0, (byte)0);
    }

    public boolean add_delete(byte[] row, int row_offset, int row_length, byte[] column_family, int column_family_offset, int column_family_length, long timestamp) {
        return this.add(row, row_offset, row_length, column_family, column_family_offset, column_family_length, null, 0, 0, timestamp, null, 0, 0, (byte)1);
    }

    public boolean add_delete(byte[] row, int row_offset, int row_length, byte[] column_family, int column_family_offset, int column_family_length, byte[] column_qualifier, int column_qualifier_offset, int column_qualifier_length, long timestamp) {
        return this.add(row, row_offset, row_length, column_family, column_family_offset, column_family_length, column_qualifier, column_qualifier_offset, column_qualifier_length, timestamp, null, 0, 0, (byte)2);
    }

    public void finalize(byte flag) {
        this.mBuffer.put((byte)(1 | flag));
        this.mBuffer.flip();
        this.mFinalized = true;
    }

    public byte[] array() {
        if (!this.mFinalized) {
            this.finalize((byte)1);
        }
        byte[] rbuf = new byte[this.mBuffer.limit()];
        this.mBuffer.get(rbuf);
        this.mBuffer.rewind();
        return rbuf;
    }

    public ByteBuffer buffer() {
        if (!this.mFinalized) {
            this.finalize((byte)1);
        }
        return this.mBuffer;
    }

    public boolean isEmpty() {
        return this.mBuffer.position() == 0;
    }

    public void clear() {
        this.mBuffer.clear();
        this.mFinalized = false;
    }

    public int capacity() {
        return this.mBuffer.capacity();
    }
}

