/*
 * Decompiled with CFR 0.152.
 */
package org.hypertable.hadoop.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.hadoop.io.Writable;
import org.hypertable.Common.ColumnNameSplit;
import org.hypertable.hadoop.util.Serialization;
import org.hypertable.thrift.SerializedCellsReader;

public class Row
implements Writable,
Comparable<Row> {
    private ByteBuffer mSerializedCells = null;
    private byte[] mRowKey = null;
    private NavigableMap<byte[], NavigableMap<byte[], byte[]>> mColFamilyToCol = null;
    private SerializedCellsReader mReader = new SerializedCellsReader(null);

    public Row() {
    }

    public Row(byte[] buf) {
        this.mSerializedCells = ByteBuffer.wrap(buf);
        this.mSerializedCells.rewind();
        this.mSerializedCells.mark();
        this.mReader.reset(this.mSerializedCells);
        if (this.mReader.next()) {
            this.mRowKey = this.mReader.get_row();
        }
    }

    public Row(ByteBuffer buf) {
        this.mSerializedCells = buf;
        this.mReader.reset(this.mSerializedCells);
        if (this.mReader.next()) {
            this.mRowKey = this.mReader.get_row();
        }
    }

    public void set(Row other) {
        this.mSerializedCells = other.mSerializedCells;
        this.mReader.reset(this.mSerializedCells);
        this.mRowKey = other.mRowKey;
        this.mColFamilyToCol = other.mColFamilyToCol;
    }

    public byte[] getSerializedRow() {
        assert (this.mSerializedCells.arrayOffset() == 0);
        return this.mSerializedCells.array();
    }

    public byte[] getRowKey() {
        return this.mRowKey;
    }

    public byte[] getValue(byte[] family, byte[] qualifier) {
        NavigableMap qualifierToValue;
        if (this.mColFamilyToCol == null) {
            this.initMap();
        }
        if ((qualifierToValue = (NavigableMap)this.mColFamilyToCol.get(family)) == null) {
            return null;
        }
        return (byte[])qualifierToValue.get(qualifier);
    }

    public NavigableMap<byte[], byte[]> getColFamilyMap(byte[] family) {
        if (this.mColFamilyToCol == null) {
            this.initMap();
        }
        return (NavigableMap)this.mColFamilyToCol.get(family);
    }

    public NavigableMap<byte[], NavigableMap<byte[], byte[]>> getMap() {
        if (this.mColFamilyToCol == null) {
            this.initMap();
        }
        return this.mColFamilyToCol;
    }

    public boolean containsColFamily(byte[] cf) {
        if (this.mColFamilyToCol == null) {
            this.initMap();
        }
        return this.mColFamilyToCol.containsKey(cf);
    }

    public boolean containsCol(String col) {
        byte[] col_family = new byte[]{};
        byte[] col_qualifier = new byte[]{};
        ColumnNameSplit.split(col, col_family, col_qualifier);
        return this.containsColFamily(col_family) && ((NavigableMap)this.mColFamilyToCol.get(col_family)).containsKey(col_qualifier);
    }

    public boolean containsCol(byte[] family, byte[] qualifier) {
        if (qualifier == null) {
            return false;
        }
        return this.containsColFamily(family) && ((NavigableMap)this.mColFamilyToCol.get(family)).containsKey(qualifier);
    }

    public byte[] getValue(String col) {
        byte[] cf = new byte[]{};
        byte[] cq = new byte[]{};
        ColumnNameSplit.split(col, cf, cq);
        return this.getValue(cf, cq);
    }

    private synchronized void initMap() {
        if (this.mColFamilyToCol != null || this.mSerializedCells == null) {
            return;
        }
        this.mReader.reset(this.mSerializedCells);
        this.mColFamilyToCol = new TreeMap<byte[], NavigableMap<byte[], byte[]>>(Serialization.ByteArrayComparator.GET);
        while (this.mReader.next()) {
            if (this.mRowKey == null) {
                this.mRowKey = this.mReader.get_row();
            }
            if (!Arrays.equals(this.mReader.get_row(), this.mRowKey)) break;
            byte[] family = this.mReader.get_column_family();
            TreeMap<byte[], byte[]> qualifierToValue = (TreeMap<byte[], byte[]>)this.mColFamilyToCol.get(family);
            if (qualifierToValue == null) {
                qualifierToValue = new TreeMap<byte[], byte[]>(Serialization.ByteArrayComparator.GET);
                this.mColFamilyToCol.put(family, qualifierToValue);
            }
            qualifierToValue.put(this.mReader.get_column_qualifier(), this.mReader.get_value());
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.mRowKey = Serialization.readByteArray(in);
        this.mSerializedCells = ByteBuffer.wrap(Serialization.readByteArray(in));
        this.mSerializedCells.mark();
        this.mReader.reset(this.mSerializedCells);
    }

    public void write(DataOutput out) throws IOException {
        Serialization.writeByteArray(out, this.mRowKey);
        assert (this.mSerializedCells.arrayOffset() == 0);
        Serialization.writeByteArray(out, this.mSerializedCells.array());
    }

    @Override
    public int compareTo(Row row) {
        return Serialization.compareTo(this.mRowKey, row.mRowKey);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.mSerializedCells == null) {
            return sb.toString();
        }
        sb.append("row=");
        String bytes = new String(this.mRowKey);
        sb.append(bytes);
        sb.append(", cells={");
        if (this.mColFamilyToCol == null) {
            this.initMap();
        }
        for (Map.Entry entry : this.mColFamilyToCol.entrySet()) {
            bytes = new String((byte[])entry.getKey());
            String column = " <column=" + bytes + ":";
            for (Map.Entry ee : ((NavigableMap)entry.getValue()).entrySet()) {
                bytes = new String((byte[])ee.getKey());
                sb.append(column + bytes);
                sb.append(", valueLen=" + ((byte[])ee.getValue()).length + ">");
            }
        }
        sb.append("}");
        return sb.toString();
    }
}

