/*
 * Decompiled with CFR 0.152.
 */
package org.hypertable.hadoop.mapred;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;
import org.hypertable.hadoop.util.Row;
import org.hypertable.thrift.SerializedCellsWriter;
import org.hypertable.thrift.ThriftClient;
import org.hypertable.thriftgen.MutatorFlag;

public class RowOutputFormat
implements OutputFormat<NullWritable, Row> {
    private static final Log log = LogFactory.getLog(RowOutputFormat.class);
    public static final String NAMESPACE = "hypertable.mapred.output.namespace";
    public static final String TABLE = "hypertable.mapred.output.table";
    public static final String MUTATOR_FLAGS = "hypertable.mapred.output.mutator-flags";
    public static final String BUFFER_SIZE = "hypertable.mapred.output.buffer-size";
    public static final String MUTATOR_FLUSH_INTERVAL = "hypertable.mapred.output.mutator-flush-interval";
    public static final int msDefaultSerializedCellBufferSize = 1000000;

    public RecordWriter<NullWritable, Row> getRecordWriter(FileSystem ignored, JobConf job, String name, Progressable progress) throws IOException {
        String namespace = job.get(NAMESPACE);
        String table = job.get(TABLE);
        int flags = job.getInt(MUTATOR_FLAGS, 0);
        int flush_interval = job.getInt(MUTATOR_FLUSH_INTERVAL, 0);
        int buffer_size = job.getInt(BUFFER_SIZE, 1000000);
        try {
            return new HypertableRecordWriter(namespace, table, flags, flush_interval, buffer_size);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new IOException("Unable to access RecordWriter - " + e.toString());
        }
    }

    public void checkOutputSpecs(FileSystem ignore, JobConf conf) throws IOException {
    }

    protected static class HypertableRecordWriter
    implements RecordWriter<NullWritable, Row> {
        private ThriftClient mClient;
        private long mMutator;
        private long mNamespace;
        private String namespace;
        private String table;
        private SerializedCellsWriter mSerializedCellsWriter;

        public HypertableRecordWriter(String namespace, String table, int flags, int flush_interval, int buffer_size) throws IOException {
            try {
                this.namespace = namespace;
                this.table = table;
                this.mClient = ThriftClient.create("localhost", 38080);
                this.mNamespace = this.mClient.open_namespace(namespace);
                this.mMutator = this.mClient.open_mutator(this.mNamespace, table, flags, flush_interval);
                this.mSerializedCellsWriter = new SerializedCellsWriter(buffer_size, false);
            }
            catch (Exception e) {
                log.error((Object)e);
                throw new IOException("Unable to open thrift mutator - " + e.toString());
            }
        }

        public HypertableRecordWriter(String namespace, String table) throws IOException {
            this(namespace, table, MutatorFlag.NO_LOG_SYNC.getValue(), 0, 1000000);
        }

        public HypertableRecordWriter(String namespace, String table, int flags) throws IOException {
            this(namespace, table, flags, 0, 1000000);
        }

        public void close(Reporter reporter) throws IOException {
            try {
                if (!this.mSerializedCellsWriter.isEmpty()) {
                    this.mClient.mutator_set_cells_serialized(this.mMutator, this.mSerializedCellsWriter.buffer(), false);
                }
                this.mClient.close_mutator(this.mMutator);
                this.mClient.close_namespace(this.mNamespace);
            }
            catch (Exception e) {
                log.error((Object)e);
                throw new IOException("Unable to close thrift mutator & namespace- " + e.toString());
            }
        }

        public void write(NullWritable key, Row value) throws IOException {
            try {
                byte[] cells = value.getSerializedRow();
                boolean added = this.mSerializedCellsWriter.add_serialized_cell_array(cells);
                if (!added) {
                    this.mClient.mutator_set_cells_serialized(this.mMutator, this.mSerializedCellsWriter.buffer(), false);
                    if (cells.length > this.mSerializedCellsWriter.capacity()) {
                        this.mSerializedCellsWriter = new SerializedCellsWriter(cells.length * 3 / 2, false);
                    } else {
                        this.mSerializedCellsWriter.clear();
                    }
                    added = this.mSerializedCellsWriter.add_serialized_cell_array(cells);
                    if (!added) {
                        throw new IOException("Unable to add cell array of size " + cells.length + " to SerializedCellsWriter of capacity " + this.mSerializedCellsWriter.capacity());
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)e);
                throw new IOException("Unable to write cell - " + e.toString());
            }
        }
    }
}

