/*
 * Decompiled with CFR 0.152.
 */
package org.hypertable.hadoop.hive;

import java.io.IOException;
import java.util.Properties;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.util.Progressable;
import org.hypertable.hadoop.mapred.RowOutputFormat;
import org.hypertable.hadoop.util.Row;

public class HiveHTOutputFormat
extends RowOutputFormat
implements HiveOutputFormat<NullWritable, Row> {
    public FileSinkOperator.RecordWriter getHiveRecordWriter(JobConf jc, Path finalOutPath, Class<? extends Writable> valueClass, boolean isCompressed, Properties tableProperties, Progressable progress) throws IOException {
        String htTableName = jc.get("hypertable.table.name");
        jc.set("hypertable.mapred.output.table", htTableName);
        final RecordWriter<NullWritable, Row> tblWriter = this.getRecordWriter(null, jc, null, progress);
        return new FileSinkOperator.RecordWriter(){

            public void close(boolean abort) throws IOException {
                tblWriter.close(null);
            }

            public void write(Writable w) throws IOException {
                Row row = (Row)w;
                tblWriter.write(null, (Object)row);
            }
        };
    }
}

