/*
 * Decompiled with CFR 0.152.
 */
package org.hypertable.hadoop.hive;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.lazy.LazyFactory;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.lazy.LazyUtils;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazySimpleStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.hypertable.hadoop.hive.LazyHTRow;
import org.hypertable.hadoop.util.Row;
import org.hypertable.hadoop.util.Serialization;
import org.hypertable.thrift.SerializedCellsWriter;

public class HTSerDe
implements SerDe {
    public static final String HT_COL_MAPPING = "hypertable.columns.mapping";
    public static final String HT_NAMESPACE = "hypertable.table.namespace";
    public static final String HT_TABLE_NAME = "hypertable.table.name";
    public static final String HT_KEY_COL = ":key";
    public static final Log LOG = LogFactory.getLog((String)HTSerDe.class.getName());
    private ObjectInspector cachedObjectInspector;
    private LazyHTRow cachedHTRow;
    private Row serializeCache;
    private String htColumnsMapping;
    private List<String> htColumnFamilies;
    private List<byte[]> htColumnFamiliesBytes;
    private List<String> htColumnQualifiers;
    private List<byte[]> htColumnQualifiersBytes;
    private LazySimpleSerDe.SerDeParameters serdeParams;
    private boolean useJSONSerialize;
    private final ByteStream.Output serializeStream = new ByteStream.Output();
    private int iKey;
    private byte[] separators;
    private boolean escaped;
    private byte escapeChar;
    private boolean[] needsEscape;

    public String toString() {
        return this.getClass().toString() + "[" + this.htColumnsMapping + ":" + ((StructTypeInfo)this.serdeParams.getRowTypeInfo()).getAllStructFieldNames() + ":" + ((StructTypeInfo)this.serdeParams.getRowTypeInfo()).getAllStructFieldTypeInfos() + "]";
    }

    public void initialize(Configuration conf, Properties tbl) throws SerDeException {
        this.initHTSerDeParameters(conf, tbl, this.getClass().getName());
        this.cachedObjectInspector = LazyFactory.createLazyStructInspector((List)this.serdeParams.getColumnNames(), (List)this.serdeParams.getColumnTypes(), (byte[])this.serdeParams.getSeparators(), (Text)this.serdeParams.getNullSequence(), (boolean)this.serdeParams.isLastColumnTakesRest(), (boolean)this.serdeParams.isEscaped(), (byte)this.serdeParams.getEscapeChar());
        this.cachedHTRow = new LazyHTRow((LazySimpleStructObjectInspector)this.cachedObjectInspector);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("HTSerDe initialized with : columnNames = " + this.serdeParams.getColumnNames() + " columnTypes = " + this.serdeParams.getColumnTypes() + " htColumnMapping = " + this.htColumnsMapping));
        }
    }

    public static int parseColumnMapping(String columnMapping, List<String> colFamilies, List<byte[]> colFamiliesBytes, List<String> colQualifiers, List<byte[]> colQualifiersBytes) throws SerDeException {
        int rowKeyIndex = -1;
        if (colFamilies == null || colQualifiers == null) {
            throw new SerDeException("Error: caller must pass in lists for the column families and qualifiers.");
        }
        colFamilies.clear();
        colQualifiers.clear();
        if (columnMapping == null) {
            throw new SerDeException("Error: hypertable.columns.mapping missing for this Hypertable table.");
        }
        if (columnMapping.equals("") || columnMapping.equals(HT_KEY_COL)) {
            throw new SerDeException("Error: hypertable.columns.mapping specifies only the HT table row key. A valid Hive-Hypertable table must specify at least one additional column.");
        }
        String[] mapping = columnMapping.split(",");
        for (int i = 0; i < mapping.length; ++i) {
            String elem = mapping[i];
            int idxFirst = elem.indexOf(":");
            int idxLast = elem.lastIndexOf(":");
            if (idxFirst < 0 || idxFirst != idxLast) {
                throw new SerDeException("Error: the HT columns mapping contains a badly formed column family, column qualifier specification.");
            }
            if (elem.equals(HT_KEY_COL)) {
                rowKeyIndex = i;
                colFamilies.add(elem);
                colQualifiers.add(null);
                continue;
            }
            String[] parts = elem.split(":");
            assert (parts.length > 0 && parts.length <= 2);
            colFamilies.add(parts[0]);
            if (parts.length == 2) {
                colQualifiers.add(parts[1]);
                continue;
            }
            colQualifiers.add(null);
        }
        if (rowKeyIndex == -1) {
            colFamilies.add(0, HT_KEY_COL);
            colQualifiers.add(0, null);
            rowKeyIndex = 0;
        }
        if (colFamilies.size() != colQualifiers.size()) {
            throw new SerDeException("Error in parsing the Hypertable columns mapping.");
        }
        if (colFamiliesBytes != null) {
            colFamiliesBytes.clear();
            for (String fam : colFamilies) {
                colFamiliesBytes.add(Serialization.toBytes(fam));
            }
        }
        if (colQualifiersBytes != null) {
            colQualifiersBytes.clear();
            for (String qual : colQualifiers) {
                if (qual == null) {
                    colQualifiersBytes.add(null);
                    continue;
                }
                colQualifiersBytes.add(Serialization.toBytes(qual));
            }
        }
        if (colFamiliesBytes != null && colQualifiersBytes != null && colFamiliesBytes.size() != colQualifiersBytes.size()) {
            throw new SerDeException("Error in caching the bytes for the hypertable column families and qualifiers.");
        }
        return rowKeyIndex;
    }

    public static boolean isSpecialColumn(String htColumnName) {
        return htColumnName.equals(HT_KEY_COL);
    }

    private void initHTSerDeParameters(Configuration job, Properties tbl, String serdeName) throws SerDeException {
        this.htColumnsMapping = tbl.getProperty(HT_COL_MAPPING);
        String columnTypeProperty = tbl.getProperty("columns.types");
        this.htColumnFamilies = new ArrayList<String>();
        this.htColumnFamiliesBytes = new ArrayList<byte[]>();
        this.htColumnQualifiers = new ArrayList<String>();
        this.htColumnQualifiersBytes = new ArrayList<byte[]>();
        this.iKey = HTSerDe.parseColumnMapping(this.htColumnsMapping, this.htColumnFamilies, this.htColumnFamiliesBytes, this.htColumnQualifiers, this.htColumnQualifiersBytes);
        if (columnTypeProperty == null) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.htColumnFamilies.size(); ++i) {
                if (sb.length() > 0) {
                    sb.append(":");
                }
                String colFamily = this.htColumnFamilies.get(i);
                String colQualifier = this.htColumnQualifiers.get(i);
                if (HTSerDe.isSpecialColumn(colFamily)) {
                    sb.append("string");
                    continue;
                }
                if (colQualifier == null) {
                    sb.append("map<string,string>");
                    continue;
                }
                sb.append("string");
            }
            tbl.setProperty("columns.types", sb.toString());
        }
        this.serdeParams = LazySimpleSerDe.initSerdeParams((Configuration)job, (Properties)tbl, (String)serdeName);
        if (this.htColumnFamilies.size() != this.serdeParams.getColumnNames().size()) {
            throw new SerDeException(serdeName + ": columns has " + this.serdeParams.getColumnNames().size() + " elements while hypertable.columns.mapping has " + this.htColumnFamilies.size() + " elements" + " (counting the key if implicit)");
        }
        this.separators = this.serdeParams.getSeparators();
        this.escaped = this.serdeParams.isEscaped();
        this.escapeChar = this.serdeParams.getEscapeChar();
        this.needsEscape = this.serdeParams.getNeedsEscape();
        for (int i = 0; i < this.htColumnFamilies.size(); ++i) {
            TypeInfo typeInfo;
            String colFamily = this.htColumnFamilies.get(i);
            String colQualifier = this.htColumnQualifiers.get(i);
            if (colQualifier != null || HTSerDe.isSpecialColumn(colFamily) || (typeInfo = (TypeInfo)this.serdeParams.getColumnTypes().get(i)).getCategory() == ObjectInspector.Category.MAP && ((MapTypeInfo)typeInfo).getMapKeyTypeInfo().getTypeName() == "string") continue;
            throw new SerDeException(serdeName + ": Hypertable column family '" + colFamily + "' should be mapped to Map<String,?> but is mapped to " + typeInfo.getTypeName());
        }
    }

    public Object deserialize(Writable row) throws SerDeException {
        if (!(row instanceof Row)) {
            throw new SerDeException(this.getClass().getName() + ": expects Row!");
        }
        Row rr = (Row)row;
        this.cachedHTRow.init(rr, this.htColumnFamilies, this.htColumnFamiliesBytes, this.htColumnQualifiers, this.htColumnQualifiersBytes);
        return this.cachedHTRow;
    }

    public ObjectInspector getObjectInspector() throws SerDeException {
        return this.cachedObjectInspector;
    }

    public Class<? extends Writable> getSerializedClass() {
        return Row.class;
    }

    public Writable serialize(Object obj, ObjectInspector objInspector) throws SerDeException {
        if (objInspector.getCategory() != ObjectInspector.Category.STRUCT) {
            throw new SerDeException(this.getClass().toString() + " can only serialize struct types, but we got: " + objInspector.getTypeName());
        }
        StructObjectInspector soi = (StructObjectInspector)objInspector;
        List fields = soi.getAllStructFieldRefs();
        List list = soi.getStructFieldsDataAsList(obj);
        List declaredFields = this.serdeParams.getRowTypeInfo() != null && ((StructTypeInfo)this.serdeParams.getRowTypeInfo()).getAllStructFieldNames().size() > 0 ? ((StructObjectInspector)this.getObjectInspector()).getAllStructFieldRefs() : null;
        boolean rowkeyOffset = false;
        boolean rowkeyLen = false;
        boolean colFamilyOffset = false;
        boolean colFamilyLen = false;
        boolean colQualifierOffset = false;
        boolean colQualifierLen = false;
        boolean valueOffset = false;
        boolean valueLen = false;
        Object rowkey = null;
        Object cf = null;
        Object cq = null;
        SerializedCellsWriter cellWriter = new SerializedCellsWriter(0, true);
        ByteStream.Output serializeStream = new ByteStream.Output();
        boolean isNotNull = false;
        String htColumn = "";
        try {
            byte[] key = this.serializeField(this.iKey, null, null, fields, list, declaredFields);
            if (key == null) {
                throw new SerDeException("Hypertable row key cannot be NULL");
            }
            for (int i = 0; i < fields.size(); ++i) {
                if (i == this.iKey) continue;
                this.serializeField(i, key, cellWriter, fields, list, declaredFields);
            }
            this.serializeCache = new Row(cellWriter.array());
        }
        catch (IOException e) {
            throw new SerDeException((Throwable)e);
        }
        return this.serializeCache;
    }

    private byte[] serializeField(int i, byte[] rowkey, SerializedCellsWriter cellWriter, List<? extends StructField> fields, List<Object> list, List<? extends StructField> declaredFields) throws IOException {
        Object f;
        String htColumnFamily = this.htColumnFamilies.get(i);
        String htColumnQualifier = this.htColumnQualifiers.get(i);
        ObjectInspector foi = fields.get(i).getFieldObjectInspector();
        Object object = f = list == null ? null : list.get(i);
        if (f == null) {
            return null;
        }
        if (htColumnQualifier == null && !HTSerDe.isSpecialColumn(htColumnFamily)) {
            MapObjectInspector moi = (MapObjectInspector)foi;
            ObjectInspector koi = moi.getMapKeyObjectInspector();
            ObjectInspector voi = moi.getMapValueObjectInspector();
            Map map = moi.getMap(f);
            if (map == null) {
                return null;
            }
            for (Map.Entry entry : map.entrySet()) {
                this.serializeStream.reset();
                this.serialize(entry.getKey(), koi, 3);
                byte[] columnQualifierBytes = new byte[this.serializeStream.getCount()];
                System.arraycopy(this.serializeStream.getData(), 0, columnQualifierBytes, 0, this.serializeStream.getCount());
                this.serializeStream.reset();
                boolean isNotNull = this.serialize(entry.getValue(), voi, 3);
                if (!isNotNull) continue;
                byte[] value = new byte[this.serializeStream.getCount()];
                System.arraycopy(this.serializeStream.getData(), 0, value, 0, this.serializeStream.getCount());
                cellWriter.add(rowkey, 0, rowkey.length, this.htColumnFamiliesBytes.get(i), 0, this.htColumnFamiliesBytes.get(i).length, columnQualifierBytes, 0, columnQualifierBytes.length, -9223372036854775806L, value, 0, value.length, (byte)-1);
            }
        } else {
            this.serializeStream.reset();
            boolean isNotNull = !foi.getCategory().equals((Object)ObjectInspector.Category.PRIMITIVE) && (declaredFields == null || declaredFields.get(i).getFieldObjectInspector().getCategory().equals((Object)ObjectInspector.Category.PRIMITIVE) || this.useJSONSerialize) ? this.serialize(SerDeUtils.getJSONString((Object)f, (ObjectInspector)foi), (ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, 1) : this.serialize(f, foi, 1);
            if (!isNotNull) {
                return null;
            }
            byte[] rowkey_or_value = new byte[this.serializeStream.getCount()];
            System.arraycopy(this.serializeStream.getData(), 0, rowkey_or_value, 0, this.serializeStream.getCount());
            if (i == this.iKey) {
                return rowkey_or_value;
            }
            cellWriter.add(rowkey, 0, rowkey.length, this.htColumnFamiliesBytes.get(i), 0, this.htColumnFamiliesBytes.get(i).length, this.htColumnQualifiersBytes.get(i), 0, this.htColumnQualifiersBytes.get(i).length, -9223372036854775806L, rowkey_or_value, 0, rowkey_or_value.length, (byte)-1);
        }
        return null;
    }

    private boolean serialize(Object obj, ObjectInspector objInspector, int level) throws IOException {
        switch (objInspector.getCategory()) {
            case PRIMITIVE: {
                LazyUtils.writePrimitiveUTF8((OutputStream)this.serializeStream, (Object)obj, (PrimitiveObjectInspector)((PrimitiveObjectInspector)objInspector), (boolean)this.escaped, (byte)this.escapeChar, (boolean[])this.needsEscape);
                return true;
            }
            case LIST: {
                char separator = (char)this.separators[level];
                ListObjectInspector loi = (ListObjectInspector)objInspector;
                List list = loi.getList(obj);
                ObjectInspector eoi = loi.getListElementObjectInspector();
                if (list == null) {
                    return false;
                }
                for (int i = 0; i < list.size(); ++i) {
                    if (i > 0) {
                        this.serializeStream.write((int)separator);
                    }
                    this.serialize(list.get(i), eoi, level + 1);
                }
                return true;
            }
            case MAP: {
                char separator = (char)this.separators[level];
                char keyValueSeparator = (char)this.separators[level + 1];
                MapObjectInspector moi = (MapObjectInspector)objInspector;
                ObjectInspector koi = moi.getMapKeyObjectInspector();
                ObjectInspector voi = moi.getMapValueObjectInspector();
                Map map = moi.getMap(obj);
                if (map == null) {
                    return false;
                }
                boolean first = true;
                for (Map.Entry entry : map.entrySet()) {
                    if (first) {
                        first = false;
                    } else {
                        this.serializeStream.write((int)separator);
                    }
                    this.serialize(entry.getKey(), koi, level + 2);
                    this.serializeStream.write((int)keyValueSeparator);
                    this.serialize(entry.getValue(), voi, level + 2);
                }
                return true;
            }
            case STRUCT: {
                char separator = (char)this.separators[level];
                StructObjectInspector soi = (StructObjectInspector)objInspector;
                List fields = soi.getAllStructFieldRefs();
                List list = soi.getStructFieldsDataAsList(obj);
                if (list == null) {
                    return false;
                }
                for (int i = 0; i < list.size(); ++i) {
                    if (i > 0) {
                        this.serializeStream.write((int)separator);
                    }
                    this.serialize(list.get(i), ((StructField)fields.get(i)).getFieldObjectInspector(), level + 1);
                }
                return true;
            }
        }
        throw new RuntimeException("Unknown category type: " + objInspector.getCategory());
    }

    public boolean isUseJSONSerialize() {
        return this.useJSONSerialize;
    }

    public void setUseJSONSerialize(boolean useJSONSerialize) {
        this.useJSONSerialize = useJSONSerialize;
    }

    int getKeyColumnOffset() {
        return this.iKey;
    }
}

