/*
 * Decompiled with CFR 0.152.
 */
package org.hypertable.DfsBroker.hadoop;

import java.net.ProtocolException;
import java.util.logging.Logger;
import org.hypertable.AsyncComm.ApplicationHandler;
import org.hypertable.AsyncComm.Comm;
import org.hypertable.AsyncComm.Event;
import org.hypertable.Common.Error;
import org.hypertable.Common.System;
import org.hypertable.DfsBroker.hadoop.HdfsBroker;
import org.hypertable.DfsBroker.hadoop.ResponseCallbackWrite;

public class RequestHandlerWrite
extends ApplicationHandler {
    static final Logger log = Logger.getLogger("org.hypertable.DfsBroker.hadoop");
    private Comm mComm;
    private HdfsBroker mBroker;

    public RequestHandlerWrite(Comm comm, HdfsBroker broker, Event event) {
        super(event);
        this.mComm = comm;
        this.mBroker = broker;
    }

    @Override
    public void run() {
        block3: {
            ResponseCallbackWrite cb = new ResponseCallbackWrite(this.mComm, this.mEvent);
            try {
                if (this.mEvent.payload.remaining() < 8) {
                    throw new ProtocolException("Truncated message");
                }
                int fd = this.mEvent.payload.getInt();
                int amount = this.mEvent.payload.getInt();
                boolean sync = this.mEvent.payload.get() != 0;
                this.mEvent.payload.position(this.mEvent.payload.position() + (System.HT_DIRECT_IO_ALIGNMENT - 9));
                byte[] data = new byte[amount];
                this.mEvent.payload.get(data);
                this.mBroker.Write(cb, fd, amount, data, sync);
            }
            catch (ProtocolException e) {
                int error = cb.error(1, e.getMessage());
                log.severe("Protocol error (WRITE) - " + e.getMessage());
                if (error == 0) break block3;
                log.severe("Problem sending (WRITE) error back to client - " + Error.GetText(error));
            }
        }
    }
}

