/*
 * Decompiled with CFR 0.152.
 */
package org.hypertable.DfsBroker.hadoop;

import java.net.ProtocolException;
import java.util.logging.Logger;
import org.hypertable.AsyncComm.ApplicationHandler;
import org.hypertable.AsyncComm.Comm;
import org.hypertable.AsyncComm.Event;
import org.hypertable.Common.Error;
import org.hypertable.DfsBroker.hadoop.HdfsBroker;
import org.hypertable.DfsBroker.hadoop.ResponseCallbackPositionRead;

public class RequestHandlerPositionRead
extends ApplicationHandler {
    static final Logger log = Logger.getLogger("org.hypertable.DfsBroker.hadoop");
    private Comm mComm;
    private HdfsBroker mBroker;

    public RequestHandlerPositionRead(Comm comm, HdfsBroker broker, Event event) {
        super(event);
        this.mComm = comm;
        this.mBroker = broker;
    }

    @Override
    public void run() {
        block3: {
            ResponseCallbackPositionRead cb = new ResponseCallbackPositionRead(this.mComm, this.mEvent);
            try {
                if (this.mEvent.payload.remaining() < 16) {
                    throw new ProtocolException("Truncated message");
                }
                int fd = this.mEvent.payload.getInt();
                long offset = this.mEvent.payload.getLong();
                int amount = this.mEvent.payload.getInt();
                boolean verify_checksum = this.mEvent.payload.get() != 0;
                this.mBroker.PositionRead(cb, fd, offset, amount, verify_checksum);
            }
            catch (ProtocolException e) {
                int error = cb.error(1, e.getMessage());
                log.severe("Protocol error (PREAD) - " + e.getMessage());
                if (error == 0) break block3;
                log.severe("Problem sending (PREAD) error back to client - " + Error.GetText(error));
            }
        }
    }
}

