/*
 * Decompiled with CFR 0.152.
 */
package org.hypertable.DfsBroker.hadoop;

import java.net.ProtocolException;
import java.util.logging.Logger;
import org.hypertable.AsyncComm.ApplicationHandler;
import org.hypertable.AsyncComm.Comm;
import org.hypertable.AsyncComm.Event;
import org.hypertable.AsyncComm.Serialization;
import org.hypertable.Common.Error;
import org.hypertable.DfsBroker.hadoop.HdfsBroker;
import org.hypertable.DfsBroker.hadoop.ResponseCallbackCreate;

public class RequestHandlerCreate
extends ApplicationHandler {
    static final Logger log = Logger.getLogger("org.hypertable.DfsBroker.hadoop");
    private Comm mComm;
    private HdfsBroker mBroker;

    public RequestHandlerCreate(Comm comm, HdfsBroker broker, Event event) {
        super(event);
        this.mComm = comm;
        this.mBroker = broker;
    }

    @Override
    public void run() {
        block4: {
            ResponseCallbackCreate cb = new ResponseCallbackCreate(this.mComm, this.mEvent);
            try {
                if (this.mEvent.payload.remaining() < 18) {
                    throw new ProtocolException("Truncated message");
                }
                int flags = this.mEvent.payload.getInt();
                int bufferSize = this.mEvent.payload.getInt();
                int ival = this.mEvent.payload.getInt();
                short replication = (short)ival;
                long blockSize = this.mEvent.payload.getLong();
                String fileName = Serialization.DecodeString(this.mEvent.payload);
                if (fileName == null) {
                    throw new ProtocolException("Filename not properly encoded in request packet");
                }
                this.mBroker.Create(cb, fileName, flags, bufferSize, replication, blockSize);
            }
            catch (ProtocolException e) {
                int error = cb.error(1, e.getMessage());
                log.severe("Protocol error (CREATE) - " + e.getMessage());
                if (error == 0) break block4;
                log.severe("Problem sending (CREATE) error back to client - " + Error.GetText(error));
            }
        }
    }
}

