/*
 * Decompiled with CFR 0.152.
 */
package org.hypertable.DfsBroker.hadoop;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.nio.BufferUnderflowException;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.server.namenode.NotReplicatedYetException;
import org.apache.hadoop.util.ReflectionUtils;
import org.hypertable.AsyncComm.Comm;
import org.hypertable.AsyncComm.ResponseCallback;
import org.hypertable.Common.Error;
import org.hypertable.DfsBroker.hadoop.OpenFileData;
import org.hypertable.DfsBroker.hadoop.OpenFileMap;
import org.hypertable.DfsBroker.hadoop.ResponseCallbackCreate;
import org.hypertable.DfsBroker.hadoop.ResponseCallbackExists;
import org.hypertable.DfsBroker.hadoop.ResponseCallbackLength;
import org.hypertable.DfsBroker.hadoop.ResponseCallbackOpen;
import org.hypertable.DfsBroker.hadoop.ResponseCallbackPositionRead;
import org.hypertable.DfsBroker.hadoop.ResponseCallbackRead;
import org.hypertable.DfsBroker.hadoop.ResponseCallbackReaddir;
import org.hypertable.DfsBroker.hadoop.ResponseCallbackWrite;

public class HdfsBroker {
    private static final int OPEN_FLAG_DIRECT = 1;
    private static final int OPEN_FLAG_OVERWRITE = 2;
    static final Logger log = Logger.getLogger("org.hypertable.DfsBroker.hadoop");
    protected static AtomicInteger msUniqueId = new AtomicInteger(0);
    private Configuration mConf = new Configuration();
    private FileSystem mFilesystem;
    private FileSystem mFilesystem_noverify;
    private boolean mVerbose = false;
    public OpenFileMap mOpenFileMap = new OpenFileMap();

    public HdfsBroker(Comm comm, Properties props) throws IOException {
        boolean shortcircuit_reads = false;
        boolean verify_checksums = false;
        String str = props.getProperty("verbose");
        this.mVerbose = str != null && str.equalsIgnoreCase("true");
        str = props.getProperty("HdfsBroker.dfs.client.read.shortcircuit");
        if (str != null && str.equalsIgnoreCase("true")) {
            shortcircuit_reads = true;
        }
        if ((str = props.getProperty("HdfsBroker.fs.default.name")) == null) {
            System.err.println("error: 'HdfsBroker.fs.default.name' property not specified.");
            System.exit(1);
        }
        if (this.mVerbose) {
            System.out.println("HdfsBroker.Server.fs.default.name=" + str);
            System.out.println("HdfsBroker.dfs.client.read.shortcircuit=" + shortcircuit_reads);
        }
        this.mConf.set("fs.default.name", str);
        this.mConf.set("dfs.client.buffer.dir", "/tmp");
        this.mConf.setInt("dfs.client.block.write.retries", 3);
        this.mConf.setBoolean("fs.automatic.close", false);
        this.mConf.setBoolean("dfs.client.read.shortcircuit", shortcircuit_reads);
        try {
            this.mFilesystem = FileSystem.get((Configuration)this.mConf);
            this.mFilesystem.initialize(FileSystem.getDefaultUri((Configuration)this.mConf), this.mConf);
            this.mFilesystem_noverify = HdfsBroker.newInstanceFileSystem(this.mConf);
            this.mFilesystem_noverify.setVerifyChecksum(false);
        }
        catch (Exception e) {
            log.severe("ERROR: Unable to establish connection to HDFS.");
            System.exit(1);
        }
    }

    private static FileSystem newInstanceFileSystem(Configuration conf) throws IOException {
        URI uri = FileSystem.getDefaultUri((Configuration)conf);
        Class clazz = conf.getClass("fs." + uri.getScheme() + ".impl", null);
        if (clazz == null) {
            throw new IOException("No FileSystem for scheme: " + uri.getScheme());
        }
        FileSystem fs = (FileSystem)ReflectionUtils.newInstance((Class)clazz, (Configuration)conf);
        fs.initialize(uri, conf);
        return fs;
    }

    public OpenFileMap GetOpenFileMap() {
        return this.mOpenFileMap;
    }

    public void Open(ResponseCallbackOpen cb, String fileName, int flags, int bufferSize, boolean verify_checksum) {
        int error = 0;
        try {
            if (fileName.endsWith("/")) {
                log.severe("Unable to open file, bad filename: " + fileName);
                error = cb.error(131076, fileName);
                return;
            }
            int fd = msUniqueId.incrementAndGet();
            if (this.mVerbose) {
                log.info("Opening file '" + fileName + "' flags=" + flags + " bs=" + bufferSize + " handle = " + fd + " verify_checksum=" + verify_checksum);
            }
            OpenFileData ofd = this.mOpenFileMap.Create(fd, cb.GetAddress());
            if (verify_checksum) {
                ofd.is = this.mFilesystem.open(new Path(fileName));
            } else {
                ofd.is_noverify = this.mFilesystem_noverify.open(new Path(fileName));
            }
            ofd.pathname = fileName;
            error = cb.response(fd);
        }
        catch (FileNotFoundException e) {
            log.severe("File not found: " + fileName);
            error = cb.error(131075, e.getMessage());
        }
        catch (IOException e) {
            log.severe("I/O exception while opening file '" + fileName + "' - " + e.toString());
            error = cb.error(131074, e.toString());
        }
        if (error != 0) {
            log.severe("Problem sending response to 'open' command - " + Error.GetText(error));
        }
    }

    public void Close(ResponseCallback cb, int fd) {
        int error = 0;
        long start_time = System.currentTimeMillis();
        OpenFileData ofd = this.mOpenFileMap.Remove(fd);
        while (true) {
            try {
                if (ofd == null) {
                    error = 131073;
                    throw new IOException("Invalid file handle " + fd);
                }
                if (ofd.is != null) {
                    if (this.mVerbose) {
                        log.info("Closing input file " + ofd.pathname + " handle " + fd);
                    }
                    ofd.is.close();
                    ofd.is = null;
                }
                if (ofd.is_noverify != null) {
                    if (this.mVerbose) {
                        log.info("Closing noverify input stream for file " + ofd.pathname + " handle " + fd);
                    }
                    ofd.is_noverify.close();
                    ofd.is_noverify = null;
                }
                if (ofd.os != null) {
                    if (this.mVerbose) {
                        log.info("Closing output file " + ofd.pathname + " handle " + fd);
                    }
                    ofd.os.close();
                    ofd.os = null;
                }
                error = cb.response_ok();
            }
            catch (NotReplicatedYetException e) {
                long now = System.currentTimeMillis();
                if (now - start_time > (long)cb.request_ttl()) {
                    log.warning(e.toString());
                    continue;
                }
                log.severe(e.toString());
                error = cb.error(131074, e.toString());
            }
            catch (IOException e) {
                log.severe("I/O exception - " + e.toString());
                if (error == 0) {
                    error = 131074;
                }
                error = cb.error(error, e.toString());
            }
            break;
        }
        if (error != 0) {
            log.severe("Error sending CLOSE response back");
        }
    }

    public void Create(ResponseCallbackCreate cb, String fileName, int flags, int bufferSize, short replication, long blockSize) {
        int error = 0;
        try {
            if (fileName.endsWith("/")) {
                log.severe("Unable to open file, bad filename: " + fileName);
                error = cb.error(131076, fileName);
                return;
            }
            int fd = msUniqueId.incrementAndGet();
            OpenFileData ofd = this.mOpenFileMap.Create(fd, cb.GetAddress());
            if (this.mVerbose) {
                log.info("Creating file '" + fileName + "' handle = " + fd);
            }
            if (replication == -1) {
                replication = this.mFilesystem.getDefaultReplication();
            }
            if (bufferSize == -1) {
                bufferSize = this.mConf.getInt("io.file.buffer.size", 70000);
            }
            if (blockSize == -1L) {
                blockSize = this.mFilesystem.getDefaultBlockSize();
            }
            boolean overwrite = (flags & 2) != 0;
            ofd.os = this.mFilesystem.create(new Path(fileName), overwrite, bufferSize, replication, blockSize);
            ofd.pathname = fileName;
            if (this.mVerbose) {
                log.info("Created file '" + fileName + "' handle = " + fd);
            }
            error = cb.response(fd);
        }
        catch (FileNotFoundException e) {
            log.severe("File not found: " + fileName);
            error = cb.error(131075, e.getMessage());
        }
        catch (IOException e) {
            log.severe("I/O exception while creating file '" + fileName + "' - " + e.toString());
            error = cb.error(131074, e.toString());
        }
        if (error != 0) {
            log.severe("Problem sending response to 'create' command - " + Error.GetText(error));
        }
    }

    public void Length(ResponseCallbackLength cb, String fileName) {
        int error = 0;
        try {
            if (this.mVerbose) {
                log.info("Getting length of file '" + fileName);
            }
            long length = this.mFilesystem.getFileStatus(new Path(fileName)).getLen();
            error = cb.response(length);
        }
        catch (FileNotFoundException e) {
            log.severe("File not found: " + fileName);
            error = cb.error(131075, e.getMessage());
        }
        catch (IOException e) {
            log.severe("I/O exception while getting length of file '" + fileName + "' - " + e.toString());
            error = cb.error(131074, e.toString());
        }
        if (error != 0) {
            log.severe("Problem sending response to 'length' command - " + Error.GetText(error));
        }
    }

    public void Mkdirs(ResponseCallback cb, String fileName) {
        int error = 0;
        try {
            if (this.mVerbose) {
                log.info("Making directory '" + fileName + "'");
            }
            if (!this.mFilesystem.mkdirs(new Path(fileName))) {
                throw new IOException("Problem creating directory '" + fileName + "'");
            }
            error = cb.response_ok();
        }
        catch (FileNotFoundException e) {
            log.severe("File not found: " + fileName);
            error = cb.error(131075, e.getMessage());
        }
        catch (IOException e) {
            log.severe("I/O exception while making directory '" + fileName + "' - " + e.toString());
            error = cb.error(131074, e.toString());
        }
        if (error != 0) {
            log.severe("Problem sending response to 'mkdirs' command - " + Error.GetText(error));
        }
    }

    public void Read(ResponseCallbackRead cb, int fd, int amount) {
        int error = 0;
        try {
            int nread;
            int r;
            OpenFileData ofd = this.mOpenFileMap.Get(fd);
            if (ofd == null) {
                error = 131073;
                throw new IOException("Invalid file handle " + fd);
            }
            if (ofd.is == null) {
                throw new IOException("File handle " + fd + " not open for reading");
            }
            long offset = ofd.is.getPos();
            byte[] data = new byte[amount];
            for (nread = 0; nread < amount && (r = ofd.is.read(data, nread, amount - nread)) >= 0; nread += r) {
            }
            error = cb.response(offset, nread, data);
        }
        catch (IOException e) {
            log.severe("I/O exception - " + e.toString());
            if (error == 0) {
                error = 131074;
            }
            error = cb.error(error, e.toString());
        }
        if (error != 0) {
            log.severe("Error sending READ response back");
        }
    }

    public void Write(ResponseCallbackWrite cb, int fd, int amount, byte[] data, boolean sync) {
        int error = 0;
        try {
            OpenFileData ofd = this.mOpenFileMap.Get(fd);
            if (ofd == null) {
                error = 131073;
                throw new IOException("Invalid file handle " + fd);
            }
            if (ofd.os == null) {
                throw new IOException("File handle " + ofd + " not open for writing");
            }
            long offset = ofd.os.getPos();
            error = 131078;
            ofd.os.write(data, 0, amount);
            if (sync) {
                ofd.os.sync();
            }
            error = cb.response(offset, amount);
        }
        catch (IOException e) {
            e.printStackTrace();
            error = cb.error(131074, e.toString());
        }
        catch (BufferUnderflowException e) {
            e.printStackTrace();
            error = cb.error(1, e.toString());
        }
        if (error != 0) {
            log.severe("Error sending WRITE response back");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void PositionRead(ResponseCallbackPositionRead cb, int fd, long offset, int amount, boolean verify_checksum) {
        int error = 0;
        int retries = 10;
        byte[] data = null;
        while (true) {
            try {
                int nread;
                int r;
                FSDataInputStream is;
                OpenFileData ofd = this.mOpenFileMap.Get(fd);
                if (ofd == null) {
                    error = 131073;
                    throw new IOException("Invalid file handle " + fd);
                }
                if (verify_checksum) {
                    if (ofd.is == null && ofd.is == null) {
                        ofd.is = this.mFilesystem.open(new Path(ofd.pathname));
                        log.info("Re-opening '" + ofd.pathname + "' for verify checksum read");
                    }
                    is = ofd.is;
                } else {
                    is = ofd.is_noverify;
                }
                if (is == null) {
                    throw new IOException("File handle " + fd + " not open for reading");
                }
                if (data == null) {
                    data = new byte[amount];
                }
                for (nread = 0; nread < amount && (r = is.read(offset + (long)nread, data, nread, amount - nread)) >= 0; nread += r) {
                }
                error = cb.response(offset, nread, data);
            }
            catch (IOException e) {
                if (--retries == 0) {
                    log.severe(e.toString());
                    if (error == 0) {
                        error = 131074;
                    }
                    error = cb.error(error, e.toString());
                    break;
                }
                log.warning(e.toString());
                log.warning("Retry in 5 seconds ...");
                try {
                    HdfsBroker r = this;
                    synchronized (r) {
                        this.wait(5000L);
                        continue;
                    }
                }
                catch (InterruptedException ie) {
                    continue;
                }
            }
            break;
        }
        if (error != 0) {
            log.severe("Error sending PREAD response back");
        }
    }

    public void Remove(ResponseCallback cb, String fileName) {
        int error = 0;
        try {
            if (this.mVerbose) {
                log.info("Removing file '" + fileName);
            }
            if (!this.mFilesystem.delete(new Path(fileName), false)) {
                throw new IOException("Problem deleting file '" + fileName + "'");
            }
            error = cb.response_ok();
        }
        catch (FileNotFoundException e) {
            log.severe("File not found: " + fileName);
            error = cb.error(131075, e.getMessage());
        }
        catch (IOException e) {
            log.severe("I/O exception while removing file '" + fileName + "' - " + e.toString());
            error = cb.error(131074, e.toString());
        }
        if (error != 0) {
            log.severe("Problem sending response to 'remove' command - " + Error.GetText(error));
        }
    }

    public void Seek(ResponseCallback cb, int fd, long offset) {
        int error = 0;
        try {
            OpenFileData ofd = this.mOpenFileMap.Get(fd);
            if (ofd == null) {
                error = 131073;
                throw new IOException("Invalid file handle " + fd);
            }
            if (this.mVerbose) {
                log.info("Seek request handle=" + fd + " offset=" + offset);
            }
            if (ofd.is == null) {
                throw new IOException("File handle " + fd + " not open for reading");
            }
            ofd.is.seek(offset);
            error = cb.response_ok();
            if (error != 0) {
                log.severe("Error sending SEEK response back - " + Error.GetText(error));
            }
        }
        catch (IOException e) {
            log.severe("I/O exception - " + e.toString());
            if (error == 0) {
                error = 131074;
            }
            error = cb.error(error, e.toString());
        }
    }

    public void Flush(ResponseCallback cb, int fd) {
        int error = 0;
        try {
            OpenFileData ofd = this.mOpenFileMap.Get(fd);
            if (ofd == null) {
                error = 131073;
                throw new IOException("Invalid file handle " + fd);
            }
            if (this.mVerbose) {
                log.info("Flush request handle=" + fd);
            }
            ofd.os.sync();
            error = cb.response_ok();
            if (error != 0) {
                log.severe("Error sending FLUSH response back - " + Error.GetText(error));
            }
        }
        catch (IOException e) {
            log.severe("I/O exception - " + e.toString());
            if (error == 0) {
                error = 131074;
            }
            error = cb.error(error, e.toString());
        }
    }

    public void Rmdir(ResponseCallback cb, String fileName) {
        int error = 0;
        try {
            if (this.mVerbose) {
                log.info("Removing directory '" + fileName + "'");
            }
            if (!this.mFilesystem.delete(new Path(fileName), true)) {
                if (!this.mFilesystem.exists(new Path(fileName))) {
                    throw new FileNotFoundException("Problem deleting path '" + fileName + "'");
                }
                throw new IOException("Problem deleting path '" + fileName + "'");
            }
            error = cb.response_ok();
        }
        catch (FileNotFoundException e) {
            log.severe("File not found: " + fileName);
            error = cb.error(131075, e.getMessage());
        }
        catch (IOException e) {
            log.severe("I/O exception while removing directory '" + fileName + "' - " + e.toString());
            error = cb.error(131074, e.toString());
        }
        if (error != 0) {
            log.severe("Problem sending response to 'rmdir' command - " + Error.GetText(error));
        }
    }

    public void Readdir(ResponseCallbackReaddir cb, String dirName) {
        int error = 0;
        try {
            if (this.mVerbose) {
                log.info("Readdir('" + dirName + "')");
            }
            String[] listing = null;
            FileStatus[] statuses = this.mFilesystem.listStatus(new Path(dirName));
            if (statuses != null) {
                Path[] paths = new Path[statuses.length];
                for (int k = 0; k < statuses.length; ++k) {
                    paths[k] = statuses[k].getPath();
                }
                listing = new String[paths.length];
                for (int i = 0; i < paths.length; ++i) {
                    String pathStr = paths[i].toString();
                    int lastSlash = pathStr.lastIndexOf(47);
                    listing[i] = lastSlash == -1 ? pathStr : pathStr.substring(lastSlash + 1);
                }
            }
            error = cb.response(listing);
        }
        catch (FileNotFoundException e) {
            log.severe("File not found: " + dirName);
            error = cb.error(131075, e.getMessage());
        }
        catch (IOException e) {
            log.severe("I/O exception while reading directory '" + dirName + "' - " + e.toString());
            error = cb.error(131074, e.toString());
        }
        if (error != 0) {
            log.severe("Problem sending response to 'readdir' command - " + Error.GetText(error));
        }
    }

    public void Exists(ResponseCallbackExists cb, String fileName) {
        int error = 0;
        try {
            if (this.mVerbose) {
                log.info("Testing for existence of file '" + fileName);
            }
            error = cb.response(this.mFilesystem.exists(new Path(fileName)));
        }
        catch (FileNotFoundException e) {
            log.severe("File not found: " + fileName);
            error = cb.error(131075, e.getMessage());
        }
        catch (IOException e) {
            log.severe("I/O exception while checking for existence of file '" + fileName + "' - " + e.toString());
            error = cb.error(131074, e.toString());
        }
        if (error != 0) {
            log.severe("Problem sending response to 'exists' command - " + Error.GetText(error));
        }
    }

    public void Rename(ResponseCallback cb, String src, String dst) {
        try {
            if (this.mVerbose) {
                log.info("Renaming " + src + " -> " + dst);
            }
            this.mFilesystem.rename(new Path(src), new Path(dst));
        }
        catch (IOException e) {
            log.severe("I/O exception while renaming " + src + " -> " + dst + ": " + e.toString());
            cb.error(131074, e.toString());
            return;
        }
        cb.response_ok();
    }

    public void Debug(ResponseCallback cb, int command, byte[] parmas) {
        if (this.mVerbose) {
            log.info("Debug command=" + command);
        }
        log.severe("Debug command " + command + " not implemented");
        cb.error(31, "Unsupported debug command - " + command);
    }
}

