/*
 * Decompiled with CFR 0.152.
 */
package org.hypertable.Common;

public class ProgressMeterVertical {
    private long mStartTime = System.currentTimeMillis();
    private long mCount;
    private long mExpectedCount;
    private int mLastPercentage;

    public ProgressMeterVertical(long expectedCount) {
        this.mExpectedCount = expectedCount;
        System.out.println("  0% complete.");
        System.out.flush();
    }

    public long add(long increment) {
        this.mCount += increment;
        int pct = (int)(this.mCount * 100L / this.mExpectedCount);
        if (pct > this.mLastPercentage) {
            long elapsed_secs = (System.currentTimeMillis() - this.mStartTime) / 1000L;
            if (pct < 10) {
                System.out.println("  " + pct + "% complete\t" + elapsed_secs);
            } else if (pct < 100) {
                System.out.println(" " + pct + "% complete\t" + elapsed_secs);
            } else {
                System.out.println(pct + "% complete\t" + elapsed_secs);
            }
            System.out.flush();
            this.mLastPercentage = pct;
        }
        return this.mCount;
    }

    public void finished() {
        if (this.mLastPercentage < 100) {
            System.out.println("100% complete.");
            System.out.flush();
            this.mLastPercentage = 100;
        }
    }
}

