/*
 * Decompiled with CFR 0.152.
 */
package org.hypertable.Common;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.hypertable.Common.DiscreteRandomGenerator;
import org.hypertable.Common.Usage;

public class DiscreteRandomGeneratorZipf
extends DiscreteRandomGenerator {
    static String[] usage = new String[]{"", "usage: DiscreteRandomGeneratorZipf [OPTIONS] <minimum> <maximum>", "", "OPTIONS:", "  --cmf-file <fname>            File containing CMF array", "  --generate-cmf-file <fname>   Write CMF array to <fname>", "  --s <svalue>                  Specifies the s value for the zipf curve (default = 0.8)", "", "This program can be used to display samples from, or generate a file", "containing the cumulative mass function data for a Zipfian distributation.", null};
    private boolean mInitialized = false;
    double mS;
    double mNorm;

    public DiscreteRandomGeneratorZipf(int min, int max, int seed, double s) {
        super(min, max, seed);
        this.mS = s;
    }

    public DiscreteRandomGeneratorZipf(String cmfFile) throws FileNotFoundException, IOException {
        super(cmfFile);
    }

    @Override
    protected double pmf(long val) {
        if (!this.mInitialized) {
            this.mNorm = (1.0 - this.mS) / Math.pow(this.mValueCount + 1, 1.0 - this.mS);
            this.mInitialized = true;
        }
        assert (val >= 0L && val <= (long)(this.mValueCount + 1));
        double prob = this.mNorm / Math.pow(++val, this.mS);
        return prob;
    }

    public static void main(String[] args) {
        String cmfFile = null;
        int seed = 1;
        double svalue = 0.8;
        int minimum = -1;
        int maximum = -1;
        boolean generate = false;
        try {
            int i;
            for (i = 0; i < args.length; ++i) {
                if (args[i].equals("--generate-cmf-file")) {
                    cmfFile = args[i + 1];
                    ++i;
                    generate = true;
                    continue;
                }
                if (args[i].equals("--cmf-file")) {
                    cmfFile = args[i + 1];
                    ++i;
                    continue;
                }
                if (args[i].equals("--s")) {
                    svalue = Double.valueOf(args[i + 1]);
                    continue;
                }
                if (minimum == -1) {
                    minimum = Integer.valueOf(args[i]);
                    continue;
                }
                if (maximum == -1) {
                    maximum = Integer.valueOf(args[i]);
                    continue;
                }
                Usage.DumpAndExit(usage);
            }
            if (maximum == -1) {
                Usage.DumpAndExit(usage);
            }
            if (generate) {
                DiscreteRandomGeneratorZipf zipf = new DiscreteRandomGeneratorZipf(minimum, maximum, seed, svalue);
                zipf.setSeed(seed);
                zipf.writeCmfFile(cmfFile);
            } else {
                DiscreteRandomGeneratorZipf zipf;
                if (cmfFile == null) {
                    zipf = new DiscreteRandomGeneratorZipf(minimum, maximum, seed, svalue);
                } else {
                    System.out.println("Loading file " + cmfFile);
                    zipf = new DiscreteRandomGeneratorZipf(cmfFile);
                }
                for (i = 0; i < 1000000; ++i) {
                    System.out.println(zipf.getSample());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

