/*
 * Decompiled with CFR 0.152.
 */
package org.hypertable.Common;

import java.util.Arrays;
import java.util.logging.Logger;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.hypertable.Common.Checksum;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.runner.JUnitCore;

public class ChecksumTest {
    static final Logger log = Logger.getLogger("org.hypertable.Common.ChecksumTest");

    @Before
    public void setUp() {
    }

    @org.junit.Test
    public void testChecksum() {
        try {
            byte[] data = new byte[36];
            Arrays.fill(data, (byte)0);
            data[0] = 1;
            data[1] = 36;
            data[2] = 1;
            data[8] = 48;
            data[12] = 3;
            data[16] = -123;
            data[28] = 4;
            Assert.assertTrue((Checksum.fletcher32(data, 0, 36) == 730906148 ? 1 : 0) != 0);
            Arrays.fill(data, (byte)0);
            data[0] = 1;
            data[1] = 36;
            data[2] = 1;
            data[8] = 35;
            data[12] = 1;
            data[16] = -40;
            data[17] = -29;
            data[18] = 6;
            data[28] = 4;
            Assert.assertTrue((Checksum.fletcher32(data, 0, 36) == -630191864 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.assertTrue((boolean)false);
        }
    }

    @After
    public void tearDown() {
    }

    public static Test suite() {
        return new JUnit4TestAdapter(ChecksumTest.class);
    }

    public static void main(String[] args) {
        JUnitCore.main((String[])new String[]{"org.hypertable.Checksum.ChecksumTest"});
    }
}

