/*
 * Decompiled with CFR 0.152.
 */
package org.hypertable.AsyncComm;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.LinkedList;
import java.util.logging.Logger;
import org.hypertable.AsyncComm.Comm;
import org.hypertable.AsyncComm.CommBuf;
import org.hypertable.AsyncComm.CommHeader;
import org.hypertable.AsyncComm.DispatchHandler;
import org.hypertable.AsyncComm.Event;
import org.hypertable.AsyncComm.ReactorFactory;
import org.hypertable.AsyncComm.Serialization;
import org.hypertable.Common.Error;

public class SampleClient {
    static final Logger log = Logger.getLogger("org.hypertable");
    static String[] usage = new String[]{"", "usage: sampleClient [OPTIONS] <input-file>", "", "OPTIONS:", "  --host=<name>  Specifies the host to connect to", "  --port=<n>     Specifies the port to connect to", "  --timeout=<t>  Specifies the connectin timeout value", "  --reactors=<n>  Specifies the number of reactors", "", "This is a sample program to test the AsyncComm library.  It connects", "to the sampleServer and sends each line of the input file", "to the server.  Each reply from the server is echoed to stdout.", "", null};
    static final int DEFAULT_PORT = 11255;
    static boolean msShutdown = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws InterruptedException, IOException {
        Event event;
        String str;
        int i;
        int port = 11255;
        String host = "localhost";
        short reactorCount = 1;
        long timeout = 0L;
        String inputFile = null;
        if (args.length == 0) {
            i = 0;
            while (usage[i] != null) {
                System.out.println(usage[i]);
                ++i;
            }
            System.exit(0);
        }
        for (i = 0; i < args.length; ++i) {
            if (args[i].startsWith("--host=")) {
                host = args[i].substring(7);
                continue;
            }
            if (args[i].startsWith("--port=")) {
                port = Integer.parseInt(args[i].substring(7));
                continue;
            }
            if (args[i].startsWith("--reactors=")) {
                reactorCount = Short.parseShort(args[i].substring(11));
                continue;
            }
            if (args[i].startsWith("--timeout=")) {
                timeout = Integer.parseInt(args[i].substring(10));
                continue;
            }
            if (inputFile == null) {
                inputFile = args[i];
                continue;
            }
            int j = 0;
            while (usage[j] != null) {
                System.out.println(usage[j]);
                ++j;
            }
            System.exit(0);
        }
        if (inputFile == null) {
            i = 0;
            while (usage[i] != null) {
                System.out.println(usage[i]);
                ++i;
            }
            System.exit(0);
        }
        System.out.println("Connecting to " + host + ":" + port);
        InetSocketAddress addr = host == null ? new InetSocketAddress(port) : new InetSocketAddress(host, port);
        ReactorFactory.Initialize(reactorCount);
        Comm comm = new Comm(0);
        ResponseHandler respHandler = new ResponseHandler();
        int error = comm.Connect(addr, timeout, respHandler);
        if (error != 0) {
            System.err.println("Connect error : " + Error.GetText(error));
            System.exit(1);
        }
        if (!respHandler.WaitForConnection()) {
            System.exit(1);
        }
        CommHeader header = new CommHeader();
        int outstanding = 0;
        int maxOutstanding = 50;
        BufferedReader in = new BufferedReader(new FileReader(inputFile));
        while ((str = in.readLine()) != null) {
            CommBuf cbuf = new CommBuf(header, Serialization.EncodedLengthString(str));
            cbuf.AppendString(str);
            int retries = 0;
            if (msShutdown) {
                System.exit(1);
            }
            while ((error = comm.SendRequest(addr, cbuf, respHandler)) != 0) {
                if (msShutdown) {
                    System.exit(1);
                }
                if (error == 65537) {
                    Integer intObj;
                    if (retries == 5) {
                        System.out.println("Connection timeout.");
                        System.exit(1);
                    }
                    Integer n = intObj = new Integer(0);
                    synchronized (n) {
                        intObj.wait(1000L);
                    }
                    ++retries;
                    continue;
                }
                System.err.println("CommEngine.SendMessage returned '" + Error.GetText(error) + "'");
                System.exit(1);
            }
            if (++outstanding <= maxOutstanding) continue;
            event = respHandler.GetResponse();
            if (event == null) break;
            event.payload.rewind();
            str = Serialization.DecodeString(event.payload);
            System.out.println("ECHO: '" + str + "'");
            --outstanding;
        }
        while (outstanding > 0 && (event = respHandler.GetResponse()) != null) {
            event.payload.rewind();
            str = Serialization.DecodeString(event.payload);
            System.out.println("ECHO: '" + str + "'");
            --outstanding;
        }
        System.gc();
        ReactorFactory.Shutdown();
    }

    static class ResponseHandler
    implements DispatchHandler {
        private LinkedList<Event> mQueue = new LinkedList();
        private boolean mConnected = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(Event event) {
            ResponseHandler responseHandler = this;
            synchronized (responseHandler) {
                if (event.type == Event.Type.CONNECTION_ESTABLISHED) {
                    System.out.println("Connection Established.");
                    this.mConnected = true;
                    this.notify();
                } else if (event.type == Event.Type.DISCONNECT) {
                    if (event.error == 65539) {
                        System.out.println("Connect error.");
                    } else {
                        System.out.println("Disconnect.");
                    }
                    this.mConnected = false;
                    this.notify();
                } else if (event.type == Event.Type.ERROR) {
                    System.err.println("Error : " + Error.GetText(event.error));
                } else if (event.type == Event.Type.MESSAGE) {
                    Event newEvent = new Event(event);
                    this.mQueue.offer(newEvent);
                    this.notify();
                }
            }
        }

        public synchronized boolean WaitForConnection() throws InterruptedException {
            if (this.mConnected) {
                return true;
            }
            this.wait();
            return this.mConnected;
        }

        public synchronized Event GetResponse() throws InterruptedException {
            while (this.mQueue.isEmpty()) {
                this.wait();
                if (this.mConnected) continue;
                return null;
            }
            return this.mQueue.remove();
        }
    }
}

